///
///  This source code is freeware and is provided on an "as is" basis without warranties of any kind, 
///  whether express or implied, including without limitation warranties that the code is free of defect, 
///  fit for a particular purpose or non-infringing.  The entire risk as to the quality and performance of 
///  the code is with the end user.
///
///  Written by: Kyong Kwak ( kkwak@purposedriven.com )


using System;
using System.IO;
using System.Text;
using System.Collections;
//using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;

namespace CmsScriptUtilities.SearchAndReplaceContent {

	/// <summary>
	/// Summary description for TemplateSwitch.
	/// </summary>
	class SearchAndReplaceContent {
		
		static bool bFindOnly = true;

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main( string[] args ) {

			string _originalString = "";
			string _replacementString = "";		
			string _startingSearchPath = "";
			bool bSearchHidden = true;

			switch( args.Length ) {
				case 1:
					Console.WriteLine( "Usage: file FindOnlyFlag SearchHiddenFlag originalContent replacementContent [ startingSearchPath ]" );
					Console.WriteLine();
					return;
			
				case 4:
				case 5:
					int i = 0;
					bFindOnly = Convert.ToBoolean( args[ i++ ] );
					bSearchHidden = Convert.ToBoolean( args[ i++ ] );
					_originalString = args[ i++ ];
					_replacementString = args[ i++ ];
					if( args.Length == 5 )
						_startingSearchPath = args[ i++ ];
					break;
			
				default:
					Console.WriteLine( "Please enter initial values..." );
					bFindOnly = Convert.ToBoolean( GetUserValue( "Find Only? ( *true*/false ): " ) );
					bSearchHidden = Convert.ToBoolean( GetUserValue( "Search Hidden? ( *true*/false ): " ) );
					_originalString = GetUserValue( "Original Value: " );
					_replacementString = GetUserValue( "Replacement Value: " );			
					_startingSearchPath = GetUserValue( "** OPTIONAL ** Enter Starting Search Path: /Channels/" );
					break;
			}

			CmsApplicationContext cmsContext = new CmsApplicationContext();
			// Logon as Update Mode since we need to CREATE postings
			cmsContext.AuthenticateAsCurrentUser( PublishingMode.Update );
			cmsContext.SessionSettings.AutoFilterHidden = !bSearchHidden;
			
			Channel startChannel;
			if( _startingSearchPath.Length > 0 ) {
				// Check that we have a valid channel
				startChannel = ( Channel ) cmsContext.Searches.GetByPath( "/Channels/" + _startingSearchPath );
				if( startChannel == null ) {
					Console.WriteLine( "Channel could not be found! Terminating..." );
					return;
				}
			}
			else 
				startChannel = cmsContext.RootChannel;

			try {
				ReplaceContent( startChannel, _originalString, _replacementString );
				cmsContext.CommitAll();
			}
			catch( Exception exception ) {
				cmsContext.RollbackAll();
				Console.WriteLine( exception.Message );
				Console.WriteLine();
			}
		}


		private static void ReplaceContent(Channel currentChannel, string strOriginalContent, string strReplacementContent ) {

			Console.WriteLine( "Entering Channel: {0}", currentChannel.Path );

			foreach( Channel subChannels in currentChannel.Channels )
				ReplaceContent( subChannels, strOriginalContent, strReplacementContent );

			foreach( Posting currentPosting in currentChannel.Postings ) {

				bool bIsModified = false;

				foreach( Placeholder content in currentPosting.Placeholders ) {
					string storedContent = content.Datasource.RawContent;
					if( storedContent.IndexOf( strOriginalContent ) >= 0 ) {
						bIsModified = true;

						if( ( bFindOnly == false ) ) {
							string replacedContent = storedContent.Replace( strOriginalContent, strReplacementContent );
							content.Datasource.RawContent = replacedContent;
						}
					}
				}
				if( bIsModified ) {
					if( ( bFindOnly == false ) && ( currentPosting.CanSubmit ) )
						currentPosting.Submit();

					Console.WriteLine( bFindOnly ? "Found: {0}" : "Updated: {0}", currentPosting.Path );
				}			
			}
		}

		private static string GetUserValue( string Question ) {
			Console.WriteLine( Question );
			return Console.ReadLine();
		}

	}
}
