Imports System.Runtime.InteropServices
Imports System.ComponentModel
Imports System.IO

<ToolboxBitmap(GetType(PictureBox))> _
Public Class VideoCapture
    Inherits System.Windows.Forms.PictureBox
    Private bmap As Bitmap = New Bitmap(1, 1)

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()
        Me.SizeMode = PictureBoxSizeMode.StretchImage
        'This call is required by the Windows Form Designer.
        InitializeComponent()
        'Add any initialization after the InitializeComponent() call

    End Sub

    'UserControl1 overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container()
    End Sub

#End Region

    Public Sub StartPreview()
        Dim frmShowPreview As New frmPreview()
        Dim rResult As DialogResult

        rResult = frmShowPreview.ShowDialog()

        If rResult = DialogResult.Yes Then
            Me.Image = frmShowPreview.img
        End If
    End Sub

    <Bindable(True), Browsable(False)> _
     Public Property ByteImage()
        Get
            Dim ms As New MemoryStream()

            Me.Image.Save(ms, Imaging.ImageFormat.Jpeg)

            Return ms.GetBuffer
        End Get
        Set(ByVal Value)
            Try
                Dim ms As New MemoryStream()
                Dim bm As Bitmap

                ms.Write(Value, 0, Value.Length)
                bm = New Bitmap(ms)

                Me.Image = bm
            Catch
                Me.Image = bmap
            End Try
        End Set

    End Property


End Class
