Imports System.Runtime.InteropServices


Public Class frmPreview
    Inherits System.Windows.Forms.Form
    Friend hWndc As Integer
    Dim nID As Long = 0
    Dim strDevice(3) As String
    Dim bFile As Boolean = False
    Public img As Image

    '
    ' API declares
    '

    Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Integer, _
        ByVal wMsg As Integer, ByVal wParam As Short, ByVal lParam As Integer) As Integer

    Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Integer, _
        ByVal hWndInsertAfter As Integer, ByVal x As Integer, ByVal y As Integer, _
        ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer) As Integer

    Declare Function DestroyWindow Lib "user32" (ByVal hndw As Integer) As Boolean

    Declare Function capCreateCaptureWindowA Lib "avicap32.dll" _
        (ByVal lpszWindowName As String, ByVal dwStyle As Integer, _
        ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, _
        ByVal nHeight As Short, ByVal hWndParent As Integer, _
        ByVal nID As Integer) As Integer

    Declare Function capGetDriverDescriptionA Lib "avicap32.dll" (ByVal wDriver As Short, _
        ByVal lpszName As String, ByVal cbName As Integer, ByVal lpszVer As String, _
        ByVal cbVer As Integer) As Boolean

    ' API constants
    '

    Friend Const WM_CAP As Short = &H400S

    Friend Const WM_CAP_DRIVER_CONNECT As Integer = WM_CAP + 10
    Friend Const WM_CAP_DRIVER_DISCONNECT As Integer = WM_CAP + 11
    Friend Const WM_CAP_EDIT_COPY As Integer = WM_CAP + 30

    Friend Const WM_CAP_SET_PREVIEW As Integer = WM_CAP + 50
    Friend Const WM_CAP_SET_PREVIEWRATE As Integer = WM_CAP + 52
    Friend Const WM_CAP_SET_SCALE As Integer = WM_CAP + 53
    Friend Const WS_CHILD As Integer = &H40000000
    Friend Const WS_VISIBLE As Integer = &H10000000
    Friend Const SWP_NOMOVE As Short = &H2S
    Friend Const SWP_NOSIZE As Short = 1
    Friend Const SWP_NOZORDER As Short = &H4S
    Friend Const HWND_BOTTOM As Short = 1

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents cmdSave As System.Windows.Forms.Button
    Friend WithEvents cmdClose As System.Windows.Forms.Button
    Friend WithEvents picPreview As System.Windows.Forms.PictureBox
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents mnuSource As System.Windows.Forms.MenuItem
    Friend WithEvents mnuSourceFile As System.Windows.Forms.MenuItem
    Friend WithEvents mnuSourceVideo As System.Windows.Forms.MenuItem
    Friend WithEvents mnuSourceVideoDevice1 As System.Windows.Forms.MenuItem
    Friend WithEvents mnuSourceVideoDevice2 As System.Windows.Forms.MenuItem
    Friend WithEvents mnuSourceVideoDevice3 As System.Windows.Forms.MenuItem
    Friend WithEvents opnPicture As System.Windows.Forms.OpenFileDialog
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.picPreview = New System.Windows.Forms.PictureBox
        Me.cmdSave = New System.Windows.Forms.Button
        Me.cmdClose = New System.Windows.Forms.Button
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.mnuSource = New System.Windows.Forms.MenuItem
        Me.mnuSourceFile = New System.Windows.Forms.MenuItem
        Me.mnuSourceVideo = New System.Windows.Forms.MenuItem
        Me.mnuSourceVideoDevice1 = New System.Windows.Forms.MenuItem
        Me.mnuSourceVideoDevice2 = New System.Windows.Forms.MenuItem
        Me.mnuSourceVideoDevice3 = New System.Windows.Forms.MenuItem
        Me.opnPicture = New System.Windows.Forms.OpenFileDialog
        Me.SuspendLayout()
        '
        'picPreview
        '
        Me.picPreview.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.picPreview.Location = New System.Drawing.Point(16, 16)
        Me.picPreview.Name = "picPreview"
        Me.picPreview.Size = New System.Drawing.Size(642, 379)
        Me.picPreview.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.picPreview.TabIndex = 0
        Me.picPreview.TabStop = False
        '
        'cmdSave
        '
        Me.cmdSave.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.cmdSave.Location = New System.Drawing.Point(221, 411)
        Me.cmdSave.Name = "cmdSave"
        Me.cmdSave.Size = New System.Drawing.Size(89, 23)
        Me.cmdSave.TabIndex = 1
        Me.cmdSave.Text = "Save Image"
        '
        'cmdClose
        '
        Me.cmdClose.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.cmdClose.Location = New System.Drawing.Point(365, 411)
        Me.cmdClose.Name = "cmdClose"
        Me.cmdClose.Size = New System.Drawing.Size(89, 23)
        Me.cmdClose.TabIndex = 2
        Me.cmdClose.Text = "Close Window"
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuSource})
        '
        'mnuSource
        '
        Me.mnuSource.Index = 0
        Me.mnuSource.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuSourceFile, Me.mnuSourceVideo})
        Me.mnuSource.Text = "Source"
        '
        'mnuSourceFile
        '
        Me.mnuSourceFile.Index = 0
        Me.mnuSourceFile.Text = "File"
        '
        'mnuSourceVideo
        '
        Me.mnuSourceVideo.Index = 1
        Me.mnuSourceVideo.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuSourceVideoDevice1, Me.mnuSourceVideoDevice2, Me.mnuSourceVideoDevice3})
        Me.mnuSourceVideo.Text = "Video Capture"
        '
        'mnuSourceVideoDevice1
        '
        Me.mnuSourceVideoDevice1.Index = 0
        Me.mnuSourceVideoDevice1.Text = "Device 1"
        '
        'mnuSourceVideoDevice2
        '
        Me.mnuSourceVideoDevice2.Index = 1
        Me.mnuSourceVideoDevice2.Text = "Device 2"
        '
        'mnuSourceVideoDevice3
        '
        Me.mnuSourceVideoDevice3.Index = 2
        Me.mnuSourceVideoDevice3.Text = "Device 3"
        '
        'frmPreview
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(674, 451)
        Me.Controls.Add(Me.cmdClose)
        Me.Controls.Add(Me.cmdSave)
        Me.Controls.Add(Me.picPreview)
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
        Me.MaximizeBox = False
        Me.Menu = Me.MainMenu1
        Me.MinimizeBox = False
        Me.Name = "frmPreview"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "Transfer Image"
        Me.ResumeLayout(False)

    End Sub

#End Region


    Private Sub cmdClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdClose.Click
        SendMessage(hWndc, WM_CAP_DRIVER_DISCONNECT, nID, 0)
        DestroyWindow(hWndc)
        Me.Close()
    End Sub

    Private Sub cmdSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSave.Click
        Dim data As IDataObject
        Dim bmap As Image

        SendMessage(hWndc, WM_CAP_EDIT_COPY, 0, 0)
        data = Clipboard.GetDataObject()
        If data.GetDataPresent(GetType(System.Drawing.Bitmap)) Then
            bmap = CType(data.GetData(GetType(System.Drawing.Bitmap)), Image)
            SendMessage(hWndc, WM_CAP_DRIVER_DISCONNECT, nID, 0)
            DestroyWindow(hWndc)
        End If

        If Not bFile Then img = bmap

        Me.DialogResult = DialogResult.Yes
        Me.Close()
    End Sub

    Private Sub frmPreview_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim strPic As String = Space(100)
        Dim strName As String = Space(100)
        Dim x As Long
        Dim boolDevice(3) As Boolean

        opnPicture.Filter = "Jpeg Files (*.jpeg)|*.jpg|Gif files (*.gif)|*.gif|Bitmaps (*.bmp)|*.bmp|All Files (*.*)|*.*"

        For x = 0 To 2
            boolDevice(x) = capGetDriverDescriptionA(x, strName, 100, strPic, 100) '// Retrieves driver info
            strDevice(x) = Trim$(strName)
        Next

        mnuSourceVideoDevice1.Text = strDevice(0)
        mnuSourceVideoDevice1.Visible = boolDevice(0)
        mnuSourceVideoDevice1.Checked = True

        mnuSourceVideoDevice2.Text = strDevice(1)
        mnuSourceVideoDevice2.Visible = boolDevice(1)

        mnuSourceVideoDevice3.Text = strDevice(2)
        mnuSourceVideoDevice3.Visible = boolDevice(2)

        OpenPreviewWindow()
    End Sub

    Private Sub picPreview_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles picPreview.Paint
        Dim fntError As New Font(Font.FontFamily.GenericSansSerif, 20, FontStyle.Bold)
        Dim g As Graphics = e.Graphics
        Dim strError As String = "Device Not Available"
        Dim iLeft As Integer
        Dim iTop As Integer
        Dim i As Integer = g.MeasureString(strError, fntError).Width
        Dim z As Integer = g.MeasureString(strError, fntError).Height

        If bFile Then Return
        iLeft = (picPreview.Width - i) / 2
        iTop = (picPreview.Height - z) / 2

        g.FillRectangle(Brushes.Blue, 0, 0, picPreview.Width, picPreview.Height)
        g.DrawString(strError, fntError, Brushes.Yellow, iLeft, iTop)

        g = Nothing

    End Sub

    Private Sub mnuSourceVideoDevice1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuSourceVideoDevice1.Click, mnuSourceVideoDevice2.Click, mnuSourceVideoDevice3.Click

        Dim mnu As MenuItem = sender
        Me.Text = mnu.Text

        UncheckVideo()
        mnuSourceFile.Checked = False

        mnu.Checked = True

        If mnu Is mnuSourceVideoDevice1 Then
            nID = 0
        ElseIf mnu Is mnuSourceVideoDevice2 Then
            nID = 1
        Else
            nID = 2
        End If

        If hWndc <> 0 Then
            SendMessage(hWndc, WM_CAP_DRIVER_DISCONNECT, nID, 0)
            DestroyWindow(hWndc)
        End If


        OpenPreviewWindow()
    End Sub

    Private Sub OpenPreviewWindow()
        Dim iHeight As Integer = picPreview.Height
        Dim iWidth As Integer = picPreview.Width

        hWndc = capCreateCaptureWindowA(strDevice(nID), WS_VISIBLE Or WS_CHILD, 0, 0, 640, 480, picPreview.Handle.ToInt32, 0)
        '// Turn Scale on
        Me.Text = strDevice(nID)
        bFile = False

        If SendMessage(hWndc, WM_CAP_DRIVER_CONNECT, nID, 0) Then

            'Set the preview scale
            SendMessage(hWndc, WM_CAP_SET_SCALE, True, 0)

            'Set the preview rate in milliseconds
            SendMessage(hWndc, WM_CAP_SET_PREVIEWRATE, 66, 0)

            'Start previewing the image from the camera
            SendMessage(hWndc, WM_CAP_SET_PREVIEW, True, 0)

            SetWindowPos(hWndc, HWND_BOTTOM, 0, 0, picPreview.Width, picPreview.Height, _
                    SWP_NOMOVE Or SWP_NOZORDER)
        Else
            DestroyWindow(hWndc)

            cmdSave.Enabled = False
        End If
    End Sub

    Private Sub mnuSourceFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuSourceFile.Click
        If opnPicture.ShowDialog() = DialogResult.OK Then
            SendMessage(hWndc, WM_CAP_DRIVER_DISCONNECT, nID, 0)
            DestroyWindow(hWndc)
            Dim strFile As String

            mnuSourceFile.Checked = True
            UncheckVideo()

            strFile = opnPicture.FileName
            bFile = True
            Try
                picPreview.Image = Image.FromFile(strFile)
                img = picPreview.Image
                cmdSave.Enabled = True
            Catch
                MessageBox.Show("Error Opening File")
            End Try
        End If

    End Sub

    Private Sub UncheckVideo()
        mnuSourceVideoDevice1.Checked = False
        mnuSourceVideoDevice2.Checked = False
        mnuSourceVideoDevice3.Checked = False
    End Sub
End Class
