Imports System.IO

Public Class frmMain
    Inherits System.Windows.Forms.Form

    'create a new csMusicLibray instance
    Dim csCls As csMusicLibraryPro.csMusicLibrary = New csMusicLibraryPro.csMusicLibrary()

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents t As System.Windows.Forms.Timer
    Friend WithEvents gbLst As System.Windows.Forms.GroupBox
    Friend WithEvents btnSave As System.Windows.Forms.Button
    Friend WithEvents btnOpen As System.Windows.Forms.Button
    Friend WithEvents lstFiles As System.Windows.Forms.ListBox
    Friend WithEvents btnRemove As System.Windows.Forms.Button
    Friend WithEvents gb As System.Windows.Forms.GroupBox
    Friend WithEvents lblPosMS As System.Windows.Forms.Label
    Friend WithEvents lblPosSec As System.Windows.Forms.Label
    Friend WithEvents lblPos As System.Windows.Forms.Label
    Friend WithEvents lblDurMS As System.Windows.Forms.Label
    Friend WithEvents lblDurSec As System.Windows.Forms.Label
    Friend WithEvents lblDur As System.Windows.Forms.Label
    Friend WithEvents btnPlay As System.Windows.Forms.Button
    Friend WithEvents btnStop As System.Windows.Forms.Button
    Friend WithEvents lblLVol As System.Windows.Forms.Label
    Friend WithEvents lblRate As System.Windows.Forms.Label
    Friend WithEvents btnAddDir As System.Windows.Forms.Button
    Friend WithEvents btnClear As System.Windows.Forms.Button
    Friend WithEvents tLVol As System.Windows.Forms.TrackBar
    Friend WithEvents tRVol As System.Windows.Forms.TrackBar
    Friend WithEvents tRate As System.Windows.Forms.TrackBar
    Friend WithEvents lblRVol As System.Windows.Forms.Label
    Friend WithEvents lblRateS As System.Windows.Forms.Label
    Friend WithEvents lblTRemSec As System.Windows.Forms.Label
    Friend WithEvents lblTRemMS As System.Windows.Forms.Label
    Friend WithEvents chkBothVol As System.Windows.Forms.CheckBox
    Friend WithEvents tPos As System.Windows.Forms.TrackBar
    Friend WithEvents chkMute As System.Windows.Forms.CheckBox
    Friend WithEvents lblBitrate As System.Windows.Forms.Label
    Friend WithEvents btnPause As System.Windows.Forms.Button
    Friend WithEvents lblTRem As System.Windows.Forms.Label
    Friend WithEvents lblStatus As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.t = New System.Windows.Forms.Timer(Me.components)
        Me.gbLst = New System.Windows.Forms.GroupBox()
        Me.btnSave = New System.Windows.Forms.Button()
        Me.btnOpen = New System.Windows.Forms.Button()
        Me.lstFiles = New System.Windows.Forms.ListBox()
        Me.btnRemove = New System.Windows.Forms.Button()
        Me.btnAddDir = New System.Windows.Forms.Button()
        Me.btnClear = New System.Windows.Forms.Button()
        Me.gb = New System.Windows.Forms.GroupBox()
        Me.lblTRem = New System.Windows.Forms.Label()
        Me.btnPause = New System.Windows.Forms.Button()
        Me.lblBitrate = New System.Windows.Forms.Label()
        Me.tPos = New System.Windows.Forms.TrackBar()
        Me.chkBothVol = New System.Windows.Forms.CheckBox()
        Me.lblTRemSec = New System.Windows.Forms.Label()
        Me.lblTRemMS = New System.Windows.Forms.Label()
        Me.lblRateS = New System.Windows.Forms.Label()
        Me.lblRVol = New System.Windows.Forms.Label()
        Me.tRate = New System.Windows.Forms.TrackBar()
        Me.tRVol = New System.Windows.Forms.TrackBar()
        Me.chkMute = New System.Windows.Forms.CheckBox()
        Me.lblRate = New System.Windows.Forms.Label()
        Me.lblPosSec = New System.Windows.Forms.Label()
        Me.lblPosMS = New System.Windows.Forms.Label()
        Me.btnStop = New System.Windows.Forms.Button()
        Me.btnPlay = New System.Windows.Forms.Button()
        Me.lblPos = New System.Windows.Forms.Label()
        Me.lblDurMS = New System.Windows.Forms.Label()
        Me.lblDurSec = New System.Windows.Forms.Label()
        Me.lblDur = New System.Windows.Forms.Label()
        Me.lblLVol = New System.Windows.Forms.Label()
        Me.tLVol = New System.Windows.Forms.TrackBar()
        Me.lblStatus = New System.Windows.Forms.Label()
        Me.gbLst.SuspendLayout()
        Me.gb.SuspendLayout()
        CType(Me.tPos, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.tRate, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.tRVol, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.tLVol, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        't
        '
        Me.t.Interval = 1000
        '
        'gbLst
        '
        Me.gbLst.Controls.AddRange(New System.Windows.Forms.Control() {Me.btnSave, Me.btnOpen, Me.lstFiles, Me.btnRemove, Me.btnAddDir, Me.btnClear})
        Me.gbLst.Location = New System.Drawing.Point(0, 124)
        Me.gbLst.Name = "gbLst"
        Me.gbLst.Size = New System.Drawing.Size(456, 144)
        Me.gbLst.TabIndex = 0
        Me.gbLst.TabStop = False
        Me.gbLst.Text = "Playlist: 0 files"
        '
        'btnSave
        '
        Me.btnSave.BackColor = System.Drawing.SystemColors.Control
        Me.btnSave.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnSave.Location = New System.Drawing.Point(88, 112)
        Me.btnSave.Name = "btnSave"
        Me.btnSave.Size = New System.Drawing.Size(72, 23)
        Me.btnSave.TabIndex = 6
        Me.btnSave.Text = "Save"
        '
        'btnOpen
        '
        Me.btnOpen.BackColor = System.Drawing.SystemColors.Control
        Me.btnOpen.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnOpen.Location = New System.Drawing.Point(8, 112)
        Me.btnOpen.Name = "btnOpen"
        Me.btnOpen.Size = New System.Drawing.Size(72, 24)
        Me.btnOpen.TabIndex = 5
        Me.btnOpen.Text = "Add/Open"
        '
        'lstFiles
        '
        Me.lstFiles.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.lstFiles.Location = New System.Drawing.Point(8, 16)
        Me.lstFiles.Name = "lstFiles"
        Me.lstFiles.Size = New System.Drawing.Size(440, 93)
        Me.lstFiles.TabIndex = 3
        '
        'btnRemove
        '
        Me.btnRemove.BackColor = System.Drawing.SystemColors.Control
        Me.btnRemove.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnRemove.Location = New System.Drawing.Point(296, 112)
        Me.btnRemove.Name = "btnRemove"
        Me.btnRemove.Size = New System.Drawing.Size(72, 23)
        Me.btnRemove.TabIndex = 4
        Me.btnRemove.Text = "Remove"
        '
        'btnAddDir
        '
        Me.btnAddDir.BackColor = System.Drawing.SystemColors.Control
        Me.btnAddDir.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnAddDir.Location = New System.Drawing.Point(184, 112)
        Me.btnAddDir.Name = "btnAddDir"
        Me.btnAddDir.Size = New System.Drawing.Size(88, 23)
        Me.btnAddDir.TabIndex = 2
        Me.btnAddDir.Text = "Add Directory"
        '
        'btnClear
        '
        Me.btnClear.BackColor = System.Drawing.SystemColors.Control
        Me.btnClear.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnClear.Location = New System.Drawing.Point(376, 112)
        Me.btnClear.Name = "btnClear"
        Me.btnClear.TabIndex = 2
        Me.btnClear.Text = "Clear List"
        '
        'gb
        '
        Me.gb.Controls.AddRange(New System.Windows.Forms.Control() {Me.lblTRem, Me.btnPause, Me.lblBitrate, Me.tPos, Me.chkBothVol, Me.lblTRemSec, Me.lblTRemMS, Me.lblRateS, Me.lblRVol, Me.tRate, Me.tRVol, Me.chkMute, Me.lblRate, Me.lblPosSec, Me.lblPosMS, Me.btnStop, Me.btnPlay, Me.lblPos, Me.lblDurMS, Me.lblDurSec, Me.lblDur, Me.lblLVol, Me.tLVol, Me.lblStatus})
        Me.gb.Location = New System.Drawing.Point(0, -4)
        Me.gb.Name = "gb"
        Me.gb.Size = New System.Drawing.Size(456, 128)
        Me.gb.TabIndex = 1
        Me.gb.TabStop = False
        '
        'lblTRem
        '
        Me.lblTRem.Location = New System.Drawing.Point(200, 72)
        Me.lblTRem.Name = "lblTRem"
        Me.lblTRem.Size = New System.Drawing.Size(152, 16)
        Me.lblTRem.TabIndex = 22
        Me.lblTRem.Text = "Time Remaining:"
        '
        'btnPause
        '
        Me.btnPause.BackColor = System.Drawing.SystemColors.Control
        Me.btnPause.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnPause.Location = New System.Drawing.Point(8, 64)
        Me.btnPause.Name = "btnPause"
        Me.btnPause.TabIndex = 21
        Me.btnPause.Text = "Pause"
        '
        'lblBitrate
        '
        Me.lblBitrate.Location = New System.Drawing.Point(88, 104)
        Me.lblBitrate.Name = "lblBitrate"
        Me.lblBitrate.Size = New System.Drawing.Size(80, 16)
        Me.lblBitrate.TabIndex = 20
        Me.lblBitrate.Text = "Bitrate:"
        '
        'tPos
        '
        Me.tPos.LargeChange = 1
        Me.tPos.Location = New System.Drawing.Point(208, 80)
        Me.tPos.Maximum = 0
        Me.tPos.Name = "tPos"
        Me.tPos.Size = New System.Drawing.Size(136, 42)
        Me.tPos.TabIndex = 19
        Me.tPos.TickFrequency = 0
        Me.tPos.TickStyle = System.Windows.Forms.TickStyle.TopLeft
        '
        'chkBothVol
        '
        Me.chkBothVol.Checked = True
        Me.chkBothVol.CheckState = System.Windows.Forms.CheckState.Checked
        Me.chkBothVol.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.chkBothVol.Location = New System.Drawing.Point(88, 88)
        Me.chkBothVol.Name = "chkBothVol"
        Me.chkBothVol.Size = New System.Drawing.Size(80, 16)
        Me.chkBothVol.TabIndex = 18
        Me.chkBothVol.Text = "Move Both"
        '
        'lblTRemSec
        '
        Me.lblTRemSec.Location = New System.Drawing.Point(200, 40)
        Me.lblTRemSec.Name = "lblTRemSec"
        Me.lblTRemSec.Size = New System.Drawing.Size(152, 16)
        Me.lblTRemSec.TabIndex = 16
        Me.lblTRemSec.Text = "Time Remaining: "
        '
        'lblTRemMS
        '
        Me.lblTRemMS.Location = New System.Drawing.Point(200, 8)
        Me.lblTRemMS.Name = "lblTRemMS"
        Me.lblTRemMS.Size = New System.Drawing.Size(152, 16)
        Me.lblTRemMS.TabIndex = 15
        Me.lblTRemMS.Text = "Time Remaining: "
        '
        'lblRateS
        '
        Me.lblRateS.Location = New System.Drawing.Point(165, 88)
        Me.lblRateS.Name = "lblRateS"
        Me.lblRateS.Size = New System.Drawing.Size(40, 16)
        Me.lblRateS.TabIndex = 14
        Me.lblRateS.Text = "Speed"
        '
        'lblRVol
        '
        Me.lblRVol.Location = New System.Drawing.Point(132, 72)
        Me.lblRVol.Name = "lblRVol"
        Me.lblRVol.Size = New System.Drawing.Size(16, 16)
        Me.lblRVol.TabIndex = 13
        Me.lblRVol.Text = "R"
        '
        'tRate
        '
        Me.tRate.LargeChange = 1
        Me.tRate.Location = New System.Drawing.Point(168, 16)
        Me.tRate.Maximum = 1937
        Me.tRate.Minimum = 1
        Me.tRate.Name = "tRate"
        Me.tRate.Orientation = System.Windows.Forms.Orientation.Vertical
        Me.tRate.Size = New System.Drawing.Size(42, 80)
        Me.tRate.TabIndex = 12
        Me.tRate.TickFrequency = 0
        Me.tRate.TickStyle = System.Windows.Forms.TickStyle.None
        Me.tRate.Value = 1000
        '
        'tRVol
        '
        Me.tRVol.Location = New System.Drawing.Point(128, 16)
        Me.tRVol.Maximum = 1000
        Me.tRVol.Name = "tRVol"
        Me.tRVol.Orientation = System.Windows.Forms.Orientation.Vertical
        Me.tRVol.Size = New System.Drawing.Size(42, 64)
        Me.tRVol.TabIndex = 11
        Me.tRVol.TickFrequency = 0
        Me.tRVol.TickStyle = System.Windows.Forms.TickStyle.None
        Me.tRVol.Value = 800
        '
        'chkMute
        '
        Me.chkMute.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.chkMute.Location = New System.Drawing.Point(24, 88)
        Me.chkMute.Name = "chkMute"
        Me.chkMute.Size = New System.Drawing.Size(48, 16)
        Me.chkMute.TabIndex = 10
        Me.chkMute.Text = "Mute"
        '
        'lblRate
        '
        Me.lblRate.Location = New System.Drawing.Point(158, 104)
        Me.lblRate.Name = "lblRate"
        Me.lblRate.Size = New System.Drawing.Size(58, 16)
        Me.lblRate.TabIndex = 6
        Me.lblRate.Text = "100%"
        Me.lblRate.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lblPosSec
        '
        Me.lblPosSec.Location = New System.Drawing.Point(352, 48)
        Me.lblPosSec.Name = "lblPosSec"
        Me.lblPosSec.Size = New System.Drawing.Size(96, 16)
        Me.lblPosSec.TabIndex = 4
        Me.lblPosSec.Text = "Position:"
        '
        'lblPosMS
        '
        Me.lblPosMS.Location = New System.Drawing.Point(352, 8)
        Me.lblPosMS.Name = "lblPosMS"
        Me.lblPosMS.Size = New System.Drawing.Size(96, 16)
        Me.lblPosMS.TabIndex = 3
        Me.lblPosMS.Text = "Position:"
        '
        'btnStop
        '
        Me.btnStop.BackColor = System.Drawing.SystemColors.Control
        Me.btnStop.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnStop.Location = New System.Drawing.Point(8, 40)
        Me.btnStop.Name = "btnStop"
        Me.btnStop.TabIndex = 1
        Me.btnStop.Text = "Stop"
        '
        'btnPlay
        '
        Me.btnPlay.BackColor = System.Drawing.SystemColors.Control
        Me.btnPlay.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnPlay.Location = New System.Drawing.Point(8, 16)
        Me.btnPlay.Name = "btnPlay"
        Me.btnPlay.TabIndex = 0
        Me.btnPlay.Text = "Play"
        '
        'lblPos
        '
        Me.lblPos.Location = New System.Drawing.Point(352, 88)
        Me.lblPos.Name = "lblPos"
        Me.lblPos.Size = New System.Drawing.Size(96, 16)
        Me.lblPos.TabIndex = 2
        Me.lblPos.Text = "Position: "
        '
        'lblDurMS
        '
        Me.lblDurMS.Location = New System.Drawing.Point(352, 24)
        Me.lblDurMS.Name = "lblDurMS"
        Me.lblDurMS.Size = New System.Drawing.Size(96, 16)
        Me.lblDurMS.TabIndex = 2
        Me.lblDurMS.Text = "Duration:"
        '
        'lblDurSec
        '
        Me.lblDurSec.Location = New System.Drawing.Point(352, 64)
        Me.lblDurSec.Name = "lblDurSec"
        Me.lblDurSec.Size = New System.Drawing.Size(96, 16)
        Me.lblDurSec.TabIndex = 2
        Me.lblDurSec.Text = "Duration:"
        '
        'lblDur
        '
        Me.lblDur.Location = New System.Drawing.Point(352, 104)
        Me.lblDur.Name = "lblDur"
        Me.lblDur.Size = New System.Drawing.Size(96, 16)
        Me.lblDur.TabIndex = 2
        Me.lblDur.Text = "Duration:"
        '
        'lblLVol
        '
        Me.lblLVol.Location = New System.Drawing.Point(92, 72)
        Me.lblLVol.Name = "lblLVol"
        Me.lblLVol.Size = New System.Drawing.Size(16, 16)
        Me.lblLVol.TabIndex = 2
        Me.lblLVol.Text = "L"
        Me.lblLVol.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'tLVol
        '
        Me.tLVol.Location = New System.Drawing.Point(88, 16)
        Me.tLVol.Maximum = 1000
        Me.tLVol.Name = "tLVol"
        Me.tLVol.Orientation = System.Windows.Forms.Orientation.Vertical
        Me.tLVol.Size = New System.Drawing.Size(42, 64)
        Me.tLVol.TabIndex = 2
        Me.tLVol.TickFrequency = 0
        Me.tLVol.TickStyle = System.Windows.Forms.TickStyle.None
        Me.tLVol.Value = 800
        '
        'lblStatus
        '
        Me.lblStatus.Location = New System.Drawing.Point(8, 104)
        Me.lblStatus.Name = "lblStatus"
        Me.lblStatus.Size = New System.Drawing.Size(72, 16)
        Me.lblStatus.TabIndex = 2
        Me.lblStatus.Text = "stopped"
        Me.lblStatus.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'frmMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(456, 268)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.gb, Me.gbLst})
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow
        Me.MaximizeBox = False
        Me.Name = "frmMain"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "  csMusicLibrary Pro v1.0 - Example Application "
        Me.gbLst.ResumeLayout(False)
        Me.gb.ResumeLayout(False)
        CType(Me.tPos, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.tRate, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.tRVol, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.tLVol, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpen.Click

        Dim theList As Collection = New Collection()
        Dim openDLG As OpenFileDialog = New OpenFileDialog()
        Dim x As Integer = Nothing
        Dim dlgResult As DialogResult = Nothing

        openDLG.Filter = "M3U Playlist (*.m3u)|*.m3u|Supported Files (*.mp3, *.wav, *.wma)|*.mp3;*.wav;*.wma"

        dlgResult = openDLG.ShowDialog()

        If dlgResult = DialogResult.Cancel Then Exit Sub

        If openDLG.FileName.EndsWith(".m3u") Then

            lstFiles.Items.Clear()

            theList = csCls.openPlaylist(openDLG.FileName)

            For x = 0 To theList.Count - 1

                lstFiles.Items.Add(theList.Item(x + 1))

            Next

        Else

            lstFiles.Items.Add(openDLG.FileName)

        End If

        gbLst.Text = "Playlist: " & lstFiles.Items.Count

        'clean the resources used by the object
        openDLG.Dispose()
        theList = Nothing
        x = Nothing
        DialogResult = Nothing


    End Sub

    Private Sub t_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles t.Tick

        tPos.Value = csCls.positionInSec

        lblPosMS.Text = "Position: " & csCls.positionInMS & " ms"
        lblPosSec.Text = "Position: " & csCls.positionInSec & " sec"
        lblPos.Text = "Position: " & csCls.formatPosition

        lblTRemMS.Text = "Time Remaining: " & csCls.timeRemainingInMS & " ms"
        lblTRemSec.Text = "Time Remaining: " & csCls.timeRemainingInSec & " sec"
        lblTRem.Text = "Time Remaining: " & csCls.formatTimeRemaining

    End Sub

    Private Sub btnPlay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPlay.Click

        If lstFiles.SelectedIndex < 0 Then

            MessageBox.Show("You need to select in the playliust, the file you want to play", " Error", MessageBoxButtons.OK) : Exit Sub

        End If

        csCls.filename = lstFiles.SelectedItem

        csCls.playMusic()

        t.Enabled = True

        tPos.Maximum = csCls.durationInSec

        lblDurMS.Text = "Duration: " & csCls.durationInMS & " ms"
        lblDurSec.Text = "Duration: " & csCls.durationInSec & " sec"
        lblDur.Text = "Duration: " & csCls.formatDuration
        lblStatus.Text = csCls.currentStatus

        If csCls.mp3BitrateKB <= 0 Then

            lblBitrate.Text = "Bitrate: n/a"

        Else

            lblBitrate.Text = "Bitrate: " & csCls.mp3BitrateKB & " KB"

        End If

    End Sub

    Private Sub btnStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStop.Click

        csCls.stopPlay()
        t.Enabled = False

        lblStatus.Text = csCls.currentStatus

    End Sub

    Private Sub btnSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSave.Click

        Dim saveDLG As SaveFileDialog = New SaveFileDialog()
        Dim dlgResult As DialogResult
        Dim col As Collection = New Collection()
        Dim x As Integer = Nothing

        For x = 0 To lstFiles.Items.Count - 1

            col.Add(lstFiles.Items.Item(x))

        Next

        saveDLG.Filter = "M3U Playlist (*.m3u)|*.m3u"

        dlgResult = saveDLG.ShowDialog

        If dlgResult = DialogResult.OK Then

            csCls.savePlaylist(saveDLG.FileName, col)

        End If

        'clean up
        x = Nothing
        dlgResult = Nothing
        saveDLG.Dispose()
        col = Nothing

    End Sub

    Private Sub btnRemove_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRemove.Click

        'remove a item from the playlist

        If lstFiles.SelectedIndex < 0 Then

            MessageBox.Show("You need to select the file you want to remove from the playlist!", " Error", MessageBoxButtons.OK) : Exit Sub

        Else

            lstFiles.Items.RemoveAt(lstFiles.SelectedIndex)

        End If

        gbLst.Text = "Playlist: " & lstFiles.Items.Count

    End Sub

    Private Sub frmMain_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing

        'close all devices from the command interface
        csCls.closeAudioDevices()

    End Sub

    Private Sub btnAddDir_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAddDir.Click

        'add the files in the specified directory to the playlist
        Dim dir As String = Nothing

        dir = InputBox("Please enter the path of the directory you want to add to the playlist.", " Add Directory", "c:\mp3 music\", Me.Left, Me.Top)

        If dir = "" Then Exit Sub

        Dim dirFiles As String

        lstFiles.Items.Clear()

        For Each dirFiles In Directory.GetFiles(dir)

            If dirFiles.EndsWith("mp3") Then

                lstFiles.Items.Add(dirFiles)

            ElseIf dirFiles.EndsWith("wav") Then

                lstFiles.Items.Add(dirFiles)

            ElseIf dirFiles.EndsWith("wma") Then

                lstFiles.Items.Add(dirFiles)

            End If

        Next

        gbLst.Text = "Playlist: " & lstFiles.Items.Count

        dir = Nothing
        dirFiles = Nothing

    End Sub

    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click

        'clear the playlist
        Dim dlg As DialogResult

        dlg = MessageBox.Show("You sure you want to clear the playlist?", " Clear Playlist?", MessageBoxButtons.YesNo)

        If dlg = DialogResult.Yes Then

            lstFiles.Items.Clear()

            gbLst.Text = "Playlist: " & lstFiles.Items.Count

        End If

        dlg = Nothing

    End Sub

    Private Sub lstFiles_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstFiles.DoubleClick

        'raise the click event of the play button
        btnPlay.PerformClick()

    End Sub

    Private Sub tLVol_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tLVol.Scroll

        If chkBothVol.CheckState = CheckState.Checked Then

            tRVol.Value = tLVol.Value

            csCls.leftVolume = tLVol.Value
            csCls.rightVolume = tLVol.Value

        Else

            csCls.leftVolume = tLVol.Value

        End If

    End Sub

    Private Sub tRVol_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tRVol.Scroll

        If chkBothVol.CheckState = CheckState.Checked Then

            tLVol.Value = tRVol.Value

            csCls.leftVolume = tLVol.Value
            csCls.rightVolume = tLVol.Value

        Else

            csCls.rightVolume = tRVol.Value

        End If

    End Sub

    Private Sub tRate_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tRate.Scroll


        csCls.playSpeed = tRate.Value

        lblRate.Text = (tRate.Value / 10) & "%"

    End Sub

    Private Sub tPos_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tPos.Scroll

        csCls.changePosition(tPos.Value)

    End Sub

    Private Sub chkMute_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkMute.CheckedChanged

        If chkMute.CheckState = CheckState.Checked Then

            csCls.muteSoundOutput = True

        Else

            csCls.muteSoundOutput = False

        End If

    End Sub

    Private Sub btnPause_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPause.Click

        If btnPause.Text = "Pause" Then

            btnPause.Text = "Resume"
            csCls.pausePlay()
            t.Enabled = False

        Else

            btnPause.Text = "Pause"
            csCls.resumePlay()
            t.Enabled = True

        End If

        lblStatus.Text = csCls.currentStatus

    End Sub

End Class
