using System;
using System.Collections;
using System.ComponentModel;
using System.Configuration;
using System.Data;
using System.Drawing;
using System.IO;
using System.Security.Permissions;
using System.Security;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Microsoft.Web.UI.WebControls;

namespace FTP
{
	/// <summary>
	/// Summary description for MenuPane.
	/// </summary>
	public class MenuPane : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.HyperLink HyperLink2;
		protected System.Web.UI.WebControls.Label currentUser;
		protected Microsoft.Web.UI.WebControls.TreeView Treeview1;		

		private void Page_Load(object sender, System.EventArgs e)
		{	
			TreeNode t = new TreeNode();
			t.Text = ConfigurationSettings.AppSettings["root"];
			t.Expanded = true;
			t.ImageUrl = "pics/icons/current.gif";
			t.NavigateUrl = "javascript:showContents('" + ConfigurationSettings.AppSettings["root"] + "')";				
			this.Treeview1.Nodes.Add(t);
			loadNodes(t, ConfigurationSettings.AppSettings["root"].ToString());

			if(User.Identity.IsAuthenticated)
				this.currentUser.Text = "&lt;" + User.Identity.Name + "&gt;"; 		
			else
				this.currentUser.Text = "&lt;Not Authenticated&gt;"; 	
		}

		private void loadNodes(TreeNode currentNode, string path)
		{
			DirectoryInfo mainDir = new DirectoryInfo(Server.MapPath(path));
			try
			{
				foreach(DirectoryInfo d in mainDir.GetDirectories())
				{				
					TreeNode t = new TreeNode();
					t.Text = d.Name;
					t.ImageUrl = "pics/icons/folder.gif";
					if(path == "/")
					{
						t.NavigateUrl = "javascript:showContents('" + path + d.Name + "')";
						currentNode.Nodes.Add(t);
						loadNodes(t, path + d.Name);
					}
					else
					{
						t.NavigateUrl = "javascript:showContents('" + path + "/" + d.Name + "')";
						currentNode.Nodes.Add(t);
						loadNodes(t, path + "/" + d.Name);
					}												
				}
			}
			catch(DirectoryNotFoundException dnfEx)
			{
				FTP.ReportError("Directory does not exist: " + path, dnfEx.ToString(), "Make sure the 'root' key in web.config is a valid path such as: / or /folder");
			}
			catch(UnauthorizedAccessException)
			{
				FTP.ReportError("Access denied: " + path, "", "");
			}
			catch(ArgumentException ArgEx)
			{
				FTP.ReportError("The path has invalid characters: " + path, ArgEx.ToString(),  "Try renaming the folder and removing non-standard characters.");
			}
			catch(Exception Ex)
			{
				FTP.ReportError("Could not get Directory Information for " + path, Ex.ToString(),  "Make sure the 'root' key in web.config is set to / unless you don't have permissions for the root.");
			}
		}
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    			
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

	}
}
