using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Security.Permissions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.IO;

namespace FTP
{
	public class edit : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label Header;
		protected System.Web.UI.WebControls.Button SaveBtn;
		protected System.Web.UI.WebControls.ImageButton homeLink;
		protected System.Web.UI.WebControls.TextBox SaveAsTxt;
		protected System.Web.UI.WebControls.Button SaveAs;
		protected System.Web.UI.WebControls.TextBox CodeText;
	
		private void Page_Load(object sender, System.EventArgs e)
		{			
			// page requires a querystring like: File=/somePath/someFile
			if(!Page.IsPostBack)
			{				
				// check for the File querystring parameter
				if(Request.QueryString["File"] != null)
				{
					try
					{
						FileInfo file = new FileInfo(Server.MapPath(Server.UrlDecode(Request.QueryString["File"].ToString())));
						// read the text from the file
						StreamReader sr = file.OpenText();
						// fill the CodeText text field with the file text
						CodeText.Text = sr.ReadToEnd().ToString();
						sr.Close();
						// set the header appropriately
						Header.Text = "Editing file: <b>" + Request.QueryString["File"].ToString() + "</b>";
					}
					catch(Exception ex)
					{
						FTP.ReportError("Could not open file for editing", ex.Message, "If the file has just been created, wait a few seconds for Windows to release the file lock. <a href='edit.aspx?" + Request.QueryString.ToString() + "'>&lt;refresh&gt;</a>");
					}
				}
				else
					Response.Write("No file parameter passed to page");
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.homeLink.Click += new System.Web.UI.ImageClickEventHandler(this.homeLink_Click);
			this.SaveBtn.Click += new System.EventHandler(this.SaveBtn_Click);
			this.SaveAs.Click += new System.EventHandler(this.SaveAs_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void SaveBtn_Click(object sender, System.EventArgs e)
		{			
			try
			{
				FileInfo file = new FileInfo(Server.MapPath(Server.UrlDecode(Request.QueryString["File"].ToString())));
				StreamWriter sw = file.CreateText();
				// write the contents of the text field to the file
				sw.Write(CodeText.Text);
				sw.Close();	
				// notify user of success				
				Response.Write("<script>alert('File saved successfully\\nName: " + Request.QueryString["File"].ToString() + "\\nTime: " + DateTime.Now.ToString() + "'); document.location=\"edit.aspx?Path=" + Request.QueryString["Path"].ToString() + "&File=" + Request.QueryString["File"].ToString() + "\";</script>");
			}
			catch(System.UnauthorizedAccessException unEx)
			{
				FTP.ReportError("Access denied.", unEx.Message, "Make sure the current user has write permissions for this file / folder.");
			}
			catch(Exception ex)
			{
				FTP.ReportError("Could not save file.", ex.Message, "Press back and try again");
			}
		}

		private void SaveAs_Click(object sender, System.EventArgs e)
		{
			if(this.SaveAsTxt.Text == "")	// user gave no filename to save as
				Response.Write("<script>alert('No filename to Save As!'); </script>");
			else
			{
				try
				{
					string physicalFilePath = Server.MapPath(Server.UrlDecode(Request["File"].ToString()));
					string physicalParentDir = Path.GetDirectoryName(physicalFilePath);
					FileInfo file = new FileInfo(physicalParentDir + "\\" + this.SaveAsTxt.Text);
					StreamWriter sw = file.CreateText();
					// write the contents of the text field to the file
					sw.Write(CodeText.Text);
					sw.Close();																
					// notify user of success
					if(Request.QueryString["Path"].ToString() == "/")
						Response.Write("<script>alert('File saved successfully\\nName: " + SaveAsTxt.Text + "\\nTime: " + DateTime.Now.ToString() + "'); document.location=\"edit.aspx?Path=" + Request.QueryString["Path"].ToString() + "&File=" + Request.QueryString["Path"].ToString() + this.SaveAsTxt.Text + "\";</script>");
					else
						Response.Write("<script>alert('File saved successfully\\nName: " + SaveAsTxt.Text + "\\nTime: " + DateTime.Now.ToString() + "'); document.location=\"edit.aspx?Path=" + Request.QueryString["Path"].ToString() + "&File=" + Request.QueryString["Path"].ToString() + "/" + this.SaveAsTxt.Text + "\";</script>");
				}
				catch(Exception ex)
				{
					FTP.ReportError("Could not save file.", ex.Message, "It is sufficient to enter a file name (not the complete path) when using Save As, the file is saved in the current directory.");
				}
			}
		}

		private void homeLink_Click(object sender, System.Web.UI.ImageClickEventArgs e)
		{
			Response.Redirect("contentPane.aspx?Path=" + Request.QueryString["Path"]); 
		}
	}
}
