/*+==========================================================================
  File:      ftp.cs

  Summary:   This file uses the FtpWebRequest class to download data from 
  			 a ftp server using the ftp:// protocol
  			 
  Classes:   EntryPoint
==========================================================================+*/
using System;
using System.Net;
using System.IO;

public class EntryPoint {

	public static void Usage(string name) {
		Console.WriteLine(name + " -u<uri> [-m<Method>] [-p<proxy>] [-ku<creds to server>] [-kp<creds to proxy>] [-f<file to upload>]\n");
		Console.WriteLine("\tSupported Methods:");
		Console.WriteLine("\t\t\"dir\" --> Get the directory listing");
		Console.WriteLine("\t\t\"get\" --> Get a resource from server");
		Console.WriteLine("\t\t\"cd\" --> Change to a specified directory");
		Console.WriteLine("\t\t\"pwd\" --> Get the current directory");
		Console.WriteLine("\t\t\"put\" --> put the specified local file on the server");
	}

	public static int Main(String [] Args) {
		bool do_usage = false;
		
		FtpRequestCreator Creator = new FtpRequestCreator();
		WebRequest.RegisterPrefix("ftp:", Creator);

		String szUri= null;
		bool fNeedUri = true;
		
		String szProxy= null;
		bool fNeedProxy = false;

		String szMethod = "dir";
		
		String szCredentials= null;
		bool fNeedCredentials = false;
		
		String szProxyCredentials= null;
		bool fNeedProxyCredentials = false;
        bool fPassive = false;
        
		String szFileToUpload = null;
		
		String exename = Environment.GetCommandLineArgs()[0];
        try
        {
            for (int i = 0; i < Args.Length; i++) {

                char[]  ArgChars = Args[i].ToCharArray();
                int     len = ArgChars.Length;

                if (ArgChars[0] == '-' ||
                    ArgChars[0] == '/') {
                    switch (ArgChars[1]) {
                    case '?':
                        do_usage = true;
                        break;

                    case 'u':

                        if (len > 2) {

                            len -= 2;
                            szUri = new String(ArgChars,2, len);
                    	} else
                    		fNeedUri = true;

                    break;
                    case 'f':

                        if (len > 2) {

                            len -= 2;
                            szFileToUpload = new String(ArgChars,2, len);
                    	}
                    break;
                    case 'p':

                        if (len > 2) {

                            len -= 2;
                            szProxy = new String(ArgChars,2, len);
                    	} else
                    		fNeedProxy = true;

                    break;
                    
                    case 'm':
                            if(len>2) {
                            	len -=2;
                            	szMethod = new String(ArgChars,2,len);
                            } else 
                            	szMethod = "dir";
                            	
                    break;

                    case 'k':

                        if (len > 2) {

                            //len -= 2;
                            if(ArgChars[2] == 'u') {
                            	//
                            	// these are credentials for the actual Ftp server
                            	//
                            	if(len > 3) {
                            		len -= 3;
	                            	szCredentials = new string(ArgChars,3, len);
	                            } else 
	                            	do_usage = true;
	                        } else
                            if(ArgChars[2] == 'p') {
                            	//
                            	// these are credentials for the intervening proxy server
                            	//
                            	if(len > 3) {
                            		len -= 3;
	                            	szProxyCredentials = new string(ArgChars,3, len);
	                            } else 
	                            	do_usage = true;
	                        } 	                        
                        }
                        break;

                        case 'v':
                            fPassive = true;
                            break;

                    default:
                        Console.WriteLine("Unknown cmdline option: " + Args[i]);
                        do_usage = true;
                        break;
                    }
                }
                else {
                }
                
                if (do_usage)
                {
                    break;
                }
            } // for

            if (do_usage) {
                Usage(exename);
                return 1;
            }
        }
        catch(Exception e) {
            Console.WriteLine("Exception: Parsing Commandline\n" + e.ToString());
            return 0;
        }

        
		WebRequest w = WebRequest.Create(szUri);
		w.Method = szMethod;

		FtpWebRequest ftp = w as FtpWebRequest;
		ftp.Passive = fPassive;
		
		if(szProxy != null) {
			WebProxy wproxy = new WebProxy(szProxy);

			if(szProxyCredentials != null) {
				String [] creds = szProxyCredentials.Split(new Char[]{':'});

				if(creds.Length != 2) {
					Usage(exename);
					return -1;
				}

				wproxy.Credentials = new NetworkCredential(creds[0],creds[1]);
			}

			w.Proxy = wproxy;
		}
		
		if(szCredentials != null) {
			String [] creds = szCredentials.Split(new Char[]{':'});

			if(creds.Length != 2) {
				Usage(exename);
				return -1;
			}

			w.Credentials = new NetworkCredential(creds[0],creds[1]);
		}

		try {
		
    		if(szFileToUpload != null) {
    			//
    			// we have an upload file
    			//
    			FileStream readstream = new FileStream(szFileToUpload, FileMode.Open, FileAccess.Read);

    			Stream writestream = w.GetRequestStream();
    			
    			int Length = 256;
    			Byte [] buffer = new Byte[Length];
    			int bytesread = readstream.Read(buffer,0,Length);

    			while( bytesread > 0) {
    				writestream.Write(buffer,0,bytesread);
    				bytesread = readstream.Read(buffer,0,Length);
    			}

    			readstream.Close();
    			writestream.Close();
    		}

    		
    		WebResponse r = w.GetResponse();

    		Console.WriteLine("Response.Status: " + ((FtpWebResponse)r).Status);
    		Console.WriteLine("Response.StatusDescription: " + ((FtpWebResponse)r).StatusDescription);
    		Console.WriteLine("Response.Transaction Log: \n" + ((FtpWebResponse)r).TransactionLog);

    		Stream respstream = r.GetResponseStream();

    		if(respstream.CanRead) {
    			StreamReader rdr = new StreamReader(respstream);

    			String resp = rdr.ReadToEnd();

    			rdr.Close();
    			Console.WriteLine(resp);
    		}
        } catch(Exception e) {
            Console.WriteLine("Exception: Toplevel");
            Console.WriteLine(e);
        }

		return 0;	
	}

		
}
