Public Class Ftp
  Inherits System.Windows.Forms.Form

  Dim WithEvents FtpLogin As New FtpLogin()

  Private currentDir As System.IO.Directory

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub
  Friend WithEvents cmdConnect As System.Windows.Forms.Button
  Friend WithEvents Ftp1 As nsoftware.IPWorks.Ftp
  Friend WithEvents cmdAbortTransfer As System.Windows.Forms.Button
  Friend WithEvents cmdExit As System.Windows.Forms.Button
  Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
  Friend WithEvents optAscii As System.Windows.Forms.RadioButton
  Friend WithEvents optBinary As System.Windows.Forms.RadioButton
  Friend WithEvents optAuto As System.Windows.Forms.RadioButton
  Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
  Friend WithEvents cboLocalPath As System.Windows.Forms.ComboBox
  Friend WithEvents lvwLocalDir As System.Windows.Forms.ListView
  Friend WithEvents strFile As System.Windows.Forms.ColumnHeader
  Friend WithEvents strSize As System.Windows.Forms.ColumnHeader
  Friend WithEvents strDate As System.Windows.Forms.ColumnHeader
  Friend WithEvents GroupBox3 As System.Windows.Forms.GroupBox
  Friend WithEvents lvwRemoteDir As System.Windows.Forms.ListView
  Friend WithEvents txtPITrail As System.Windows.Forms.TextBox
  Friend WithEvents cboRemotePath As System.Windows.Forms.ComboBox
  Friend WithEvents strFileRemote As System.Windows.Forms.ColumnHeader
  Friend WithEvents strSizeRemote As System.Windows.Forms.ColumnHeader
  Friend WithEvents strDateRemote As System.Windows.Forms.ColumnHeader
  Friend WithEvents cmdUpload As System.Windows.Forms.Button
  Friend WithEvents cmdDownload As System.Windows.Forms.Button

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.optBinary = New System.Windows.Forms.RadioButton()
    Me.strDateRemote = New System.Windows.Forms.ColumnHeader()
    Me.cboLocalPath = New System.Windows.Forms.ComboBox()
    Me.cmdConnect = New System.Windows.Forms.Button()
    Me.cboRemotePath = New System.Windows.Forms.ComboBox()
    Me.strSize = New System.Windows.Forms.ColumnHeader()
    Me.GroupBox1 = New System.Windows.Forms.GroupBox()
    Me.optAuto = New System.Windows.Forms.RadioButton()
    Me.optAscii = New System.Windows.Forms.RadioButton()
    Me.GroupBox2 = New System.Windows.Forms.GroupBox()
    Me.lvwLocalDir = New System.Windows.Forms.ListView()
    Me.strFile = New System.Windows.Forms.ColumnHeader()
    Me.strDate = New System.Windows.Forms.ColumnHeader()
    Me.GroupBox3 = New System.Windows.Forms.GroupBox()
    Me.lvwRemoteDir = New System.Windows.Forms.ListView()
    Me.strFileRemote = New System.Windows.Forms.ColumnHeader()
    Me.strSizeRemote = New System.Windows.Forms.ColumnHeader()
    Me.cmdAbortTransfer = New System.Windows.Forms.Button()
    Me.cmdExit = New System.Windows.Forms.Button()
    Me.cmdDownload = New System.Windows.Forms.Button()
    Me.txtPITrail = New System.Windows.Forms.TextBox()
    Me.cmdUpload = New System.Windows.Forms.Button()
    Me.Ftp1 = New nsoftware.IPWorks.Ftp()
    Me.GroupBox1.SuspendLayout()
    Me.GroupBox2.SuspendLayout()
    Me.GroupBox3.SuspendLayout()
    Me.SuspendLayout()
    '
    'optBinary
    '
    Me.optBinary.Location = New System.Drawing.Point(72, 16)
    Me.optBinary.Name = "optBinary"
    Me.optBinary.Size = New System.Drawing.Size(56, 16)
    Me.optBinary.TabIndex = 0
    Me.optBinary.Text = "Binary"
    '
    'strDateRemote
    '
    Me.strDateRemote.Text = "Date"
    '
    'cboLocalPath
    '
    Me.cboLocalPath.DropDownWidth = 224
    Me.cboLocalPath.Location = New System.Drawing.Point(8, 16)
    Me.cboLocalPath.Name = "cboLocalPath"
    Me.cboLocalPath.Size = New System.Drawing.Size(232, 21)
    Me.cboLocalPath.TabIndex = 0
    '
    'cmdConnect
    '
    Me.cmdConnect.Anchor = (System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left)
    Me.cmdConnect.Location = New System.Drawing.Point(8, 384)
    Me.cmdConnect.Name = "cmdConnect"
    Me.cmdConnect.Size = New System.Drawing.Size(72, 24)
    Me.cmdConnect.TabIndex = 0
    Me.cmdConnect.Text = "Connect"
    '
    'cboRemotePath
    '
    Me.cboRemotePath.DropDownWidth = 224
    Me.cboRemotePath.Location = New System.Drawing.Point(8, 16)
    Me.cboRemotePath.Name = "cboRemotePath"
    Me.cboRemotePath.Size = New System.Drawing.Size(232, 21)
    Me.cboRemotePath.TabIndex = 0
    '
    'strSize
    '
    Me.strSize.Text = "Size"
    '
    'GroupBox1
    '
    Me.GroupBox1.Anchor = (System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left)
    Me.GroupBox1.Controls.AddRange(New System.Windows.Forms.Control() {Me.optAuto, Me.optBinary, Me.optAscii})
    Me.GroupBox1.Location = New System.Drawing.Point(168, 256)
    Me.GroupBox1.Name = "GroupBox1"
    Me.GroupBox1.Size = New System.Drawing.Size(192, 40)
    Me.GroupBox1.TabIndex = 3
    Me.GroupBox1.TabStop = False
    Me.GroupBox1.Text = "Transfer Mode"
    '
    'optAuto
    '
    Me.optAuto.Checked = True
    Me.optAuto.Location = New System.Drawing.Point(128, 16)
    Me.optAuto.Name = "optAuto"
    Me.optAuto.Size = New System.Drawing.Size(56, 16)
    Me.optAuto.TabIndex = 0
    Me.optAuto.TabStop = True
    Me.optAuto.Text = "Auto"
    '
    'optAscii
    '
    Me.optAscii.Location = New System.Drawing.Point(16, 16)
    Me.optAscii.Name = "optAscii"
    Me.optAscii.Size = New System.Drawing.Size(56, 16)
    Me.optAscii.TabIndex = 0
    Me.optAscii.Text = "ASCII"
    '
    'GroupBox2
    '
    Me.GroupBox2.Anchor = ((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                Or System.Windows.Forms.AnchorStyles.Left)
    Me.GroupBox2.Controls.AddRange(New System.Windows.Forms.Control() {Me.lvwLocalDir, Me.cboLocalPath})
    Me.GroupBox2.Location = New System.Drawing.Point(8, 8)
    Me.GroupBox2.Name = "GroupBox2"
    Me.GroupBox2.Size = New System.Drawing.Size(248, 240)
    Me.GroupBox2.TabIndex = 4
    Me.GroupBox2.TabStop = False
    Me.GroupBox2.Text = "Local Host"
    '
    'lvwLocalDir
    '
    Me.lvwLocalDir.Anchor = ((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                Or System.Windows.Forms.AnchorStyles.Left)
    Me.lvwLocalDir.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.strFile, Me.strSize, Me.strDate})
    Me.lvwLocalDir.FullRowSelect = True
    Me.lvwLocalDir.Location = New System.Drawing.Point(8, 40)
    Me.lvwLocalDir.Name = "lvwLocalDir"
    Me.lvwLocalDir.Size = New System.Drawing.Size(232, 192)
    Me.lvwLocalDir.TabIndex = 1
    Me.lvwLocalDir.View = System.Windows.Forms.View.Details
    '
    'strFile
    '
    Me.strFile.Text = "File"
    Me.strFile.Width = 108
    '
    'strDate
    '
    Me.strDate.Text = "Date"
    '
    'GroupBox3
    '
    Me.GroupBox3.Anchor = ((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                Or System.Windows.Forms.AnchorStyles.Left)
    Me.GroupBox3.Controls.AddRange(New System.Windows.Forms.Control() {Me.lvwRemoteDir, Me.cboRemotePath})
    Me.GroupBox3.Location = New System.Drawing.Point(296, 8)
    Me.GroupBox3.Name = "GroupBox3"
    Me.GroupBox3.Size = New System.Drawing.Size(248, 240)
    Me.GroupBox3.TabIndex = 4
    Me.GroupBox3.TabStop = False
    Me.GroupBox3.Text = "Remote Host"
    '
    'lvwRemoteDir
    '
    Me.lvwRemoteDir.Anchor = ((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                Or System.Windows.Forms.AnchorStyles.Left)
    Me.lvwRemoteDir.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.strFileRemote, Me.strSizeRemote, Me.strDateRemote})
    Me.lvwRemoteDir.FullRowSelect = True
    Me.lvwRemoteDir.Location = New System.Drawing.Point(8, 40)
    Me.lvwRemoteDir.Name = "lvwRemoteDir"
    Me.lvwRemoteDir.Size = New System.Drawing.Size(232, 192)
    Me.lvwRemoteDir.TabIndex = 1
    Me.lvwRemoteDir.View = System.Windows.Forms.View.Details
    '
    'strFileRemote
    '
    Me.strFileRemote.Text = "File"
    Me.strFileRemote.Width = 108
    '
    'strSizeRemote
    '
    Me.strSizeRemote.Text = "Size"
    '
    'cmdAbortTransfer
    '
    Me.cmdAbortTransfer.Anchor = (System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left)
    Me.cmdAbortTransfer.Location = New System.Drawing.Point(88, 384)
    Me.cmdAbortTransfer.Name = "cmdAbortTransfer"
    Me.cmdAbortTransfer.Size = New System.Drawing.Size(80, 24)
    Me.cmdAbortTransfer.TabIndex = 1
    Me.cmdAbortTransfer.Text = "Cancel"
    '
    'cmdExit
    '
    Me.cmdExit.Anchor = (System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left)
    Me.cmdExit.Location = New System.Drawing.Point(176, 384)
    Me.cmdExit.Name = "cmdExit"
    Me.cmdExit.Size = New System.Drawing.Size(80, 24)
    Me.cmdExit.TabIndex = 1
    Me.cmdExit.Text = "Exit"
    '
    'cmdDownload
    '
    Me.cmdDownload.Anchor = System.Windows.Forms.AnchorStyles.Left
    Me.cmdDownload.Location = New System.Drawing.Point(264, 144)
    Me.cmdDownload.Name = "cmdDownload"
    Me.cmdDownload.Size = New System.Drawing.Size(24, 24)
    Me.cmdDownload.TabIndex = 5
    Me.cmdDownload.Text = "<-"
    '
    'txtPITrail
    '
    Me.txtPITrail.Anchor = ((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Left) _
                Or System.Windows.Forms.AnchorStyles.Right)
    Me.txtPITrail.Location = New System.Drawing.Point(8, 304)
    Me.txtPITrail.Multiline = True
    Me.txtPITrail.Name = "txtPITrail"
    Me.txtPITrail.Size = New System.Drawing.Size(528, 72)
    Me.txtPITrail.TabIndex = 6
    Me.txtPITrail.Text = ""
    '
    'cmdUpload
    '
    Me.cmdUpload.Anchor = System.Windows.Forms.AnchorStyles.Left
    Me.cmdUpload.Location = New System.Drawing.Point(264, 112)
    Me.cmdUpload.Name = "cmdUpload"
    Me.cmdUpload.Size = New System.Drawing.Size(24, 24)
    Me.cmdUpload.TabIndex = 5
    Me.cmdUpload.Text = "->"
    '
    'Ftp1
    '
    Me.Ftp1.FirewallPort = 1080
    Me.Ftp1.FirewallType = nsoftware.IPWorks.FtpFirewallTypes.fwNone
    Me.Ftp1.TransferMode = nsoftware.IPWorks.FtpTransferModes.tmDefault
    '
    'Main
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(544, 413)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.txtPITrail, Me.cmdDownload, Me.cmdUpload, Me.GroupBox3, Me.GroupBox2, Me.GroupBox1, Me.cmdExit, Me.cmdAbortTransfer, Me.cmdConnect})
    Me.Name = "Ftp"
    Me.Text = "FTP Client"
    Me.GroupBox1.ResumeLayout(False)
    Me.GroupBox2.ResumeLayout(False)
    Me.GroupBox3.ResumeLayout(False)
    Me.ResumeLayout(False)

  End Sub

#End Region
  Private Sub Ftp_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
    currentDir.SetCurrentDirectory("c:\")
    txtPITrail.ScrollBars = ScrollBars.Vertical
    Local_Dir_Refresh()
  End Sub

  Private Sub cmdConnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdConnect.Click
    If Not Ftp1.Connected Then
      cmdConnect.Text = "Disconnect"
      FtpLogin.Show()
    Else
      cmdConnect.Text = "Connect"
      Ftp1.Logoff()
    End If
  End Sub
  Private Sub cmdExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdExit.Click
    Me.Close()
  End Sub
  Private Sub cmdAbortTransfer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdAbortTransfer.Click
    Try
      Ftp1.Interrupt()
      Ftp1.Abort()
    Catch
    End Try
  End Sub

  Private Sub FtpLogin_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles FtpLogin.Closing
    e.Cancel = True
    FtpLogin.Hide()

    If FtpLogin.blnLogin Then
      Ftp1.User = FtpLogin.txtUser.Text
      Ftp1.Password = FtpLogin.txtPassword.Text
      Ftp1.RemoteHost = FtpLogin.txtServer.Text
      Try
        'Ftp1.Passive = True - To pass through firewalls
        Ftp1.Logon()
        Remote_Dir_Refresh()
      Catch
        MsgBox("Error: " & Err.Number & " " & Err.Description)
      End Try
    End If
  End Sub

  Private Sub lvwLocalDir_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lvwLocalDir.DoubleClick
    Dim dirName As System.IO.Directory
    Dim selectedIndice As String = lvwLocalDir.Items(lvwLocalDir.SelectedIndices.Item(0)).Text()

    If dirName.Exists(currentDir.GetCurrentDirectory & "\" & selectedIndice) Then
      currentDir.SetCurrentDirectory(currentDir.GetCurrentDirectory & "\" & selectedIndice)
      Local_Dir_Refresh()
    End If
  End Sub
  Private Sub lvwRemoteDir_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lvwRemoteDir.DoubleClick
    Dim selectedIndex As Integer = lvwRemoteDir.SelectedIndices.Item(0)

    If lvwRemoteDir.Items(selectedIndex).Tag = "dir" Then
      Try
        Ftp1.RemotePath += "/" & lvwRemoteDir.Items(lvwRemoteDir.SelectedIndices.Item(0)).Text()
      Catch
        MsgBox("Error: " & Err.Number & " " & Err.Description)
      End Try
      Remote_Dir_Refresh()
    End If
  End Sub

  Private Sub cmdUpload_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdUpload.Click
    If lvwLocalDir.SelectedIndices.Count > 0 Then
      Dim fileName As System.IO.File
      Dim selectedIndice As String = lvwLocalDir.Items(lvwLocalDir.SelectedIndices.Item(0)).Text()
      Try
        Ftp1.LocalFile = currentDir.GetCurrentDirectory & selectedIndice
        Ftp1.RemoteFile = selectedIndice
        Ftp1.Upload()
      Catch
        MsgBox("Error: " & Err.Number & " " & Err.Description)
      End Try
      Remote_Dir_Refresh()
    End If
  End Sub
  Private Sub cmdDownload_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDownload.Click
    If lvwRemoteDir.SelectedIndices.Count > 0 Then
      Dim selectedIndice As String = lvwRemoteDir.Items(lvwRemoteDir.SelectedIndices.Item(0)).Text()
      Try
        Ftp1.LocalFile = currentDir.GetCurrentDirectory & selectedIndice
        Ftp1.RemoteFile = selectedIndice
        Ftp1.Download()
      Catch
        MsgBox("Error: " & Err.Number & " " & Err.Description)
      End Try
      Local_Dir_Refresh()
    End If
  End Sub

  Private Sub Ftp1_OnDirList(ByVal sender As System.Object, ByVal e As nsoftware.IPWorks.FtpDirListEventArgs) Handles Ftp1.OnDirList
    Dim intlvwCount As Integer = lvwRemoteDir.Items.Count
    If e.IsDir Then
      lvwRemoteDir.Items.Add(e.FileName)
      lvwRemoteDir.Items(intlvwCount).SubItems.Add("<dir>")
      lvwRemoteDir.Items(intlvwCount).SubItems.Add("")
      lvwRemoteDir.Items(intlvwCount).Tag = "dir"
    Else
      lvwRemoteDir.Items.Add(e.FileName)
      lvwRemoteDir.Items(intlvwCount).SubItems.Add(e.FileSize)
      lvwRemoteDir.Items(intlvwCount).SubItems.Add(e.FileTime)
    End If
  End Sub
  Private Sub Ftp1_OnPITrail(ByVal sender As System.Object, ByVal e As nsoftware.IPWorks.FtpPITrailEventArgs) Handles Ftp1.OnPITrail
    txtPITrail.AppendText(e.Direction & ": " & e.Message & vbCrLf)
  End Sub

  Private Sub Update_ComboBox(ByRef cboBox As ComboBox, ByVal strItem As String)
    Dim i As Integer
    Dim intPos As Integer

    For i = 0 To (cboBox.Items.Count - 1)
      Dim x As String = cboBox.Items(i)
      If cboBox.Items(i) = strItem Then intPos = i
    Next i

    If intPos > 0 Then cboBox.Items.RemoveAt(intPos)

    cboBox.Items.Insert(0, strItem)
    cboBox.Text = cboBox.Items(0)
  End Sub

  Private Sub Local_Dir_Refresh()
    Dim localDir As New System.IO.DirectoryInfo(currentDir.GetCurrentDirectory)

    Update_ComboBox(cboLocalPath, currentDir.GetCurrentDirectory)
    lvwLocalDir.Items.Clear()

    lvwLocalDir.Items.Add("..")
    lvwLocalDir.Items(0).SubItems.Add("<dir>")
    lvwLocalDir.Items(0).SubItems.Add("")

    Dim dirName As System.IO.DirectoryInfo
    For Each dirName In localDir.GetDirectories()
      Dim intlvwCount As Integer = lvwLocalDir.Items.Count
      lvwLocalDir.Items.Add(dirName.Name)
      lvwLocalDir.Items(intlvwCount).SubItems.Add("<dir>")
      lvwLocalDir.Items(intlvwCount).SubItems.Add(dirName.CreationTime)
    Next

    Dim fileName As System.IO.FileInfo
    For Each fileName In localDir.GetFiles
      Dim intlvwCount As Integer = lvwLocalDir.Items.Count
      lvwLocalDir.Items.Add(fileName.Name)
      lvwLocalDir.Items(intlvwCount).SubItems.Add(fileName.Length)
      lvwLocalDir.Items(intlvwCount).SubItems.Add(fileName.LastWriteTime)
    Next

  End Sub
  Private Sub Remote_Dir_Refresh()
    Update_ComboBox(cboRemotePath, Ftp1.RemotePath)
    lvwRemoteDir.Items.Clear()
    Try
      Ftp1.RemoteFile = ""
      Ftp1.ListDirectoryLong()
    Catch
      MsgBox("Error: " & Err.Number & " " & Err.Description)
    End Try
  End Sub

  Private Sub optAscii_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles optAscii.Click
    Ftp1.TransferMode = nsoftware.IPWorks.FtpTransferModes.tmASCII
  End Sub
  Private Sub optBinary_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles optBinary.Click
    Ftp1.TransferMode = nsoftware.IPWorks.FtpTransferModes.tmBinary
  End Sub
  Private Sub optAuto_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles optAuto.Click
    Ftp1.TransferMode = nsoftware.IPWorks.FtpTransferModes.tmDefault
  End Sub
End Class
