<!--This tip (GraphPointerX.aspx) shows how to build (on-the-fly) and display
    a graphical pointer to different parts of the image (ASP.NET applications).
    Online demo URL=http://www.amerihomesrealty.com/GraphPointerX.aspx
    
      Author:  Vladimir Olifer,  e-mail: Vladimir.Olifer@gte.net            -->


<!--------------------------GraphPointerX.aspx----------------------------->
<%@ Page EnableSessionState="False" enableViewState="False" %>
<%@ Import Namespace="System.Drawing" %>
<%@ Import Namespace="System.Drawing.Drawing2D" %>
<html><head>
<script language="VB" runat="server">
Sub Page_Load(sender As Object, e As EventArgs) 
         If Request.QueryString("showX") = "yes" Then ShowX()
         If Request.QueryString("show") = "yes" Then
            Image1.ImageUrl = Request.Url.AbsolutePath & "?" _
             & Replace(Request.QueryString.ToString, "show", "showX")
             Label1.Text = Request.QueryString("element")
         End If
End Sub

   Sub ShowX()
        Dim YY(6) As System.Drawing.PointF, i%
        For i = 0 To 6
             YY(i).X = Choose(i + 1, 0, -6, -2, -2, 2, 2, 6, 0)
             YY(i).Y = Choose(i + 1, 0, -6, -6, -14, -14, -6, -6, 0)
        Next
        Dim h% = Image1.Height.Value, w% = Image1.Width.Value
        Dim bmp As New Bitmap(w, h), gr As Graphics = Graphics.FromImage(bmp)
        gr.DrawImage(New Bitmap(System.Drawing.Image.FromFile(Server.MapPath("home.Jpeg"))), 0, 0, w, h)
        If Request.QueryString("element") <> "" Then
        Dim x! = Request.QueryString("x"), y! = Request.QueryString("y")
          Select Case Request.QueryString("type")
              Case "top"
                  gr.Transform = New Matrix(1.0F, 0.0F, 0.0F, 1.0F, x, y)
              Case "bottom"
                  gr.Transform = New Matrix(1.0F, 0.0F, 0.0F, -1.0F, x, y)
              Case "left"
                  gr.Transform = New Matrix(0.0F, 1.0F, 1.0F, 0.0F, x, y)
              Case "right"
                  gr.Transform = New Matrix(0.0F, 1.0F, -1.0F, 0.0F, x, y)
          End Select
        gr.FillPolygon(Brushes.Yellow, YY)
        gr.DrawPolygon(Pens.Black, YY)
        End If
        With Response
          .Clear() :   bmp.Save(.OutputStream, Imaging.ImageFormat.Jpeg)
        End With
        gr.Dispose() : bmp.Dispose()
    End Sub
</script></head>


<body>
<form  runat="server">
   <table style="FONT-SIZE: 9pt; FONT-FAMILY: Arial;" height="174" width="307" align="center" border="0">
   <tr><td style="WIDTH: 146px" align="middle">
            <asp:image id="Image1" runat="server" Height="100px" Width="100px" 
            ImageUrl="GraphPointerX.aspx?showX=yes" BorderWidth="1px"> </asp:image><br><br>
            <asp:label id="Label1" runat="server" ForeColor="Green">&nbsp;</asp:label></td>
        <td>
            <P><b>Show me where:</b><br>
            <asp:hyperlink id="hlRoof" runat="server"                 NavigateUrl="GraphPointerX.aspx?show=yes&amp;x=30&amp;y=30&amp;type=top&amp;element=Roof">
               Roof</asp:hyperlink><br>
           <asp:hyperlink id="hlWall" runat="server"                              NavigateUrl="GraphPointerX.aspx?show=yes&amp;x=20&amp;y=60&amp;type=left&amp;element=Wall">
              Wall</asp:hyperlink><br>
           <asp:hyperlink id="hlWindow" runat="server"                              NavigateUrl="GraphPointerX.aspx?show=yes&amp;x=47&amp;y=70&amp;type=bottom&amp;element=Window">
              Window</asp:hyperlink><br>
           <asp:hyperlink id="hlDoor" runat="server"               NavigateUrl="GraphPointerX.aspx?show=yes&amp;x=70&amp;y=70&amp;type=right&amp;element=Door">Door</asp:hyperlink><br>
           <asp:hyperlink id="hlChimney" runat="server"              NavigateUrl="GraphPointerX.aspx?show=yes&amp;x=70&amp;y=10&amp;type=right&amp;element=Chimney">Chimney</asp:hyperlink>
             </P><P>&nbsp;</P></td>
   </tr>
   </table></form></body></html>