using System;
using System.Data;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Data.Common;

namespace DataGridCSharp
{
	/// <summary>
	/// Summary description for AdvancedRepeater.
	/// </summary>
	public class AdvancedRepeater : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Repeater Repeater1;
	
//var used for the name of the title
private string m_strTitle;

	private void Page_Load(object sender, System.EventArgs e)
	{
		if (!IsPostBack)
		{
			//load the repeater the fist time the pages loads
			//using a repeater sometimes is a good candidate for UC
			LoadRepeater();
		}


	}
	private void LoadRepeater ()
	{
		//fill the repeater
		SqlConnection conn = new SqlConnection(System.Configuration.ConfigurationSettings.AppSettings["ConnectionStringNWnd"]);
		SqlCommand cmd = new SqlCommand("select Title, FirstName + ' ' + LastName as EmpName From  dbo.Employees Order By Title",conn);
		SqlDataReader dr;

		conn.Open();
		dr=cmd.ExecuteReader(CommandBehavior.Default);
	
		//do the databinding
		Repeater1.DataSource=dr;
		Repeater1.DataBind();
	}

//must hook up to the ItemDataBound Event Sink
private void RepeaterSkip(Object sender, RepeaterItemEventArgs e)
{
	string strTitle;

	//This is going to fire for the <ItemTemplate> items only
	if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem) 
	{ 
		//get the data that is in the current record
		//and stuff it into a DataRecord
		DbDataRecord dbr   = (DbDataRecord) e.Item.DataItem;
		//Get the current value of the item being databound
		strTitle = dbr["Title"].ToString();
		//compare to the module static variable and if the same
		//make the HTML invisible
		if (strTitle.Equals(m_strTitle))
		{
			//My HTML has this in it: <tr id="trheader" runat="server">
			((System.Web.UI.HtmlControls.HtmlTableRow)e.Item.FindControl("trheader")).Visible = false;
		}
		//now make the module variable the same as the current item
		m_strTitle = strTitle;
	}
}
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
