using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace ServerControls
{
	/// <summary>
	/// Summary description for ContactDataList.
	/// </summary>
	public class ContactDataList : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.HyperLink HyperLink1;
		protected System.Web.UI.WebControls.DropDownList DropDown1;
		protected System.Web.UI.WebControls.DropDownList DropDown2;
		protected System.Web.UI.WebControls.DropDownList DropDown3;
		protected System.Web.UI.WebControls.CheckBox Check1;
		protected System.Web.UI.WebControls.LinkButton Button1;
		protected System.Web.UI.WebControls.DataList DataList1;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			DataSet ds;
			ds = new DataSet();
			//load from XML into a dataset
			ds.ReadXml(Server.MapPath("Contacts.xml"));
			//dataview
			DataView dv = ds.Tables[0].DefaultView;
			//real simple binding code here
			DataList1.DataSource=dv;
			DataList1.DataBind();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Button1.Click += new System.EventHandler(this.Button1_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void Button1_Click(object sender, System.EventArgs e)
		{
			//get the user options
			if (DropDown1.SelectedIndex == 0 )
				DataList1.RepeatDirection = RepeatDirection.Horizontal;
			else
				DataList1.RepeatDirection = RepeatDirection.Vertical;
        
					if (DropDown2.SelectedIndex ==0)
						DataList1.RepeatLayout = RepeatLayout.Table;
					else
						DataList1.RepeatLayout = RepeatLayout.Flow;

			DataList1.RepeatColumns = DropDown3.SelectedIndex + 1;
        
			if ((Check1.Checked == true) && (DataList1.RepeatLayout == RepeatLayout.Table))
			{
				DataList1.BorderWidth = Unit.Pixel(1);
				DataList1.GridLines = GridLines.Both;
			}
			else
			{
				DataList1.BorderWidth = Unit.Pixel(0);
				DataList1.GridLines = GridLines.None;
			}
		}
	}
}
