using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Data.SqlClient;

namespace DataGridCSharp
{

public class WebForm1 : System.Web.UI.Page
{
	protected System.Web.UI.WebControls.DataGrid DataGrid1;
	protected System.Web.UI.WebControls.Label lblResults;

	//used for hiding a table cell
	bool bln=false;

	private void Page_Load(object sender, System.EventArgs e)
	{
		if (!IsPostBack) 
		{
			//call the function to fill the grid
			fillGrid();
		}

	}


	public void fillGrid()
	{
		//You can store a connection string in the web.confif section
		SqlConnection conn =new SqlConnection(System.Configuration.ConfigurationSettings.AppSettings["ConnectionStringNWnd"]);
		//open the connection
		conn.Open();
		//can set a command to a SQL text and connection
		SqlCommand cmd = new SqlCommand("Select * From Customers", conn);
		SqlDataReader dr;
	
		//open a datareader
		dr = cmd.ExecuteReader(CommandBehavior.Default);

		//do the databinding
		DataGrid1.DataSource = dr;
		DataGrid1.DataBind();
		
		//use the properties of the datagrid
		//to show the total number of items
		lblResults.Text = DataGrid1.Items.Count + " Rows Returned";
	}

	//ignore this code until demo 3!!

	//this toggles the yellow part
	public void ToggleYellow(object sender, DataGridItemEventArgs e)
	{
		if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem) 
		{
			//get the data that is in the current record
			if (e.Item.Cells[2].Text == "Sales Representative")
			{
				//make the cell yellow
				e.Item.Cells[2].BackColor = System.Drawing.Color.Yellow;
			}
		}
	}

	//this adds a footer
/**/
	public void CreateFooter(object sender, DataGridItemEventArgs e )
	{
		
		//use datagrid's footer
		//to display a message to users
		if (bln == true)
			{
			TableCell tc;  
			tc = e.Item.Cells[0];
			tc.Text = "Total Amount of Rows in this Query: " + DataGrid1.Items.Count.ToString();
			tc.HorizontalAlign = HorizontalAlign.Right;
			}

		bln = true;
	}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.DataGrid1.ItemDataBound += new System.Web.UI.WebControls.DataGridItemEventHandler(this.ToggleYellow);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}

