using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

namespace DataGridCSharp
{

public class DataGridDemo5 : System.Web.UI.Page
{
	protected System.Web.UI.WebControls.TextBox txtSQLStatement;
	protected System.Web.UI.WebControls.DataGrid DataGrid1;

	private void Page_Load(object sender, System.EventArgs e)
	{
		if (!IsPostBack) 
		{
			//SQL statement in the text box the 1st time
			txtSQLStatement.Text = "Select * From Customers";
			FillGrid("Select * From Customers");
			//For toggle of ASC DESC via ViewState
			ViewState ["sortField"] = "CustomerID";
			ViewState ["sortDirection"] = "ASC";
		}
	}


	private void FillGrid(string strSQL )
	{
		//to presist the SQL statement
		//should use ViewState in production
		txtSQLStatement.Text = "" + strSQL;
		//You can store a connection string in the web.confif section
		SqlConnection conn =new SqlConnection(System.Configuration.ConfigurationSettings.AppSettings["ConnectionStringNWnd"]);
		//typical DataSet
		DataSet ds=new DataSet();
		SqlDataAdapter da;
		//open the connection
		conn.Open();
		//fill the da
		da = new SqlDataAdapter (strSQL, conn);
		da.Fill(ds, "Customers");
		
		//perform the databinding here
		DataGrid1.DataSource = ds.Tables["Customers"];
		DataGrid1.DataBind();
	}

	
	private void MovePage(object source, DataGridPageChangedEventArgs e)
	{
	//move to the selected page																																							'move to the next page
	DataGrid1.CurrentPageIndex = e.NewPageIndex;
	//refill the grid w/ existing SQL statement
	FillGrid(txtSQLStatement.Text);
	}

	
	private void SortGrid(object source,DataGridSortCommandEventArgs e) 
	{
	//SQL String that will be used
	string strSQL = "Select * From Customers";
	//the Order By
	string strOrderBy  = "ASC";


	//See what the viewstate has for the sortfield and ASC/DESC
	if (e.SortExpression.ToString() == ViewState["sortField"].ToString())
		{
			//a match, see if ASC or DESC
			strOrderBy = ViewState["sortDirection"].ToString();
			//now toggle the viewstate for later
			switch (strOrderBy)
				{
					case "ASC":
						ViewState["sortDirection"] = "DESC";
						break;
					case "DESC":
						ViewState["sortDirection"] = "ASC";
						break;
				}
		}
		else
		{
			//New Field, so it will be ASC by default, so make DESC
			ViewState["sortField"] = e.SortExpression.ToString();
			ViewState["sortDirection"] = "DESC";
		}

	//SQL statement compelted
	strSQL = strSQL + " " + " ORDER BY [" + e.SortExpression + "] " + strOrderBy;
	//set the grid to the first page before you resort
	DataGrid1.CurrentPageIndex = 0;
	//call the FillGrid method to rebind the grid w/ new OrderBy
	FillGrid(strSQL);

	}

#region Web Form Designer generated code
	override protected void OnInit(EventArgs e)
	{
		//
		// CODEGEN: This call is required by the ASP.NET Web Form Designer.
		//
		InitializeComponent();
		base.OnInit(e);
	}
	
	/// <summary>
	/// Required method for Designer support - do not modify
	/// the contents of this method with the code editor.
	/// </summary>
	private void InitializeComponent()
	{    
		this.DataGrid1.PageIndexChanged += new System.Web.UI.WebControls.DataGridPageChangedEventHandler(this.MovePage);
		this.DataGrid1.SortCommand += new System.Web.UI.WebControls.DataGridSortCommandEventHandler(this.SortGrid);
		this.Load += new System.EventHandler(this.Page_Load);

	}
	#endregion
}
}
