using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

namespace DataGridCSharp
{

public class DataGridDemo6 : System.Web.UI.Page
{
	protected System.Web.UI.WebControls.DataGrid DataGrid1;
	protected System.Web.UI.WebControls.Label lblMessage;

	private void Page_Load(object sender, System.EventArgs e)
	{
		if (!IsPostBack) 
		{
			//call the function to fill the grid
			fillGrid("Select * From Customers");
		}
	}


	public void fillGrid(string strSQL)
	{
		//You can store a connection string in the web.confif section
		SqlConnection conn =new SqlConnection(System.Configuration.ConfigurationSettings.AppSettings["ConnectionStringNWnd"]);
		//open the connection
		conn.Open();
		//can set a command to a SQL text and connection
		SqlCommand cmd = new SqlCommand(strSQL, conn);
		SqlDataReader dr;
	
		//open a datareader
		dr = cmd.ExecuteReader(CommandBehavior.Default);

		//do the databinding
		DataGrid1.DataSource = dr;
		DataGrid1.DataBind();
	}


	public void GridEdit(object source, DataGridCommandEventArgs e) 
		{
			//set the EditItemIndex of the item to edit
			DataGrid1.EditItemIndex = e.Item.ItemIndex;
			fillGrid("Select * From Customers");
		}


	public void GridCancel(object source,DataGridCommandEventArgs e) 
	{
		//real easy, just start over
		DataGrid1.EditItemIndex = -1;
		fillGrid("Select * From Customers");
	}


	public void GridUpdate(object source, DataGridCommandEventArgs e)
	{
		//update code here!
		SqlConnection conn = new SqlConnection(System.Configuration.ConfigurationSettings.AppSettings["ConnectionStringNWnd"]);
		//DataSet ds;
		SqlCommand cmd; 
		TextBox CurrentTextBox;

		string strSQL = "UPDATE Customers SET ContactName = @ContactName, ContactTitle = @ContactTitle, Address = @Address";
		strSQL += "\n where CustomerID = @CustomerID";

		cmd = new SqlCommand(strSQL, conn);

		cmd.Parameters.Add("@CustomerID",SqlDbType.NVarChar, 5, "CustomerID");
		cmd.Parameters.Add("@ContactName",SqlDbType.NVarChar, 50, "ContactName");
		cmd.Parameters.Add("@ContactTitle",SqlDbType.NVarChar, 50, "ContactTitle");
		cmd.Parameters.Add("@Address",SqlDbType.NVarChar, 50, "Address");

		cmd.Parameters["@CustomerID"].Value = DataGrid1.DataKeys[e.Item.ItemIndex];

		//very important
		DataGrid1.EditItemIndex = e.Item.ItemIndex;

		CurrentTextBox = (TextBox) (e.Item.Cells[2].Controls[0]);
		cmd.Parameters["@ContactName"].Value = Server.HtmlEncode(CurrentTextBox.Text);

		CurrentTextBox = (TextBox) (e.Item.Cells[3].Controls[0]);
		cmd.Parameters["@ContactTitle"].Value = Server.HtmlEncode(CurrentTextBox.Text);

		CurrentTextBox = (TextBox) (e.Item.Cells[4].Controls[0]);
		cmd.Parameters["@Address"].Value = Server.HtmlEncode(CurrentTextBox.Text);

		cmd.Connection.Open();

		try
			{
				cmd.ExecuteNonQuery();
				lblMessage.Text = "Record Updated:" + cmd.ToString();
				DataGrid1.EditItemIndex = -1;
			}
		catch (SqlException Exp)
			{
				if (Exp.Number == 2627)
					{
						lblMessage.Text = "ERROR: A record already exists with the same primary key";
					}
				else
					{
						lblMessage.Text = "ERROR: Could not update record, please ensure the fields are correctly filled out Error: " + Exp.ToString();
					}
			}

		cmd.Connection.Close();

		fillGrid("Select * From Customers");

}


	#region Web Form Designer generated code
	override protected void OnInit(EventArgs e)
	{
		//
		// CODEGEN: This call is required by the ASP.NET Web Form Designer.
		//
		InitializeComponent();
		base.OnInit(e);
	}
	
	/// <summary>
	/// Required method for Designer support - do not modify
	/// the contents of this method with the code editor.
	/// </summary>
	private void InitializeComponent()
	{    
		this.DataGrid1.CancelCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.GridCancel);
		this.DataGrid1.EditCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.GridEdit);
		this.DataGrid1.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.GridUpdate);
		this.Load += new System.EventHandler(this.Page_Load);

	}
	#endregion
}
}
