Imports System.Data.SqlClient

Public Class DataGridDemo5
    Inherits System.Web.UI.Page
Protected WithEvents txtSQLStatement As System.Web.UI.WebControls.TextBox
Protected WithEvents DataGrid1 As System.Web.UI.WebControls.DataGrid

#Region " Web Form Designer Generated Code "

    'This call is required by the Web Form Designer.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: This method call is required by the Web Form Designer
        'Do not modify it using the code editor.
        InitializeComponent()
    End Sub

#End Region

Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    'code to run first time page is loaded
    If Not IsPostBack Then
        Me.txtSQLStatement.Text = "Select * From Customers"
        FillGrid("Select * From Customers")
        'For toggle of ASC DESC via ViewState
        viewstate("sortField") = "CustomerID"
        viewstate("sortDirection") = "ASC"
    End If
End Sub

Private Sub FillGrid(ByVal strSQL As String)

    'to presist the SQL statement
    'should use ViewState in production
    Me.txtSQLStatement.Text = "" & strSQL
    'You can store a connection string in the web.confif section
    Dim conn As New SqlClient.SqlConnection _
        (System.Configuration.ConfigurationSettings.AppSettings("ConnectionStringNWnd"))
    'typical DataSet
    Dim ds As New DataSet()
    Dim da As SqlDataAdapter

    'open the connection
    conn.Open()
    'fill the da
    da = New SqlDataAdapter(strSQL, conn)
    da.Fill(ds, "Customers")
    'perform the databinding here
    DataGrid1.DataSource = ds.Tables("Customers")
    DataGrid1.DataBind()

End Sub

Private Sub DataGrid1_PageIndexChanged(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridPageChangedEventArgs) Handles DataGrid1.PageIndexChanged

    'move to the next page
    DataGrid1.CurrentPageIndex = e.NewPageIndex
    'refill the grid
    FillGrid(Me.txtSQLStatement.Text)

End Sub

Private Sub DataGrid1_SortCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridSortCommandEventArgs) Handles DataGrid1.SortCommand
    'SQL String that will be used
    Dim strSQL As String = "Select * From Customers"
    'the Order By
    Dim strOrderBy As String = "ASC"

    'See what the viewstate has for the sortfield and ASC/DESC
    If e.SortExpression.ToString() = viewstate("sortField").ToString() Then
        'a match, see if ASC or DESC
        strOrderBy = viewstate("sortDirection").ToString()
        'now toggle the viewstate for later
        Select Case strOrderBy
            Case "ASC"
                viewstate("sortDirection") = "DESC"
            Case "DESC"
                viewstate("sortDirection") = "ASC"
        End Select
    Else
        'New Field, so it will be ASC by default, so make DESC
        viewstate("sortField") = e.SortExpression
        viewstate("sortDirection") = "DESC"
    End If

    'SQL statement compelted
    strSQL &= vbNewLine & " ORDER BY [" + e.SortExpression & "] " & strOrderBy

    'set the grid to the first page before you resort
    Me.DataGrid1.CurrentPageIndex = 0
    'call the FillGrid method to rebind the grid w/ new OrderBy
    FillGrid(strSQL)

End Sub

End Class
