Imports System.Data.SqlClient

Public Class DataGridDemo6
    Inherits System.Web.UI.Page
Protected WithEvents lblMessage As System.Web.UI.WebControls.Label
Protected WithEvents DataGrid1 As System.Web.UI.WebControls.DataGrid

#Region " Web Form Designer Generated Code "

    'This call is required by the Web Form Designer.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: This method call is required by the Web Form Designer
        'Do not modify it using the code editor.
        InitializeComponent()
    End Sub

#End Region

Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    'Put user code to initialize the page here
    If Not IsPostBack Then FillGrid("Select * From Customers")
End Sub

Public Sub FillGrid(ByVal strSQL As String)

    'You can store a connection string in the web.confif section
    Dim conn As New SqlClient.SqlConnection _
        (System.Configuration.ConfigurationSettings.AppSettings("ConnectionStringNWnd"))
    Dim ds As New DataSet()
    Dim da As SqlDataAdapter

    'open the connection
    conn.Open()
    da = New SqlDataAdapter(strSQL, conn)
    da.Fill(ds, "Customers")
    DataGrid1.DataSource = ds.Tables("Customers")
    DataGrid1.DataBind()

End Sub

Public Sub DataGrid1_EditCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridCommandEventArgs) Handles DataGrid1.EditCommand
DataGrid1.EditItemIndex = e.Item.ItemIndex
FillGrid("Select * From Customers")
End Sub

Public Sub DataGrid1_CancelCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridCommandEventArgs) Handles DataGrid1.CancelCommand
DataGrid1.EditItemIndex = -1
FillGrid("Select * From Customers")
End Sub

Public Sub DataGrid1_UpdateCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridCommandEventArgs) Handles DataGrid1.UpdateCommand
'update code here!

'Dim currenttextbox As TextBox
'currenttextbox = e.Item.Cells(2).Controls(0)
'Me.lblMessage.Text = Server.HtmlEncode(currenttextbox.Text)

Dim conn As New SqlClient.SqlConnection _
        (System.Configuration.ConfigurationSettings.AppSettings("ConnectionStringNWnd"))
Dim cmd As SqlCommand
Dim CurrentTextBox As TextBox

Dim strSQL As String = "UPDATE Customers SET ContactName = @ContactName, ContactTitle = @ContactTitle, Address = @Address"
strSQL &= vbNewLine & "where CustomerID = @CustomerID"

cmd = New SqlCommand(strSQL, conn)

cmd.Parameters.Add(New SqlParameter("@CustomerID", SqlDbType.NVarChar, 5))
cmd.Parameters.Add(New SqlParameter("@ContactName", SqlDbType.NVarChar, 50))
cmd.Parameters.Add(New SqlParameter("@ContactTitle", SqlDbType.NVarChar, 50))
cmd.Parameters.Add(New SqlParameter("@Address", SqlDbType.NVarChar, 50))

cmd.Parameters("@CustomerID").Value = DataGrid1.DataKeys(e.Item.ItemIndex)

'very important
DataGrid1.EditItemIndex = e.Item.ItemIndex

CurrentTextBox = e.Item.Cells(2).Controls(0)
cmd.Parameters("@ContactName").Value = Server.HtmlEncode(CurrentTextBox.Text)

CurrentTextBox = e.Item.Cells(3).Controls(0)
cmd.Parameters("@ContactTitle").Value = Server.HtmlEncode(CurrentTextBox.Text)

CurrentTextBox = e.Item.Cells(4).Controls(0)
cmd.Parameters("@Address").Value = Server.HtmlEncode(CurrentTextBox.Text)

cmd.Connection.Open()

Try
    cmd.ExecuteNonQuery()
    Me.lblMessage.Text = "Record Updated:" & cmd.ToString()
    DataGrid1.EditItemIndex = -1
Catch Exp As SqlException
    If Exp.Number = 2627 Then
        lblMessage.Text = "ERROR: A record already exists with the same primary key"
    Else
        lblMessage.Text = "ERROR: Could not update record, please ensure the fields are correctly filled out Error: " & Err.Description
    End If
    'Message.Style("color") = "red"
End Try

cmd.Connection.Close()

FillGrid("Select * From Customers")

End Sub

Public Sub DataGrid1_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.DataGridItemEventArgs) Handles DataGrid1.ItemDataBound

If (e.Item.ItemType = ListItemType.EditItem) Then
    Dim intCount As Integer

    For intCount = 0 To e.Item.Controls.Count - 1
        'Change the item to a text box
        If (e.Item.Controls(intCount).Controls(0).GetType().ToString() = _
            "System.Web.UI.WebControls.TextBox") Then
            Dim txt As TextBox
            txt = e.Item.Controls(intCount).Controls(0)
            txt.Text = Server.HtmlDecode(txt.Text)
        End If
    Next
End If

End Sub

End Class
