' *****************************************************************************
'
'  NOTE: This file is client side VBScript. The comments are in server side script 
'  so they don't get sent to the client.
'
'  The sample code shows how to create a simple context sensitive button
'
'  created by Stefan Goner (stefang@microsoft.com) MAY-26-2003.
'  Help message and image alignment tweaks by Andrew Connell (andrew@aconnell.com) DEC-24-2003.
'
' *****************************************************************************
'
'
' -----------------------------------------------------------------------------
'
'  This is the hook function being called when the Toolbar is initialized for the first time. 
'  The custom code here can add or remove toolbar buttons.
'
'   @pToolbarInterface [in] - Toolbar interface object that can be used to create
'                             button or comboboxes.
'
' sample implementation that creates a new toolbar and adds five buttons to it:
'
' -----------------------------------------------------------------------------

call EnableCompatibleToolbarHooks

Sub OnToolbarInitialize( ByVal pToolbarInterface )

	Dim pToolBar

	Set pToolBar = document.ToolbarInterface.Toolbars.CreateToolbar("ImageAlignment")
 	Call pToolBar.AddButton( "IABOTTOM", "", "sg-top.gif", "Align Image Top" )
 	Call pToolBar.AddButton( "IALEFT", "", "sg-left.gif", "Align Image Left" )
 	Call pToolBar.AddButton( "IAMIDDLE", "", "sg-center.gif", "Align Image Middle" )
 	Call pToolBar.AddButton( "IARIGHT", "", "sg-right.gif", "Align Image Right" )
 	Call pToolBar.AddButton( "IATOP", "", "sg-bottom.gif", "Align Image Bottom" )
 	call pToolBar.AddSeperator	

End Sub

' -----------------------------------------------------------------------------
'
'	This hook is called for each placeholder, and is used to initialize the state
'	for that specific placeholder. The toolbar state will already be initialized to
'	its default state.
'
'	@strPlaceholderName [in] - The name of the placeholder we are initializing for
'
'	@pState [in] - The toolbar state of this toolbar. The toolbar state keeps track
'					of the clicked/disabled state for the toolbar for this placeholder.
'
' sample implementation that enables our button only if the InsertTable button is enabled as well:
'
'	If (pState.Item("InsertTable").Allowed = True) Then
'		pState.Item("TestButton").Allowed = True
'	End If
' -----------------------------------------------------------------------------

Sub OnToolbarStateInitialize( ByVal strPlaceholderName, ByVal pState )
	pState.Item("IABOTTOM").Allowed = True
	pState.Item("IATOP").Allowed = True
	pState.Item("IALEFT").Allowed = True
	pState.Item("IAMIDDLE").Allowed = True
	pState.Item("IARIGHT").Allowed = True
End Sub

' -----------------------------------------------------------------------------
'
'	This is the hook function being called when the toolbar state should be
'	updated because there is a change of state or context in the ActiveX
'	placeholder.
'
'	@pActiveHtmlEditor [in] - The currently active DHTML control
'
'	@bEditingSource [in] - TRUE if we are currently in HTML Source Mode
'
' sample implementation that only enables the test button in non-HTML edit mode
'
'	If bEditingSource Then
'		pActiveHtmlEditor.ToolbarState.Item("TestButton").Enabled = False
'	Else
'		pActiveHtmlEditor.ToolbarState.Item("TestButton").Enabled = True
'	End If
' -----------------------------------------------------------------------------

Sub OnToolbarUpdate( ByVal pActiveHtmlEditor, ByVal bEditingSource )

	if bEditingSource Then
		pActiveHtmlEditor.ToolbarState.Item("IABOTTOM").Enabled = False
		pActiveHtmlEditor.ToolbarState.Item("IATOP").Enabled = False
		pActiveHtmlEditor.ToolbarState.Item("IALEFT").Enabled = False
		pActiveHtmlEditor.ToolbarState.Item("IAMIDDLE").Enabled = False
		pActiveHtmlEditor.ToolbarState.Item("IARIGHT").Enabled = False
	else
		pActiveHtmlEditor.ToolbarState.Item("IABOTTOM").Enabled = True
		pActiveHtmlEditor.ToolbarState.Item("IATOP").Enabled = True
		pActiveHtmlEditor.ToolbarState.Item("IALEFT").Enabled = True
		pActiveHtmlEditor.ToolbarState.Item("IAMIDDLE").Enabled = True
		pActiveHtmlEditor.ToolbarState.Item("IARIGHT").Enabled = True
	end if
	
End Sub

' -----------------------------------------------------------------------------
'
'	This is the hook function being called when a button is clicked in the 
'	ActiveX toolbar.
'
'	@pActiveHtmlEditor [in] - The currently active DHTML edit control
'
'	@bstrId [in] - The ID of the button or combo box that was clicked on
'
'	@pItem [in] - The item that was clicked on
'
'	@bEditingSource [in] - TRUE if we are currently in HTML Source Mode
'
' sample implementation that shows a message box and makes the current text bold:
'
'	Select Case bstrId
'
'		Case "TestButton"
'			Call MsgBox( "hello!" )
'			pActiveHtmlEditor.dom.execCommand "Bold"
'
'	End Select
' -----------------------------------------------------------------------------

Sub OnToolbarEvent( ByVal pActiveHtmlEditor, ByVal bstrId, ByVal pItem, ByVal bEditingSource )

 	Select Case bstrId
		Case "IATOP"
 			call AlignImage(pActiveHtmlEditor,"top")
 		Case "IABOTTOM"
 			call AlignImage(pActiveHtmlEditor,"bottom")
 		Case "IALEFT"
 			call AlignImage(pActiveHtmlEditor,"left")
 		Case "IARIGHT"
 			call AlignImage(pActiveHtmlEditor,"right")
 		Case "IAMIDDLE"
			call AlignImage(pActiveHtmlEditor,"middle")	
	end select

End Sub



Sub AlignImage(ByVal pActiveHtmlEditor, ByVal strAlign)

 	Dim strhtml
 	Dim intIMGBegin
 	Dim intIMGEnd
 	Dim intAlign	
 	Dim objTextRange
 
	on error resume next
 	set objTextRange = pActiveHtmlEditor.dom.selection.createRange
 	strhtml = objTextRange.htmltext
 
 	If UBound(Split(UCase(strhtml), "<IMG")) = 1 Then
 	    intIMGBegin = InStr(UCase(strhtml), "<IMG")
 	    intIMGEnd = InStr(intIMGBegin, UCase(strhtml), ">")
 	    intAlign = InStr(intIMGBegin, UCase(strhtml), "ALIGN=")
 		    
 	    If intAlign > 0 Then
 	        If InStr(intAlign, strhtml, "middle") > 0 And InStr(intAlign, strhtml, "middle") < intIMGEnd Then
 	            objTextRange.pastehtml Left(strhtml, intAlign - 1) & "ALIGN=""" & strAlign &""" " & Right(strhtml, Len(strhtml) - InStr(intAlign, strhtml, "middle") - 5)
 	        ElseIf InStr(intAlign, strhtml, "top") > 0 And InStr(intAlign, strhtml, "top") < intIMGEnd Then
 	            objTextRange.pastehtml Left(strhtml, intAlign - 1) & "ALIGN=""" & strAlign &""" " &  Right(strhtml, Len (strhtml) - InStr(intAlign, strhtml, "top") - 2)
 	        ElseIf InStr(intAlign, strhtml, "bottom") > 0 And InStr(intAlign, strhtml, "bottom") < intIMGEnd Then
 	            objTextRange.pastehtml Left(strhtml, intAlign - 1) & "ALIGN=""" & strAlign &""" " &  Right(strhtml, Len (strhtml) - InStr(intAlign, strhtml, "bottom") - 5)
 	        ElseIf InStr(intAlign, strhtml, "left") > 0 And InStr(intAlign, strhtml, "left") < intIMGEnd Then
 	            objTextRange.pastehtml Left(strhtml, intAlign - 1) & "ALIGN=""" & strAlign &""" " &  Right(strhtml, Len (strhtml) - InStr(intAlign, strhtml, "left") - 3)
 	        ElseIf InStr(intAlign, strhtml, "right") > 0 And InStr(intAlign, strhtml, "right") < intIMGEnd Then
 	            objTextRange.pastehtml Left(strhtml, intAlign - 1) & "ALIGN=""" & strAlign &""" " &  Right(strhtml, Len (strhtml) - InStr(intAlign, strhtml, "right") - 4)
			Else
				call MsgBox("Image could not be aligned.",,"Image Align")
			End If
 	    Else
			objTextRange.pastehtml Left (strhtml, intIMGBegin + 4) & " ALIGN=""" & strAlign &""" " & Right (strhtml, Len(strhtml) - intIMGBegin - 4)
 	    End If
 	Elseif UBound(Split(UCase(strhtml), "<IMG")) > 1 then
 	    Call MsgBox("Please select only one image to align.",,"Image Align")
 	End If
 	
 	'display error & help info
 	If err.number >0 Then
 		Call MsgBox ("The image could not be aligned." &Chr(13) &Chr(10) _
 				&"This could be because you didn't select the image or because of an unspecified error." &Chr(13) &Chr(10) &Chr(13) &Chr(10) _
 				&"To select an image, (1) place the cursor to the left of the image in the placeholder." &Chr(13) &Chr(10) _
 				&"(2) Then press [SHIFT][RIGHT-ARROW]." &Chr(13) &Chr(10) _
 				&"This will mask (or shadow) the image to show it is selected.  (3) Then click the appropriate image alignment button in the toolbar." &Chr(13) &Chr(10) &Chr(13) &Chr(10) _
 				&"If you need further assistance, please contact an administrator.", 64, "Image Align")
 	End If
 	
 	set objTextRange = nothing
end sub
