Imports System.IO

Public Class vioADC
  Private Declare Ansi Function GetPrivateProfileString _
  Lib "kernel32.dll" Alias "GetPrivateProfileStringA" _
  (ByVal lpApplicationName As String, _
  ByVal lpKeyName As String, ByVal lpDefault As String, _
  ByVal lpReturnedString As System.Text.StringBuilder, _
  ByVal nSize As Integer, ByVal lpFileName As String) _
  As Integer

  Function GetStartCashDirectory() As String
    Return Path.Combine(Environment.GetFolderPath( _
           Environment.SpecialFolder.LocalApplicationData), "assembly\dl2")
  End Function

  Function GetCashDirectory$(ByVal AssemblyFile$)
    Dim dirs$() = GetCashDirectories(GetStartCashDirectory())
    For Each asmDir As String In dirs
      If File.Exists(Path.Combine(asmDir, AssemblyFile)) Then
        Return asmDir
      End If
    Next
    Return Nothing
  End Function

  Function GetCashDirectories(ByVal startDirectory As String) As String()
    Dim results As New ArrayList
    For Each dir As String In Directory.GetDirectories(startDirectory)
      If File.Exists(Path.Combine(dir, _
               "__AssemblyInfo__.ini")) Then results.Add(dir)
      results.AddRange(Me.GetCashDirectories(dir))
    Next
    Return CType(results.ToArray(GetType(String)), String())
  End Function

  Function GetCachedAssemblyInfo(ByVal localCacheDirectory As String) _
                                                As CachedAssemblyInfo
    Return New CachedAssemblyInfo(localCacheDirectory)
  End Function

  Function DeleteCachedAssembly(ByVal asm As CachedAssemblyInfo)
    Directory.Delete(asm.LocalCacheDirectory, True)
  End Function

  Function DeleteCache()
    System.IO.Directory.Delete(GetStartCashDirectory(), True)
  End Function

  Public Structure CachedAssemblyInfo
    Public DisplayName, Version, Culture, URL, MVID, _
           PublicKeyToken, LocalCacheDirectory As String

    Public Sub New(ByVal [localCacheDirectory] As String)
      Const SecName$ = "AssemblyInfo"
      Dim fPath$ = Path.Combine([localCacheDirectory], "__AssemblyInfo__.ini")
      localCacheDirectory = [localCacheDirectory]
      URL = GetString(SecName, "URL", String.Empty, fPath)
      MVID = GetString(SecName, "MVID", String.Empty, fPath)
      Dim retValue = GetString(SecName, "DisplayName", String.Empty, fPath)
      Try
        Dim v$() = Split(retValue, ",")
        DisplayName = v(0)
        Version = Split(v(1), "=")(1)
        Culture = Split(v(2), "=")(1)
        PublicKeyToken = Split(v(3), "=")(1)
      Catch ex As Exception
      End Try
    End Sub

    Private Function GetString$(ByVal Section As String, _
      ByVal Key$, ByVal sDefault$, ByVal strFilename$)
      Dim intCharCount As Integer
      Dim objResult As New System.Text.StringBuilder(256)
      intCharCount = GetPrivateProfileString(Section, Key, _
         sDefault, objResult, objResult.Capacity, strFilename)
      If intCharCount > 0 Then GetString = _
         Left(objResult.ToString, intCharCount)
    End Function
  End Structure
End Class
