Global Const CTLRECESSED = 0   ' Frame is recessed.
Global Const CTLRAISED = -1    ' Frame is raised.
Global Const BKGNDGRAY = 192   ' Background Gray.
Global Const DARKGRAY = 64     ' Dark Gray
Global Const LIGHTGRAY = 255   ' Light Gray (white).
Global Const DEFAULTWIDTH = 3  ' Default Frame Width
Global FrameWidth As Integer   ' Width of 3d frame (in pixels).

Sub HighLight (C As Control, InOut As Integer)
' Convert ScaleMode of form to pixels.
' Set up colors for borders on InOut.  For recessed control:
'       top & left = dark, bottom & right = left
'       opposite for raised controls.
    C.Parent.ScaleMode = 3
    If InOut = CTLRAISED Then
        TLShade& = RGB(LIGHTGRAY, LIGHTGRAY, LIGHTGRAY)
        BRShade& = RGB(DARKGRAY, DARKGRAY, DARKGRAY)
    Else
        TLShade& = RGB(DARKGRAY, DARKGRAY, DARKGRAY)
        BRShade& = RGB(LIGHTGRAY, LIGHTGRAY, LIGHTGRAY)
    End If
' Now draw the Frame Around the Control, on the Parent Form.
    For I% = 1 To FrameWidth
        T% = C.Top - I%
        L% = C.Left - I%
        H% = C.Height + 2 * I%
        W% = C.Width + 2 * I%
        C.Parent.Line (L%, T%)-Step(0, H%), TLShade&   ' left side
        C.Parent.Line (L%, T%)-Step(W%, 0), TLShade&   ' top
        C.Parent.Line (L% + W%, T%)-Step(0, H%), BRShade& ' right side
        C.Parent.Line (L%, T% + H%)-Step(W%, 0), BRShade&  ' bottom
    Next I%
End Sub

