Option Explicit
' the BRW_INC.TXT was included here

'====== BROWSE CONTROL CONSTANTS ===============================================================
' Limitative Constants
Global Const BRW_MAX_NO_OF_COLS = 64     ' Maximum number of columns in the browse
Global Const BRW_MAX_COL_WIDTH = 256     ' Maximum column width (in characters)

' Error Codes
Global Const BRW_ERR_BADINDX = 81        ' Invalid index reference to one of the array properties
Global Const BRW_ERR_NO_OF_COLS = 32700  ' Invalid number of columns
Global Const BRW_ERR_COL_NO = 32702      ' Invalid column no
Global Const BRW_ERR_ROW_NO = 32703      ' Invalid row number
Global Const BRW_ERR_COL_WIDTH = 32704   ' Invalid data column width (characters)
Global Const BRW_ERR_COL_WIDTHX = 32705  ' Invalid column width (pixels)

' Available actions (for the Action property)
Global Const BRW_ACT_REFRESHLINE = 1     ' Refresh current line (will trigger one GetLine event)
Global Const BRW_ACT_REFRESHALL = 2      ' Refresh all visible lines / records (impl. RefreshBar)
Global Const BRW_ACT_REFRESHBAR = 3      ' Refresh the vertical scroll bar (not needed normally)
Global Const BRW_ACT_GOBOTTOM = 4        ' Go to the last record in file / scope and refresh all
Global Const BRW_ACT_GOTOP = 5           ' Go to the first record in file / scope and refresh all
Global Const BRW_ACT_UP = 6              ' Skip one record up, if not posible a HitTop is fired
Global Const BRW_ACT_DOWN = 7            ' Skip one record down, if not pos. a HitBottom is fired
Global Const BRW_ACT_RIGHT = 8           ' Move to the next column to the right (if any)
Global Const BRW_ACT_LEFT = 9            ' Move to the next column to the left (if any)
Global Const BRW_ACT_EDIT = 10           ' Edit current cell, if editing is enabled

' Values of the nRowCol argument of the Change event:
Global Const BRW_CHANGE_REC = 0          ' The record no has changed
Global Const BRW_CHANGE_ROW = 1          ' The recno no and the Row have changed
Global Const BRW_CHANGE_COL = 2          ' The column no has changed
Global Const BRW_CHANGE_BOTH = 3         ' Both the row and column no have changed

' Column text display alignment for the ColAlign propriety
Global Const BRW_ALIGN_LEFT = 0          ' The column text is left justified (default):
Global Const BRW_ALIGN_CENTER = 1        ' The column text is centered
Global Const BRW_ALIGN_RIGHT = 2         ' The column text is right justified
Global Const BRW_ALIGNH_LEFT = 4         ' The column header text is left justified (default):
Global Const BRW_ALIGNH_CENTER = 8       ' The column header text is centered
Global Const BRW_ALIGNH_RIGHT = 16       ' The column header text is right justified
'===============================================================================================

Function HasFocus (c As Control) As Integer
   ' find out if the control c has focus
   On Error Resume Next
   If Screen.ActiveControl.hWnd = c.hWnd Then HasFocus = True
End Function

