#ifdef __ZTC__                          // Zortech doesn't know _huge
#define _huge   /* */
#endif
#define STRICT  1

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define APPNAME     "DLGSTYLE"
WORD	ZTCAllocFlag = GMEM_SHARE;

#ifdef DLLPROC
#undef DLLPROC
#endif

#define DLLPROC     FAR PASCAL _export
#ifndef DLLCALLBACK
#define DLLCALLBACK FAR PASCAL _export _loadds
#endif

#define	INT		int
#define	CHAR	char

#include "w:\windev\vbx\vbapi.h"

#define SC_BKCOLOR     1700     // choose something unlikely...

#define OFFSETIN(struc, field)  ((USHORT)&(((struc *)NULL)->field))
#define ATOM2STR(a) 			(LPSTR)MAKELP(0,(a))

typedef struct					// VBX structure: controls data
    {
    BOOL        bSysMenu;		// put menu item in sysmenu?
	BOOL		bWantCallback;	// want window messages?
    } scData, *PDATA;

typedef struct					// my structure: main windows data
    {
    HWND        hWnd;           // window handle of this control
	COLORREF	rgbBkColor;		// color
	HBRUSH		hBkBrush;		// background brush
	INT			nSubwindows;	// number of subclassed children
    } scMainWndData, NEAR *PMAINWNDDATA;

typedef struct					// my structure: current forms data
    {
    HCTL        hCtl;           // window handle of this control
    WNDPROC     lpfnWndProc;    // old window procedure
	PMAINWNDDATA pMainWndData;	// points to main windows data
    BOOL        bSysMenu;       // include menu item in system menu? (copy of scData.bSysMenu)
	BOOL		bWantCallback;	// want window messages? (copy of scData.bWantCallback)
    } scWndData, NEAR *PWNDDATA;

////////////////////////
// global variables
////////////////////////

HINSTANCE   hInstance;			// module instance
ATOM        atomWndData;		// property atom for current form
ATOM        atomMainWndData;	// property atom for main window
CHAR		sTemp[20];			// temporary string (better than on the stack)
CHAR		[8+1+3+1];			// application title 

////////////////////////
// properties
////////////////////////

PROPINFO piSysMenu =
    {
    "IncludeInSysMenu",
    DT_BOOL | PF_fSaveData | PF_fSetMsg | PF_fGetData | PF_fNoRuntimeW | PF_fDefVal,
    OFFSETIN(scData,bSysMenu),0,
    FALSE
    };

PROPINFO piCallback =
    {
    "WantCallback",
    DT_BOOL | PF_fSaveData | PF_fSetMsg | PF_fGetData | PF_fDefVal,
    OFFSETIN(scData,bWantCallback),0,
    FALSE
    };

PROPINFO piBkColor =
    {
    "ColorBackground",
    DT_COLOR | PF_fSetMsg | PF_fGetMsg,
    0,0,
    RGB(255,0,255)
    };

#define IPROP_NAME               0
#define IPROP_INDEX              1
#define IPROP_LEFT               2
#define IPROP_TOP                3
#define IPROP_WIDTH              4
#define IPROP_HEIGHT             5
#define IPROP_PARENT             6
#define IPROP_SYSMENU            7
#define IPROP_BKCOLOR            8
#define	IPROP_CALLBACK			 9

PPROPINFO    Properties100[] =
    {
    PPROPINFO_STD_NAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_PARENT,
    (PPROPINFO)&piSysMenu, 
    (PPROPINFO)&piBkColor,
    (PPROPINFO)&piCallback,
    NULL
    };

////////////////////////
// events
////////////////////////

WORD iParamTypes[] = {ET_I2, ET_I4};
WORD cbParamTypes[] = {ET_I2, ET_I2, ET_I4, ET_I2, ET_I4, ET_I2};

#define NULLEVENTINFO(type,name) \
	EVENTINFO type = { name, 0, 0, NULL, NULL, 0 }

typedef struct
    {
	BOOL	FAR *pbDone;
	LRESULT FAR *plResult;
	BOOL	FAR *phPre;
	LPARAM 	FAR *plParam;
	WPARAM	FAR *pwParam;
	WORD	FAR *pwMsg;
    LPVOID  nIndex;
    } CBPARAM;

NULLEVENTINFO(eiDlgBkColor,"ColorBackground");

EVENTINFO eiCallback =
    {
    "WndProc",
    6, 12,
    cbParamTypes,
    "wMsg As Integer, wParam As Integer, lParam As Long, bPreDefault As Integer, lResult As Long, Done As Integer",
    EF_fNoUnload
    };

#define IEVENT_DLG_COLOR         0
#define IEVENT_CALLBACK      	 1

PEVENTINFO  Events100[] =
    {
    (PEVENTINFO)&eiDlgBkColor,
    (PEVENTINFO)&eiCallback,
    NULL
    };


////////////////////////
// model structures
////////////////////////

LONG        DLLPROC CtlProc(HCTL hCtl,
				HWND hWnd, 
				WORD wMsg, 
				WPARAM wParam, 
				LPARAM lParam);

MODEL model100 =
    {
    VB100_VERSION,
    MODEL_fLoadMsg,
    (PCTLPROC)CtlProc,
    CS_VREDRAW|CS_HREDRAW|CS_GLOBALCLASS,
    WS_CHILD|WS_BORDER,
    sizeof(scData),
    IDBMP_DS,
    "BkColor",
    "stormBkColor",
    NULL,
    Properties100,
    Events100,
    IPROP_NAME,
    IEVENT_DLG_COLOR,
    -1
    };

MODEL model200 =
    {
    VB200_VERSION,
    MODEL_fLoadMsg | MODEL_fInvisAtRun,
    (PCTLPROC)CtlProc,
    CS_VREDRAW|CS_HREDRAW|CS_GLOBALCLASS,
    WS_CHILD|WS_BORDER,
    sizeof(scData),
    IDBMP_DS,
    "BkColor",
    "stormBkColor",
    NULL,
    Properties100,
    Events100,
    IPROP_NAME,
    IEVENT_DLG_COLOR,
    -1
    };

MODEL model300 =
    {
    VB300_VERSION,
    MODEL_fLoadMsg | MODEL_fInvisAtRun,
    (PCTLPROC)CtlProc,
    CS_VREDRAW|CS_HREDRAW|CS_GLOBALCLASS,
    WS_CHILD|WS_BORDER,
    sizeof(scData),
    IDBMP_DS,
    "BkColor",
    "stormBkColor",
    NULL,
    Properties100,
    Events100,
    IPROP_NAME,
    IEVENT_DLG_COLOR,
    -1
    };


///////////////////////

LPVOID  LPML100[] =
    { &model100, NULL };

MODELINFO MI100 =
    { 0x100, (LPMODEL *)&LPML100 };

LPVOID  LPML200[] =
    { &model200, NULL };

MODELINFO MI200 =
    { 0x200, (LPMODEL *)&LPML200 };

LPVOID  LPML300[] =
    { &model300, NULL };

MODELINFO MI300 =
    { 0x300, (LPMODEL *)&LPML300 };

LPMODELINFO DLLPROC VBGetModelInfo(USHORT usVersion)
{
    switch (usVersion)
    	{
    	case VB100_VERSION:
	        return(&MI100);
    	case VB200_VERSION:
	        return(&MI200);
    	case VB300_VERSION:
        default:                // who knows... :-)
	        return(&MI300);
		}
}


////////////////////////
// code: typecast shielding
////////////////////////


PWNDDATA NEAR GetWndData(HWND hWnd)
{
	return((PWNDDATA)GetProp(hWnd,ATOM2STR(atomWndData)));
}

PMAINWNDDATA NEAR GetMainWndData(HWND hWnd)
{
	return((PMAINWNDDATA)GetProp(hWnd,ATOM2STR(atomMainWndData)));
}

void NEAR SetWndData(HWND hWnd, PWNDDATA pWndData)
{
	SetProp(hWnd,ATOM2STR(atomWndData),pWndData);
}

void NEAR SetMainWndData(HWND hWnd, PMAINWNDDATA pMainWndData)
{
	SetProp(hWnd,ATOM2STR(atomMainWndData),pMainWndData);
}


////////////////////////
// code: window enumeration
////////////////////////


BOOL CALLBACK _export ChildWndEnumProc(HWND hWnd, LPARAM lParam)
{
	InvalidateRect(hWnd,NULL,TRUE);
	return(TRUE);
}


BOOL CALLBACK _export WndEnumProc(HWND hWnd, LPARAM lParam)
{
	PWNDDATA	pWndData;
    pWndData = GetWndData(hWnd);

	if (pWndData && pWndData->pMainWndData == (PMAINWNDDATA)lParam)	
		{
		InvalidateRect(hWnd,NULL,TRUE);
		EnumChildWindows(hWnd,ChildWndEnumProc,NULL);
		}
	return(TRUE);
}


void NEAR TellAllSiblings(PMAINWNDDATA pMainWndData)
{
	EnumWindows(WndEnumProc,(DWORD)(WORD)pMainWndData);
}


////////////////////////
// code: my customization
////////////////////////


BOOL NEAR WindowCustomize(HWND hWnd, 
	WORD wMsg, 
	WPARAM wParam, 
	LPARAM lParam, 
	LPARAM *plResult)
{
    PWNDDATA 	pWndData;
    PMAINWNDDATA pMainWndData;
    RECT    rc;
    HDC     hDC;
    int     ctl;

    switch (wMsg)
        {
        case WM_ERASEBKGND:
	        pWndData 	 = GetWndData(hWnd);
            pMainWndData = pWndData->pMainWndData;

            hDC = (HDC)wParam;
            GetClientRect(hWnd,&rc);
            FillRect(hDC,&rc,pMainWndData->hBkBrush);
            *plResult = 1;
            return(TRUE);
        case WM_CTLCOLOR:
	        pWndData 	 = GetWndData(hWnd);
            pMainWndData = pWndData->pMainWndData;

            ctl = HIWORD(lParam);
            if (ctl == CTLCOLOR_DLG ||
            	ctl == CTLCOLOR_STATIC ||
				ctl == CTLCOLOR_BTN)
                {
                SetTextColor((HDC)wParam,pMainWndData->rgbBkColor ^ 0x00ffffff);
                SetBkColor((HDC)wParam,pMainWndData->rgbBkColor);
                *plResult = (LPARAM)pMainWndData->hBkBrush;
                return(TRUE);
                }
            break;
        case WM_SYSCOLORCHANGE:
            InvalidateRect(hWnd,NULL,FALSE);
            break;
        }
    return(FALSE);
}


BOOL NEAR WindowOnSysCommand(HWND hWnd, WPARAM wParam)
{
    PMAINWNDDATA pMainWndData;
	PWNDDATA pWndData;
    COLORREF rgbColor;

    if (wParam == SC_BKCOLOR)
        {
        pWndData 	  = GetWndData(hWnd);

        VBFireEvent(pWndData->hCtl,IEVENT_DLG_COLOR,NULL);
        return(TRUE);
        }
    return(FALSE);
}


////////////////////////
// code: the subclassing routine (the heart of the matter :-))
////////////////////////

LRESULT DLLCALLBACK SubclassWndProc(HWND hWnd, WORD wMsg, WPARAM wParam, LPARAM lParam)
{
    LRESULT lResult;
    WNDPROC lpfnOldProc;
    PWNDDATA pWndData;
	PMAINWNDDATA pMainWndData;
    CBPARAM  P;
	BOOL	bDone;
	BOOL	bPre;

    pWndData 	 = GetWndData(hWnd);

	if (pWndData->bWantCallback && 
		(wMsg < VBM__BASE || wMsg >= VBN__BASE+WM_USER))
		{
		if (wMsg == WM_DESTROY)
			pWndData->bWantCallback = FALSE;
		  else
			{
			bDone		= FALSE;
			lResult		= 0;
			bPre		= -1;							// TRUE
			P.pbDone 	= &bDone;
			P.plResult 	= &lResult;
			P.plParam 	= &lParam;
			P.pwParam 	= &wParam;
			P.pwMsg 	= &wMsg;
			P.phPre		= &bPre;
			VBFireEvent(pWndData->hCtl,IEVENT_CALLBACK,(LPVOID)&P);
			if (bDone)
				return(lResult);
			}
		}

    if (WindowCustomize(hWnd,wMsg,wParam,lParam,&lResult))
        return(lResult);

    if (wMsg == WM_SYSCOMMAND &&
        pWndData->bSysMenu && 
        WindowOnSysCommand(hWnd,wParam))
        return(0);

    lpfnOldProc = pWndData->lpfnWndProc;

    if (wMsg == WM_NCDESTROY)							// only happens to Forms
        {
		HWND	hWndParent;

        SetWindowLong(hWnd,GWL_WNDPROC,(LONG)lpfnOldProc);
		RemoveProp(hWnd,ATOM2STR(atomWndData));

	    pMainWndData = pWndData->pMainWndData;
		if (--pMainWndData->nSubwindows == 0)			// remove from owner?
			{											// need to do it here due to GPF on CallWindowProc() for owner WM_CLOSE
			DeleteObject(pMainWndData->hBkBrush);
			wsprintf(sTemp,"0x%08lx",pMainWndData->rgbBkColor);
			WriteProfileString(sTask,"BkColor",sTemp);
			RemoveProp(pMainWndData->hWnd,ATOM2STR(atomMainWndData));
			LocalFree((HLOCAL)pMainWndData);
			}
		LocalFree((HLOCAL)pWndData);
        }

    lResult = CallWindowProc(lpfnOldProc,hWnd,wMsg,wParam,lParam);

	if (pWndData->bWantCallback && 
		(wMsg < VBM__BASE || wMsg >= VBN__BASE+WM_USER))
		{
		bPre		= 0;								// anything not -1 is FALSE in VB...
		VBFireEvent(pWndData->hCtl,IEVENT_CALLBACK,(LPVOID)&P);
		}

	return(lResult);
}


////////////////////////
// VBX code 
////////////////////////


void NEAR Init(HCTL hCtl, PDATA pData)
{
    atomWndData     = GlobalAddAtom("ThunderstormWndData");
    atomMainWndData = GlobalAddAtom("ThunderstormMainWndData");
}


void NEAR Exit(HCTL hCtl, PDATA pData)
{
    GlobalDeleteAtom(atomWndData);
}


BOOL NEAR TrySubclassWindow(HWND hWnd, HCTL hCtl, PDATA pData)
{
    PWNDDATA pWndData;
	PMAINWNDDATA pMainWndData;
	HWND	hWndParent;

    if (!hWnd || !IsWindow(hWnd))
        return(FALSE);
    if (GetWndData(hWnd) != NULL)
        return(FALSE);

#if 1 // colors separately for the applications
	hWndParent = GetWindow(hWnd,GW_OWNER);
#else // colors identical to all forms containing control
	hWndParent = GetDesktopWindow();
#endif
	if (!hWndParent || !IsWindow(hWndParent))
		return(FALSE);		

    if (GetMainWndData(hWndParent) == NULL)	// need to create structure for parent
		{
	    pMainWndData = (PMAINWNDDATA)LocalAlloc(LPTR,sizeof(scMainWndData));

		wsprintf(sTemp,"0x%08lx",GetSysColor(COLOR_WINDOW));
		GetProfileString(sTask,"BkColor",sTemp,sTemp,sizeof(sTemp));
		sscanf(sTemp,"0x%08lx",&pMainWndData->rgbBkColor);

		pMainWndData->hWnd			= hWndParent;
		pMainWndData->hBkBrush	 	= CreateSolidBrush(pMainWndData->rgbBkColor);
		SetMainWndData(hWndParent,pMainWndData);
		}
	  else
	    pMainWndData = GetMainWndData(hWndParent);

    pWndData = (PWNDDATA)LocalAlloc(LPTR,sizeof(scWndData));
    pWndData->lpfnWndProc   = (WNDPROC)GetWindowLong(hWnd,GWL_WNDPROC);
    pWndData->bSysMenu      = pData->bSysMenu;
    pWndData->hCtl          = hCtl;
	pWndData->pMainWndData 	= pMainWndData;
	pWndData->bWantCallback = pData->bWantCallback;
    SetWndData(hWnd,pWndData);
    SetWindowLong(hWnd,GWL_WNDPROC,(LONG)SubclassWndProc);

	++pMainWndData->nSubwindows;			// this is one more control
	
    if (pWndData->bSysMenu)					// append to system menu of form?
        {
        HMENU   hMenu;

        hMenu = GetSystemMenu(hWnd,FALSE);
        AppendMenu(hMenu,MF_SEPARATOR,0,NULL);
        AppendMenu(hMenu,MF_STRING,SC_BKCOLOR,"&Background Color");
        }
		
    return(TRUE);
}


LONG    DLLPROC CtlProc(HCTL hCtl, HWND hWnd, WORD wMsg, WPARAM wParam, LPARAM lParam)
{
    PDATA   pData;
    HBRUSH  hBkBrush;
    DWORD   nStyle;
	HWND	hWndParent;
	PWNDDATA pWndData;
	PMAINWNDDATA pMainWndData;
	COLORREF rgbBkColor;

    switch (wMsg)
        {
        case WM_CREATE:                 // Load event
			VBGetAppTitle(sTask,sizeof(sTask));
		    pData = VBDerefControl(hCtl);
            Init(hCtl,pData);
            break;

        case WM_DESTROY:                // Unload event
		    pData = VBDerefControl(hCtl);
            Exit(hCtl,pData);
            break;

        case VBM_CREATED:
			if (VBGetMode() != MODE_DESIGN) // only visible at design time
				return(0);
				
		case VBM_LOADED:				// the right time to subclass!
		    pData = VBDerefControl(hCtl);
			TrySubclassWindow(GetParent(hWnd),hCtl,pData);
            break;

		case VBM_GETPROPERTY:
            switch (wParam)
                {
				case IPROP_BKCOLOR:
				    pWndData = GetWndData(GetParent(hWnd));
					if (pWndData)
						{
					    pMainWndData = pWndData->pMainWndData;
						if (pMainWndData)
							{
							*(COLORREF *)lParam = pMainWndData->rgbBkColor;
							return(0);
							}
						}
					break;
				}
			break;

        case VBM_SETPROPERTY:
		    pData = VBDerefControl(hCtl);
            switch (wParam)
                {
				case IPROP_BKCOLOR:
				    pWndData = GetWndData(GetParent(hWnd));
					if (pWndData)
						{
					    pMainWndData = pWndData->pMainWndData;
						if (pMainWndData)
							{
							DeleteObject(pMainWndData->hBkBrush);
							pMainWndData->rgbBkColor = (COLORREF)lParam;
							pMainWndData->hBkBrush   = CreateSolidBrush((COLORREF)lParam);
							TellAllSiblings(pMainWndData);
							}
						}
					return(0);					
                case IPROP_SYSMENU:
                    nStyle = GetWindowLong(GetParent(hWnd),GWL_STYLE);
                    if (LOWORD(lParam) != 0 && (nStyle & WS_SYSMENU) == 0)
                        {
                        VBSetErrorMessage(29999,"Cannot include in system menu, window has no system menu!");
                        return(29999);
                        }
                    pData->bSysMenu = (LOWORD(lParam) != 0);
                    return(0);
				case IPROP_CALLBACK:
				    pWndData = GetWndData(GetParent(hWnd));
					if (pWndData)
						pWndData->bWantCallback = (LOWORD(lParam) != 0);
					pData->bWantCallback = (LOWORD(lParam) != 0);
					return(0);
					break;
                }
            break;
        }

	return(VBDefControlProc(hCtl,hWnd,wMsg,wParam,lParam));
}


////////////////////////
// VBX start procedure
////////////////////////


BOOL DLLPROC VBINITCC(WORD wVersion, BOOL bRuntime)
{
	switch (wVersion)
		{
		case VB100_VERSION:
            return(VBRegisterModel(hInstance,&model100));
		case VB200_VERSION:
            return(VBRegisterModel(hInstance,&model200));
		default: 
            return(VBRegisterModel(hInstance,&model300));
		}
}


////////////////////////
// DLL start/end procedures (standard)
////////////////////////


BOOL FAR PASCAL LibMain(HINSTANCE hModule, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
{
    hInstance = hModule;
    if (wHeapSize != 0) UnlockData(0);

    return(TRUE);
}


int DLLPROC WEP(int nSystemExit)
{
    return(1);
}

