# ----------------------------------------------------------------------------
# CBENCH.MAK: Build Windows benchmark program CBENCH
#             by using Microsoft Visual-C++ 1.0
# ----------------------------------------------------------------------------
#
# Enter
#   nmake [UC=1] [WIN32=1] [SIZE=1]
# to build application file CBENCH.EXE
#
# Options:
#  WIN32=1 .. to build Win32 specific application
#  SIZE=1 ... to optimize for size instead for speed (only if RELEASE=1 set)
#
# Enter
#   nmake clean
# to delete all built files except target CBENCH.EXE
# ----------------------------------------------------------------------------

HD  =
OBJ = cbench.obj

!IFDEF CMDLINE
COUT = >>proj.err
!ENDIF

!IFDEF WIN32
# build for Win32
DSYS = /DWIN32=1 /D_X86_=1
COPT = /G3 /Gf /Gy
LOPT = /Subsystem:Windows
LIBS = libc.lib kernel32.lib user32.lib gdi32.lib
LOPT = $(LOPT) /Debug:Full /DebugType:CV

!ELSE
# build for Win16 (large memory model)
DSYS = /DWIN16=1
COPT = /AL /f /GA /G2fsy /Gx /nologo
LOPT = /Align:16/NoD
LIBS = lLibCeW+LibW
COPT = $(COPT) /Oz
LOPT = $(LOPT)/CodeView

!ENDIF # 32/16 bit

!IFDEF SIZE
COPT = $(COPT) /O1w
!ELSE
COPT = $(COPT) /O2w
!ENDIF

COPT = $(COPT) /W3 /WX /YX /Zi

CC = cl $(COUT) $(DOPT) $(DSYS) /c $(COPT) $*.c

all: init cbench.exe

init:
!IFDEF CMDLINE
  erase proj.err
!ENDIF

cbench.exe: $(OBJ)
!IFNDEF WIN32
cbench.exe: cbench.def
!ENDIF
!IFDEF WIN32
 link $(LOPT) /out:$@ $(OBJ) $(LIBS)
!ELSE
 link $(LOPT) $(OBJ), $*, $*, $(LIBS), $*;
!ENDIF

cbench.obj: $*.c $(HD)
 $(CC)

clean:
 -erase *.bak
 -erase *.pch
 -erase *.obj
 -erase *.err
 -erase *.map
