/*****************************************************************************

 ----  C B E N C H  -------- C Benchmark Windows Application ----------------
                             CBENCH.C: Complete C source of application

==============================================================================

This is a small benchmark program which searchs different data types in a
array.

------------------------------------------------------------------------------

Copyright 1994 by Buchheit software research
          Kronenstrasse 30, D-76133 Karlsruhe, Germany/Europe
          Phone: +49 (0)721/37 67 76   Fax: +49 (0)721/35 62 38
          Internet: mabu@buchheit.de   CompuServe: 100020,1723
          All rights reserved.

Version:    1.00 of 93-Jan-25
Programmer: Marcellus Buchheit
System:     DOS 6.20, Windows (NT) 3.1
Compiler:   Microsoft Visual-C++ 1.00

Change Report
93-Jan-25 1.00 mabu: initial version

*****************************************************************************/

#include <windows.h>
#include <string.h>


/*****************************************************************************
P r i n t T i m e
==============================================================================

This function displays the specified time in milliseconds in a message box.

Parameters
 ulTime   contains the time value in milliseconds.
 pszType  points to the type of measuring.

*****************************************************************************/

void PrintTime(DWORD ulTime, char *pszType)
{
  char szBuf[200];
  ulTime += 50; // round up/down by "/" and "%"
  wsprintf(szBuf, "Ende der %s-Suche.\nZeit: %u.%02u Sek.",
    pszType, (UINT)(ulTime / 1000), (UINT)(ulTime % 100));
  MessageBox(0, szBuf, "C-Bench", MB_OK|MB_ICONINFORMATION);
} /* PrintTime() */


/*****************************************************************************
S e a r c h D o u b l e
==============================================================================

This function searches a value in an array of double float values.

*****************************************************************************/

void SearchDouble()
{
  double afd[13];
  long l;
  int i;
  DWORD ulTime;
  // initialize array
  afd[0] = 3.1415;
  afd[1] = 6.283;
  afd[2] = 12.566;
  afd[3] = 25.132;
  afd[4] = 50.264;
  afd[5] = 100.528;
  afd[6] = 201.056;
  afd[7] = 402.112;
  afd[8] = 804.224;
  afd[9] = 1608.448;
  afd[10] = 3216.896;
  afd[11] = 6433.792;
  afd[12] = 12867.584;
  // start of measure
  ulTime = GetTickCount();
  for (l = 0; l < 200000; l++) {
    for (i = 0; i < 13; i++) {
      if (afd[i] == 2.718281) break;
    } /* for (i) */
  } /* for (l) */
  ulTime = GetTickCount() - ulTime;
  PrintTime(ulTime, "DOUBLE");
} /* SearchDouble() */


/*****************************************************************************
S e a r c h F l o a t
==============================================================================

This function searches a value in an array of single precision float values.

*****************************************************************************/

void SearchFloat()
{
  float aft[13];
  long l;
  int i;
  DWORD ulTime;
  // initialize array
  aft[0] = 3.1415f;
  aft[1] = 6.283f;
  aft[2] = 12.566f;
  aft[3] = 25.132f;
  aft[4] = 50.264f;
  aft[5] = 100.528f;
  aft[6] = 201.056f;
  aft[7] = 402.112f;
  aft[8] = 804.224f;
  aft[9] = 1608.448f;
  aft[10] = 3216.896f;
  aft[11] = 6433.792f;
  aft[12] = 12867.584f;
  // start of measure
  ulTime = GetTickCount();
  for (l = 0; l < 200000; l++) {
    for (i = 0; i < 13; i++) {
      if (aft[i] == 2.718281) break;
    } /* for (i) */
  } /* for (l) */
  ulTime = GetTickCount() - ulTime;
  PrintTime(ulTime, "FLOAT");
} /* SearchFloat() */


/*****************************************************************************
S e a r c h S h o r t
==============================================================================

This function searches a value in an array of short integer (16 bit) values.

*****************************************************************************/

void SearchShort()
{
  short as[13];
  long l;
  int i;
  DWORD ulTime;
  // initialize array
  as[0] = 4;
  as[1] = 9;
  as[2] = 19;
  as[3] = 39;
  as[4] = 79;
  as[5] = 159;
  as[6] = 319;
  as[7] = 639;
  as[8] = 1279;
  as[9] = 2559;
  as[10] = 5119;
  as[11] = 10239;
  as[12] = 20479;
  // start of measure
  ulTime = GetTickCount();
  for (l = 0; l < 2000000; l++) {
    for (i = 0; i < 13; i++) {
      if (as[i] == 12345) break;
    } /* for (i) */
  } /* for (l) */
  ulTime = GetTickCount() - ulTime;
  PrintTime(ulTime, "SHORT");
} /* SearchShort() */


/*****************************************************************************
S e a r c h L o n g
==============================================================================

This function searches a value in an array of long integer (32 bit) values.

*****************************************************************************/

void SearchLong()
{
  long al[13];
  long l;
  int i;
  DWORD ulTime;
  // initialize array
  al[0] = 262144;
  al[1] = 524288;
  al[2] = 1048576;
  al[3] = 2097152;
  al[4] = 4194304;
  al[5] = 8388608;
  al[6] = 16777216;
  al[7] = 33554432;
  al[8] = 67108864;
  al[9] = 134217728;
  al[10] = 268435456;
  al[11] = 536870912;
  al[12] = 1073741824;
  // start of measure
  ulTime = GetTickCount();
  for (l = 0; l < 2000000; l++) {
    for (i = 0; i < 13; i++) {
      if (al[i] == 1234567890) break;
    } /* for (i) */
  } /* for (l) */
  ulTime = GetTickCount() - ulTime;
  PrintTime(ulTime, "LONG");
} /* SearchLong() */


/*****************************************************************************
S e a r c h S t r i n g
==============================================================================

This function searches a value in an array of string values.

*****************************************************************************/

void SearchString()
{
  char *apsz[13];
  long l;
  int i;
  DWORD ulTime;
  // initialize array
  apsz[0] = "Buchheit";
  apsz[1] = "Dudek";
  apsz[2] = "Jung";
  apsz[3] = "Kopf";
  apsz[4] = "Kreisel";
  apsz[5] = "Maslo";
  apsz[6] = "Monadjemi";
  apsz[7] = "Ramm";
  apsz[8] = "Reinartz";
  apsz[9] = "Steingrber";
  apsz[10] = "Tischer";
  apsz[11] = "Waldmeyer";
  apsz[12] = "Zoschke";
  // start of measure
  ulTime = GetTickCount();
  for (l = 0; l < 200000; l++) {
    for (i = 0; i < 13; i++) {
      if (!strcmp(apsz[i], "Gates")) break;
    } /* for (i) */
  } /* for (l) */
  ulTime = GetTickCount() - ulTime;
  PrintTime(ulTime, "STRING");
} /* SearchString() */


/*****************************************************************************

 ------------------------------- Main function ------------------------------

*****************************************************************************/

int PASCAL WinMain(HINSTANCE hiNew, HINSTANCE hiPrev, LPSTR pszCmdLine,
  int idCmdShow)
{
  SearchString();
  SearchShort();
  SearchLong();
  SearchFloat();
  SearchDouble();
  return 0;
} /* WinMain() */


/* ===================================
   End of Windows Application CBENCH.C
   ===================================
*/
