/*****************************************************************************

 ----  V B C S A M P  ------ Visual-Basic/C-Calling Library Sample ----------
                             VBCSAMP.C: Complete C source of library

==============================================================================

This module is completely written in ANSI-C except the using of C++ style
single line comments.

------------------------------------------------------------------------------

Copyright 1994 by Buchheit software research
          Kronenstrasse 30, D-76133 Karlsruhe, Germany/Europe
          Phone: +49 (0)721/37 67 76   Fax: +49 (0)721/35 62 38
          Internet: mabu@buchheit.de   CompuServe: 100020,1723
          All rights reserved.

Version:    1.00 of 94-Jan-27
Programmer: Marcellus Buchheit
System:     DOS 6.20
Compiler:   Microsoft Visual C++ 1.0

Change Report
94-Jan-27 1.00 mabu: Initial version

*****************************************************************************/

#if !defined(_WINDOWS)
#define _WINDOWS
#endif
#include <windows.h>


/*****************************************************************************
G e t V e r s i o n
==============================================================================

This function returns the version of the library which is currently 1.0

Return
 The major value is returned in the upper byte, the minor value returned in
 the lower byte.

*****************************************************************************/

UINT _export WINAPI VbcGetVersion(VOID)
{
  return 256 * 1 + 0;
} /* GetVersion() */


/*****************************************************************************
V b c G e t W i n A p p l L i s t
==============================================================================

This function determines the handles of all currently available application
windows and writes into a buffer of handles.

Parameters
 pahwnd  points to a buffer which gets the handles of the application windows.
 cBuf .. contains the number of window handles which can be stored in the
         the <pahwnd> buffer. Never more handles are stored than this
         parameter specifies.

Return
 The function returns the number of available application windows. If this
 number if greater than the number in the <nBuf> parameter, then the buffer
 is not long enough to receive all application windows.

*****************************************************************************/

int _export WINAPI VbcGetWinApplList(HWND hwndAppl, HWND *pahwnd, int cBuf)
{
  HWND hwnd;
  int cWnd = 0; // number of windows
  hwnd = GetWindow(hwndAppl, GW_HWNDFIRST); // get top window
  while (hwnd != NULL) {
    // check if window is application window
    if (hwnd != hwndAppl &&
        IsWindowVisible(hwnd) && GetWindow(hwnd, GW_OWNER) == NULL
      ) {
      // valid window: set into list
      if (cWnd < cBuf) {
        // destination buffer not full: save handle
        *pahwnd++ = hwnd;
      } /* if */
      cWnd++; // one window more
    } /* if */
    // get next window
    hwnd = GetWindow(hwnd, GW_HWNDNEXT);
  } /* while */
  // return number of windows
  return cWnd;
} /* VbcGetWinApplList() */


/*****************************************************************************
V b c A c t i v a t e
==============================================================================

This function activates the application with the specified application window.
Not always this window is activated: If the application has opened a popup
window, then the latter is activated

Parameters
 hwnd  contains the handle of the window.

*****************************************************************************/

VOID _export WINAPI VbcActivate(HWND hwnd)
{
  // validate parameters
  if (!IsWindow(hwnd)) return;
  // activate application by using last popup window
  SetActiveWindow(GetLastActivePopup(hwnd));
} /* VbcActivate() */


/*****************************************************************************
V b c C l o s e
==============================================================================

This function closes the application with the specified window by posting
a WM_CLOSE message to this window.

Parameters
 hwnd  contains the handle of the window.

*****************************************************************************/

VOID _export WINAPI VbcClose(HWND hwnd)
{
  // validate parameters
  if (!IsWindow(hwnd)) return;
  // close application by posting message
  PostMessage(hwnd, WM_CLOSE, 0, 0);
} /* VbcClose() */


/*****************************************************************************
W E P
==============================================================================

### DLL entry function ###

This function is the "Window Exit Procedure" which is called before the DLL
is unloaded by the Windows system.

Parameters
 idExit  contains WEP_SYSTEM_EXIT if the system will be shut down and
         WEP_FREE_DLL if only the library is freed.

Return
 This functions returns always 1.

*****************************************************************************/

int CALLBACK WEP(int idExit)
{
  return 1; // nothing to do here
} /* WEP() */


/*****************************************************************************
L i b M a i n
==============================================================================

### entry function ###

This function is called if the library is initialized.

Parameters
 hiLib ..... is the instance of the library.
 usDS ...... is the data segment value.
 cbHeap .... is the initial size of the local heap.
 ulReserved  is not used.

Return
 FALSE if an error occurred during the initialization phase of the library.
 TRUE  if the initialization was successful.

*****************************************************************************/

BOOL WINAPI LibMain(HINSTANCE hiLib, WORD usDS, WORD cbHeap,
  DWORD ulReserved)
{
  return TRUE; // no error
} /* LibMain() */


/* =================================
   Library VBCSAMP: End of VBCSAMP.C
   =================================
*/
