// Frame.c - Steuerelementkontrollprozedur FRAME
// Autor: Dipl.-Ing. Andreas Maslo

//Line3d.c - Steuerelementprozedur
//Autor: Dipl.-Ing. Andreas Maslo
//(c)1993/94 by IngES/Dipl.-Ing. Andreas Maslo

#define  NOCOMM
#include <windows.h>

#include <vbapi.h>
#include <string.h>
#include "line3d.h"

// lokale Prototypen
VOID NEAR DrawBack(PLINE3D pline3d, HWND hwnd, HDC hdc);
VOID NEAR RecalcArea(PLINE3D pline3d, HWND hwnd);

// Line3D-Kontrollprozedur
LONG FAR PASCAL _export Line3dCtlProc
(
    HCTL   hctl,
    HWND   hwnd,
    USHORT msg,
    USHORT wp,
    LONG   lp
)
{
    PLINE3D pline3d = NULL;
    HDC     hdc;
    LPRECT  prect = &pline3d->rectDrawInto;

    switch (msg)
	{
        case WM_CREATE:
          //Fenster ffnen
          pline3d = (PLINE3D)VBDerefControl(hctl);
          //standardmig 3D-Rahmen
	      pline3d->LineStyle = 3;
	      //Font3D eingeschaltet, erhoben
	      pline3d-> Font3D = 1;
	      //Hintergundfarbe auf grau setzen
	      VBSetControlProperty(hctl, IPROP_LINE3D_BACKCOLOR, RGB(192, 192, 192));
          break;
        case WM_SETFONT:
          //zu verwendende Schriftart festlegen
	      pline3d = (PLINE3D)VBDerefControl(hctl);
	      pline3d->hfont = (HFONT)wp;
          return 0;
        case WM_GETFONT:
          //zu verwendende Schriftart ermitteln
	      pline3d = (PLINE3D)VBDerefControl(hctl);
	      return pline3d->hfont;
        case WM_SETTEXT:
          //Textinhalt festlegen
          {
	       HSZ hsz;
           pline3d = (PLINE3D)VBDerefControl(hctl);
	       if (pline3d->hszCaption)
	  	    {
		    VBDestroyHsz(pline3d->hszCaption);
  		    }
	       hsz = VBCreateHsz((_segment)hctl, (LPSTR)lp);
	       pline3d = (PLINE3D)VBDerefControl(hctl);
	       pline3d->hszCaption = hsz;
	       //Fensterbereich zum Neuzeichnen ausweisen
	       InvalidateRect(hwnd, NULL, TRUE);
	       return 0L;
          }
        case WM_GETTEXT:
          //Textinhalt ermitteln
          {
	       LPSTR   lpstr;
	       WORD    cch;
           pline3d = (PLINE3D)VBDerefControl(hctl);
	       if (pline3d->hszCaption == NULL)
	          //leere Zeichenkette
		      {
		       *(LPSTR)lp = 0L;
		       wp = 1;
		      }
	        else
		      {
		       lpstr = VBDerefHsz(pline3d->hszCaption);
		       cch = lstrlen(lpstr) + 1;
	     	   if (wp > cch)
		         wp = cch;
		         _fstrncpy((LPSTR)lp, lpstr, wp);
		         ((LPSTR)lp)[wp - 1] = '\0';
		      }
          }
	      return (LONG)(wp - 1);
        case WM_GETTEXTLENGTH:
          //Textlnge ermitteln
	      pline3d = (PLINE3D)VBDerefControl(hctl);
          if (pline3d->hszCaption == NULL)
              return 0L;
            else
	       	  return lstrlen(VBDerefHsz(pline3d->hszCaption));
        case WM_PAINT:
          //Fenster neuzeichnen
	      pline3d = (PLINE3D)VBDerefControl(hctl);
          if (wp)
		      DrawBack(pline3d, hwnd, (HDC)wp);
	        else
		      {
               PAINTSTRUCT ps;
               BeginPaint(hwnd, &ps);
		       DrawBack(pline3d, hwnd, ps.hdc);
		       EndPaint(hwnd, &ps);
		      }
          break;
        case WM_SIZE:
          //Grennderung des Fensters
	      pline3d = (PLINE3D)VBDerefControl(hctl);
	      RecalcArea(pline3d, hwnd);
	      break;
        case VBM_SETPROPERTY:
          //benutzerdefinierte Eigenschaften festlegen
	      switch (wp)
	  	    {
	  	     case IPROP_LINE3D_LINESTYLE:
	  	         //Rahmenstil wurde gewechselt
		         pline3d = (PLINE3D)VBDerefControl(hctl);
                 pline3d->LineStyle = (ENUM)lp;
                 InvalidateRect(hwnd, prect, FALSE);
               break;
             case IPROP_LINE3D_FONT3D:
	  	         //3D-Schriftstil wurde gewechselt
		         pline3d = (PLINE3D)VBDerefControl(hctl);
                 pline3d->Font3D = (ENUM)lp;
                 InvalidateRect(hwnd, prect, FALSE);
               break;
          }
          break;
	}
	//alles weitere an Visual Basic weiterleiten
    return VBDefControlProc(hctl, hwnd, msg, wp, lp);
}


//Zeichnen des Steuerelementes
//Aufruf erfolgt durch Botschaft WM_PAINT
VOID NEAR DrawBack
(
    PLINE3D pline3d,
    HWND    hwnd,
    HDC     hdc
)
{
    HBRUSH  hbr;
    HBRUSH  hbrOld = NULL;
    LPSTR   lpstr;
    LPRECT  prect = &pline3d->rectDrawInto;
    HFONT   hfontOld;
    HPEN    hPen;
    LONG	OldColor;
    //Korrekturwert zum Verschieben eines weien
    //Hintergrundtextes zur Erzielung eines
    //3D-Effekts
    SHORT   CorrectionValue;


    //Rechteck ausfllen und mit selber Farbe umranden
    hbr = (HBRUSH)SendMessage(GetParent(hwnd), WM_CTLCOLOR,
				      hdc, MAKELONG(hwnd, 0));
    hPen=SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(192,192,192)));
    hbrOld = SelectObject(hdc, hbr);
    Rectangle(hdc, prect->left, prect->top, prect->right, prect->bottom);
    //Linie zeichen
    if (pline3d->LineStyle == 1)
        {
         //horizontale 3D-Linie
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(129,129,129))));
         MoveTo (hdc, prect->right, (prect->bottom - prect->top)/2 );
         LineTo (hdc, prect->left,  (prect->bottom - prect->top)/2 );
         DeleteObject(SelectObject(hdc,GetStockObject(WHITE_PEN)));
         MoveTo (hdc, prect->right, (prect->bottom - prect->top)/2+1 );
         LineTo (hdc, prect->left,  (prect->bottom - prect->top)/2+1 );
         DeleteObject(SelectObject(hdc,GetStockObject(BLACK_PEN)));
        }
     else if (pline3d->LineStyle == 2)
        {
         //vertikale 3D-Linie
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(129,129,129))));
         MoveTo (hdc, prect->right/2, prect->top);
         LineTo (hdc, prect->right/2, prect->bottom);
         DeleteObject(SelectObject(hdc,GetStockObject(WHITE_PEN)));
         MoveTo (hdc, prect->right/2+1, prect->top);
         LineTo (hdc, prect->right/2+1, prect->bottom);
         DeleteObject(SelectObject(hdc,GetStockObject(BLACK_PEN)));
        }
     else if (pline3d->LineStyle == 3)
        {
         //3D-Rahmen versenkt
         //dunkelgrauen Stift erzeugen
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(129,129,129))));
         Rectangle(hdc, prect->left, prect->top, prect->right, prect->bottom);
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(255,255,255))));
         Rectangle(hdc, prect->left+1, prect->top+1, prect->right-1, prect->bottom-1);
         DeleteObject(SelectObject(hdc,GetStockObject(BLACK_PEN)));
        }
     else if (pline3d->LineStyle == 4)
        {
         //3D-Rahmen erhoben
         //dunkelgrauen Stift erzeugen
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(255,255,255))));
         Rectangle(hdc, prect->left, prect->top, prect->right, prect->bottom);
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(129,129,129))));
         Rectangle(hdc, prect->left+1, prect->top+1, prect->right-1, prect->bottom-1);
         DeleteObject(SelectObject(hdc,GetStockObject(BLACK_PEN)));
        }
     else if (pline3d->LineStyle == 5)
        {
         //abgerundeter 3D-Rahmen versenkt
         //dunkelgrauen Stift erzeugen
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(129,129,129))));
         //Hinweis: das letzte Koordinatenpaar legt die Ausrundung der Ecken fest
         RoundRect(hdc, prect->left, prect->top, prect->right, prect->bottom,10,10);
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(255,255,255))));
         RoundRect(hdc, prect->left+1, prect->top+1, prect->right-1, prect->bottom-1,10,10);
         DeleteObject(SelectObject(hdc,GetStockObject(BLACK_PEN)));
        }
     else if (pline3d->LineStyle == 6)
        {
         //abgerundeter 3D-Rahmen erhoben
         //dunkelgrauen Stift erzeugen
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(255,255,255))));
         RoundRect(hdc, prect->left, prect->top, prect->right, prect->bottom,10,10);
         DeleteObject(SelectObject(hdc,CreatePen(PS_SOLID,1,RGB(129,129,129))));
         RoundRect(hdc, prect->left+1, prect->top+1, prect->right-1, prect->bottom-1,10,10);
         DeleteObject(SelectObject(hdc,GetStockObject(BLACK_PEN)));
        };

    hfontOld = SelectObject(hdc, pline3d->hfont);
    //Text der Eigenschaft CAPTION ermitteln
    lpstr = VBDerefHsz(pline3d->hszCaption);

    //3D-Effekt wird durch erstmaliges und leicht
    //versetztes Schreiben des Textes gegenber seiner
    //endgltigen Position mit weier Farbe erzielt
    //Text fr 3D-Effekt im Hintergrund ausgeben
    //Hinweis: dieser Text wird nur dann ausgegeben,
    //         wenn der 3D-Look aktiviert wurde
    if (pline3d->Font3D != 0)
      {
       //nur wenn Eigenschaft auf 1 gesetzt ist, Schrift
       //im 3D-Look ausgeben
       //Hintergrundfarbe bleibt unberhrt, d.h. Text
       //wird transparent ausgegeben; das verhindert,
       //das der nachfolgend versetzt ausgegebene Text
       //den ersten Text vollstndig berschreibt
       SetBkMode(hdc, 1);
       //alte Schriftfarbe sichern
       OldColor = GetTextColor(hdc);
       //Schriftfarbe fr Hintergrundtext ist immer wei
       SetTextColor(hdc, RGB(255, 255, 255));

       //abhngig vom Rechteck des Steuerelementes
       //weien Hintergrundtext leicht versetzen
       if (pline3d->Font3D==1)
         //Korrekturwert zum Verschieben des
         //Hintergrundtextes ist abhngig davon, ob
         //der Text erhoben oder versenkt erscheinen soll
         {
         //Text erhoben
         //weier Text wird nach links oben verschoben
         CorrectionValue=1;
         }
       else if (pline3d->Font3D==2)
         {
         //Text versenkt
         //weier Text wird nach rechts unten verschoben
         CorrectionValue=-1;
         };

       //Ausgabebereich anpassen
       //Achtung: alle Bereich mssen um den gewhlten
       //         Korrekturwert temporr gendert werden
       prect->left = prect->left-CorrectionValue;
       prect->top = prect->top-CorrectionValue;
       prect->right = prect->right-CorrectionValue;
       prect->bottom = prect->bottom-CorrectionValue;

       //weien Hintergrundtext ausgeben
       //Achtung: die Textausgabe ist auch hier wieder abhngig von der
       //         Eigenschaft TextStyle!
       //Text zentriert, mehrzeilig, automatischer Zeilenumbruch
       DrawText(hdc, lpstr, -1, prect, DT_SINGLELINE|DT_VCENTER|DT_CENTER);

       //Rechteck des Steuerelementes wieder auf ursprngliche Gre
       //Achtung: alle ursprnglichen Grenzen mssen
       //         wiederhergestellt werden
       prect->left = prect->left+CorrectionValue;
       prect->top = prect->top+CorrectionValue;
       prect->right = prect->right+CorrectionValue;
       prect->bottom = prect->bottom+CorrectionValue;

       //alte Textfarbe wiederherstellen
       SetTextColor(hdc, OldColor);
      }

    //eigentlichen Text in gewhlter Vordergrundfarbe ausgeben
    //Hinweis: dieser Text wird in jedem Fall ausgegeben, und zwar
    //         auch dann, wenn kein 3D-Look aktiviert wurde
    DrawText(hdc, lpstr, -1, prect, DT_SINGLELINE|DT_VCENTER|DT_CENTER);

    SelectObject(hdc, hfontOld);
    SelectObject(hdc, hbrOld);
    return;
}


VOID NEAR RecalcArea
(
    PLINE3D pline3d,
    HWND    hwnd
)
{
    LPRECT   prect = &pline3d->rectDrawInto;
    //aktuelle Fenstergre ermitteln
    GetClientRect(hwnd, prect);
	return;
}




