//Line3D.h - Headerdatei zu LINE3D.C
//
//Das Steuerelement ist eine erweiterte Fassung des in der "Basic professional
//6/93" vorgestellten 3D-Liniensteuerelementes. Die wesentlichen Neuerungen
//sind nachfolgend zusammengefat:
//
// - neue Linienstile zum Zeichnen eines erhobenen oder
//   versenkten 3D-Rahmens
// - Eigenschaft CAPTION zur Ausgabe von Text
// - Untersttzung unterschiedlicher Schriftfarben durch Einfhrung
//   der Standardeigenschaft FORECOLOR
// - optionale Textausgabe im 3D-Stil
// - mit Hilfe der Standardeigenschaft ALIGN kann das Steuerelement
//   automatisch als Status- oder Symbolleiste ausgerichtet werden
// - ber das Ereignis MouseMove kann ermittelt werden, wann sich
//   der Mauscursor innerhalb des Steuerelementbereichs befindet
//
//Autor: Dipl.-Ing. Andreas Maslo
//(c)1993/94 by IngES/Dipl.-Ing. Andreas Maslo

#define OFFSETIN(struc,field)	  ((USHORT)&(((struc *)0)->field))

//Ressourcenkennungen fr VB-Toolbox-Elemente
#define IDBMP_LINE3D		8000
#define IDBMP_LINE3DDOWN	8001
#define IDBMP_LINE3DMONO	8003
#define IDBMP_LINE3DEGA 	8006

//Kontrollprozedur zum Steuerelement LINE3D
LONG FAR PASCAL _export Line3dCtlProc(HCTL, HWND, USHORT, USHORT, LONG);

// globale Variablen und Konstanten
extern	HANDLE hmodDLL;     // aus ccinit.c

//LINE3D Kontrollstruktur
typedef struct tagLINE3D
{
    RECT    rectDrawInto;
    //Linien-/Rahmenstil
    ENUM    LineStyle;
    //3D-Schriftstil
    ENUM    Font3D;
    //Schriftart
    HFONT   hfont;
    //Text
    HSZ     hszCaption;
} LINE3D;

typedef LINE3D FAR * PLINE3D;

#ifndef RC_INVOKED

//Kennungen der Steuerelementeigenschaften
#define IPROP_LINE3D_CTLNAME              0
#define IPROP_LINE3D_INDEX                1
#define IPROP_LINE3D_BACKCOLOR            2
#define IPROP_LINE3D_LEFT                 3
#define IPROP_LINE3D_TOP                  4
#define IPROP_LINE3D_WIDTH                5
#define IPROP_LINE3D_HEIGHT               6
#define IPROP_LINE3D_VISIBLE              7
#define IPROP_LINE3D_PARENT               8
#define IPROP_LINE3D_TAG                  9
#define IPROP_LINE3D_LINESTYLE           10
#define IPROP_LINE3D_FONT3D              11
#define IPROP_LINE3D_CAPTION             12
#define IPROP_LINE3D_FONTNAME            13
#define IPROP_LINE3D_FONTBOLD            14
#define IPROP_LINE3D_FONTITALIC          15
#define IPROP_LINE3D_FONTSTRIKE          16
#define IPROP_LINE3D_FONTUNDER           17
#define IPROP_LINE3D_FONTSIZE            18
//Schriftfarbe variabel
#define IPROP_LINE3D_FORECOLOR           19
#define IPROP_LINE3D_ALIGN               20


#ifdef CTL_DATA


//benutzerdefinierte Eigenschaft:
//3D-Linienstil
PROPINFO Property_LineStyle =
{
    "LineStyle",
    DT_ENUM | PF_fGetData|PF_fSetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(LINE3D, LineStyle), 0,
    0,
    //werden keine Linien ausgegeben, kann das Steuerelement
    //als reines Anzeigesteuerelement fr 3D-Text verwendet werden
    "0 - kein\0" "1 - horizontal\0" "2 - vertikal\0"
    //3D-Rahmenstile
    "3 - Rahmen versenkt\0" "4 - Rahmen erhoben\0"
    "5 - abgerundeter Rahmen versenkt\0" "6 - abgerundeter Rahmen erhoben\0", 7
};


//benutzerdefinierte Eigenschaft: Font3D
//3D-Schrift (Eigenschaftsbezeichnung wurde
//entsprechend dem Steuerelement THREED.VBX der
//professionellen VB-Version gewhlt)
PROPINFO Property_Font3D =
{
    "Font3D",
    DT_ENUM | PF_fGetData|PF_fSetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(LINE3D, Font3D), 0,
    0,
    "0 - keine 3D-Schrift\0" "1 - 3D-Schrift erhoben\0" "2 - 3D-Schrift versenkt\0", 3
};


//Tabelle der Steuerelementeigenschaften
PPROPINFO Line3d_Properties[] =
{
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_TAG,
    //benutzerdefinierter Linienstil (LineStyle)
    //(3D-Linien)
    &Property_LineStyle,
    //benutzerdefinierte 3D-Schrift (Font3D)
    //(erweiterter Textstil)
    &Property_Font3D,
    PPROPINFO_STD_CAPTION,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_FONTSIZE,
    PPROPINFO_STD_FORECOLOR,
    //Ausrichtung als Status-/Symbolleiste
    //wird ber Eigenschaft ALIGN untersttzt
    PPROPINFO_STD_ALIGN,
    PPROPINFO_STD_BORDERSTYLEOFF,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_MOUSEPOINTER,
    NULL
};
#endif	// CTL_DATA

//Kennungen der Ereignisse
#define IEVENT_LINE3D_CLICK  		  0
#define IEVENT_LINE3D_MOUSEMOVE       1

#ifdef CTL_DATA

//Tabelle der Steuerelementereignisse
PEVENTINFO Line3d_Events[] =
{
    //Steuerelement reagiert auf die Ereignisse
    //Click und MouseMove
    PEVENTINFO_STD_CLICK,
    PEVENTINFO_STD_MOUSEMOVE,
    NULL
};
#endif	// CTL_DATA

// Steuerelementmodellstruktur
#ifdef CTL_DATA
MODEL modelLine3d =
{
    VB_VERSION,
    0,
    //Zeiger auf Kontrollprozedur
    (PCTLPROC)Line3dCtlProc,
    //Klassenstile
    CS_VREDRAW | CS_HREDRAW,
    //Fensterstil
    WS_CLIPCHILDREN,
    //Gre der Steuerelementstruktur
    sizeof(LINE3D),
    //Bitmap-Kennung (Toolbox)
    IDBMP_LINE3D,
    //Standardkontrollname
    "Line3D",
    //Visual Basic-Klassenname
    "Line3D1",
    NULL,
    //Tabelle Eigenschaften
    Line3d_Properties,
    //Tabelle Ereignisse
    Line3d_Events
};
#endif	// CTL_DATA

#endif	// RC_INVOKED

