'************************************************************
'Modul       : LOCKING.BAS
'Compiler    : Visual Basic fr Windows 3.0
'Zweck       : Enthlt globale Routinen fr Record-Locking unter
'              VB 3.0 in Verbindung mit der Access-Datenbank
'erstellt am : 22.06.1994
'durch       : Arthur Burda
'Anmerkung   :
'************************************************************
'nderung am :
'durch       :
'Version     :
'Anmerkung   :
'************************************************************

Option Explicit

'Globale Konstanten

Global Const DB_Locking_Name = "LOCKING.MDB"
Global Const Tab_Sperrungen_Name = "TAB-Sperrungen"

'Globale Variablen

Global DB_Locking As Database
Global DS_Sperrungen As Dynaset
Global Gesperrt% '0 = Datensatz ist nicht gesperrt, 1 = Datensatz gesperrt (akt. Benutzer), 2 = Datensatz wurde von einem anderen Benutzer gesperrt
Global EditFelder_gesperrt% 'True, wenn die Editierfelder innerhalb der akt. Form gesperrt sind, sonst False

'************************************************************
'Funktion  : Daten_gendert
'Zweck     : Liefert True zurck, wenn Daten innerhalb einer Form
'            gendert wurden (d.h. der Datensatz editiert wurde),
'            sonst False
'Parameter : F
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Function Daten_gendert (F As Form)

    Dim i

    Daten_gendert = False

    If F.Controls.Count > 0 Then 'prfen, ob Form Steuerelemente enthlt
        For i = 0 To F.Controls.Count - 1 'alle Steuerelemente durchlaufen
            If Ist_EditFeld(F.Controls(i)) Then 'prfen, ob es sich um ein Editierfeld handelt
                If F.Controls(i).DataChanged Then 'prfen, ob Daten gendert wurden
                    Daten_gendert = True
                    Exit Function 'Funktion verlassen
                End If
            End If
        Next i
    End If

End Function

'************************************************************
'Funktion  : Datensatz_gesperrt
'Zweck     : Liefert True zurck, wenn der angegebene Datensatz
'            in der angegebenen Tabelle oder Abfrage gesperrt ist,
'            sonst False
'Parameter : Tab_Abf_Name, Satz_Nr
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Function Datensatz_gesperrt (Tab_Abf_Name$, Satz_Nr&)

    Dim Snap As Snapshot

    Datensatz_gesperrt = False

    Set Snap = DB_Locking.CreateSnapshot(Tab_Sperrungen_Name) 'Snapshot auf Basis der Tabelle "TAB-Sperrungen" erstellen
    Snap.FindFirst "[Name] = '" & Tab_Abf_Name & "' AND [Datensatz-Id] = " & Satz_Nr 'Datensatz finden
    If Not Snap.NoMatch Then Datensatz_gesperrt = True
    Snap.Close 'Snapshot schlieen

End Function

'************************************************************
'Funktion  : Entsperre_Datensatz
'Zweck     : Entsperrt den Datensatz mit der angegebenen Nummer
'            in der angegebenen Tabelle oder Abfrage und liefert
'            bei Erfolg True zurck
'Parameter : Tab_Abf_Name, Satz_Nr
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Function Entsperre_Datensatz (Tab_Abf_Name$, Satz_Nr&)

    On Error GoTo ERR_Entsperre_Datensatz

    Entsperre_Datensatz = True

    If Datensatz_gesperrt(Tab_Abf_Name, Satz_Nr) Then 'prfen, ob der Datensatz gesperrt ist
        DS_Sperrungen.FindFirst "[Name] = '" & Tab_Abf_Name & "' AND [Datensatz-Id] = " & Satz_Nr 'Datensatz finden
        If Not DS_Sperrungen.NoMatch Then DS_Sperrungen.Delete 'Datensatz entsperren
    End If

EXIT_Entsperre_Datensatz:

    Exit Function 'Funktion verlassen

ERR_Entsperre_Datensatz:

    Entsperre_Datensatz = False
    MsgBox "Der Datensatz konnte nicht entsperrt werden."
    Resume Next

End Function

'************************************************************
'Sub       : Entsperre_EditFelder
'Zweck     : Entsperrt alle Editierfelder innerhalb der Form
'Parameter : F
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Entsperre_EditFelder (F As Form)

    Dim i

    If F.Controls.Count > 0 Then 'prfen, ob Form Steuerelemente enthlt
        For i = 0 To F.Controls.Count - 1 'alle Steuerelemente durchlaufen
            If Ist_EditFeld(F.Controls(i)) Then 'prfen, ob es sich um ein Editierfeld handelt
                F.Controls(i).Enabled = True 'Feld aktivieren
            End If
        Next i
    End If

End Sub

'************************************************************
'Sub       : Init_Sperrungen
'Zweck     : ffnet die Datenbank LOCKING.MDB zur Verwaltung
'            von Datensatz-Sperrungen, erstellt einen Dynaset auf
'            Basis der Tabelle "TAB-Sperrungen" und setzt die glo-
'            bale Variable Gesperrt auf False
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Init_Sperrungen ()

    Lsche_Sperrungen 'Locking-Tabelle lschen, wenn die Datenbank zum ersten Mal geffnet wird

    Set DB_Locking = OpenDatabase(DB_Locking_Name)
    Set DS_Sperrungen = DB_Locking.CreateDynaset(Tab_Sperrungen_Name)
    Gesperrt = 0
    EditFelder_gesperrt = True

End Sub

'************************************************************
'Funktion  : Ist_EditFeld
'Zweck     : Liefert True zurck, wenn das angegebene Steuerelement
'            ein Editierfeld ist, sonst False
'Parameter : C
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Function Ist_EditFeld (C As Control)

    Ist_EditFeld = False

    If TypeOf C Is TextBox Then 'Textfeld?
        Ist_EditFeld = True 'ist ein Eingabefeld
    ElseIf TypeOf C Is ComboBox Then 'Kombinationslistenfeld?
        Ist_EditFeld = True
    ElseIf TypeOf C Is CheckBox Then 'Kontrollfeld?
        Ist_EditFeld = True
    ElseIf TypeOf C Is OptionButton Then 'Optionsfeld?
        Ist_EditFeld = True
    End If

End Function

'************************************************************
'Sub       : Lsche_Sperrungen
'Zweck     : Lscht alle Datenstze in der Tabelle "TAB-Sperrungen"
'            (Datenbank LOCKING.MDB), wenn die Datenbank zum ersten
'            Mal geffnet wird
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Lsche_Sperrungen ()

    Dim QD As QueryDef

    On Error GoTo ERR_Lsche_Sperrungen

    Set DB_Locking = OpenDatabase(DB_Locking_Name, True) 'Datenbank exklusiv ffnen
    If Err = 0 Then 'kein Fehler, d.h. die Datenbank wurde zum ersten Mal geffnet
        Set QD = DB_Locking.CreateQueryDef("Lschabfrage")
        QD.SQL = "DELETE * FROM [TAB-Sperrungen]"
        QD.Execute
        QD.Close
        DB_Locking.DeleteQueryDef ("Lschabfrage")
        DB_Locking.Close 'Datenbank schlieen
    End If

EXIT_Lsche_Sperrungen:

    Exit Sub 'Sub verlassen

ERR_Lsche_Sperrungen:

    If Err <> 0 Then Exit Sub 'wenn die Datenbank nicht exklusiv geffnet werden konnte, ist sie bereits geffnet

End Sub

'************************************************************
'Sub       : Schliee_Sperrungen
'Zweck     : Schliet die Datenbank LOCKING.MDB zur Verwaltung
'            von Datensatz-Sperrungen sowie den Dynaset in der
'            Variablen DS_Sperrungen
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Schliee_Sperrungen ()

    DS_Sperrungen.Close
    DB_Locking.Close

End Sub

'************************************************************
'Sub       : Sperre_Datensatz
'Zweck     : Sperrt den Datensatz mit der angegebenen Nummer in
'            der angegebenen Tabelle oder Abfrage und liefert
'            bei Erfolg True zurck
'Parameter : Tab_Abf_Name, Satz_Nr
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Function Sperre_Datensatz (Tab_Abf_Name$, Satz_Nr&)

    On Error GoTo ERR_Sperre_Datensatz

    Sperre_Datensatz = True

    If Not Datensatz_gesperrt(Tab_Abf_Name, Satz_Nr) Then 'prfen, ob der Datensatz noch nicht gesperrt ist
        If DS_Sperrungen.RecordCount > 0 Then DS_Sperrungen.MoveLast 'zum letzten Datensatz gehen
        DS_Sperrungen.AddNew 'neuen Datensatz anlegen
        DS_Sperrungen("[Name]") = Tab_Abf_Name
        DS_Sperrungen("[Datensatz-Id]") = Satz_Nr
        DS_Sperrungen.Update 'speichern
    End If

EXIT_Sperre_Datensatz:

    Exit Function 'Funktion verlassen

ERR_Sperre_Datensatz:
    
    Sperre_Datensatz = False
    MsgBox "Der Datensatz konnte nicht gesperrt werden."
    Resume Next

End Function

'************************************************************
'Sub       : Sperre_EditFelder
'Zweck     : Sperrt alle Editierfelder innerhalb der Form
'Parameter : F
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Sperre_EditFelder (F As Form)

    Dim i

    If F.Controls.Count > 0 Then 'prfen, ob Form Steuerelemente enthlt
        For i = 0 To F.Controls.Count - 1 'alle Steuerelemente durchlaufen
            If Ist_EditFeld(F.Controls(i)) Then 'prfen, ob es sich um ein Editierfeld handelt
                F.Controls(i).Enabled = False 'Feld deaktivieren
            End If
        Next i
    End If

End Sub

'************************************************************
'Sub       : Zentriere_Form
'Zweck     : Stellt eine Form zentriert auf dem Bildschirm dar
'Parameter : F
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Zentriere_Form (F As Form)

    F.Top = Screen.Height / 2 - F.Height / 2
    F.Left = Screen.Width / 2 - F.Width / 2

End Sub

