VERSION 2.00
Begin Form frm_Locking1 
   BackColor       =   &H00808080&
   Caption         =   "Beispiel fr Record-Locking mit der Access-Datenbank    (c) 1994 by A. Burda"
   ClientHeight    =   4575
   ClientLeft      =   630
   ClientTop       =   1545
   ClientWidth     =   8475
   Height          =   4980
   KeyPreview      =   -1  'True
   Left            =   570
   LinkTopic       =   "Form1"
   ScaleHeight     =   4575
   ScaleWidth      =   8475
   Top             =   1200
   Width           =   8595
   Begin CommandButton cmd_Neu 
      Caption         =   "&Neu"
      Height          =   555
      Left            =   540
      TabIndex        =   3
      Top             =   2880
      Width           =   1155
   End
   Begin CommandButton cmd_Ende 
      Cancel          =   -1  'True
      Caption         =   "&Ende"
      Height          =   555
      Left            =   6720
      TabIndex        =   4
      Top             =   2880
      Width           =   1155
   End
   Begin TextBox txt_Beruf 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      DataField       =   "Beruf"
      DataSource      =   "dat_Tab_Personen"
      Height          =   285
      Left            =   3060
      MaxLength       =   50
      TabIndex        =   2
      Top             =   1800
      Width           =   4815
   End
   Begin TextBox txt_Vorname 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      DataField       =   "Vorname"
      DataSource      =   "dat_Tab_Personen"
      Height          =   285
      Left            =   3060
      MaxLength       =   50
      TabIndex        =   1
      Top             =   1440
      Width           =   4815
   End
   Begin TextBox txt_Name 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFFF&
      DataField       =   "Name"
      DataSource      =   "dat_Tab_Personen"
      Height          =   285
      Left            =   3060
      MaxLength       =   50
      TabIndex        =   0
      Top             =   1080
      Width           =   4815
   End
   Begin Data dat_Tab_Personen 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Tabelle: TAB-Personen"
      Connect         =   ""
      DatabaseName    =   ""
      Exclusive       =   0   'False
      ForeColor       =   &H00000000&
      Height          =   270
      Left            =   480
      Options         =   0
      ReadOnly        =   0   'False
      RecordSource    =   ""
      Top             =   3840
      Width           =   7515
   End
   Begin Label lab_Person_Id 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      DataField       =   "Person-Id"
      DataSource      =   "dat_Tab_Personen"
      Height          =   255
      Index           =   4
      Left            =   3060
      TabIndex        =   9
      Top             =   480
      Width           =   4815
   End
   Begin Label lab_Beschriftung 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Beruf"
      Height          =   255
      Index           =   3
      Left            =   540
      TabIndex        =   8
      Top             =   1800
      Width           =   2415
   End
   Begin Label lab_Beschriftung 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Vorname"
      Height          =   255
      Index           =   2
      Left            =   540
      TabIndex        =   7
      Top             =   1440
      Width           =   2415
   End
   Begin Label lab_Beschriftung 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Name"
      Height          =   255
      Index           =   1
      Left            =   540
      TabIndex        =   6
      Top             =   1080
      Width           =   2415
   End
   Begin Label lab_Beschriftung 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Person-Id (Datensatz-Nr)"
      Height          =   255
      Index           =   0
      Left            =   540
      TabIndex        =   5
      Top             =   480
      Width           =   2415
   End
   Begin Shape sha_Rahmen 
      BackColor       =   &H00404040&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00000000&
      FillColor       =   &H00404040&
      Height          =   495
      Index           =   1
      Left            =   360
      Top             =   3720
      Width           =   7755
   End
   Begin Shape sha_Rahmen 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00000000&
      FillColor       =   &H00C0C0C0&
      Height          =   4155
      Index           =   0
      Left            =   240
      Top             =   180
      Width           =   7995
   End
End
'************************************************************
'Form        : LOCKING1.FRM
'Compiler    : Visual Basic fr Windows 3.0
'Zweck       : Beispiel fr Record-Locking unter VB 3.0 via
'              Tastaturabfrage
'erstellt am : 22.06.1994
'durch       : Arthur Burda
'Anmerkung   : Demonstriert anhand einer Beispiel-Datenbank
'              (PERSONEN.MDB) die Datensatzsperrung unter Vi-
'              sual Basic fr Windows 3.0
'************************************************************
'nderung am :
'durch       :
'Version     :
'Anmerkung   :
'************************************************************

Option Explicit

'Konstanten

Const DB_Personen_Name = "PERSONEN.MDB"
Const Tab_Personen_Name = "TAB-Personen"

'Variablen

Dim Speichern% 'True, wenn akt. Datensatz gespeichert werden soll (Methode Validate von Data Control), sonst False
Dim First% 'nur bei Initialisierung der Form von Bedeutung

'************************************************************
'Sub       : cmd_Ende_Click
'Zweck     : Schalter "Ende" wurde angeklickt, Programm beenden
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub cmd_Ende_Click ()

    Unload Me

End Sub

'************************************************************
'Sub       : cmd_Neu_Click
'Zweck     : Schalter "Neu" wurde angeklickt, neue Person hinzu-
'            fgen
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub cmd_Neu_Click ()

    If dat_Tab_Personen.Recordset.RecordCount > 0 Then dat_Tab_Personen.Recordset.MoveLast
    dat_Tab_Personen.Recordset.AddNew 'neuen Datensatz anlegen
    txt_Name.SetFocus

End Sub

'************************************************************
'Sub       : dat_Tab_Personen_Reposition
'Zweck     : Wird aufgerufen nach nderung der Position innerhalb
'            einer Tabelle oder Abfrage
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub dat_Tab_Personen_Reposition ()

    Dim Tab_Abf_Name$ 'Name der aktuellen Tabelle bzw. Abfrage
    Dim Satz_Nr& 'Nummer des aktuellen Datensatzes

    Gesperrt = 0

    Tab_Abf_Name = Lese_Tab_Abf_Name()
    Satz_Nr = Lese_Satz_Nr()

    If Datensatz_gesperrt(Tab_Abf_Name, Satz_Nr) Then 'prfen, ob der Datensatz von einem anderen Benutzer gesperrt wurde
        If Not First And Speichern Then
            Gesperrt = 2
            Sperre_EditFelder Me 'alle Editierfelder innerhalb der Form sperren
            EditFelder_gesperrt = True
            MsgBox "Dieser Datensatz wurde von einem anderen Benutzer gesperrt. Editieren nicht mglich."
        End If
    Else
        If EditFelder_gesperrt Then 'prfen, ob Editierfelder innerhalb der Form deaktiviert sind
            Entsperre_EditFelder Me 'alle Editierfelder innerhalb der Form entsperren
            EditFelder_gesperrt = False
        End If
    End If

End Sub

'************************************************************
'Sub       : dat_Tab_Personen_Validate
'Zweck     : Entsperrt den akt. Datensatz, wenn dieser vorher vom
'            akt. Benutzer gesperrt wurde
'Parameter : Action, Save
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub dat_Tab_Personen_Validate (Action As Integer, Save As Integer)

    Dim Tab_Abf_Name$ 'Name der aktuellen Tabelle bzw. Abfrage
    Dim Satz_Nr& 'Nummer des aktuellen Datensatzes

    If Speichern Then
        Save = Daten_gendert(Me)
    Else
        Save = Speichern
    End If

    If Gesperrt = 1 Then
        Tab_Abf_Name = Lese_Tab_Abf_Name()
        Satz_Nr = Lese_Satz_Nr()
        If Entsperre_Datensatz(Tab_Abf_Name, Satz_Nr) Then 'Datensatz entsperren
            Gesperrt = 0
        End If
    End If

End Sub

'************************************************************
'Sub       : Form_KeyDown
'Zweck     : Wird aufgerufen, wenn eine Taste niedergedrckt wurde
'            und ist fr die Datensatzsperrung verantwortlich
'Parameter : KeyCode, Shift
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)

    Dim Tab_Abf_Name$ 'Name der aktuellen Tabelle bzw. Abfrage
    Dim Satz_Nr& 'Nummer des aktuellen Datensatzes
    Dim Mark 'Datensatzmarkierung

    DoEvents
    If Gesperrt = 0 Then 'Datensatz nicht gesperrt?
        Tab_Abf_Name = Lese_Tab_Abf_Name()
        Satz_Nr = Lese_Satz_Nr()
        If Datensatz_gesperrt(Tab_Abf_Name, Satz_Nr) Then 'Wurde der Datensatz von einem anderen Benutzer inzwischen gesperrt?
            KeyCode = 0
            Gesperrt = 2
            Speichern = False 'Datensatz nicht aktualisieren
            Mark = dat_Tab_Personen.Recordset.Bookmark 'Bookmark merken
            dat_Tab_Personen.Recordset.Bookmark = Mark 'Bookmark setzen
            Speichern = True 'Datensatzaktualisierung wieder erlaubt
            Sperre_EditFelder Me 'alle Editierfelder innerhalb der Form sperren
            EditFelder_gesperrt = True
            MsgBox "Dieser Datensatz wurde von einem anderen Benutzer gesperrt. Editieren nicht mglich."
        Else 'Datensatz ist nicht gesperrt
            If Daten_gendert(Me) Then 'prfen, ob sich irgendwelche Daten gendert haben, d.h. der Datensatz editiert wurde
                If Sperre_Datensatz(Tab_Abf_Name, Satz_Nr) Then 'Datensatz sperren
                    Gesperrt = 1 'Datensatz wurde vom akt. Benutzer gesperrt
                    MsgBox "Ab jetzt ist dieser Datensatz fr alle anderen Benutzer in der Mehrbenutzerumgebung gesperrt."
                Else 'Datensatz konnte nicht gesperrt werden
                    Speichern = False 'Datensatz nicht aktualisieren
                    Mark = dat_Tab_Personen.Recordset.Bookmark 'Bookmark merken
                    dat_Tab_Personen.Recordset.Bookmark = Mark 'Bookmark setzen
                    Speichern = True 'Datensatzaktualisierung wieder erlaubt
                End If
            End If
        End If
    End If

End Sub

'************************************************************
'Sub       : Form_KeyUp
'Zweck     : Wird aufgerufen, wenn eine Taste losgelassen wurde
'            und ist fr die Datensatzsperrung verantwortlich
'Parameter : KeyCode, Shift
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Form_KeyUp (KeyCode As Integer, Shift As Integer)

    Dim Tab_Abf_Name$ 'Name der aktuellen Tabelle bzw. Abfrage
    Dim Satz_Nr& 'Nummer des aktuellen Datensatzes
    Dim Mark 'Datensatzmarkierung

    If Gesperrt = 0 Then 'Datensatz nicht gesperrt?
        Tab_Abf_Name = Lese_Tab_Abf_Name()
        Satz_Nr = Lese_Satz_Nr()
        If Datensatz_gesperrt(Tab_Abf_Name, Satz_Nr) Then 'Wurde der Datensatz von einem anderen Benutzer inzwischen gesperrt?
            Gesperrt = 2
            Speichern = False 'Datensatz nicht aktualisieren
            Mark = dat_Tab_Personen.Recordset.Bookmark 'Bookmark merken
            dat_Tab_Personen.Recordset.Bookmark = Mark 'Bookmark setzen
            Speichern = True 'Datensatzaktualisierung wieder erlaubt
            Sperre_EditFelder Me 'alle Editierfelder innerhalb der Form sperren
            EditFelder_gesperrt = True
            MsgBox "Dieser Datensatz wurde von einem anderen Benutzer gesperrt. Editieren nicht mglich."
        Else 'Datensatz ist nicht gesperrt
            If Daten_gendert(Me) Then 'prfen, ob sich irgendwelche Daten gendert haben, d.h. der Datensatz editiert wurde
                If Sperre_Datensatz(Tab_Abf_Name, Satz_Nr) Then 'Datensatz sperren
                    Gesperrt = 1 'Datensatz wurde vom akt. Benutzer gesperrt
                    MsgBox "Ab jetzt ist dieser Datensatz fr alle anderen Benutzer in der Mehrbenutzerumgebung gesperrt."
                Else 'Datensatz konnte nicht gesperrt werden
                    Speichern = False 'Datensatz nicht aktualisieren
                    Mark = dat_Tab_Personen.Recordset.Bookmark 'Bookmark merken
                    dat_Tab_Personen.Recordset.Bookmark = Mark 'Bookmark setzen
                    Speichern = True 'Datensatzaktualisierung wieder erlaubt
                End If
            End If
        End If
    End If

End Sub

'************************************************************
'Sub       : Form_Load
'Zweck     : Wird beim Laden der Form aufgerufen und ist fr
'            die Initialisierung verantwortlich
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Form_Load ()

    Init_Form

End Sub

'************************************************************
'Sub       : Form_Unload
'Zweck     : Wird aufgerufen, wenn die Form geschlossen wird
'Parameter : Cancel
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Form_Unload (Cancel As Integer)

    Schliee_Sperrungen

End Sub

'************************************************************
'Sub       : Init_Form
'Zweck     : Initialisiert die Form frm_Locking1
'Parameter :
'Stand     : 22.06.1994
'Bemerkung : Diese Routine wird in Form_Load aufgerufen.
'************************************************************
'
Sub Init_Form ()

    Dim Pfad$ 'Verzeichnis, in dem sich die Datenbanken LOCKING.MDB und PERSONEN.MDB befinden

    First = True
    Speichern = True

    Pfad = InputBox("Bitte geben Sie den Pfad an, in dem sich die Datenbanken LOCKING.MDB und PERSONEN.MDB befinden oder besttigen Sie die vorgeschlagene Pfadangabe (akt. Verzeichnis).", "LOCKING", CurDir)
    If Pfad = "" Then 'Abbruch?
        End
    Else
        ChDir Pfad 'Pfad wechseln
    End If
    
    Zentriere_Form Me
    Init_Sperrungen 'Datensatz-Sperrsystem initialisieren
    Me.Show
    Init_Tab_Personen 'Tabelle "TAB-Personen" und das zugehrige Datensteuerelement initialisieren

    First = False

    If dat_Tab_Personen.Recordset.RecordCount > 0 Then dat_Tab_Personen.Recordset.MoveFirst 'zum ersten Datensatz gehen

End Sub

'************************************************************
'Sub       : Init_Tab_Personen
'Zweck     : Initialisiert die Tabelle "TAB-Personen" und das
'            zugehrige Datensteuerelement
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Sub Init_Tab_Personen ()

    dat_Tab_Personen.DatabaseName = DB_Personen_Name
    dat_Tab_Personen.RecordSource = Tab_Personen_Name
    dat_Tab_Personen.Refresh 'Tabelle aktualisieren
    dat_Tab_Personen.Recordset.LockEdits = False 'Optimistic Locking einschalten
    dat_Tab_Personen.Refresh 'Tabelle aktualisieren

End Sub

'************************************************************
'Funktion  : Lese_Satz_Nr
'Zweck     : Liest die Nummer des aktuellen Datensatzes
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Function Lese_Satz_Nr ()

    Lese_Satz_Nr = dat_Tab_Personen.Recordset("[Person-Id]")

End Function

'************************************************************
'Funktion  : Lese_Tab_Abf_Name
'Zweck     : Liest den Namen der aktuellen Tabelle bzw. Abfrage
'Parameter :
'Stand     : 22.06.1994
'Bemerkung :
'************************************************************
'
Function Lese_Tab_Abf_Name ()

    Lese_Tab_Abf_Name = dat_Tab_Personen.RecordSource

End Function

