//************************************************************************
//
//	Dateiname: bptools.c
//	Diverse Funktion zur Untersttzung einer Makrosprache
//	in Visual Basic
//
//	Autor: Torsten Zimmermann
//
//************************************************************************

#include <windows.h>
#include <vbapi.h>
#include <dos.h>
#include "bptools.h"

                     
void WINAPI VBCombo_SelectString(HCTL hCombo, LPSTR lpstr)
{
    HWND hwnd = VBGetControlHwnd(hCombo);
    if(IsWindow(hwnd))
    {
	DWORD dwIndex = SendMessage(hwnd, CB_FINDSTRING, 0, (DWORD)(LPSTR)lpstr);
	if((int)dwIndex != CB_ERR)
	   SendMessage(hwnd, CB_SETCURSEL, (WPARAM)dwIndex, 0L);
    }
}

void WINAPI VBCombo_ClearString(HCTL hCombo)
{
	HWND hwnd = VBGetControlHwnd(hCombo);
    	if(IsWindow(hwnd))
    	 SendMessage(hwnd, CB_SETCURSEL, -1, 0L);
}


short WINAPI DiskInfo (short nDiskID, LPLONG lBytesTotal, LPLONG lBytesFree)
{
	struct diskfree_t	df;
	long		bpc;

	if(_dos_getdiskfree(nDiskID, &df) == 0)
	{
		//Bytes per Cluster
		bpc = df.bytes_per_sector * df.sectors_per_cluster;
		*lBytesTotal = df.total_clusters * bpc;
		*lBytesFree = df.avail_clusters * bpc;
	        return -1;
	}
		else return 0;
}

int WINAPI VBEdit_GetLineCount(HCTL hctl)
{
	HWND hwnd = VBGetControlHwnd(hctl);
	if(!IsWindow(hwnd)) return (0);
	return (int) SendMessage(hwnd, EM_GETLINECOUNT, 0, 0L);
}

void WINAPI VBEdit_InvertLine(HCTL hctl, int iIndex)
{
        int	istart, iend;
	HWND hwnd = VBGetControlHwnd(hctl);
	if(IsWindow(hwnd))
        {
	istart = SendMessage(hwnd, EM_LINEINDEX, iIndex, 0L);
	iend = istart + SendMessage(hwnd, EM_LINELENGTH, istart, 0L);
	SendMessage(hwnd, EM_SETSEL, 0, MAKELPARAM(istart,iend));
	SetFocus(hwnd);
        }
}

HLSTR WINAPI VBEdit_GetLine(HCTL hctl, int iIndex)
{
	char cBuffer[128];
        WORD cbCount;
	HWND hwnd = VBGetControlHwnd(hctl);
	if(IsWindow(hwnd))
	{
	   *(WORD *)cBuffer = sizeof(cBuffer);
	   cbCount = SendMessage(hwnd, EM_GETLINE, iIndex, (DWORD)(LPSTR)cBuffer);
	   cBuffer[cbCount] = '\0';
	}
	return VBCreateHlstr(cBuffer, lstrlen(cBuffer));
        
}
