// scrolldi.cpp : implementation file
//

#include "stdafx.h"
#include "mfcdemo.h"
#include "scrolldi.h" 
#include "demotbl.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScrollDialog dialog


CScrollDialog::CScrollDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CScrollDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CScrollDialog)
	m_SmoothScroll = FALSE;
	//}}AFX_DATA_INIT
}

void CScrollDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CScrollDialog)
	DDX_Control(pDX, IDC_SCROLL_VSCROLL, m_VScroll);
	DDX_Control(pDX, IDC_SCROLL_VRANGE, m_VRange);
	DDX_Control(pDX, IDC_SCROLL_HSCROLL, m_HScroll);
	DDX_Control(pDX, IDC_SCROLL_HRANGE, m_HRange);
	DDX_Check(pDX, IDC_SCROLL_SMOOTH, m_SmoothScroll);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CScrollDialog, CDialog)
	//{{AFX_MSG_MAP(CScrollDialog)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()   
      
/////////////////////////////////////////////////////////////////////////////
// CScrollDialog  
                    
void CScrollDialog::InitializeFrom( CDemoTableControl * aCKTBL )
{                   
	DWORD flags  = aCKTBL->GetFlags();
	cktbl = aCKTBL;
	
	m_SmoothScroll 	= (flags&CKTBL_SMOOTH_SCROLL)!=0;      
}    

void CScrollDialog::ApplyData()
{    
	long mask=0,value=0;
	
	// TODO: Add your control notification handler code here
	      
	cktbl->SetFlagsTo( CKTBL_SMOOTH_SCROLL, m_SmoothScroll );  
	      
	mask |= CKTBL_HSCROLL|CKTBL_HSCROLL_ONDEMAND;
    switch(m_HScroll.GetCurSel()) {
    	case 0: value|=0; break;
	   	case 1: value|=CKTBL_HSCROLL; break;
 	  	case 2: value|=CKTBL_HSCROLL|CKTBL_HSCROLL_ONDEMAND; break;  
 	}  
 	 
 	mask |= CKTBL_VSCROLL|CKTBL_VSCROLL_ONDEMAND;
    switch(m_VScroll.GetCurSel()) {
    	case 0: value|=0; break;
	   	case 1: value|=CKTBL_VSCROLL; break;
 	  	case 2: value|=CKTBL_VSCROLL|CKTBL_VSCROLL_ONDEMAND; break;  
 	}   
 	
 	mask |= CKTBL_HSCROLL_MASK;
    switch(m_HRange.GetCurSel()) {
    	case 0: value|=CKTBL_HSCROLL_STOP; break;
	   	case 1: value|=CKTBL_HSCROLL_EXTRA; break;      
 	}     
 	
 	mask |= CKTBL_VSCROLL_MASK;
    switch(m_VRange.GetCurSel()) {
    	case 0: value|=CKTBL_VSCROLL_STOP; break;
	   	case 1: value|=CKTBL_VSCROLL_EXTRA; break;      
 	}  

   	cktbl->SetFlags( (cktbl->GetFlags() & ~mask) | value); 

	// Fore a WM_SIZE message to CKTBL so that scroll ranges are updated

	CRect rect;
	CSize size;
	cktbl->GetWindowRect(&rect);
	size = rect.Size();
	                    
	cktbl->PostMessage( WM_SIZE, 0, size.cx*256 + size.cy );  
	cktbl->Invalidate();
}                      
       
/////////////////////////////////////////////////////////////////////////////
// CScrollDialog message handlers
                    
void CScrollDialog::OnOK()
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();  
	ApplyData();
}
    

void CScrollDialog::OnApply()
{
	// TODO: Add your control notification handler code here
	if(UpdateData()) ApplyData();
}
    

BOOL CScrollDialog::OnInitDialog()
{     
	long flags = cktbl->GetFlags();
	int sel;
	
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	m_HScroll.Clear();
	m_HScroll.AddString( "None" );
	m_HScroll.AddString( "Always" );
	m_HScroll.AddString( "On demand only" );
	
	m_VScroll.Clear();
	m_VScroll.AddString( "None" );
	m_VScroll.AddString( "Always" );
	m_VScroll.AddString( "On demand only" );
	
	m_HRange.Clear();
	m_HRange.AddString( "Scroll upto limit" );
	m_HRange.AddString( "Scroll into gray area" );
	
	m_VRange.Clear();
	m_VRange.AddString( "Scroll upto limit" );
	m_VRange.AddString( "Scroll into gray area" );

	// HScroll
	
	switch( flags & CKTBL_HSCROLL|CKTBL_HSCROLL_ONDEMAND ) {
		case 0: 				sel = 0; break;
		case CKTBL_HSCROLL: 	sel = 1; break;
		case CKTBL_HSCROLL|CKTBL_HSCROLL_ONDEMAND: 	sel = 2; break;    
		default: 				sel=0;
	}       
	m_HScroll.SetCurSel(sel);
              
	// VScroll              
              
	switch( flags & CKTBL_VSCROLL|CKTBL_VSCROLL_ONDEMAND ) {
		case 0: 				sel = 0; break;
		case CKTBL_VSCROLL: 	sel = 1; break;
		case CKTBL_VSCROLL|CKTBL_VSCROLL_ONDEMAND: 	sel = 2; break;    
		default: 				sel=0;
	}       
	m_VScroll.SetCurSel(sel);
	          
	// HRange	          
	          
	switch( flags & CKTBL_HSCROLL_MASK ) {
		case CKTBL_HSCROLL_STOP:	sel = 0; break;
		case CKTBL_HSCROLL_EXTRA: 	sel = 1; break;
		default: 					sel=0;
	}       
	m_HRange.SetCurSel(sel);   
	
	// VRange	          
	          
	switch( flags & CKTBL_VSCROLL_MASK ) {
		case CKTBL_VSCROLL_STOP:	sel = 0; break;
		case CKTBL_VSCROLL_EXTRA: 	sel = 1; break;
		default: 					sel=0;
	}       
	m_VRange.SetCurSel(sel);
	 
	 
	return TRUE;  // return TRUE  unless you set the focus to a control
}
      