VERSION 2.00
Begin Form FrmCock 
   Caption         =   "Cocktails"
   ClientHeight    =   3765
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   5580
   Height          =   4170
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   3765
   ScaleWidth      =   5580
   Top             =   1140
   Width           =   5700
   Begin CommandButton CmdExit 
      Caption         =   "E&xit"
      Height          =   495
      Left            =   4080
      TabIndex        =   3
      Top             =   3000
      Width           =   1215
   End
   Begin CommandButton CmdSelect 
      Caption         =   "&Select"
      Height          =   495
      Left            =   240
      TabIndex        =   2
      Top             =   3000
      Width           =   1215
   End
   Begin VScrollBar Vsc 
      Height          =   2535
      LargeChange     =   10
      Left            =   5040
      TabIndex        =   1
      Top             =   240
      Width           =   255
   End
   Begin ListBox Lst 
      Height          =   2565
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   4695
   End
End
Option Explicit
Dim fIn As Integer       ' Anti recursion Flag
Dim fId As Integer       ' Current Index flag
Dim iMi As Integer       ' Cur rec relative pointer
Dim iMo As Integer       ' Scrollbar position
Dim iMf As String        ' First record
Dim iMt As String        ' Top record position
Dim iMb As String        ' Bottom record position
Dim iMl As String        ' Last Record
Dim iMn As Integer       ' No of records
Dim sKey As String       ' Search Key
Dim iN1 As Integer       ' Listbox Size
Dim iLev As Integer      ' Recursion Counter

Sub CmdExit_Click ()
    Unload Me
End Sub

Sub CmdSelect_Click ()
    Call GoSelect
End Sub

Sub Form_Activate ()
    'Debug.Print "Activate"
    Vsc.SetFocus
End Sub

Sub Form_Load ()
    If fIn Then Exit Sub

    fIn = True
    Call NameInit
    FrmCock.Show
    Call NameLoad
    fIn = False
End Sub

Sub Form_Resize ()
    If fIn Then Exit Sub

    fIn = True
    Call NameResize
    fIn = False
End Sub

Sub Form_Unload (Cancel As Integer)
    Call NameClose
End Sub

Sub GoDirect ()
    sKey = ""                        ' Blank srch key
    iMo = Vsc.Value                  ' Store scroll pos
    If fId = 1 Then
        FT1.Index = "I12"                ' Set Correct index
        fId = 2
    End If
    FT1.Seek "=", Format$(iMo, "00000")  ' Find record
    If Not FT1.NoMatch Then
        iMi = 0                          ' Set the Listbox index to Top
        iMt = FT1.Bookmark               ' Store the Top bookmark
        Call LoadList                    ' Reload the Listbox
    End If
End Sub

Sub GoDown ()
    If iMi >= (iN1 - 1) Then
        Call GoPageDown
    Else
        iMi = iMi + 1              ' Increment Index Pointer
        Lst.ListIndex = iMi        ' Set ListBox Index
    End If
End Sub

Sub GoEnd ()
    Dim Mcnt As Integer
    iMi = iN1 - 1
    FT1.Bookmark = iMl            ' Move To Last
    For Mcnt = 1 To iMi           ' Skip backwards n records
        FT1.MovePrevious
    Next Mcnt
    iMt = FT1.Bookmark            ' Set New Top Bookmark
    Call LoadList                 ' Reload the Listbox
End Sub

Sub GoHome ()
    iMt = iMf            ' Set the Top-Bookmark to First
    iMi = 0              ' Set the Listbox Index to Top (0)
    Call LoadList        ' Reload the Listbox
End Sub

Sub GoKey (sKeyX As String)
    sKey = sKey & sKeyX                  ' Increment String
    If fId = 2 Then
        FT1.Index = "I11"                ' Set Correct index
        fId = 1
    End If
    FT1.Seek ">=", sKey                  ' Seek reqd key
    If FT1.NoMatch Then
        sKey = ""
    Else
        If sKey <> UCase$(Mid$(FT1("F11"), 1, Len(sKey))) Then
            sKey = ""
        Else
            Vsc.Value = Val(FT1("F12"))  ' Move Scroll-bar
            iMo = Vsc.Value              ' Store value
            iMt = FT1.Bookmark           ' Store position
            iMi = 0                      ' Set Listbox index
            Call LoadList                ' Reload Listbox
        End If
    End If
End Sub

Sub GoPageDown ()
    iMt = iMb                  ' Set Top to bottom bookmark
    iMi = 0                    ' Set Listbox index pointer
    Call LoadList              ' Load the Listbox
End Sub

Sub GoPageUp1 ()
    Dim iMj As Integer
    FT1.Bookmark = iMt                     ' Move to Top
    iMj = 0
    Do While (Not FT1.BOF) And (iMj < iN1) ' Skip back n records
        FT1.MovePrevious
        iMj = iMj + 1
    Loop
    If FT1.BOF Then                        ' Protect from BOF errors
        iMj = iMj - 1
        FT1.MoveNext
    End If
    iMt = FT1.Bookmark                     ' Store New Top
    iMi = iMj - 1                          ' Set index position
    Call LoadList                          ' Load ListBox
End Sub

Sub GoPageUp10 ()
    Dim iMj As Integer
    FT1.Bookmark = iMt                     ' Move to Top
    iMj = iN1
    Do While (Not FT1.BOF) And (iMj > 0)   ' Skip back n
        iMj = iMj - 1
        FT1.MovePrevious
    Loop
    If FT1.BOF Then                        ' Prevent BOF errors
        FT1.MoveNext
    End If
    iMt = FT1.Bookmark                     ' Store new top
    Call LoadList                          ' Reload listbox
    iMi = 0
    Lst.ListIndex = 0
End Sub

Sub GoSelect ()
    ' Code goes here to action on user selection
    Debug.Print "Item Selected = " & Lst.Text
End Sub

Sub GoUp ()
    If iMi = 0 Then
        Call GoPageUp1
    Else
        iMi = iMi - 1            ' Decrement Index Pointer
        Lst.ListIndex = iMi      ' Set Listbox Index
    End If
End Sub

Sub LoadList ()
    Dim iMj As Integer
    Lst.Clear                                 ' Clear ListBox
    FT1.Bookmark = iMt                        ' Move To Top
    iMj = 1
    Do Until (FT1.EOF) Or (iMj > iN1)         ' Read thru records
        Lst.AddItem FT1("F11") + Space(70) + FT1("F12")
        FT1.MoveNext                          ' Next Record (Skip)
        iMj = iMj + 1                         ' Increment Counter
    Loop
    If FT1.EOF Then                           ' Prevent EOF errors
        FT1.MovePrevious
    End If
    iMb = FT1.Bookmark                        ' Store bottom
    Lst.ListIndex = iMi                       ' Set Listbox index to pointer
End Sub

Sub Lst_Click ()
    If fIn Then Exit Sub

    fIn = True
    Call SLstClk
    Vsc.SetFocus
    fIn = False
End Sub

Sub Lst_DblClick ()
    Call GoSelect
    Vsc.SetFocus
End Sub

Sub NameClose ()
    SetIni "Cocktail", "NameTop", Str$(FrmCock.Top)
    SetIni "Cocktail", "NameLeft", Str$(FrmCock.Left)
    SetIni "Cocktail", "NameWidth", Str$(FrmCock.Width)
    SetIni "Cocktail", "NameHeight", Str$(FrmCock.Height)
End Sub

Sub NameInit ()
    Dim Fetch As String
    Fetch = GetIni("Cocktail", "NameTop")
    If Fetch <> "" Then
        FrmCock.Top = Val(Fetch)
    End If
    Fetch = GetIni("Cocktail", "NameLeft")
    If Fetch <> "" Then
        FrmCock.Left = Val(Fetch)
    End If
    Fetch = GetIni("Cocktail", "NameWidth")
    If Fetch <> "" Then
        FrmCock.Width = Val(Fetch)
    End If
    Fetch = GetIni("Cocktail", "NameHeight")
    If Fetch <> "" Then
        FrmCock.Height = Val(Fetch)
    End If
    Call NameSize
End Sub

Sub NameLoad ()
    Set FD = OpenDatabase("D:\utils\Vb\Cocktail\Cocktail.mdb")
    Set FT1 = FD.OpenTable("T1")    '
    FT1.Index = "I12"               ' Open RecNo Index
    fId = 2                         ' Set Current Index Flag
    iMf = FT1.Bookmark              ' First Record
    iMt = iMf                       ' Top Record
    iMi = 1                         ' Index of Current Record
    iMn = FT1.RecordCount           ' Number of Records
    FT1.Seek "=", Format$(iMn - 1, "00000")
    iMl = FT1.Bookmark
    Call GoHome
    iMo = 0
    Vsc.Max = iMn - 1               ' because scrolls start from 0
    Vsc.SetFocus                    ' needed to set focus at start
End Sub

Sub NameResize ()
    Call NameSize
    If iMi > (iN1 - 1) Then
        iMi = iN1 - 1
    End If
    Vsc.LargeChange = iN1            ' Scroll granularity
    Call LoadList
End Sub

Sub NameSize ()
    Lst.Top = 120
    Lst.Left = 120
    Lst.Width = FrmCock.Width - 600
    Lst.Height = FrmCock.Height - CmdSelect.Height - 360 - 360
    iN1 = (Lst.Height - 30) / 195
    Vsc.Top = 120
    Vsc.Left = 120 + Lst.Width
    Vsc.Height = Lst.Height
    Vsc.LargeChange = iN1            ' Scroll granularity
    CmdSelect.Left = 120
    CmdExit.Left = Lst.Width + Vsc.Width - CmdExit.Width + 120
    CmdSelect.Top = Lst.Height + 240
    CmdExit.Top = CmdSelect.Top
End Sub

Sub SKeyPress (KeyAscii As Integer)
    If KeyAscii = 13 Then            ' Detect <CR>
        Call GoSelect
    Else
        GoKey UCase(Chr(KeyAscii))   ' Convert to Upper-case
    End If
End Sub

Sub SLstClk ()
    If iMi <> Lst.ListIndex Then  ' Action only if moved
        Vsc.Value = Vsc.Value - iMi + Lst.ListIndex
        iMo = Vsc.Value           ' Store the old comparison value
        iMi = Lst.ListIndex       ' Store the index pointer
        sKey = ""                 ' Blank the srch-key
    End If
End Sub

Sub sVscCng ()
    Dim iMm As Integer               ' Net Movement
    sKey = ""                        ' Blank Srch-Key
    If Vsc.Value = 0 Then
        GoHome                       ' Home
    ElseIf Vsc.Value = iMn - 1 Then
        GoEnd                        ' End
    Else
        iMm = Vsc.Value - iMo        ' Calc Net Movement
        If iMm = 1 Then              ' Down
            GoDown
        ElseIf iMm = -1 Then         ' Up
            GoUp
        ElseIf iMm = iN1 Then         ' Page-Down
            GoPageDown
        ElseIf iMm = (-1 * iN1) Then ' Page-Up
            GoPageUp10
        Else
            GoDirect                 ' Go Direct
        End If
    End If
    iMo = Vsc.Value                  ' Store old value
End Sub

Sub Vsc_Change ()
    If fIn Then Exit Sub

    fIn = True
    Call sVscCng
    fIn = False
End Sub

Sub Vsc_KeyPress (KeyAscii As Integer)
    If fIn Then Exit Sub

    fIn = True
    SKeyPress KeyAscii
    fIn = False
End Sub

Sub Vsc_Scroll ()
    If fIn Then Exit Sub

    fIn = True
    Call GoDirect
    Vsc.SetFocus
    fIn = False
End Sub

