VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "250 point line graph.  Resize window to see scaling.  Drag to move tracker."
   ClientHeight    =   5985
   ClientLeft      =   1185
   ClientTop       =   1740
   ClientWidth     =   9555
   ClipControls    =   0   'False
   Height          =   6390
   Left            =   1125
   LinkTopic       =   "Form1"
   ScaleHeight     =   399
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   637
   Top             =   1395
   Width           =   9675
   Begin TextBox MouseY 
      Enabled         =   0   'False
      Height          =   315
      Left            =   2115
      TabIndex        =   0
      Top             =   0
      Width           =   705
   End
   Begin TextBox MouseX 
      Enabled         =   0   'False
      Height          =   315
      Left            =   1425
      TabIndex        =   1
      Top             =   0
      Width           =   705
   End
   Begin CommandButton Command2 
      BackColor       =   &H00000000&
      Caption         =   "New"
      Height          =   315
      Left            =   720
      TabIndex        =   3
      Top             =   0
      Width           =   720
   End
   Begin CommandButton Command1 
      BackColor       =   &H00000000&
      Caption         =   "Print"
      Height          =   315
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   720
   End
   Begin FG FG1 
      Height          =   420
      Left            =   510
      Top             =   285
      Width           =   420
   End
End
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' I've created this mini demo as a quick introduction to FG coding
' techniques.  I've chosen a simplified timeseries graph
' and implemented just enough to illustrate the most important
' concepts.  Code clutter is avoided by varying Y values but not X,
' not drawing axes, legends etc.  Also, it makes only basic use
' of the Picture construct.  A real linegraph should use at least
' three pictures: one for the y axis (scaled Pixels horizontally
' and Data vertically), one for the x axis (scaled Data horizontally
' and Pixels vertically, and one for the datalines (scaled data
' horizontally and vertically).
'
' See Form's Load, Paint, Resize, MouseMove events and the CommandX
' clicks.
'
'Marc Pienaar                                                      '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Option Explicit
Dim DataPic As Long, YAxisPic As Long
Dim TheLine As Long
Dim TheYLabel As Long
Dim ThePoints() As ScalePointApi
Dim ThePolyLine As Long
Dim TheBitmap As Long
Dim TrackingLine As Long
Dim MinY As Double, MaxY As Double
Dim GraphPresent As Integer
Dim LeftMargin As Double

Sub Command1_Click ()
    ' Flaky, just shows the general idea
    Screen.MousePointer = 11
    Printer.Print ""            'Initialise printer
    Printer.ScaleMode = 3       'Because Placement is in pixels
    SetPlacement FG1, Printer.ScaleLeft + Printer.ScaleWidth * .2, Printer.ScaleTop, Printer.ScaleWidth * .8, Printer.ScaleHeight
    DoScale FG1                 'Realise to new placement
    DoDraw FG1, Printer.hDC
    Printer.EndDoc
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Rescale to screen
    SetPlacement FG1, Me.ScaleLeft, Me.ScaleTop, Me.ScaleWidth, Me.ScaleHeight
    DoScale FG1
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Screen.MousePointer = 0
End Sub

Sub Command2_Click ()
    'New Graph
    Populate
    SetScale FG1, 0, MaxY, 250, MinY - MaxY 'X data hard-coded 0-249,
    SetString TheYLabel, Format(MinY, "#0.00") & " to " & Format(MaxY, "#0.00")

    SSetY TrackingLine, 1, MinY
    SSetY TrackingLine, 2, MaxY
    SSetX TrackingLine, 1, 0
    SSetX TrackingLine, 2, 0

    GraphPresent = True
    Form_Resize
End Sub

Sub Form_Load ()
    Dim i As Integer
    Me.ScaleMode = 3                        'Pixels, because placement is in pixels
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add bitmap in pixel coordinates
    TheBitmap = CreateDib(FG1, 0, Command1.Top + Command1.Height, 96, Command1.Top + Command1.Height + 96, "Example1.Bmp", True)
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add Rotated Y-Label
    TheYLabel = SCreateTextOut(FG1, -30, 4, "")
    SetFontFaceName TheYLabel, "Arial"      'Only TrueType fonts can be rotated
    SetFontPointHeight TheYLabel, 16        'Fixed point-size; use SetFontScaleHeight to scale with graph
    SetFontEscapement TheYLabel, 900        '90 degrees
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add Polyline, although we'll only populate it on Command2_Click
    ReDim ThePoints(0)                      'Must redim before using
    ThePolyLine = SBCreatePolyLine(FG1, ThePoints())
    SetBorderColor ThePolyLine, QBColor(9)
    SetPreserveAttribs ThePolyLine, True    'restore DC after drawing
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add Tracking
    TrackingLine = SCreateLine(FG1, 0, 0, 0, 0)
    SetDrawMode TrackingLine, 10'7'
    SetBorderColor TrackingLine, QBColor(6)
    'SetPreserveAttribs TrackingLine, True   'don't bother - this is last item
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Command2 = True
End Sub

Sub Form_MouseMove (Button As Integer, Shift As Integer, x As Single, y As Single)
    Dim mx As Double, my As Double, tx As String, ty As String
    If Button <> 1 Then Exit Sub        'Not left-dragging
    If Not GraphPresent Then Exit Sub   'No graph yet
    mx = x: my = y                      'FG needs doubles
    ToScaleXY FG1, mx, my               'Convert mouse coords to scale of picture
    mx = Int(mx)                        'Not interested in fractions of a period
    tx = Format(mx, "#0")               'Format period for display
    If MouseX = tx Then Exit Sub        'Snap to period
    MouseX = tx
    If mx >= 0 And mx < 250 Then
        MouseY = Format(ThePoints(mx).y, "#0.00")
    Else MouseY = ""
    End If
    DoPaint TrackingLine        'Erase tracking line
    SSetX TrackingLine, 1, mx   'Set X1
    SSetX TrackingLine, 2, mx   'And X2
    DoScale TrackingLine        'Realise just the tracking line at new pos
    DoPaint TrackingLine        'Redraw just the tracking line
End Sub

Sub Form_Paint ()
    ' Just paint: DoScale has already been called where necessary
    DoPaint FG1
End Sub

Sub Form_Resize ()
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Purely cosmetic
    If Me.ScaleWidth < 300 Or Me.ScaleHeight < 300 Then ' If the window is small
        LeftMargin = Me.ScaleWidth \ 100                ' make left margin small
        SetVisible TheBitmap, False                     ' hide bitmap
        SetVisible TheYLabel, False                     ' hide rotated Y-Label
    Else
        LeftMargin = Command2.Left + Command2.Width
        SetVisible TheBitmap, True
        SetVisible TheYLabel, True
    End If
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    SSetY TheYLabel, 1, MinY + .3 * (MaxY - MinY)
    'Scale the graph to the new window size, excluding space at top for buttons
    SetPlacement FG1, Me.ScaleLeft + LeftMargin, Me.ScaleTop + Command1.Height, Me.ScaleWidth - LeftMargin, Me.ScaleHeight - Command1.Height
    DoScale FG1     'Scale everything
    Cls             'Clear the screen
    Form_Paint      'Necessary because no paint event when window is resized smaller
End Sub

Sub Populate ()
    Dim i As Integer
    Randomize
    MinY = 1E+100
    MaxY = -1E+100
    ReDim ThePoints(249)
    ThePoints(0).x = 0
    ThePoints(0).y = 4
    For i = 1 To 249
        ThePoints(i).x = i
        ThePoints(i).y = ThePoints(i - 1).y * (1 + ((-.5 + ((-1) ^ (i \ 80)) * .05 + Rnd) / 10#))
        If MinY > ThePoints(i).y Then MinY = ThePoints(i).y
        If MaxY < ThePoints(i).y Then MaxY = ThePoints(i).y
    Next i
End Sub

