Option Explicit
'Core definition of the VB API

Type PointAPI
    X As Integer
    Y As Integer
End Type

Type SCALEPOINTAPI
    X As Double
    Y As Double
End Type

'Object Creation functions

Declare Function CreatePicture Lib "FG.VBX" Alias "CreatePicture" (ByVal PictureHandle&) As Long
Declare Function CreateGlobalPicture Lib "FG.VBX" Alias "CreateGlobalPicture" () As Long

' Physical objects

Declare Function CreateArc Lib "FG.VBX" Alias "CreateArc" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%, ByVal X4%, ByVal Y4%) As Long
Declare Function CreateChord Lib "FG.VBX" Alias "CreateChord" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%, ByVal X4%, ByVal Y4%) As Long
Declare Function CreateDrawText Lib "FG.VBX" Alias "CreateDrawText" (ByVal PictureHandle&, ByVal NewText$, ByVal RectLeft%, ByVal RectTop%, ByVal RectWidth%, ByVal RectHeight%, ByVal nFormat%) As Long
Declare Function CreateEllipse Lib "FG.VBX" Alias "CreateEllipse" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%) As Long
Declare Function CreateLine Lib "FG.VBX" Alias "CreateLine" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%) As Long
Declare Function CreatePolygon Lib "FG.VBX" Alias "CreatePolygon" (ByVal PictureHandle&) As Long
Declare Function BCreatePolygon Lib "FG.VBX" Alias "BCreatePolygon" (ByVal PictureHandle&, ThePoints() As PointAPI) As Long
Declare Function CreatePie Lib "FG.VBX" Alias "CreatePie" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%, ByVal X4%, ByVal Y4%) As Long
Declare Function CreatePolyLine Lib "FG.VBX" Alias "CreatePolyLine" (ByVal PictureHandle&) As Long
Declare Function BCreatePolyLine Lib "FG.VBX" Alias "BCreatePolyLine" (ByVal PictureHandle&, ThePoints() As PointAPI) As Long
Declare Function CreatePolyPolygon Lib "FG.VBX" Alias "CreatePolyPolygon" (ByVal PictureHandle&) As Long
Declare Function BCreatePolyPolygon Lib "FG.VBX" Alias "BCreatePolyPolygon" (ByVal PictureHandle&, ThePoints() As PointAPI, Polycounts%()) As Long
Declare Function CReateRectangle Lib "FG.VBX" Alias "CreateRectangle" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%) As Long
Declare Function CreateRoundRect Lib "FG.VBX" Alias "CreateRoundRect" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal X3%, ByVal Y3%) As Long
Declare Function CreateTextOut Lib "FG.VBX" Alias "CreateTextOut" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal NewText$) As Long
Declare Function BCreateTabbedTextOut Lib "FG.VBX" Alias "BCreateTabbedTextOut" (ByVal PictureHandle&, ByVal X%, ByVal Y%, ByVal NewText$, TabStopPositions%(), ByVal TabOrigin%) As Long
Declare Function CreatePolyTextOut Lib "FG.VBX" Alias "CreatePolyTextOut" (ByVal PictureHandle&) As Long
Declare Function BCreatePolyTextOut Lib "FG.VBX" Alias "BCreatePolyTextOut" (ByVal PictureHandle&, ThePoints() As PointAPI, OutText$()) As Long
Declare Function CreateDIB Lib "FG.VBX" Alias "CreateDIB" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal FileName$, ByVal STretch%) As Long
Declare Function CreateBMP Lib "FG.VBX" Alias "CreateBMPPic" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal hBitmap%, ByVal STretch%) As Long
Declare Function CreateWMF Lib "FG.VBX" Alias "CreateWMF" (ByVal PictureHandle&, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%, ByVal FileName$, ByVal STretch%, ByVal MaintainAspect%) As Long


' World objects

Declare Function SCreateArc Lib "FG.VBX" Alias "SCreateArc" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#, ByVal X3#, ByVal Y3#, ByVal X4#, ByVal Y4#) As Long
Declare Function SCreateChord Lib "FG.VBX" Alias "SCreateChord" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#, ByVal X3#, ByVal Y3#, ByVal X4#, ByVal Y4#) As Long
Declare Function SCreateDrawText Lib "FG.VBX" Alias "SCreateDrawText" (ByVal PictureHandle&, ByVal NewText$, ByVal RectLeft#, ByVal RectTop#, ByVal RectWidth#, ByVal RectHeight#, ByVal nFormat%) As Long
Declare Function SCreateEllipse Lib "FG.VBX" Alias "SCreateEllipse" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#) As Long
Declare Function SCreateLine Lib "FG.VBX" Alias "SCreateLine" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#) As Long
Declare Function SCreatePolygon Lib "FG.VBX" Alias "SCreatePolygon" (ByVal PictureHandle&) As Long
Declare Function SBCreatePolygon Lib "FG.VBX" Alias "SBCreatePolygon" (ByVal PictureHandle&, ThePoints() As SCALEPOINTAPI) As Long
Declare Function SCreatePie Lib "FG.VBX" Alias "SCreatePie" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#, ByVal X3#, ByVal Y3#, ByVal X4#, ByVal Y4#) As Long
Declare Function SCreatePolyline Lib "FG.VBX" Alias "SCreatePolyLine" (ByVal PictureHandle&) As Long
Declare Function SBCreatePolyline Lib "FG.VBX" Alias "SBCreatePolyLine" (ByVal PictureHandle&, ThePoints() As SCALEPOINTAPI) As Long
Declare Function SCreatePolyPolygon Lib "FG.VBX" Alias "SCreatePolyPolygon" (ByVal PictureHandle&) As Long
Declare Function SBCreatePolyPolygon Lib "FG.VBX" Alias "SBCreatePolyPolygon" (ByVal PictureHandle&, ThePoints() As SCALEPOINTAPI, Polycounts%()) As Long
Declare Function SCReateRectangle Lib "FG.VBX" Alias "SCreateRectangle" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#) As Long
Declare Function SCreateRoundRect Lib "FG.VBX" Alias "SCreateRoundRect" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#, ByVal X3#, ByVal Y3#) As Long
Declare Function SCreateTextOut Lib "FG.VBX" Alias "SCreateTextOut" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal NewText$) As Long
Declare Function SBCreateTabbedTextOut Lib "FG.VBX" Alias "SBCreateTabbedTextOut" (ByVal PictureHandle&, ByVal X#, ByVal Y#, ByVal NewText$, TabStopPositions#(), ByVal TabOrigin#) As Long
Declare Function SCreatePolyTextOut Lib "FG.VBX" Alias "SCreatePolyTextOut" (ByVal PictureHandle&) As Long
Declare Function SBCreatePolyTextOut Lib "FG.VBX" Alias "SBCreatePolyTextOut" (ByVal PictureHandle&, ThePoints() As SCALEPOINTAPI, OutText$()) As Long
Declare Function SCreateDIB Lib "FG.VBX" Alias "SCreateDIB" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#, ByVal FileName$, ByVal STretch%) As Long
Declare Function SCreateBMP Lib "FG.VBX" Alias "SCreateBMPPic" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#, ByVal hBitmap%, ByVal STretch%) As Long
Declare Function SCreateWMF Lib "FG.VBX" Alias "SCreateWMF" (ByVal PictureHandle&, ByVal X1#, ByVal Y1#, ByVal X2#, ByVal Y2#, ByVal FileName$, ByVal STretch%, ByVal MaintainAspect%) As Long

' Positive border widths are scalable
Declare Sub SetBorderWidth Lib "FG.VBX" Alias "SETPENWIDTH" (ByVal GraphicHandle&, ByVal nPenStyle%)
' 0 - Solid
' 1 - Dash
' 2 - Dot
' 3 - Dash Dot
' 4 - Dash Dot Dot
' 5 - Transparent
' 6 - Inside Solid
Declare Sub SetBorderStyle Lib "FG.VBX" Alias "SETPENSTYLE" (ByVal GraphicHandle&, ByVal nPenWidth%)
Declare Sub SetBorderColor Lib "FG.VBX" Alias "SETPENCOLOR" (ByVal GraphicHandle&, ByVal crColor&)

' 0 - Solid
' 1 - Hollow
' 2 - Horizontal Lines
' 3 - Vertical Lines
' 4 - Upward Diagonal
' 5 - Downward Diagonal
' 6 - Cross
' 7 - Diagonal Cross
Declare Sub SetFillStyle Lib "FG.VBX" Alias "SetFillStyle" (ByVal GraphicHandle&, ByVal nBrushStyle%)
Declare Sub SetFillColor Lib "FG.VBX" Alias "SetFillColor" (ByVal GraphicHandle&, ByVal crColor&)

Declare Sub SetFontPixelHeight Lib "FG.VBX" Alias "SetPixelFontHeight" (ByVal GraphicHandle&, ByVal nHeight%)
Declare Sub SetFontPointHeight Lib "FG.VBX" Alias "SetPointFontHeight" (ByVal GraphicHandle&, ByVal nHeight#)
Declare Sub SetFontScaleHeight Lib "FG.VBX" Alias "SetScaleFontHeight" (ByVal GraphicHandle&, ByVal dHeight#)
Declare Sub SetFontPixelWidth Lib "FG.VBX" Alias "SetPixelFontWidth" (ByVal GraphicHandle&, ByVal nWidth%)
Declare Sub SetFontPointWidth Lib "FG.VBX" Alias "SetPointFontWidth" (ByVal GraphicHandle&, ByVal nWidth#)
Declare Sub SetFontScaleWidth Lib "FG.VBX" Alias "SetScaleFontWidth" (ByVal GraphicHandle&, ByVal dWidth#)
Declare Sub SetFontEscapement Lib "FG.VBX" Alias "SetFontEscapement" (ByVal GraphicHandle&, ByVal nEscapement%)
Declare Sub SetFontWeight Lib "FG.VBX" Alias "SetFontWeight" (ByVal GraphicHandle&, ByVal nWeight%)
Declare Sub SetFontItalic Lib "FG.VBX" Alias "SetFontItalic" (ByVal GraphicHandle&, ByVal nItalic%)
Declare Sub SetFontUnderline Lib "FG.VBX" Alias "SetFontUnderline" (ByVal GraphicHandle&, ByVal nUnderline%)
Declare Sub SetFontStrikeOut Lib "FG.VBX" Alias "SetFontStrikeOut" (ByVal GraphicHandle&, ByVal nStrikeOut%)
Declare Sub SetFontFaceName Lib "FG.VBX" Alias "SetFontFaceName" (ByVal GraphicHandle&, ByVal FaceName As String)
Declare Sub SetFontColor Lib "FG.VBX" Alias "SetFontColor" (ByVal GraphicHandle&, ByVal crColor&)

Declare Sub SetBackColor Lib "FG.VBX" Alias "SetBackColor" (ByVal GraphicHandle&, ByVal crColor&)
' 1 - Transparent
' 2 - Opaque
Declare Sub SetBackStyle Lib "FG.VBX" Alias "SetBackStyle" (ByVal GraphicHandle&, ByVal BackStyle%)
'  1 - Pixel is always black.
'  2 - Pixel is the inverse of the R2_MERGEPEN color (final pixel = ~(pen | screen pixel)).
'  3 - Pixel is a combination of the colors common to both the screen and the inverse of the pen (final pixel = (~pen) & screen pixel).
'  4 - Pixel is the inverse of the pen color.
'  5 - Pixel is a combination of the colors common to both the pen and the inverse of the screen (final pixel = (~screen pixel) & pen).
'  6 - Pixel is the inverse of the screen color.
'  7 - Pixel is a combination of the colors that are in the pen and in the screen, but not in both (final pixel = pen ^ screen pixel).
'  8 - Pixel is the inverse of the R2_MASKPEN color (final pixel = ~(pen & screen pixel)).
'  9 - Pixel is a combination of the colors common to both the pen and the screen (final pixel = pen & screen pixel).
' 10 - Pixel is the inverse of the R2_XORPEN color (final pixel = ~(pen ^ screen pixel)).
' 11 - Pixel remains unchanged.
' 12 - Pixel is a combination of the screen color and the inverse of the pen color (final pixel = (~pen) | screen pixel).
' 13 - Pixel is the pen color.
' 14 - Pixel is a combination of the pen color and the inverse of the screen color (final pixel = (~screen pixel) | pen).
' 15 - Pixel is a combination of the pen color and the screen color (final pixel = pen | screen pixel).
' 16 - Pixel is always white.
Declare Sub SetDrawMode Lib "FG.VBX" Alias "SETDRAWMODE" (ByVal GraphicHandle&, ByVal NewDrawMode%)
Declare Sub SetVisible Lib "FG.VBX" Alias "SETVISIBLE" (ByVal GraphicHandle&, ByVal IsVisible%)
Declare Sub SetPreserveAttribs Lib "FG.VBX" Alias "SetPreserveAttribs" (ByVal GraphicHandle&, ByVal PreserveAttribs%)

Declare Function GetBorderWidth% Lib "FG.VBX" Alias "GETPENWIDTH" (ByVal GraphicHandle&)
Declare Function GetBorderStyle% Lib "FG.VBX" Alias "GETPENSTYLE" (ByVal GraphicHandle&)
Declare Function GetBorderColor& Lib "FG.VBX" Alias "GETPENCOLOR" (ByVal GraphicHandle&)

Declare Function GetFillStyle% Lib "FG.VBX" Alias "GetFillStyle" (ByVal GraphicHandle&)
Declare Function GetFillColor& Lib "FG.VBX" Alias "GetFillColor" (ByVal GraphicHandle&)

Declare Function GetFontPixelHeight% Lib "FG.VBX" Alias "GetPixelFontHeight" (ByVal GraphicHandle&)
Declare Sub GetFontPointHeightEx Lib "FG.VBX" Alias "GetPointFontHeight" (ByVal GraphicHandle&, dRetVal As Double)
Declare Sub GetFontScaleHeightEx Lib "FG.VBX" Alias "GetScaleFontHeight" (ByVal GraphicHandle&, dRetVal#)
Declare Function GetFontPixelWidth% Lib "FG.VBX" Alias "GetPixelFontWidth" (ByVal GraphicHandle&)
Declare Sub GetFontPointWidthEx Lib "FG.VBX" Alias "GetPointFontWidth" (ByVal GraphicHandle&, dRetVal As Double)
Declare Sub GetFontScaleWidthEx Lib "FG.VBX" Alias "GetScaleFontWidth" (ByVal GraphicHandle&, dRetVal#)
Declare Function GetFontEscapement% Lib "FG.VBX" Alias "GetFontEscapement" (ByVal GraphicHandle&)
Declare Function GetFontWeight% Lib "FG.VBX" Alias "GetFontWeight" (ByVal GraphicHandle&)
Declare Function GetFontItalic% Lib "FG.VBX" Alias "GetFontItalic" (ByVal GraphicHandle&)
Declare Function GetFontUnderline% Lib "FG.VBX" Alias "GetFontUnderline" (ByVal GraphicHandle&)
Declare Function GetFontStrikeOut% Lib "FG.VBX" Alias "GetFontStrikeOut" (ByVal GraphicHandle&)
Declare Sub GetFontFaceNameex Lib "FG.VBX" Alias "GetFontFaceName" (ByVal GraphicHandle&, ByVal RetSTring$)
Declare Function GetFontColor& Lib "FG.VBX" Alias "GetFontColor" (ByVal GraphicHandle&)

Declare Function GetBackColor& Lib "FG.VBX" Alias "GetBackColor" (ByVal GraphicHandle&)
Declare Function GetBackStyle% Lib "FG.VBX" Alias "GetBackStyle" (ByVal GraphicHandle&)
Declare Function GetDrawMode% Lib "FG.VBX" Alias "GETDRAWMODE" (ByVal GraphicHandle&)
Declare Function GetVisible% Lib "FG.VBX" Alias "GETVISIBLE" (ByVal GraphicHandle&)
Declare Function GetPreserveAttribs% Lib "FG.VBX" Alias "GetPreserveAttribs" (ByVal GraphicHandle&)



' Object manipulation functions

Declare Sub SetX Lib "FG.VBX" Alias "SetX" (ByVal GraphicHandle&, ByVal Idx%, ByVal X%)
Declare Function GetX Lib "FG.VBX" Alias "GetX" (ByVal GraphicGHandle&, ByVal Idx%) As Integer
Declare Sub SetY Lib "FG.VBX" Alias "SetY" (ByVal GraphicHandle&, ByVal Idx%, ByVal Y%)
Declare Function GetY Lib "FG.VBX" Alias "GetY" (ByVal GraphicGHandle&, ByVal Idx%) As Integer

Declare Sub SSetX Lib "FG.VBX" Alias "ScaleSetX" (ByVal GraphicHandle&, ByVal Idx%, ByVal X#)
Declare Sub SGetXex Lib "FG.VBX" Alias "ScaleGetX" (ByVal GraphicGHandle&, ByVal Idx%, RetX#)
Declare Sub SSetY Lib "FG.VBX" Alias "ScaleSetY" (ByVal GraphicHandle&, ByVal Idx%, ByVal Y#)
Declare Sub SGetYex Lib "FG.VBX" Alias "ScaleGetY" (ByVal GraphicGHandle&, ByVal Idx%, RetY#)

Declare Sub ADDPoint Lib "FG.VBX" Alias "AddXY" (ByVal GraphicGHandle&, ByVal NewX%, ByVal NewY%)
Declare Sub SAddPoint Lib "FG.VBX" Alias "ScaleAddXY" (ByVal GraphicGHandle&, ByVal NewX#, ByVal NewY#)
Declare Function GetNumPoints Lib "FG.VBX" Alias "GetSize" (ByVal GraphicHandle&) As Integer
Declare Sub RemoveAllPoints Lib "FG.VBX" Alias "RemoveAllPoints" (ByVal GraphicGHandle&)
Declare Sub InsertPointAt Lib "FG.VBX" Alias "InsertPointAt" (ByVal GraphicGHandle&, ByVal nIndex%, ByVal dNewX%, ByVal dNewY%)
Declare Sub RemovePointAt Lib "FG.VBX" Alias "RemovePointAt" (ByVal GraphicGHandle&, ByVal nIndex%)
Declare Sub SInsertPointAt Lib "FG.VBX" Alias "ScaleInsertPointAt" (ByVal GraphicGHandle&, ByVal nIndex%, ByVal dNewX#, ByVal dNewY#)
Declare Sub RemoveAllPolyCounts Lib "FG.VBX" Alias "RemoveAllPolyCounts" (ByVal GraphicGHandle&)
Declare Sub SetPolyCount Lib "FG.VBX" Alias "SetPolyCount" (ByVal GraphicGHandle&, ByVal nIndex%, ByVal nCount%)
Declare Sub AddPolyCount Lib "FG.VBX" Alias "AddPolyCount" (ByVal GraphicGHandle&, ByVal nNewCount%)
Declare Sub InsertPolyCountAt Lib "FG.VBX" Alias "InsertPolyCountAt" (ByVal GraphicGHandle&, ByVal nIndex%, ByVal nNewCount%)
Declare Sub RemovePolyCountAt Lib "FG.VBX" Alias "RemovePolyCountAt" (ByVal GraphicGHandle&, ByVal nIndex%)
Declare Function GetNumPolyCounts Lib "FG.VBX" Alias "GetNumCounts" (ByVal GraphicHandle&) As Integer
Declare Sub SetString Lib "FG.VBX" Alias "SetText" (ByVal GraphicGHandle&, ByVal pNewText As String)
Declare Sub GetStringex Lib "FG.VBX" Alias "GetText" (ByVal GraphicGHandle&, ByVal pNewText As String)
Declare Sub AddPText Lib "FG.VBX" Alias "AddPText" (ByVal PolyTextHandle&, ByVal nNewX%, ByVal nNewY%, ByVal pNewText$)
Declare Sub SAddPText Lib "FG.VBX" Alias "WorldAddPText" (ByVal PolyTextHandle&, ByVal dNewX#, ByVal dNewY#, ByVal pNewText$)
Declare Sub SetPTextAt Lib "FG.VBX" Alias "SetPTextAt" (ByVal PolyTextHandle&, ByVal nIdx%, ByVal pNewText$)
Declare Sub GetPTextAtex Lib "FG.VBX" Alias "GetPTextAt" (ByVal PolyTextHandle&, ByVal nIdx%, ByVal pNewText$)
Declare Sub RemoveAllPText Lib "FG.VBX" Alias "RemoveAllPText " (ByVal PolyTextHandle&)
Declare Sub InsertPTextAt Lib "FG.VBX" Alias "InsertPTextAt" (ByVal PolyTextHandle&, ByVal nIdx%, ByVal X%, ByVal Y%, ByVal pNewText$)
Declare Sub SInsertPTextAt Lib "FG.VBX" Alias "WorldInsertPTextAt" (ByVal PolyTextHandle&, ByVal nIdx%, ByVal X#, ByVal Y#, ByVal pNewText$)
Declare Sub RemovePTextAt Lib "FG.VBX" Alias "RemovcePTextAt" (ByVal PolyTextHandle&, ByVal nIdx%)

Declare Sub ToScaleXY Lib "FG.VBX" Alias "PhysicalToScale" (ByVal PictureHandle&, X#, Y#)
Declare Sub ToPhysicalXY Lib "FG.VBX" Alias "ScaleToPhysical" (ByVal PictureHandle&, X#, Y#)
Declare Sub ToScaleWH Lib "FG.VBX" Alias "PhysicalToScaleWH" (ByVal PictureHandle&, TWidth#, THeight#)
Declare Sub ToPhysicalWH Lib "FG.VBX" Alias "ScaleToPhysicalWH" (ByVal PictureHandle&, TWidth#, THeight#)

Declare Function GetTextWidth Lib "FG.VBX" Alias "GetTextWidth" (ByVal PictureHandle&, ByVal hDC%, ByVal Text$) As Integer
Declare Function GetTextHeight Lib "FG.VBX" Alias "GetTextHeight" (ByVal PictureHandle&, ByVal hDC%, ByVal Text$) As Integer
Declare Sub GetScaleTextWidthex Lib "FG.VBX" Alias "GetScaleTextWidth" (ByVal PictureHandle&, ByVal hDC%, ByVal Text$, dRetVal#)
Declare Sub GetScaleTextHeightex Lib "FG.VBX" Alias "GetScaleTextHeight" (ByVal PictureHandle&, ByVal hDC%, ByVal Text$, dRetVal#)

'Common functions

Declare Sub SetScale Lib "FG.VBX" Alias "SETPICWORLD" (ByVal PictureHandle&, ByVal WorldLeft#, ByVal WorldTop#, ByVal WorldWidth#, ByVal WorldHeight#)
Declare Sub SetPlacement Lib "FG.VBX" Alias "SETPICPHYSICAL" (ByVal PictureHandle&, ByVal PhysicalLeft#, ByVal PhysicalTop#, ByVal PhysicalWidth#, ByVal PhysicalHeight#)
Declare Function IsScaleble Lib "FG.VBX" Alias "IsScalable" (ByVal GraphicHandle&) As Integer

Declare Sub DoScale Lib "FG.VBX" Alias "REALIZE" (ByVal GraphicHandle&)
Declare Sub DoPaint Lib "FG.VBX" Alias "DOPAINT" (ByVal GraphicHandle&)
Declare Sub DoDraw Lib "FG.VBX" Alias "DODRAW" (ByVal GraphicHandle&, ByVal ThehDC%)
Declare Sub ClearAll Lib "FG.VBX" Alias "CLEARALL" (ByVal PictureHandle&)
' There are a few ways in which an object is removed.
'   0-No Drawing
'   1-Draw object to its background color
'   2-Redraw the object with its current settings.  (this is incase it is xor'ing)
Declare Sub RemoveObject Lib "FG.VBX" Alias "REMOVEOBJECT" (ByVal GraphicHandle&, ByVal ThehDC%, ByVal RemoveMode%, ByVal ShouldRemoveObject%, ByVal DrawColor&)

Function GetFontFaceName (GraphicHandle As Long) As String
    Dim APISTR As String * 64
    Dim RetSTring As String

    GetFontFaceNameex GraphicHandle, APISTR
    RetSTring = Left$(APISTR, InStr(APISTR, Chr$(0)))
    GetFontFaceName = RetSTring
End Function

Function GetFontPointHeight (GraphicHandle As Long) As Double
    Dim Dummy As Double
    
    GetFontPointHeightEx GraphicHandle, Dummy
    GetFontPointHeight = Dummy
End Function

Function GetFontPointWidth (GraphicHandle As Long) As Double
    Dim Dummy As Double
    
    GetFontPointWidthEx GraphicHandle, Dummy
    GetFontPointWidth = Dummy
End Function

Function GetFontScaleHeight (GraphicHandle As Long) As Double
    Dim Dummy As Double

    GetFontScaleHeightEx GraphicHandle, Dummy
    GetFontScaleHeight = Dummy
End Function

Function GetFontScaleWidth (GraphicHandle As Long) As Double
    Dim Dummy As Double

    GetFontScaleWidthEx GraphicHandle, Dummy
    GetFontScaleWidth = Dummy
End Function

Function GetPTextAt (GraphicHandle As Long, Idx As Integer) As String
    Dim APISTR As String * 64
    Dim RetSTring As String

    GetPTextAtex GraphicHandle, Idx, APISTR
    RetSTring = Left$(APISTR, InStr(APISTR, Chr$(0)))
    GetPTextAt = RetSTring
End Function

Function GetScaleTextHeight (PictureHandle As Long, hDC As Integer, Text As String) As Double
    Dim Dummy As Double

    GetScaleTextHeightex PictureHandle, hDC, Text, Dummy
    GetScaleTextHeight = Dummy
End Function

Function GetScaleTextWidth (GraphicHandle As Long, hDC As Integer, Text As String) As Double
    Dim Dummy As Double

    GetScaleTextWidthex GraphicHandle, hDC, Text, Dummy
    GetScaleTextWidth = Dummy
End Function

Function GetString (GraphicHandle As Long) As String
    Dim APISTR As String * 64
    Dim RetSTring As String

    GetStringex GraphicHandle, APISTR
    RetSTring = Left$(APISTR, InStr(APISTR, Chr$(0)) - 1)
    GetString = RetSTring
End Function

Function SGetX (GraphicHandle As Long, Idx As Integer) As Double
    Dim Dummy As Double

    SGetXex GraphicHandle, Idx, Dummy
    SGetX = Dummy
End Function

Function SGetY (GraphicHandle As Long, Idx As Integer) As Double
    Dim Dummy As Double

    SGetYex GraphicHandle, Idx, Dummy
    SGetY = Dummy
End Function

