unit Edit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, VBXCtrl, Hotmap;

type
  TEditForm = class(TForm)
    Memo1: TMemo;
    HotMap1: THotMap;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    ListBox1: TListBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Edit3: TEdit;
    Edit4: TEdit;
	procedure UpdateList(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure HotMap1RegionMouseDown(Sender: TObject;
      var RegionNum: Single; var Button: Integer);

  private
     OffsetX: Integer;
     OffsetY: Integer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  EditForm: TEditForm;

implementation

{$R *.DFM}

procedure TEditForm.FormCreate(Sender: TObject);
begin
    HotMap1.FillType := 3;
    Memo1.Text :=  'This form demonstrates DataFile and BmpName properties. You can read, save ';
    Memo1.Text := Memo1.Text + 'and edit regions in run time. You can load any bitmap. The ''Open File'' ';
    Memo1.Text := Memo1.Text + 'dialogs build-in into control. You can assocciate any text with any region.';

end;

procedure TEditForm.UpdateList(Sender: TObject);
	var n: Integer;
begin
	ListBox1.Clear;

   	For n := 0 To (HotMap1.NumOfRgns - 1) Do
       	ListBox1.Items.Add(HotMap1.RegionString[n]);
end;

procedure TEditForm.FormShow(Sender: TObject);
begin
   	OffsetX := (self.Width - HotMap1.Width);
    OffsetY := (self.Height - HotMap1.Height);
end;

procedure TEditForm.FormResize(Sender: TObject);
begin
    If self.WindowState <> wsMinimized Then
        {Do not let user to make to small picture, to avoid loosing scaling}
        If ((self.Width - OffsetX) > 50) And ((self.Height - OffsetY) > 50) Then
        begin
            HotMap1.Width := self.Width - OffsetX;
            HotMap1.Height := self.Height - OffsetY;
	end;
end;

procedure TEditForm.Button1Click(Sender: TObject);
begin
    HotMap1.Action := 6;
    If HotMap1.DataFile <> '' Then
	begin
        HotMap1.Action := 4;
        HotMap1.CurrentRgn := 0;
        Edit3.Text := HotMap1.DataFile;
        Edit4.Text := HotMap1.BmpName;
    end;

    UpdateList(Self);
end;

procedure TEditForm.Button2Click(Sender: TObject);
begin
    HotMap1.DataFile := Edit3.Text;
    HotMap1.Action := 3;
end;

procedure TEditForm.Button3Click(Sender: TObject);
begin
    HotMap1.Action := 7;
    UpdateList(Self);
end;

procedure TEditForm.Button4Click(Sender: TObject);
begin
    HotMap1.Action := 5;
    Edit4.Text := HotMap1.BmpName
end;

procedure TEditForm.ListBox1Click(Sender: TObject);
	var n:	Integer;
begin
    For n := 0 To (HotMap1.NumOfRgns - 1) Do
    begin
      If ListBox1.Items[ListBox1.ItemIndex] = HotMap1.RegionString[n] Then
      begin
        HotMap1.CurrentRgn := (n + 1);
        HotMap1.Action := 1;
        Exit;
      end;
    end;
end;

procedure TEditForm.HotMap1RegionMouseDown(Sender: TObject;
  var RegionNum: Single; var Button: Integer);
  var Rn:	Integer;
begin
    Rn := Round(RegionNum);
    Edit1.Text := IntToStr(Rn);
    Case Rn of
        0:
            Edit2.Text := '';
        else
            Edit2.Text := HotMap1.RegionString[Rn - 1];
	end;
end;

end.
