{********************************************}
{*                                          *}
{*   HOTMAP.PAS generated from HOTMAP.VBX   *}
{*                                          *}
{********************************************}

unit Hotmap;

interface

uses SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTHotMap}
{^- Remove space to enable default init data -- See documentation. }

type
  THotMapLinkErrorEvent = procedure (Sender: TObject; var LinkErr: Integer)
    of object;
  THotMapLinkCloseEvent = procedure (Sender: TObject) of object;
  THotMapLinkOpenEvent = procedure (Sender: TObject; var Cancel: Integer) of
    object;
  THotMapLinkChangeEvent = procedure (Sender: TObject) of object;
  THotMapRegionMouseDownEvent = procedure (Sender: TObject; var RegionNum:
    Single; var Button: Integer) of object;
  THotMapRegionMouseUpEvent = procedure (Sender: TObject; var RegionNum:
    Single; var Button: Integer) of object;
  THotMapRegionMouseOverEvent = procedure (Sender: TObject; var RegionNum:
    Single) of object;

  { THotMap }

  THotMap = class(TVBXControl)
  protected
    FOnLinkError: THotMapLinkErrorEvent;
    FOnLinkClose: THotMapLinkCloseEvent;
    FOnLinkOpen: THotMapLinkOpenEvent;
    FOnLinkChange: THotMapLinkChangeEvent;
    FOnRegionMouseDown: THotMapRegionMouseDownEvent;
    FOnRegionMouseUp: THotMapRegionMouseUpEvent;
    FOnRegionMouseOver: THotMapRegionMouseOverEvent;
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 1 read GetIntProp;
    property RegionString[Index: Integer]: TVBString index 12 read
      GetStringArrayProp write SetStringArrayProp;
    property MyTag: TVBString index 14 read GetBStringProp write
      SetBStringProp;
    property MyTagMsg: TVBString index 19 read GetBStringProp write
      SetBStringProp;
    property NumOfRgns: TVBInteger index 21 read GetIntProp write SetIntProp;
    property RegionColor[Index: Integer]: TColor index 28 read
      GetColorArrayProp write SetColorArrayProp;
  published
    property BackColor: TColor index 2 read GetColorProp write SetColorProp
      default -2147483633;
    property Visible;
    property DragMode;
    property DragCursor;
    property MouseCursor: TVBPic index 13 read GetPictureProp write
      SetPictureProp stored False;
    property LinkTopic: TVBString index 15 read GetStringProp write
      SetStringProp;
    property LinkItem: TVBString index 16 read GetStringProp write
      SetStringProp;
    property LinkTimeOut: TVBInteger index 17 read GetIntProp write
      SetIntProp default 50;
    property LinkMode: TVBEnum index 18 read GetEnumProp write SetEnumProp
      default 0;
    property BmpName: TVBString index 20 read GetStringProp write
      SetStringProp;
    property FillType: TVBEnum index 22 read GetEnumProp write SetEnumProp;
    property Stretch: Boolean index 23 read GetBoolProp write SetBoolProp;
    property CurrentRgn: TVBInteger index 24 read GetIntProp write SetIntProp;
    property Action: TVBEnum index 25 read GetEnumProp write SetEnumProp
      stored False;
    property About: TVBEnum index 26 read GetEnumProp write SetEnumProp
      stored False;
    property DataFile: TVBString index 27 read GetStringProp write
      SetStringProp;
    property ColorMode: Boolean index 29 read GetBoolProp write SetBoolProp;
    property DragAllowed: Boolean index 30 read GetBoolProp write SetBoolProp;
    property MouseHotX: TVBInteger index 31 read GetIntProp write SetIntProp;
    property MouseHotY: TVBInteger index 32 read GetIntProp write SetIntProp;
    property OnClick;
    property OnDragDrop;
    property OnEndDrag;
    property OnDragOver;
    property OnLinkError: THotMapLinkErrorEvent read FOnLinkError write
      FOnLinkError;
    property OnLinkClose: THotMapLinkCloseEvent read FOnLinkClose write
      FOnLinkClose;
    property OnLinkOpen: THotMapLinkOpenEvent read FOnLinkOpen write
      FOnLinkOpen;
    property OnLinkChange: THotMapLinkChangeEvent read FOnLinkChange write
      FOnLinkChange;
    property OnRegionMouseDown: THotMapRegionMouseDownEvent read
      FOnRegionMouseDown write FOnRegionMouseDown;
    property OnRegionMouseUp: THotMapRegionMouseUpEvent read FOnRegionMouseUp
      write FOnRegionMouseUp;
    property OnRegionMouseOver: THotMapRegionMouseOverEvent read
      FOnRegionMouseOver write FOnRegionMouseOver;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

{ THotMap }

constructor THotMap.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('HOTMAP.VBX');
  FVBXClass := StrNew('HotMap');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents];
  FVBXFlags := [vfArrows, vfLoadMessage];
  {$IFDEF InitTHotMap}
  FHForm := VBXCreateFormFile(THotMapInitLen, @THotMapInitData);
  {$ENDIF}
end;

procedure THotMap.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: begin end; { VCL Handles OnDragDrop }
    2: begin end; { VCL Handles OnDragOver }
    3: DispatchCustomEvent(FOnLinkError, Message, 3);
    4: DispatchCustomEvent(FOnLinkClose, Message, 4);
    5: DispatchCustomEvent(FOnLinkOpen, Message, 5);
    6: DispatchCustomEvent(FOnLinkChange, Message, 6);
    7: DispatchCustomEvent(FOnRegionMouseDown, Message, 7);
    8: DispatchCustomEvent(FOnRegionMouseUp, Message, 8);
    9: DispatchCustomEvent(FOnRegionMouseOver, Message, 9);
    10: DispatchMouseEvent(OnMouseDown, Message);
    11: DispatchMouseMoveEvent(OnMouseMove, Message);
    12: DispatchMouseEvent(OnMouseUp, Message);
  end;
end;

procedure THotMap.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  HandleBinaryProperty('MouseCursor_Data', Filer, 13);
  HandleProperty('MyTag', Filer, 14);
  HandleProperty('MyTagMsg', Filer, 19);
  HandleBinaryProperty('NumOfRgns', Filer, 21);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    THotMap]);
end;

end.
