//--------------------------------------------------------------------------
// Api.c
//---------------------------------------------------------------------------
// Griglia Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>
#include <string.h>

#include "vbapi.h"
#include "griglia.h"

//---------------------------------------------------------------------------
// RepaintGriglia
//---------------------------------------------------------------------------
VOID _export RepaintGriglia (HWND hWnd) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        InvalidateRect (lpGrigliaStruct->hWndStatic, NULL, TRUE);        

    }
}

//---------------------------------------------------------------------------
// GetGrigliaProperty
//---------------------------------------------------------------------------
BOOL _export GetGrigliaProperty (HWND	hWnd,
                                 USHORT nProp,                                 
                                 LPVOID lpData) {                     

    HCTL hctlLocal;

    if (hctlLocal = VBGetHwndControl (hWnd)) {
    switch (nProp) {
        case    IPROP_GRIGLIA_ROWS:
        case    IPROP_GRIGLIA_COLS:
        case    IPROP_GRIGLIA_FIXEDROWS:
        case    IPROP_GRIGLIA_FIXEDCOLS:
        case    IPROP_GRIGLIA_ROW:
        case    IPROP_GRIGLIA_COL:
        case    IPROP_GRIGLIA_ROWHEIGHT:
        case    IPROP_GRIGLIA_COLWIDTH:
        case    IPROP_GRIGLIA_TOPROW:
        case    IPROP_GRIGLIA_LEFTCOL:
        case    IPROP_GRIGLIA_CURSORROW:
        case    IPROP_GRIGLIA_CURSORCOL:
        case    IPROP_GRIGLIA_TEXT:
        case    IPROP_GRIGLIA_CLIP:
        case    IPROP_GRIGLIA_SELSTARTROW:
        case    IPROP_GRIGLIA_SELENDROW:
        case    IPROP_GRIGLIA_SELSTARTCOL:
        case    IPROP_GRIGLIA_SELENDCOL:
            return (VBGetControlProperty (hctlLocal, nProp, lpData) == 0);    
        }    
    }
    return (FALSE);    
}

//---------------------------------------------------------------------------
// SetGrigliaProperty
//---------------------------------------------------------------------------
BOOL _export SetGrigliaProperty (HWND	hWnd,
                                 USHORT nProp,
                                 LONG   lData) {

    HCTL hctlLocal;

    if (hctlLocal = VBGetHwndControl (hWnd)) {
        switch (nProp) {
            case    IPROP_GRIGLIA_ROWS:
            case    IPROP_GRIGLIA_COLS:
            case    IPROP_GRIGLIA_FIXEDROWS:
            case    IPROP_GRIGLIA_FIXEDCOLS:
            case    IPROP_GRIGLIA_ROW:
            case    IPROP_GRIGLIA_COL:
            case    IPROP_GRIGLIA_ROWHEIGHT:
            case    IPROP_GRIGLIA_COLWIDTH:
            case    IPROP_GRIGLIA_TOPROW:
            case    IPROP_GRIGLIA_LEFTCOL:
            case    IPROP_GRIGLIA_CURSORROW:
            case    IPROP_GRIGLIA_CURSORCOL:
            case    IPROP_GRIGLIA_TEXT:
            case    IPROP_GRIGLIA_CLIP:
            case    IPROP_GRIGLIA_SELSTARTROW:
            case    IPROP_GRIGLIA_SELENDROW:
            case    IPROP_GRIGLIA_SELSTARTCOL:
            case    IPROP_GRIGLIA_SELENDCOL:
                return (VBSetControlProperty (hctlLocal, nProp, lData) == 0);                
        }        
    }    
    return (FALSE);    
}

//---------------------------------------------------------------------------
// PutText
//---------------------------------------------------------------------------
BOOL _export PutText (HWND    hWnd,
                      WORD    wRow,                        
                      WORD    wCol,        
                      LPSTR   lpText) {            
    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        if (        
            (lpText) &&            
            (lstrlen (lpText))            
           )       
            return (PutCellText (lpGrigliaStruct,            
                                wRow,                                 
                                wCol,                 
                                lpText));                 
        return (TRUE);
    }
    return (FALSE);    
}

//---------------------------------------------------------------------------
// GetText
//---------------------------------------------------------------------------
LPSTR _export GetText (HWND    hWnd,
                       WORD    wRow,                        
                       WORD    wCol) {
    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        return (GetCellText (lpGrigliaStruct,        
                             wRow,                             
                             wCol));             
    }
    return (FALSE);    
}

//---------------------------------------------------------------------------
// InsertLines
//---------------------------------------------------------------------------
BOOL _export InsertLines (HWND    hWnd,
                          WORD    wRow,
                          WORD    wInsertRows) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        return (InsertLinesText (lpGrigliaStruct,        
                                  wRow,                                 
                                  wInsertRows));                 
    }
    return (FALSE);    

}

//---------------------------------------------------------------------------
// DeleteLines
//---------------------------------------------------------------------------
BOOL _export DeleteLines (HWND    hWnd,
                          WORD    wRow,                        
                          WORD    wDeleteRows) {                

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        return (DeleteLinesText (lpGrigliaStruct,        
                                 wRow,                             
                                 wDeleteRows));                 
    }
    return (FALSE);    

}

//---------------------------------------------------------------------------
// FindLine
//---------------------------------------------------------------------------
BOOL _export FindLine (	HWND 		hWnd,
                        LPFINDTEXT      lpFind) {

    HCTL hctlLocal;

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        return (FindText (lpGrigliaStruct,        
                          lpFind));      
    }
    return (0xffff);    

}

//---------------------------------------------------------------------------
// EraseLines
//---------------------------------------------------------------------------
void _export EraseGrid (HWND hWnd) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        
        
        ClearText (lpGrigliaStruct);
    }
}

//---------------------------------------------------------------------------
// SelColSize in CHARS
//---------------------------------------------------------------------------
void _export SetColSize (HWND hWnd,
                         UINT nCol,
                         UINT nColSize) {

    UINT nColSizeTwips;

    if (SetGrigliaProperty (hWnd,
                            IPROP_GRIGLIA_COL,
                            MAKELONG (nCol, 0))) {     
        
        nColSizeTwips = (WORD)VBYPixelsToTwips (nColSize);
        SetGrigliaProperty (hWnd,
                            IPROP_GRIGLIA_COLWIDTH,
                            MAKELONG (nColSizeTwips, 0));
    
    }                        
}

//---------------------------------------------------------------------------
// SortLine
//---------------------------------------------------------------------------
BOOL _export SortLine ( HWND            hWnd,
                        LPFINDTEXT      lpFind) {

    HCTL hctlLocal;

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        SortText (lpGrigliaStruct,        
                  lpFind);      
        return (TRUE);
    }
    return (0xffff);    

}

//---------------------------------------------------------------------------
// InsertCells
//---------------------------------------------------------------------------
void _export InsertCells (HWND    hWnd,
                          WORD    wRow,
                          WORD    wCol,
                          WORD    wInsertCells) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        InsertCellsText (lpGrigliaStruct,        
                         wRow,                                 
                         wCol,                              
                         wInsertCells);
    }
}

//---------------------------------------------------------------------------
// InsertLineBreak
//---------------------------------------------------------------------------
void _export InsertLineBreak (HWND    hWnd,
                              WORD    wRow,
                              WORD    wCol) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        LineBreakText (lpGrigliaStruct,
                       wRow,
                       wCol);
    }
}

//---------------------------------------------------------------------------
// DeleteCells
//---------------------------------------------------------------------------
void _export DeleteCells (HWND    hWnd,
                          WORD    wRow,
                          WORD    wCol,
                          WORD    wDeleteCells) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        DeleteCellsText (lpGrigliaStruct,
                         wRow,                                 
                         wCol,                              
                         wDeleteCells);
    }
}

//---------------------------------------------------------------------------
// DeleteLineBreak
//---------------------------------------------------------------------------
void _export DeleteLineBreak (HWND    hWnd,
                              WORD    wRow,
                              WORD    wCol) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        RemoveLineBreakText (lpGrigliaStruct,
                             wRow,
                             wCol);
    }
}

//---------------------------------------------------------------------------
// MoveWordLeft
//---------------------------------------------------------------------------
void FAR PASCAL _export MoveWordLeft (HWND    hWnd,
                                      WORD    wRow,
                                      WORD    wCol) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        MoveWordTextLeft (lpGrigliaStruct,
                          wRow,
                          wCol);
    }
}

//---------------------------------------------------------------------------
// MoveWordRight
//---------------------------------------------------------------------------
void FAR PASCAL _export MoveWordRight (HWND    hWnd,
                                       WORD    wRow,
                                       WORD    wCol) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        MoveWordTextRight (lpGrigliaStruct,
                           wRow,
                           wCol);
    }
}

//---------------------------------------------------------------------------
// ShiftWordLeft
//---------------------------------------------------------------------------
void FAR PASCAL _export ShiftWordLeft (HWND    hWnd,
                                       WORD    wRow,
                                       WORD    wCol) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        ShiftWordTextLeft (lpGrigliaStruct,
                           wRow,
                           wCol);
    }
}

//---------------------------------------------------------------------------
// ShiftWordRight
//---------------------------------------------------------------------------
void FAR PASCAL _export ShiftWordRight (HWND    hWnd,
                                        WORD    wRow,
                                        WORD    wCol) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        ShiftWordTextRight (lpGrigliaStruct,
                            wRow,
                            wCol);
    }
}

//----------------------------------------------------------------------------
// ADJUST COLUMN SIZES
//----------------------------------------------------------------------------
void FAR PASCAL _export AdjustColumnSizes (HWND hWnd) {
                                    
    static ULONG    lRows;    
    static ULONG    lCols;    
    static ULONG    lFixedRows;    
    static ULONG    lFixedCols;    
    LPSTR  lpText;    
    UINT   n, m, nLength, xChar;                                
    HDC    hDC;
    HCTL   hctlLocal;    
    
    // Get # of rows and cols    
    GetGrigliaProperty (hWnd,    
                        (USHORT)IPROP_GRIGLIA_ROWS,
                        (LPVOID)&lRows);
    GetGrigliaProperty (hWnd,    
                        (USHORT)IPROP_GRIGLIA_COLS,
                        (LPVOID)&lCols);
    GetGrigliaProperty (hWnd,    
                        (USHORT)IPROP_GRIGLIA_FIXEDROWS,
                        (LPVOID)&lFixedRows);
    GetGrigliaProperty (hWnd,    
                        (USHORT)IPROP_GRIGLIA_FIXEDCOLS,
                        (LPVOID)&lFixedCols);

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        if (hDC = GetDC (hWnd)) {
            static TEXTMETRIC  sTextMetrics;                
            HFONT  hOldFont;
        
            hOldFont = SelectObject (hDC, lpGrigliaStruct->hFont);
            GetTextMetrics (hDC, (LPTEXTMETRIC) &sTextMetrics);            
            xChar = (sTextMetrics.tmAveCharWidth + 
                     sTextMetrics.tmMaxCharWidth) / 2;
            if (hOldFont)
                SelectObject (hDC, hOldFont);
            ReleaseDC (hWnd, hDC);            
        
            for (n = LOWORD (lFixedCols); n < LOWORD (lCols); ++n) {
                nLength = 0;
                if (lpText = GetText (hWnd, 0, n))    
                    nLength = max (nLength, _fstrlen (lpText));       
                for (m = LOWORD (lFixedRows); m < LOWORD (lRows); ++m) {
                    if (lpText = GetText (hWnd, m, n))
                        nLength = max (nLength, _fstrlen (lpText));   
                }    
                SetColSize (hWnd, n, (UINT) (xChar * nLength + 5));
            }          
        }    
    }        
} 

//----------------------------------------------------------------------------
// GetBlockSize
//----------------------------------------------------------------------------
UINT FAR PASCAL _export GetBlockSize (HWND hWnd,
                                      WORD wTop,
                                      WORD wLeft,
                                      WORD wBottom,
                                      WORD wRight) {
                                    
    LPSTR  lpText;    
    UINT   n, m, nLength, nTotLength;                                
    
    nTotLength = 0;
    for (n = wLeft; n <= wRight; ++n) {
        nLength = 0;    
        for (m = wTop; m <= wBottom; ++m) {
            if (lpText = GetText (hWnd, m, n)) {
                nLength = max (nLength, _fstrlen (lpText));
            }
        }          
        nTotLength += nLength;
        if (n != wRight)
            ++nTotLength;    
    }                 
    
    return (nTotLength);       
} 

//----------------------------------------------------------------------------
// CJust            
//----------------------------------------------------------------------------
void FAR PASCAL _export CJust (HWND hWnd,
                               WORD wTop,
                               WORD wLeft,
                               WORD wBottom,
                               WORD wRight) {

    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        Just (lpGrigliaStruct, wTop, wLeft, wBottom, wRight, CENTER_JUST);
    }
}

//----------------------------------------------------------------------------
// LJust            
//----------------------------------------------------------------------------
void FAR PASCAL _export LJust (HWND hWnd,
                               WORD wTop,
                               WORD wLeft,
                               WORD wBottom,
                               WORD wRight) {
                               
    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        Just (lpGrigliaStruct, wTop, wLeft, wBottom, wRight, LEFT_JUST);
    }
}

//----------------------------------------------------------------------------
// RJust            
//----------------------------------------------------------------------------
void FAR PASCAL _export RJust (HWND hWnd,
                               WORD wTop,
                               WORD wLeft,
                               WORD wBottom,
                               WORD wRight) {
                               
    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        Just (lpGrigliaStruct, wTop, wLeft, wBottom, wRight, RIGHT_JUST);
    }
}

//----------------------------------------------------------------------------
// IsBlockEmpty
//----------------------------------------------------------------------------
BOOL FAR PASCAL _export IsBlockEmpty (HWND hWnd,
                                      WORD wTop,
                                      WORD wLeft,
                                      WORD wBottom,
                                      WORD wRight) {
                                    
    LPSTR  lpText;    
    UINT   n, m;
    
    for (n = wLeft; n <= wRight; ++n) {
        for (m = wTop; m <= wBottom; ++m) {
            if (
                (lpText = GetText (hWnd, m, n)) &&
                (_fstrlen (lpText))
               ) {

                // remove initial blanks
                while (
                       (*lpText)        &&
                       (*lpText == ' ')
                      )
                    ++lpText;

                // anything left ?
                if (
                    (*lpText) &&
                    (_fstrlen (lpText))
                   )
                    return (FALSE);
            }
        }          
    }                 
    
    return (TRUE);
} 

//---------------------------------------------------------------------------
// PutText_Ext
//---------------------------------------------------------------------------
BOOL _export PutText_Ext (HWND        hWnd,
                          WORD        wRow,
                          WORD        wCol,
                          LPEXT_INPUT lpExt,
                          LPSTR       lpText) {
    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        if (        
            (lpText) &&            
            (lpExt)  &&
            (_fstrlen (lpText))
           )
            return (PutCellText_Ext (lpGrigliaStruct,
                                     wRow,
                                     wCol,
                                     lpExt,
                                     lpText));
    }
    return (FALSE);    
}

//---------------------------------------------------------------------------
// GetText_Ext
//---------------------------------------------------------------------------
LPSTR _export GetText_Ext (HWND        hWnd,
                           WORD        wRow,
                           WORD        wCol,
                           LPEXT_INPUT lpExt) {
    HCTL hctlLocal;    

    if (hctlLocal = VBGetHwndControl (hWnd)) {

        PGRIGLIA lpGrigliaStruct = GRIGLIADEREF(hctlLocal);        

        return (GetCellText_Ext (lpGrigliaStruct,
                                 wRow,
                                 wCol,
                                 lpExt));
    }
    return (FALSE);    
}
