//---------------------------------------------------------------------------
// Cursor.c
//---------------------------------------------------------------------------
// Griglia Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "vbapi.h"
#include "griglia.h"

static BOOL 		PaintCursorLocal 				(PGRIGLIA, HDC);
static SHORT NEAR	ReturnIncrement					(PGRIGLIA, WORD);
BOOL LBlockButtonDown (PGRIGLIA, POINT);

//---------------------------------------------------------------------------
// ResetRow
//---------------------------------------------------------------------------
BOOL ResetRow (PGRIGLIA lpGrigliaStruct,
               WORD     wRow) {

    RECT  rStatic;    
    BOOL  bRet = FALSE;    

    GetClientRect (lpGrigliaStruct->hWndStatic,     (LPRECT)&rStatic);    

    // Reset Scroll to view current line    
    if (lpGrigliaStruct->wTopRow > wRow) {    
        Griglia_VScroll (lpGrigliaStruct,        
                          SB_THUMBTRACK,                         
                          MAKELONG (wRow                                            -                     
                                    lpGrigliaStruct->wTopRow    +                               
                                    lpGrigliaStruct->nVScrollPos,0)                               
                                   );            
        bRet = TRUE;        
    } else {    

        LONG  lScroll;    
        SHORT nGap;    

        lScroll = Griglia_VertPos (wRow, lpGrigliaStruct);        
        nGap    = LOWORD (PUSH_V_GRID + lScroll) - (WORD)rStatic.bottom;        
        if ((lScroll != INVALID_POS) && (nGap > 0)) {        
            Griglia_VScroll (lpGrigliaStruct,            
                             SB_THUMBTRACK,                            
                             MAKELONG (wRow                                            -                            
                                       lpGrigliaStruct->wTopRow    +                                      
                                       lpGrigliaStruct->nVScrollPos, 0));                                    
            bRet = TRUE;            
        }        
    }    
    return (bRet);    
}

//---------------------------------------------------------------------------
// ResetCol
//---------------------------------------------------------------------------
BOOL ResetCol (PGRIGLIA lpGrigliaStruct,
               WORD     wCol) {

    RECT  rStatic;
    BOOL  bRet = FALSE;

    GetClientRect (lpGrigliaStruct->hWndStatic, (LPRECT)&rStatic);

    // Reset Scroll to view current column
    if (lpGrigliaStruct->wLeftCol > wCol) {
        Griglia_HScroll (lpGrigliaStruct,
                         SB_THUMBTRACK,
                         MAKELONG (wCol                         -
                                   lpGrigliaStruct->wLeftCol    +
                                   lpGrigliaStruct->nHScrollPos, 0)
                                   );
        bRet = TRUE;
    } else {

        LONG  lScroll;
        SHORT nGap;

        lScroll = Griglia_HorPos (wCol, lpGrigliaStruct);
        nGap    = LOWORD (PUSH_H_GRID + lScroll) - (WORD)rStatic.right;
        if ((lScroll != INVALID_POS) && (nGap > 0)) {
            Griglia_HScroll (lpGrigliaStruct,
                            SB_THUMBTRACK,
                            MAKELONG (wCol                        -
                                      lpGrigliaStruct->wLeftCol   +
                                      lpGrigliaStruct->nHScrollPos, 0));
            bRet = TRUE;
        }
    }

    return (bRet);
}

//---------------------------------------------------------------------------
// ReturnIncrement
//---------------------------------------------------------------------------
static SHORT NEAR ReturnIncrement ( PGRIGLIA lpGrigliaStruct,
                                    WORD     wDirection) {

    RECT  rStatic;
    SHORT nGap;
    LONG  lScroll;

    GetClientRect (lpGrigliaStruct->hWndStatic,
                               (LPRECT)&rStatic);

    switch (wDirection) {

        case VK_DOWN:
            // Get Next Cell Position
            lScroll = Griglia_VertPos (lpGrigliaStruct->wCursorRow + 1,
                                       lpGrigliaStruct);
            nGap    = LOWORD (PUSH_V_GRID + lScroll) - (WORD)rStatic.bottom;

            // If it exceeds grid compute incr
            if (
                (lScroll != INVALID_POS) &&
                (nGap > 0)
               ) {
                int     n;
                WORD    wSize = 0;

                for (n = lpGrigliaStruct->wTopRow;
                     n < (SHORT)lpGrigliaStruct->wRows;
                     ++n) {

                    wSize += ((lpGrigliaStruct->lpHorBars + n)->wSize +
                              lpGrigliaStruct->yChar / INTERCOLUMN_FACTOR);
                    if ((SHORT)wSize >= nGap)
                        return (n + 1 - lpGrigliaStruct->wTopRow);
                }
            }
            break;

        case VK_RIGHT:
            // Get Next Cell Position
            lScroll = Griglia_HorPos (lpGrigliaStruct->wCursorCol + 1,
                                      lpGrigliaStruct);
            if (lScroll == INVALID_POS)
                break;

            nGap = LOWORD (PUSH_H_GRID + lScroll) - (WORD) rStatic.right;
            // If it exceeds grid compute incr
            if (nGap > 0) {

                int     n;
                LONG    lSize;

                for (n = lpGrigliaStruct->wLeftCol + 1;
                     n < (SHORT)lpGrigliaStruct->wCols;
                     ++n) {

                    lSize = (lpGrigliaStruct->lpVertBars + n)->lPos -
                            (lpGrigliaStruct->lpVertBars +
                             lpGrigliaStruct->wLeftCol)->lPos;
                    if (LOWORD (lSize) >= (WORD)nGap)
                        return (n - lpGrigliaStruct->wLeftCol);
                }
            }
            break;
    }

    return (NULL);
}

//---------------------------------------------------------------------------
// MoveCursorLeft
//---------------------------------------------------------------------------
BOOL MoveCursorLeft (PGRIGLIA lpGrigliaStruct) {

    if (bShiftPressed) {

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		// Set Selection to Cursor
		if (bCtrlPressed)
			lpGrigliaStruct->wSelEndCol = max (lpGrigliaStruct->wSelStartCol,
			 								   lpGrigliaStruct->wSelEndCol - 1);
		else
			lpGrigliaStruct->wSelStartCol = max (lpGrigliaStruct->wFixedCols,
			 								     lpGrigliaStruct->wSelStartCol - 1);

		// Remove Selection
		PaintBlock (lpGrigliaStruct);
		return (TRUE);

    } else {

		if (lpGrigliaStruct->wCursorCol > lpGrigliaStruct->wFixedCols) {

			// Reset Scroll to view current col
			ResetRow (lpGrigliaStruct,
  		  	      	lpGrigliaStruct->wCursorRow);

			if (!ResetCol (lpGrigliaStruct,
  		  	      	   	lpGrigliaStruct->wCursorCol - 1)) {

				if (lpGrigliaStruct->wCursorCol <=
			    	(lpGrigliaStruct->wFixedCols +
		     		lpGrigliaStruct->nHScrollPos))
					Griglia_HScroll (lpGrigliaStruct, SB_LINEUP, (LONG)NULL);

			}

			// Remove Selection
			PaintBlock (lpGrigliaStruct);

			PaintCursor (lpGrigliaStruct);
			--lpGrigliaStruct->wCursorCol;
			lpGrigliaStruct->wCol = lpGrigliaStruct->wCursorCol;
			PaintCursor (lpGrigliaStruct);
			SetEditText (lpGrigliaStruct,
					 	lpGrigliaStruct->wCursorRow,
					 	lpGrigliaStruct->wCursorCol);

			// Set Selection to Cursor
			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelStartCol =
						lpGrigliaStruct->wCursorCol;
			lpGrigliaStruct->wSelEndCol =
						lpGrigliaStruct->wCursorCol;

		}
		return (TRUE);
    }
    return (FALSE);
}

//---------------------------------------------------------------------------
// MoveCursorRight
//---------------------------------------------------------------------------
BOOL MoveCursorRight (PGRIGLIA lpGrigliaStruct) {

    if (bShiftPressed) {

        // Remove Selection
        PaintBlock (lpGrigliaStruct);

        // Set Selection to Cursor
        if (bCtrlPressed)
            lpGrigliaStruct->wSelStartCol = min (lpGrigliaStruct->wSelEndCol,
                                                 lpGrigliaStruct->wSelStartCol + 1);
        else {
            lpGrigliaStruct->wSelEndCol = min (lpGrigliaStruct->wCols - 1,
                                               lpGrigliaStruct->wSelEndCol + 1);
        }
        // Remove Selection
        PaintBlock (lpGrigliaStruct);
        return (TRUE);

    } else {

        if (lpGrigliaStruct->wCursorCol < (lpGrigliaStruct->wCols - 1)) {
            SHORT nIncr;

            // Reset Scroll to view current col
            ResetRow (lpGrigliaStruct,
                      lpGrigliaStruct->wCursorRow);

            // Scroll if necessary
            if (nIncr = ReturnIncrement (lpGrigliaStruct, VK_RIGHT))
                Griglia_HScroll (lpGrigliaStruct,
                                 SB_THUMBTRACK,
                                 MAKELONG (nIncr +
                                           lpGrigliaStruct->nHScrollPos, 0));
            ResetCol (lpGrigliaStruct,
                      lpGrigliaStruct->wCursorCol);

            // Remove Selection
            PaintBlock (lpGrigliaStruct);

            PaintCursor (lpGrigliaStruct);
            ++lpGrigliaStruct->wCursorCol;
            lpGrigliaStruct->wCol = lpGrigliaStruct->wCursorCol;
            PaintCursor (lpGrigliaStruct);
            SetEditText (lpGrigliaStruct,
                         lpGrigliaStruct->wCursorRow,
                         lpGrigliaStruct->wCursorCol);

            // Set Selection to Cursor
            lpGrigliaStruct->wSelStartRow =
                            lpGrigliaStruct->wCursorRow;
            lpGrigliaStruct->wSelEndRow =
                            lpGrigliaStruct->wCursorRow;
            lpGrigliaStruct->wSelStartCol =
                            lpGrigliaStruct->wCursorCol;
            lpGrigliaStruct->wSelEndCol =
                            lpGrigliaStruct->wCursorCol;

            return (TRUE);
    	}
    }
    return (FALSE);

}

//---------------------------------------------------------------------------
// MoveCursorUp
//---------------------------------------------------------------------------
BOOL MoveCursorUp (PGRIGLIA lpGrigliaStruct) {

    if (bShiftPressed) {

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		// Set Selection to Cursor
		if (bCtrlPressed)
			lpGrigliaStruct->wSelEndRow = max (lpGrigliaStruct->wSelStartRow,
			 								     lpGrigliaStruct->wSelEndRow - 1);
		else
			lpGrigliaStruct->wSelStartRow = max (lpGrigliaStruct->wFixedRows,
										     	lpGrigliaStruct->wSelStartRow - 1);

		// Remove Selection
		PaintBlock (lpGrigliaStruct);
		return (TRUE);

    } else {

		if (lpGrigliaStruct->wCursorRow > lpGrigliaStruct->wFixedRows) {

			// Reset Scroll to view current line
			ResetCol (lpGrigliaStruct,
  		  	      	lpGrigliaStruct->wCursorCol);

			if (!ResetRow (lpGrigliaStruct,
			           	lpGrigliaStruct->wCursorRow - 1)) {

				// See if further scroll is necessary
				if (lpGrigliaStruct->wCursorRow <=
				    (lpGrigliaStruct->wFixedRows +
		     		lpGrigliaStruct->nVScrollPos))
					Griglia_VScroll (lpGrigliaStruct, SB_LINEUP, (LONG)NULL);
			}

			// Remove Selection
			PaintBlock (lpGrigliaStruct);

			PaintCursor (lpGrigliaStruct);
			--lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wRow = lpGrigliaStruct->wCursorRow;
			PaintCursor (lpGrigliaStruct);
			SetEditText (lpGrigliaStruct,
					 	lpGrigliaStruct->wCursorRow,
					 	lpGrigliaStruct->wCursorCol);

			// Set Selection to Cursor
			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelStartCol =
						lpGrigliaStruct->wCursorCol;
			lpGrigliaStruct->wSelEndCol =
						lpGrigliaStruct->wCursorCol;

			return (TRUE);
    	}
    }
    return (FALSE);
}

//---------------------------------------------------------------------------
// MoveCursorDown
//---------------------------------------------------------------------------
BOOL MoveCursorDown (PGRIGLIA lpGrigliaStruct) {


    if (bShiftPressed) {

        // Remove Selection
        PaintBlock (lpGrigliaStruct);

        // Set Selection to Cursor
        if (bCtrlPressed)
                lpGrigliaStruct->wSelStartRow = min (lpGrigliaStruct->wSelEndRow,
                                                                                   lpGrigliaStruct->wSelStartRow + 1);
        else
                lpGrigliaStruct->wSelEndRow = min (lpGrigliaStruct->wRows - 1,
                                                                                   lpGrigliaStruct->wSelEndRow + 1);

        // Remove Selection
        PaintBlock (lpGrigliaStruct);
        return (TRUE);

    } else {

        // See if further scroll is necessary
        if (lpGrigliaStruct->wCursorRow < (lpGrigliaStruct->wRows - 1)) {
                SHORT nIncr;

            // Reset Scroll to view current line
            ResetCol (lpGrigliaStruct,
                      lpGrigliaStruct->wCursorCol);
            // Scroll if necessary
            if (nIncr = ReturnIncrement (lpGrigliaStruct, VK_DOWN))
                Griglia_VScroll (lpGrigliaStruct,
                                SB_THUMBTRACK,
                                MAKELONG (nIncr +
                                          lpGrigliaStruct->nVScrollPos, 0));
            ResetRow (lpGrigliaStruct,
                      lpGrigliaStruct->wCursorRow);

            // Remove Selection
            PaintBlock (lpGrigliaStruct);

            PaintCursor (lpGrigliaStruct);
            ++lpGrigliaStruct->wCursorRow;
            lpGrigliaStruct->wRow = lpGrigliaStruct->wCursorRow;
            PaintCursor (lpGrigliaStruct);
            SetEditText (lpGrigliaStruct,
                                    lpGrigliaStruct->wCursorRow,
                                    lpGrigliaStruct->wCursorCol);

            // Set Selection to Cursor
            lpGrigliaStruct->wSelStartRow =
                                    lpGrigliaStruct->wCursorRow;
            lpGrigliaStruct->wSelEndRow =
                                    lpGrigliaStruct->wCursorRow;
            lpGrigliaStruct->wSelStartCol =
                                    lpGrigliaStruct->wCursorCol;
            lpGrigliaStruct->wSelEndCol =
                                    lpGrigliaStruct->wCursorCol;

            return (TRUE);
        }
    }
    return (FALSE);

}

//---------------------------------------------------------------------------
// MoveCursorHome
//---------------------------------------------------------------------------
BOOL MoveCursorHome (PGRIGLIA lpGrigliaStruct,
					 BOOL     bCtrlPressed) {

    if (bShiftPressed) {

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		// Set Selection to Cursor
		if (bCtrlPressed) {
			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wFixedRows;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wCursorRow;
		} else {
			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wCursorRow;
		}
		lpGrigliaStruct->wSelStartCol =
					lpGrigliaStruct->wFixedCols;
		lpGrigliaStruct->wSelEndCol =
					lpGrigliaStruct->wCursorCol;

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

    } else {

		// Scroll if necessary
		Griglia_HScroll (lpGrigliaStruct, SB_TOP, (LONG)NULL);
		if (bCtrlPressed)
				Griglia_VScroll (lpGrigliaStruct, SB_TOP, (LONG)NULL);

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		PaintCursor (lpGrigliaStruct);
		if (bCtrlPressed) {
			lpGrigliaStruct->wCursorRow = lpGrigliaStruct->wFixedRows;
			lpGrigliaStruct->wRow       = lpGrigliaStruct->wCursorRow;
		}
		lpGrigliaStruct->wCursorCol = lpGrigliaStruct->wFixedCols;
		lpGrigliaStruct->wCol       = lpGrigliaStruct->wCursorCol;
		PaintCursor (lpGrigliaStruct);
		SetEditText (lpGrigliaStruct,
				 	lpGrigliaStruct->wCursorRow,
				 	lpGrigliaStruct->wCursorCol);

		// Set Selection to Cursor
		lpGrigliaStruct->wSelStartRow =
					lpGrigliaStruct->wCursorRow;
		lpGrigliaStruct->wSelEndRow =
					lpGrigliaStruct->wCursorRow;
		lpGrigliaStruct->wSelStartCol =
					lpGrigliaStruct->wCursorCol;
		lpGrigliaStruct->wSelEndCol =
					lpGrigliaStruct->wCursorCol;
	}
	return (TRUE);

}

//---------------------------------------------------------------------------
// MoveCursorEnd
//---------------------------------------------------------------------------
BOOL MoveCursorEnd (PGRIGLIA lpGrigliaStruct,
					BOOL	 bCtrlPressed) {

    if (bShiftPressed) {

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		// Set Selection to Cursor
		if (bCtrlPressed) {
			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wRows - 1;
		} else {
			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wCursorRow;
		}
		lpGrigliaStruct->wSelStartCol =
					lpGrigliaStruct->wCursorCol;
		lpGrigliaStruct->wSelEndCol =
					lpGrigliaStruct->wCols - 1;

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

    } else {

		// Scroll if necessary
		Griglia_HScroll (lpGrigliaStruct, SB_BOTTOM, (LONG)NULL);

		if (bCtrlPressed)
			Griglia_VScroll (lpGrigliaStruct, SB_BOTTOM, (LONG)NULL);

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		PaintCursor (lpGrigliaStruct);
		if (bCtrlPressed) {
			lpGrigliaStruct->wCursorRow = lpGrigliaStruct->wRows - 1;
			lpGrigliaStruct->wRow       = lpGrigliaStruct->wCursorRow;
		}
		lpGrigliaStruct->wCursorCol = lpGrigliaStruct->wCols - 1;
		lpGrigliaStruct->wCol       = lpGrigliaStruct->wCursorCol;
		PaintCursor (lpGrigliaStruct);
		SetEditText (lpGrigliaStruct,
				 	lpGrigliaStruct->wCursorRow,
				 	lpGrigliaStruct->wCursorCol);

		// Set Selection to Cursor
		lpGrigliaStruct->wSelStartRow =
					lpGrigliaStruct->wCursorRow;
		lpGrigliaStruct->wSelEndRow =
					lpGrigliaStruct->wCursorRow;
		lpGrigliaStruct->wSelStartCol =
					lpGrigliaStruct->wCursorCol;
		lpGrigliaStruct->wSelEndCol =
					lpGrigliaStruct->wCursorCol;
		return (TRUE);
    }
}

//---------------------------------------------------------------------------
// MoveCursorPrior
//---------------------------------------------------------------------------
BOOL MoveCursorPrior (PGRIGLIA lpGrigliaStruct,
					  BOOL     bCtrlPressed) {

    if (bShiftPressed) {

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		// Set Selection to Cursor
		if (bCtrlPressed) {
			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wFixedRows;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wCursorRow;
		} else {
			int nPos,
				nIncr,
				newPos;

    		nPos  = (lpGrigliaStruct->wCursorRow - lpGrigliaStruct->wFixedRows);

			// Compute increment to align on page border
			nIncr = nPos % lpGrigliaStruct->nVScrollInc;
			if ((nPos) && (!nIncr))
				nIncr = lpGrigliaStruct->nVScrollInc;

			newPos = max (lpGrigliaStruct->wFixedRows,
			      		lpGrigliaStruct->wCursorRow - nIncr);

			lpGrigliaStruct->wSelStartRow = newPos;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wCursorRow;
		}
		lpGrigliaStruct->wSelStartCol =
					lpGrigliaStruct->wCursorCol;
		lpGrigliaStruct->wSelEndCol =
					lpGrigliaStruct->wCursorCol;

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

    } else {

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		if (bCtrlPressed) {

			Griglia_VScroll (lpGrigliaStruct, SB_TOP, (LONG)NULL);
			PaintCursor (lpGrigliaStruct);
			lpGrigliaStruct->wCursorRow = lpGrigliaStruct->wFixedRows;
			lpGrigliaStruct->wRow 		= lpGrigliaStruct->wCursorRow;
			PaintCursor (lpGrigliaStruct);

		} else {
			int nPos,
				nIncr,
				newPos;

			// Distance from fixed rows
    		nPos  = (lpGrigliaStruct->wCursorRow - lpGrigliaStruct->wFixedRows);

			// Compute increment to align on page border
			nIncr = nPos % lpGrigliaStruct->nVScrollInc;
			if ((nPos) && (!nIncr))
				nIncr = lpGrigliaStruct->nVScrollInc;

			newPos = max (lpGrigliaStruct->wFixedRows,
			      		lpGrigliaStruct->wCursorRow - nIncr);
			if (newPos < (SHORT)lpGrigliaStruct->wTopRow)
				Griglia_VScroll (lpGrigliaStruct,
						 		SB_THUMBTRACK,
						 		MAKELONG (lpGrigliaStruct->nVScrollPos -
						 		   		nIncr, 0));

			PaintCursor (lpGrigliaStruct);
			lpGrigliaStruct->wCursorRow = newPos;
			lpGrigliaStruct->wRow 		= lpGrigliaStruct->wCursorRow;
			PaintCursor (lpGrigliaStruct);
		}
		SetEditText (lpGrigliaStruct,
				 	lpGrigliaStruct->wCursorRow,
				 	lpGrigliaStruct->wCursorCol);

		// Set Selection to Cursor
		lpGrigliaStruct->wSelStartRow =
					lpGrigliaStruct->wCursorRow;
		lpGrigliaStruct->wSelEndRow =
					lpGrigliaStruct->wCursorRow;
		lpGrigliaStruct->wSelStartCol =
					lpGrigliaStruct->wCursorCol;
		lpGrigliaStruct->wSelEndCol =
					lpGrigliaStruct->wCursorCol;
	}
	return (TRUE);

}

//---------------------------------------------------------------------------
// MoveCursorNext
//---------------------------------------------------------------------------
BOOL MoveCursorNext (PGRIGLIA lpGrigliaStruct,
					 BOOL     bCtrlPressed) {

    if (bShiftPressed) {

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		// Set Selection to Cursor
		if (bCtrlPressed) {
			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelEndRow =
						lpGrigliaStruct->wRows - 1;
		} else {
			int nPos,
				nIncr,
				newPos;

			// Distance from fixed rows
    		nPos  = (lpGrigliaStruct->wCursorRow + 1		-
		     		lpGrigliaStruct->wFixedRows);

			// Compute increment to align on page border
			nIncr = lpGrigliaStruct->nVScrollInc -
					nPos % lpGrigliaStruct->nVScrollInc;
			if ((nPos) && (!nIncr))
				nIncr = lpGrigliaStruct->nVScrollInc;

			newPos = min (lpGrigliaStruct->wRows - 1,
				      	lpGrigliaStruct->wCursorRow + nIncr);

			lpGrigliaStruct->wSelStartRow =
						lpGrigliaStruct->wCursorRow;
			lpGrigliaStruct->wSelEndRow = newPos;
		}
		lpGrigliaStruct->wSelStartCol =
					lpGrigliaStruct->wCursorCol;
		lpGrigliaStruct->wSelEndCol =
					lpGrigliaStruct->wCursorCol;

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

    } else {

		// Remove Selection
		PaintBlock (lpGrigliaStruct);

		if (bCtrlPressed) {

			Griglia_VScroll (lpGrigliaStruct, SB_BOTTOM, (LONG)NULL);
			PaintCursor (lpGrigliaStruct);
			lpGrigliaStruct->wCursorRow = lpGrigliaStruct->wRows - 1;
			lpGrigliaStruct->wRow 		= lpGrigliaStruct->wCursorRow;
			PaintCursor (lpGrigliaStruct);

		} else {

			int nPos,
				nIncr,
				newPos;

			// Distance from fixed rows
    		nPos  = (lpGrigliaStruct->wCursorRow + 1		-
		     		lpGrigliaStruct->wFixedRows);

			// Compute increment to align on page border
			nIncr = lpGrigliaStruct->nVScrollInc -
					nPos % lpGrigliaStruct->nVScrollInc;
			if ((nPos) && (!nIncr))
				nIncr = lpGrigliaStruct->nVScrollInc;

			newPos = min (lpGrigliaStruct->wRows - 1,
				      	lpGrigliaStruct->wCursorRow + nIncr);
			Griglia_VScroll (lpGrigliaStruct,
					 		SB_THUMBTRACK,
					 		MAKELONG (lpGrigliaStruct->nVScrollPos +
					 		   		nIncr, 0));

			PaintCursor (lpGrigliaStruct);
			lpGrigliaStruct->wCursorRow = newPos;
			lpGrigliaStruct->wRow 		= lpGrigliaStruct->wCursorRow;
			PaintCursor (lpGrigliaStruct);

		}
		SetEditText (lpGrigliaStruct,
					 lpGrigliaStruct->wCursorRow,
					 lpGrigliaStruct->wCursorCol);

		// Set Selection to Cursor
		lpGrigliaStruct->wSelStartRow =
					lpGrigliaStruct->wCursorRow;
		lpGrigliaStruct->wSelEndRow =
					lpGrigliaStruct->wCursorRow;
		lpGrigliaStruct->wSelStartCol =
					lpGrigliaStruct->wCursorCol;
		lpGrigliaStruct->wSelEndCol =
					lpGrigliaStruct->wCursorCol;
	}
	return (TRUE);
}

//---------------------------------------------------------------------------
// LButtonDown
//---------------------------------------------------------------------------
void LButtonDown (PGRIGLIA lpGrigliaStruct,
                  POINT    pPoint) {

    static POINT pOut;
    static RECT  rRect;
           UINT  nCol, nRow;

    // Block Selection ?
    if (LBlockButtonDown (lpGrigliaStruct, pPoint))
    	return;

    if (FindCell (lpGrigliaStruct,
                  (LPPOINT)&pOut,
                  pPoint)) {    
                        
        nCol = pOut.x;
        nRow = pOut.y;
        
        // Remove Selection    
        PaintBlock (lpGrigliaStruct);    
        if (    
            (nCol != lpGrigliaStruct->wCursorCol) ||    
            (nRow != lpGrigliaStruct->wCursorRow)    
            ) {   
            PaintCursor (lpGrigliaStruct);        
            lpGrigliaStruct->wCursorCol = nCol;
            lpGrigliaStruct->wCursorRow = nRow;
            lpGrigliaStruct->wCol       = nCol;        
            lpGrigliaStruct->wRow       = nRow;        
            PaintCursor (lpGrigliaStruct);        
        }    
        SetEditText (lpGrigliaStruct,    
                    lpGrigliaStruct->wCursorRow,                 
                    lpGrigliaStruct->wCursorCol);                 
        
        // Set Selection to Cursor    
        lpGrigliaStruct->wSelStartRow =    
                        lpGrigliaStruct->wCursorRow;        
        lpGrigliaStruct->wSelEndRow =    
                        lpGrigliaStruct->wCursorRow;        
        lpGrigliaStruct->wSelStartCol =    
                        lpGrigliaStruct->wCursorCol;        
        lpGrigliaStruct->wSelEndCol =    
                        lpGrigliaStruct->wCursorCol;        
        return;    
    }   
}


//---------------------------------------------------------------------------
// Paint Block
//---------------------------------------------------------------------------
BOOL PaintBlockLocal (PGRIGLIA lpGrigliaStruct,
                      HDC      hDC) {                  

    RECT  rCursor, rBlock;
    HRGN  hBlockRgn  = 0, 
          hCursorRgn = 0;    

    // If single cell,  skip    
    if (    
        (lpGrigliaStruct->wSelStartCol == lpGrigliaStruct->wSelEndCol) &&        
        (lpGrigliaStruct->wSelStartRow == lpGrigliaStruct->wSelEndRow)        
       )   
        return (TRUE);   
    
    if (BlockRect ( lpGrigliaStruct,    
                    lpGrigliaStruct->wSelStartCol,   
                    lpGrigliaStruct->wSelEndCol,   
                    lpGrigliaStruct->wSelStartRow,   
                    lpGrigliaStruct->wSelEndRow,   
                    (LPRECT)&rBlock)) {   

        // paint block                
        ++rBlock.bottom;                        
        ++rBlock.right;                        

        hBlockRgn  = CreateRectRgn (rBlock.left,                                
                                    rBlock.top,                                                        
                                    rBlock.right,                                                            
                                    rBlock.bottom);                                                                

        if (hBlockRgn) {            
            if (CellRect (lpGrigliaStruct,        
                          lpGrigliaStruct->wCursorCol,          
                          lpGrigliaStruct->wCursorRow,          
                          (LPRECT)&rCursor)) {          
                                    
                hCursorRgn = CreateRectRgn (rCursor.left,                                
                                            rCursor.top,                                                                    
                                            rCursor.right,                                                            
                                            rCursor.bottom);                                                    
                if (hCursorRgn) {        
                    CombineRgn (hBlockRgn, hBlockRgn, hCursorRgn,                
                                RGN_DIFF);                
                    DeleteObject (hCursorRgn);                                
                }        
            }        
            InvertRgn (hDC, hBlockRgn);                
            DeleteObject (hBlockRgn);                                    
            return (TRUE);                            
        }                        
    }    
    return (FALSE);    

}

//---------------------------------------------------------------------------
// Paint Block
//---------------------------------------------------------------------------
BOOL PaintBlock (PGRIGLIA lpGrigliaStruct) {

    HDC   hDC;        
    BOOL  bRet;    

    // Get DC of Static Window
    if (    
        (lpGrigliaStruct->hWndStatic) &&        
        (hDC = GetDC (lpGrigliaStruct->hWndStatic))        
       ){       

        bRet = PaintBlockLocal (lpGrigliaStruct, hDC);        
        ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);        
        return (bRet);        

    }    
    return (FALSE);    

}

//---------------------------------------------------------------------------
// LBlockButtonDown
//---------------------------------------------------------------------------
BOOL LBlockButtonDown (PGRIGLIA lpGrigliaStruct,
                       POINT    pPoint) {       

           SHORT n, m;
           RECT  rStatic;  
    static RECT  rRect, rNewButton;

    GetClientRect (lpGrigliaStruct->hWndStatic,     (LPRECT)&rStatic);

    // Handle Vertical or Horizontal Block Selection
    if (
        (pPoint.x < PUSH_H_GRID) &&
        (pPoint.y < PUSH_V_GRID)
       ) {
        HDC hDC;

        if (        
            (lpGrigliaStruct->wSelStartRow != lpGrigliaStruct->wFixedRows) ||        
            (lpGrigliaStruct->wSelEndRow   != lpGrigliaStruct->wRows - 1)  ||    
            (lpGrigliaStruct->wSelStartCol != lpGrigliaStruct->wFixedCols) ||    
            (lpGrigliaStruct->wSelEndCol   != lpGrigliaStruct->wCols - 1)    
           ) {   

            PaintBlock (lpGrigliaStruct);

            // Paint and Move Cursor to Top Left Pos        
            if (        
                (lpGrigliaStruct->wFixedCols !=            
                        lpGrigliaStruct->wCursorCol) ||             
                (lpGrigliaStruct->wFixedRows !=            
                        lpGrigliaStruct->wCursorRow)     
               ) {       
                PaintCursor (lpGrigliaStruct);                
                lpGrigliaStruct->wCursorCol = lpGrigliaStruct->wFixedCols;            
                lpGrigliaStruct->wCursorRow = lpGrigliaStruct->wFixedRows;            
                lpGrigliaStruct->wCol       = lpGrigliaStruct->wFixedCols;            
                lpGrigliaStruct->wRow       = lpGrigliaStruct->wFixedRows;            
                PaintCursor (lpGrigliaStruct);            
            }        

            SetEditText (lpGrigliaStruct,        
                         lpGrigliaStruct->wCursorRow,                     
                         lpGrigliaStruct->wCursorCol);                     

            lpGrigliaStruct->wSelStartRow = lpGrigliaStruct->wFixedRows;        
            lpGrigliaStruct->wSelEndRow   = lpGrigliaStruct->wRows - 1;        
            lpGrigliaStruct->wSelStartCol = lpGrigliaStruct->wFixedCols;        
            lpGrigliaStruct->wSelEndCol   = lpGrigliaStruct->wCols - 1;        
            PaintBlock (lpGrigliaStruct);

        }

        rNewButton.left   = 1;
        rNewButton.top    = 1;
        rNewButton.right  = PUSH_H_GRID - 1;
        rNewButton.bottom = PUSH_V_GRID - 1;
        if (!EqualRect ((LPRECT)&rButton,
                        (LPRECT)&rNewButton)) {    
                    
            // Raise previous button if still down
            if (!IsRectEmpty ((LPRECT)&rButton))
                LButtonUp (lpGrigliaStruct, pPoint);
            hDC = GetDC (lpGrigliaStruct->hWndStatic);
            PaintButtonDown (hDC,
                            rNewButton.left,
                            rNewButton.top,
                            rNewButton.right,
                            rNewButton.bottom);
            ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);
            rButton = rNewButton;               
        
        }    
        
        return (TRUE);    

    } else if (pPoint.x < PUSH_H_GRID) {

        // Scan Rows    
        for (m = (lpGrigliaStruct->wFixedRows +
                  lpGrigliaStruct->nVScrollPos);      
             m < (SHORT)lpGrigliaStruct->wRows; 
             ++m) {    
        
            if (
                (CellTBRect (lpGrigliaStruct, m, (LPRECT)&rRect)) &&
                (rRect.top    <= pPoint.y)                        &&                                  
                (rRect.bottom >= pPoint.y) 
               ) {

                if (                
                    ((SHORT)lpGrigliaStruct->wSelStartRow != m)  ||                
                    ((SHORT)lpGrigliaStruct->wSelEndRow   != m)  ||                
                    (lpGrigliaStruct->wSelStartCol != lpGrigliaStruct->wFixedCols) ||                
                    (lpGrigliaStruct->wSelEndCol   != lpGrigliaStruct->wCols - 1)                
                   ) {               

                    PaintBlock (lpGrigliaStruct);            

                    // Paint and Move Cursor to Top Left Pos                    
                    if (                    
                        (lpGrigliaStruct->wFixedCols !=                    
                            lpGrigliaStruct->wCursorCol) ||                     
                        (m != (SHORT)lpGrigliaStruct->wCursorRow)                                                 
                       ) {                        
                        PaintCursor (lpGrigliaStruct);
                        lpGrigliaStruct->wCursorCol = lpGrigliaStruct->wFixedCols;
                        lpGrigliaStruct->wCursorRow = m;
                        lpGrigliaStruct->wCol       = lpGrigliaStruct->wFixedCols;
                        lpGrigliaStruct->wRow       = m;
                        PaintCursor (lpGrigliaStruct);
                    }                    

                    SetEditText (lpGrigliaStruct,                    
                                lpGrigliaStruct->wCursorRow,                                
                                lpGrigliaStruct->wCursorCol);                                

                    lpGrigliaStruct->wSelStartRow = m;                    
                    lpGrigliaStruct->wSelEndRow   = m;                    
                    lpGrigliaStruct->wSelStartCol = lpGrigliaStruct->wFixedCols;                    
                    lpGrigliaStruct->wSelEndCol   = lpGrigliaStruct->wCols - 1;                    
                    PaintBlock (lpGrigliaStruct);            

                }

                // PRESS BUTTON
                {
                    HDC hDC;

                    rNewButton.left   = 1;
                    rNewButton.top    = rRect.top + 1;
                    rNewButton.right  = PUSH_H_GRID - 1;
                    rNewButton.bottom = rRect.bottom;
                    if (!EqualRect ((LPRECT)&rButton,
                                    (LPRECT)&rNewButton)) {    
                    
                        // Raise previous button if still down
                        if (!IsRectEmpty ((LPRECT)&rButton))
                            LButtonUp (lpGrigliaStruct, pPoint);

                        hDC = GetDC (lpGrigliaStruct->hWndStatic);
                        PaintButtonDown (hDC,
                                         rNewButton.left,
                                         rNewButton.top,
                                         rNewButton.right,
                                         rNewButton.bottom);
                        ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);
                        rButton = rNewButton;
                    }
                }
                return (TRUE);
            }    
        }    

    } else if (pPoint.y < PUSH_V_GRID) {

        // Scan Columns
        for (n = (lpGrigliaStruct->wFixedCols + lpGrigliaStruct->nHScrollPos);
             n < (SHORT)lpGrigliaStruct->wCols; ++n) {

            if (
                (CellLRRect (lpGrigliaStruct, n, (LPRECT)&rRect)) &&
                (rRect.left   <= pPoint.x)                        &&                                  
                (rRect.right  >= pPoint.x) 
               ) {
                if (                    
                    ((SHORT)lpGrigliaStruct->wSelStartCol != n)  ||                        
                    ((SHORT)lpGrigliaStruct->wSelEndCol   != n)  ||                        
                    (lpGrigliaStruct->wSelStartRow != lpGrigliaStruct->wFixedRows) ||                        
                    (lpGrigliaStruct->wSelEndRow   != lpGrigliaStruct->wRows - 1)                        
                ) {                   

                    PaintBlock (lpGrigliaStruct);                

                    // Paint and Move Cursor to Top Left Pos                        
                    if (                        
                        (n != (SHORT)lpGrigliaStruct->wCursorCol) ||                        
                        (lpGrigliaStruct->wFixedCols !=                            
                        lpGrigliaStruct->wCursorRow)                             
                       ) {                            
                        PaintCursor (lpGrigliaStruct);
                        lpGrigliaStruct->wCursorCol = n;
                        lpGrigliaStruct->wCursorRow = lpGrigliaStruct->wFixedRows;
                        lpGrigliaStruct->wCol           = n;
                        lpGrigliaStruct->wRow           = lpGrigliaStruct->wFixedRows;
                        PaintCursor (lpGrigliaStruct);
                    }                        

                    SetEditText (lpGrigliaStruct,                        
                                lpGrigliaStruct->wCursorRow,                                    
                                lpGrigliaStruct->wCursorCol);                                    

                    lpGrigliaStruct->wSelStartCol = n;
                    lpGrigliaStruct->wSelEndCol   = n;
                    lpGrigliaStruct->wSelStartRow = lpGrigliaStruct->wFixedRows;
                    lpGrigliaStruct->wSelEndRow   = lpGrigliaStruct->wRows - 1;
                    PaintBlock (lpGrigliaStruct);

                }   
                     
                // PRESS BUTTON    
                {    
                    HDC hDC;

                    rNewButton.left   = rRect.left +
                                        lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR);
                    rNewButton.top    = 1;
                    rNewButton.right  = rRect.right + 1;
                    rNewButton.bottom = PUSH_V_GRID - 1;
                    if (!EqualRect ((LPRECT)&rButton,
                                    (LPRECT)&rNewButton)) {    
                    
                        // Raise previous button if still down
                        if (!IsRectEmpty ((LPRECT)&rButton))
                            LButtonUp (lpGrigliaStruct, pPoint);

                        hDC = GetDC (lpGrigliaStruct->hWndStatic);
                        PaintButtonDown (hDC,
                                         rNewButton.left,
                                         rNewButton.top,
                                         rNewButton.right,
                                         rNewButton.bottom);
                        ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);
                        rButton = rNewButton;
                    }
                }    
                return (TRUE);                
                
            }        
        }        
    }
    return (FALSE);
}

//---------------------------------------------------------------------------
// LMouseMoveDown
//---------------------------------------------------------------------------
void LMouseMoveDown (PGRIGLIA lpGrigliaStruct,
				     POINT	  pPoint) {

	LONG  lLeft, lRight, lTop, lBottom, lHScroll, lVScroll;
	SHORT n, m;
	RECT  rStatic;
	WORD  wCol, wRow;

	GetClientRect (lpGrigliaStruct->hWndStatic,	(LPRECT)&rStatic);

    lLeft = PUSH_H_GRID;
    if (lpGrigliaStruct->wFixedCols)
    	lLeft = (lpGrigliaStruct->lpVertBars  +
    			 lpGrigliaStruct->wFixedCols - 1)->lPos;

    // Scan Other Columns
    for (n = (lpGrigliaStruct->wFixedCols + lpGrigliaStruct->nHScrollPos);
    	 n < (SHORT)lpGrigliaStruct->wCols; ++n) {

        if ((lHScroll =
                 Griglia_HorPos (n, lpGrigliaStruct)) !=
        	 INVALID_POS) {
			lRight = PUSH_H_GRID + lHScroll -
		 			 lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR);

			if (lLeft > (LONG)rStatic.right)
				return;
			else if (
				 	 (lLeft  <= pPoint.x) &&
				 	 (lRight >= pPoint.x)
					) {
				wCol = n;

				// Scan Other Rows
    			lTop = PUSH_V_GRID;
    			if (lpGrigliaStruct->wFixedRows)
    				lTop = (lpGrigliaStruct->lpHorBars  +
    			 			lpGrigliaStruct->wFixedRows - 1)->lPos;

    			// Scan Other Columns
    			for (m = (lpGrigliaStruct->wFixedRows +
    					  lpGrigliaStruct->nVScrollPos);
    	 				  m < (SHORT)lpGrigliaStruct->wRows; ++m) {

        			if ((lVScroll =
        				 Griglia_VertPos (m, lpGrigliaStruct)) !=
        	 			 INVALID_POS) {
						lBottom = PUSH_V_GRID + lVScroll -
		 			 			  lpGrigliaStruct->yChar /
		 			 			  (2 * INTERCOLUMN_FACTOR);

						if (lBottom > (LONG)rStatic.bottom)
							return;
						else if (
				 	 			 (lTop    <= pPoint.y) &&
				 	 			 (lBottom >= pPoint.y)
				 	 			) {

							wRow = m;

							if (
							    (lpGrigliaStruct->wSelEndRow != wRow) ||
							    (lpGrigliaStruct->wSelEndCol != wCol)
							   ) {
								// Set Selection to Cursor							// Remove Selection
								PaintBlock (lpGrigliaStruct);
								lpGrigliaStruct->wSelEndRow = wRow;
								lpGrigliaStruct->wSelEndCol = wCol;
								PaintBlock (lpGrigliaStruct);
							}
							return;
						}
					}
				}
			}
		}
	}
}   

//---------------------------------------------------------------------------
// LButtonUp
//---------------------------------------------------------------------------
void LButtonUp (PGRIGLIA lpGrigliaStruct,
                POINT    pPoint) {
 
    UINT n;
    static RECT rRect;

    if (!IsRectEmpty ((LPRECT)&rButton)) {

        HDC hDC;

        hDC = GetDC (lpGrigliaStruct->hWndStatic);
        PaintButtonUp (hDC,
                       rButton.left,
                       rButton.top,
                       rButton.right,
                       rButton.bottom);
        ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);
        SetRectEmpty ((LPRECT)&rButton);

    } else {
        // TEMPORARILY
        return;
            
        if (
            (pPoint.x < PUSH_H_GRID) &&
            (pPoint.y < PUSH_V_GRID)
           ) {
            HDC hDC;
        
            hDC = GetDC (lpGrigliaStruct->hWndStatic);
            PaintButtonUp (hDC,
                           1,
                           1,
                           PUSH_H_GRID - 1,
                           PUSH_V_GRID - 1);
            ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);
        } else if (pPoint.x < PUSH_H_GRID) {
        
            // Scan Rows
            for (n = (lpGrigliaStruct->wFixedRows +
                      lpGrigliaStruct->nVScrollPos);
                 n < lpGrigliaStruct->wRows;
                 ++n) {
        
                if (
                    (CellTBRect (lpGrigliaStruct, n, (LPRECT)&rRect)) &&
                    (rRect.top    <= pPoint.x)                        &&
                    (rRect.bottom >= pPoint.x)
                   ) {
                    HDC hDC;    
            
                    hDC = GetDC (lpGrigliaStruct->hWndStatic);    
                    PaintButtonUp (hDC,
                                   1,
                                   rRect.top + 1,
                                   PUSH_H_GRID - 1,
                                   rRect.bottom);
                    ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);    
                }    
            }
        } else if (pPoint.y < PUSH_V_GRID) {
        
            // Scan Columns
            for (n = (lpGrigliaStruct->wFixedCols + 
                      lpGrigliaStruct->nHScrollPos);
                 n < lpGrigliaStruct->wCols; 
                 ++n) {
        
                if (
                    (CellLRRect (lpGrigliaStruct, n, (LPRECT)&rRect)) &&
                    (rRect.left   <= pPoint.x)                        &&                                  
                    (rRect.right  >= pPoint.x) 
                   ) {
                    HDC hDC;    
            
                    hDC = GetDC (lpGrigliaStruct->hWndStatic);    
                    PaintButtonUp (hDC,    
                                   rRect.left +     
                                   lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR),     
                                   1,     
                                   rRect.right + 1,     
                                   PUSH_V_GRID - 1);     
                    ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);    
                }    
            }
        }
    }    
}
                      
        
