//---------------------------------------------------------------------------
// Ext.c
//---------------------------------------------------------------------------
// Griglia Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include "vbapi.h"
#include "griglia.h"

//---------------------------------------------------------------------------
// RepaintGrid
//---------------------------------------------------------------------------
void RepaintGrid (PGRIGLIA  lpGrigliaStruct,
                  BOOL      bRepaint) {

    HDC   hDC;
    HFONT hOldFont;

    if (bRepaint) {    
        if (hDC = GetDC (lpGrigliaStruct->hWndStatic)) {    
            hOldFont = SelectObject (hDC, lpGrigliaStruct->hFont);

            PaintBackground  (lpGrigliaStruct, hDC, lpGrigliaStruct->rStatic);        
            PaintTastoSu     (lpGrigliaStruct, hDC, lpGrigliaStruct->rStatic);                                
            PaintHorBars     (lpGrigliaStruct, hDC, lpGrigliaStruct->rStatic);                                
            PaintVertBars    (lpGrigliaStruct, hDC, lpGrigliaStruct->rStatic);

            if (hOldFont)
                SelectObject (hDC, hOldFont);
            ReleaseDC(lpGrigliaStruct->hWndStatic, hDC);
        }
    } else {    
        PaintCursor (lpGrigliaStruct);                
        if (hDC = GetDC (lpGrigliaStruct->hWndStatic)) {
            hOldFont = SelectObject (hDC, lpGrigliaStruct->hFont);

            PaintBlockLocal  (lpGrigliaStruct, hDC);                

            if (hOldFont)
                SelectObject (hDC, hOldFont);
            ReleaseDC(lpGrigliaStruct->hWndStatic, hDC);    
        }
    }    
    if (hDC = GetDC (lpGrigliaStruct->hWndStatic)) {    
        hOldFont = SelectObject (hDC, lpGrigliaStruct->hFont);
        PaintText (lpGrigliaStruct, hDC, lpGrigliaStruct->rStatic);    
        PaintBlockLocal  (lpGrigliaStruct, hDC);            
        ReleaseDC(lpGrigliaStruct->hWndStatic, hDC);
        PaintCursor (lpGrigliaStruct);            

        if (hOldFont)
            SelectObject (hDC, hOldFont);
        ReleaseDC(lpGrigliaStruct->hWndStatic, hDC);        
    }
    SetEditText (lpGrigliaStruct,
                 lpGrigliaStruct->wCursorRow,
                 lpGrigliaStruct->wCursorCol);
}

//---------------------------------------------------------------------------
// InsertCellsText
//---------------------------------------------------------------------------
void InsertCellsText (PGRIGLIA  lpGrigliaStruct,
                      WORD      wRow,                          
                      WORD      wCol,
                      WORD      wInsertCells) {      

    WORD  wRows,
          wClusRows, wClusLast, wClusFirst, wClusPos,
          wShift, wMove,   
          nScrl;
    SHORT n;
    LPSTR lpPtr0, lpPtr1, lpStr;
    BOOL  bRepaint = FALSE;

    wRows = lpGrigliaStruct->wRows;
    for (n = 0; n < (SHORT)wInsertCells; ++n) {
     
        if (
            (lpStr = GetCellText (lpGrigliaStruct,
                                  lpGrigliaStruct->wRows - 1,
                                  max (0, lpGrigliaStruct->wCols - n - 1))) &&
            (_fstrlen (lpStr))
           ) {
                            
            // Increase Total Number of Rows
            wRows = lpGrigliaStruct->wRows + 
                    1 + (wInsertCells - 1) / lpGrigliaStruct->wCols;
            nScrl = lpGrigliaStruct->nVScrollPos;
            GrigliaRows (lpGrigliaStruct, wRows);
            lpGrigliaStruct->nVScrollPos = nScrl;
            bRepaint = TRUE;
            break;
        }
    }

    // Rows per Cluster
    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
                lpGrigliaStruct->wCols));            
                      
    // Last Cluster
    wClusLast  = wRows / wClusRows;        
    wClusFirst = wRow  / wClusRows;        
                                          
    // Amount to shift
    wShift    =  sizeof (LPSTR) * wInsertCells;
    
    // Bytes to shift right
    wMove     = ( wClusRows * lpGrigliaStruct->wCols - wInsertCells ) *
                sizeof (LPSTR);
    
    for (n = (SHORT)wClusLast; n > (SHORT)wClusFirst; --n) {
                              
        // shift entire row cluster    
        lpPtr1 = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [n].lpCluster);    
        _fmemmove (lpPtr1 + wShift, lpPtr1, wMove);    
        
        // copy shift bytes from previous row cluster        
        lpPtr0 = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster         
                        [n - 1].lpCluster);     
        _fmemmove (lpPtr0, lpPtr1 + wMove, wShift);    
        
    }                                             
    
    // shift first row cluster
    wClusPos  = wCol +    
                (wRow - wClusFirst * wClusRows) * lpGrigliaStruct->wCols;
    lpPtr1 = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusFirst].lpCluster +
                             wClusPos);        
    _fmemmove (lpPtr1 + wShift,
               lpPtr1,
               wMove - (wRow * lpGrigliaStruct->wCols + wCol) * sizeof (LPSTR));
    _fmemset  (lpPtr1, 0, wShift); 

    RepaintGrid (lpGrigliaStruct, bRepaint);
}        
        
//---------------------------------------------------------------------------
// LineBreakText
//---------------------------------------------------------------------------
void LineBreakText (PGRIGLIA  lpGrigliaStruct,
                    WORD      wRow,
                    WORD      wCol) {

    InsertCellsText (lpGrigliaStruct,
                     wRow,
                     wCol,
                     lpGrigliaStruct->wCols - wCol);
}

//---------------------------------------------------------------------------
// DeleteCellsText
//---------------------------------------------------------------------------
void DeleteCellsText (PGRIGLIA  lpGrigliaStruct,
                      WORD      wRow,                          
                      WORD      wCol,
                      WORD      wDeleteCells) {

    WORD  wRows,
          wClusRows, wClusLast, wClusFirst, wClusPos,
          wShift, wMove,   
          nScrl;
    SHORT n;
    LPSTR lpPtr0, lpPtr1, lpStr;
    BOOL  bRepaint = TRUE;

    // Rows per Cluster
    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
                lpGrigliaStruct->wCols));            
                      
    // Last Cluster
    wClusLast  = lpGrigliaStruct->wRows / wClusRows;
    wClusFirst = wRow  / wClusRows;        
                                          
    // Amount to shift
    wShift    =  sizeof (LPSTR) * wDeleteCells;
    
    // Bytes to shift left
    wMove     = ( wClusRows * lpGrigliaStruct->wCols - wDeleteCells ) *
                sizeof (LPSTR);

    // shift first row cluster
    wClusPos  = wCol +    
                (wRow - wClusFirst * wClusRows) * lpGrigliaStruct->wCols;
    lpPtr0 = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusFirst].lpCluster);
    lpPtr1 = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusFirst].lpCluster +
                             wClusPos);        
    _fmemmove (lpPtr1,
               lpPtr1 + wShift,
               wMove - (wRow * lpGrigliaStruct->wCols + wCol) * sizeof (LPSTR));
    _fmemset  (lpPtr0 + wMove, 0, wShift);

    // shift other clusters
    for (n = (SHORT)wClusFirst + 1; n < (SHORT)wClusLast; ++n) {

        // copy shift bytes to previous row cluster
        lpPtr0 = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster         
                         [n - 1].lpCluster);
        _fmemmove (lpPtr0 + wMove, lpPtr1, wShift);

        // shift entire row cluster    
        lpPtr1 = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [n].lpCluster);    
        _fmemmove (lpPtr1, lpPtr1 + wShift, wMove);
        _fmemset  (lpPtr1 + wMove, 0, wShift);
    }

    // need to decrease total number of rows ?
    for (n = (SHORT)lpGrigliaStruct->wCols - 1;
         n >= 0;
         --n) {
        if (
            (lpStr = GetCellText (lpGrigliaStruct,
                                  lpGrigliaStruct->wRows - 1,
                                  n)) &&
            (_fstrlen (lpStr))
           ) {
            bRepaint = FALSE;
            break;
        }
    }
    if (bRepaint) {
        // Decrease Total Number of Rows
        wRows = lpGrigliaStruct->wRows -
                1 - (wDeleteCells - 1) / lpGrigliaStruct->wCols;
        nScrl = lpGrigliaStruct->nVScrollPos;
        GrigliaRows (lpGrigliaStruct, wRows);
        lpGrigliaStruct->nVScrollPos = nScrl;
    }

    RepaintGrid (lpGrigliaStruct, bRepaint);
}

//---------------------------------------------------------------------------
// RemoveLineBreakText
//---------------------------------------------------------------------------
void RemoveLineBreakText (PGRIGLIA  lpGrigliaStruct,
                          WORD      wRow,
                          WORD      wCol) {

    WORD  wDeleteCells = 0;
    SHORT n;
    LPSTR lpStr;

    if (wRow < lpGrigliaStruct->wRows - 1) {
        for (n = (SHORT)lpGrigliaStruct->wCols - 1; n >= (SHORT)wCol; --n) {
            ++wDeleteCells;
            if (
                (lpStr = GetCellText (lpGrigliaStruct, wRow, n)) &&
                (_fstrlen (lpStr))
               )
                break;
        }
        if (wDeleteCells)
            DeleteCellsText (lpGrigliaStruct,
                            wRow,
                            wCol,
                            wDeleteCells);

    }
}

//---------------------------------------------------------------------------
// MoveWordRight
//---------------------------------------------------------------------------
void MoveWordTextRight (PGRIGLIA  lpGrigliaStruct,
                        WORD      wRow,
                        WORD      wCol) {

    HANDLE hStr, hRight;
    PSTR   pStr, pRight;
    LPSTR  lpStr, lpRight, lpToken, lpLoop;
    WORD   nStrLen, nRightLen, nTokenLen;
    WORD   wRightCol = 0xffff;
    WORD   wRightRow = 0xffff;

    // Determine Right Column
    if (wCol < lpGrigliaStruct->wCols - 1) {
        wRightCol = wCol + 1;
        wRightRow = wRow;
    } else if (
               (wCol == lpGrigliaStruct->wCols - 1) &&
               (wRow < lpGrigliaStruct->wRows - 1)
              ) {
        wRightCol = 0;
        wRightRow = wRow + 1;
    }

    // Parse text of current cell
    if (
        (wRightRow != 0xffff)                                &&
        (wRightCol != 0xffff)                                &&
        (lpStr   = GetCellText (lpGrigliaStruct, wRow, wCol)) &&
        (nStrLen = _fstrlen (lpStr))
       ) {
        if ( hStr = LocalAlloc (LHND,
                                nStrLen + 3) ) {
            pStr = (PSTR) LocalLock (hStr);
            _fstrcpy (pStr, lpStr);

            // get last word
            lpToken   = _fstrtok ( pStr, " \t\n");
            while (lpLoop = _fstrtok (NULL, " \t\n"))
                lpToken = lpLoop;

            nTokenLen = 0;
            if (lpToken)
                nTokenLen = _fstrlen (lpToken);

            if (nTokenLen) {
                // get left word
                nRightLen = 0;
                if (lpRight = GetCellText (lpGrigliaStruct, wRightRow, wRightCol))
                    nRightLen = _fstrlen (lpRight);

                // prepend token to right word
                if ( hRight = LocalAlloc (LHND,
                                          nRightLen + nTokenLen + 3) ) {

                    pRight = (PSTR) LocalLock (hRight);
                    *pRight = 0;
                    if (nTokenLen)
                        _fstrcat (pRight, lpToken);
                    if (
                        (nRightLen) &&
                        (nTokenLen)
                       )
                        _fstrcat (pRight, " ");
                    if (nRightLen)
                        _fstrcat (pRight, lpRight);
                    PutCellText (lpGrigliaStruct, wRightRow, wRightCol, pRight);

                    LocalUnlock (hRight);
                    LocalFree   (hRight);
                }

                // remove token from cell text
                if (nTokenLen == nStrLen)
                    PutCellText (lpGrigliaStruct, wRow, wCol, "");
                else if (nStrLen > nTokenLen) {
                    // write rest of string back - find last char
                    _fstrcpy (pStr, lpStr);

                    *lpToken-- = 0;
                    while ((LPSTR)pStr < lpToken) {
                        if (
                            (*lpToken != ' ')  &&
                            (*lpToken != '\t') &&
                            (*lpToken != '\n')
                           )
                            break;
                        *lpToken-- = 0;
                    }
                    if (
                        (pStr) &&
                        (_fstrlen (pStr))
                       )
                        PutCellText (lpGrigliaStruct, wRow, wCol, pStr);
                }

                // paint grid
                RepaintGrid (lpGrigliaStruct, FALSE);

            }
            LocalUnlock (hStr);
            LocalFree   (hStr);
        }
    }
}

//---------------------------------------------------------------------------
// MoveWordLeft
//---------------------------------------------------------------------------
void MoveWordTextLeft (PGRIGLIA  lpGrigliaStruct,
                       WORD      wRow,
                       WORD      wCol) {

    HANDLE hStr, hLeft;
    PSTR   pStr, pLeft;
    LPSTR  lpStr, lpLeft, lpToken;
    WORD   nStrLen, nLeftLen, nTokenLen;
    WORD   wLeftCol = 0xffff;
    WORD   wLeftRow = 0xffff;

    // Determine Left Column
    if (wCol > 0) {
        wLeftCol = wCol - 1;
        wLeftRow = wRow;
    } else if (
             (wCol == 0) &&
             (wRow > lpGrigliaStruct->wFixedRows)
            ) {
        wLeftCol = lpGrigliaStruct->wCols - 1;
        wLeftRow = wRow - 1;
    }

    // Parse text of current cell
    if (
        (wLeftRow != 0xffff)                                &&
        (wLeftCol != 0xffff)                                &&
        (lpStr   = GetCellText (lpGrigliaStruct, wRow, wCol)) &&
        (nStrLen = _fstrlen (lpStr))
       ) {
        if ( hStr = LocalAlloc (LHND,
                                nStrLen + 3) ) {
            pStr = (PSTR) LocalLock (hStr);
            _fstrcpy (pStr, lpStr);

            // get first word
            lpToken   = _fstrtok ( pStr, " \t\n");
            nTokenLen = 0;
            if (lpToken)
                nTokenLen = _fstrlen (lpToken);

            if (nTokenLen) {
                // get left word
                nLeftLen = 0;
                if (lpLeft = GetCellText (lpGrigliaStruct, wLeftRow, wLeftCol))
                    nLeftLen = _fstrlen (lpLeft);

                // append token to left word
                if ( hLeft = LocalAlloc (LHND,
                                         nLeftLen + nTokenLen + 3) ) {

                    pLeft = (PSTR) LocalLock (hLeft);
                    *pLeft = 0;
                    if (nLeftLen)
                        _fstrcat (pLeft, lpLeft);
                    if (
                        (nLeftLen) &&
                        (nTokenLen)
                       )
                        _fstrcat (pLeft, " ");
                    if (nTokenLen)
                        _fstrcat (pLeft, lpToken);
                    PutCellText (lpGrigliaStruct, wLeftRow, wLeftCol, pLeft);

                    LocalUnlock (hLeft);
                    LocalFree   (hLeft);
                }

                // remove token from cell text
                if (nTokenLen == nStrLen)
                    PutCellText (lpGrigliaStruct, wRow, wCol, "");
                else if (nStrLen > nTokenLen) {
                    // write rest of string back - find first char
                    pStr += nTokenLen + 1;
                    while (*pStr) {
                        if (
                            (*pStr != ' ')  &&
                            (*pStr != '\t') &&
                            (*pStr != '\n')
                           )
                            break;
                        ++pStr;
                    }
                    if (
                        (pStr) &&
                        (_fstrlen (pStr))
                       )
                        PutCellText (lpGrigliaStruct, wRow, wCol, pStr);
                }

                // paint grid
                RepaintGrid (lpGrigliaStruct, FALSE);

            }
            LocalUnlock (hStr);
            LocalFree   (hStr);
        }
    }
}

//---------------------------------------------------------------------------
// ShiftWordLeft
//---------------------------------------------------------------------------
void ShiftWordTextLeft (PGRIGLIA  lpGrigliaStruct,
                        WORD      wRow,
                        WORD      wCol) {

    LPSTR  lpStr;
    WORD   wLeftCol = 0xffff;
    WORD   wLeftRow = 0xffff;

    if (
        (lpStr   = GetCellText (lpGrigliaStruct, wRow, wCol)) &&
        (_fstrlen (lpStr))
       ) {

        // Determine Left Column
        if (wCol > 0) {
            wLeftCol = wCol - 1;
            wLeftRow = wRow;
        } else if (
                   (wCol == 0) &&
                   (wRow > lpGrigliaStruct->wFixedRows)
                  ) {
            wLeftCol = lpGrigliaStruct->wCols - 1;
            wLeftRow = wRow - 1;
        }

        MoveWordTextLeft (lpGrigliaStruct, wRow, wCol);
        if (
            (!(lpStr = GetCellText (lpGrigliaStruct, wRow, wCol))) ||
            (!_fstrlen (lpStr))
        )
            DeleteCellsText (lpGrigliaStruct, wRow, wCol, 1);
    }
}

//---------------------------------------------------------------------------
// ShiftWordRight
//---------------------------------------------------------------------------
void ShiftWordTextRight (PGRIGLIA  lpGrigliaStruct,
                         WORD      wRow,
                         WORD      wCol) {

    LPSTR  lpStr, lpRight;
    WORD   wRightCol = 0xffff;
    WORD   wRightRow = 0xffff;

    if (
        (lpStr   = GetCellText (lpGrigliaStruct, wRow, wCol)) &&
        (_fstrlen (lpStr))
       ) {

        // Determine Right Column
        if (wCol < lpGrigliaStruct->wCols - 1) {
            wRightCol = wCol + 1;
            wRightRow = wRow;
        } else if (
                   (wCol == lpGrigliaStruct->wCols - 1) &&
                   (wRow < lpGrigliaStruct->wRows - 1)
                  ) {
            wRightCol = 0;
            wRightRow = wRow + 1;
        }

        if (
            (
             (lpRight = GetCellText (lpGrigliaStruct, wRightRow, wRightCol)) &&
             (_fstrlen (lpRight))
            ) ||
            (
             (wRow == lpGrigliaStruct->wRows - 1) &&
             (wCol == lpGrigliaStruct->wCols - 1)
            )
           )
            InsertCellsText (lpGrigliaStruct,
                            wRightRow,
                            wRightCol,
                            1);

        MoveWordTextRight (lpGrigliaStruct, wRow, wCol);
    }
}

//---------------------------------------------------------------------------
// Just
//---------------------------------------------------------------------------
void Just (PGRIGLIA lpGrigliaStruct,
           WORD     wTop,
           WORD     wLeft,
           WORD     wBottom,
           WORD     wRight,
           BYTE     byJust) {

    UINT  nTotLength,
          nLength,
          nBlanks;
    SHORT m, n;
    LPSTR lpText;
    HANDLE hStr;
    PSTR  pStr;

    for (n = (SHORT) wLeft; n <= (SHORT) wRight; ++n) {

        nTotLength = 0;
        for (m = (SHORT) wTop; m <= (SHORT) wBottom; ++m) {
            if (lpText = GetCellText (lpGrigliaStruct, m, n)) {

                // remove initial blanks
                while (
                       (*lpText)        &&
                       (*lpText == ' ')
                      )
                    ++lpText;

                // remove final blanks
                while (
                       (lpText)                       &&
                       (nLength  = _fstrlen (lpText)) &&
                       (*(lpText + nLength - 1) == ' ')
                      )
                    *(lpText + nLength - 1) = 0;

                nTotLength = max (nTotLength, _fstrlen (lpText));
            }
        }

        if (nTotLength)
            for (m = (SHORT) wTop; m <= (SHORT) wBottom; ++m) {

            // get existing text
            if (lpText = GetCellText (lpGrigliaStruct, m, n)) {

                // remove initial blanks
                while (
                       (*lpText)        &&
                       (*lpText == ' ')
                      )
                    ++lpText;

                // determine how many blanks to prepend
                if (
                    (lpText) &&
                    (nLength = _fstrlen (lpText))
                   ) {
                    nBlanks = 0;
                    if (
                        (byJust == CENTER_JUST) &&
                        (nTotLength >= nLength)
                       )
                        nBlanks = (nTotLength - nLength) / 2;
                    else if (byJust == LEFT_JUST)
                        nBlanks = 0;
                    else if (
                             (byJust == RIGHT_JUST) &&
                             (nTotLength >= nLength)
                            )
                        nBlanks = nTotLength - nLength;

                    // prepend blanks
                    if ( hStr = LocalAlloc (LHND,
                                            nBlanks + nLength + 3) ) {

                        pStr = LocalLock (hStr);

                        _fmemset (pStr, 0, nBlanks + nLength + 1);
                        if (nBlanks)
                            _fmemset (pStr, ' ', nBlanks);

                        _fmemcpy (pStr + nBlanks, lpText, nLength);

                        PutCellText (lpGrigliaStruct,
                                     m, n,
                                     pStr);

                        LocalUnlock (hStr);
                        LocalFree   (hStr);
                    }
                }
            }
        }
    }

    // paint grid
    RepaintGrid (lpGrigliaStruct, FALSE);
}

//---------------------------------------------------------------------------
// PaintTextCell_Ext
//---------------------------------------------------------------------------
BOOL PaintTextCell_Ext (HDC         hDC,
                        RECT        rRect,
                        LPEXT_INPUT lpExt,
                        LPSTR       lpStr) {

    COLORREF rgbOldFColor, rgbOldBColor;
    UINT     bRet, nLen;
    RECT     rTemp;
    static   LOGFONT  lfFont;
    HFONT    hOldFont, hFont = 0;

    lfFont.lfHeight         = 12;
    lfFont.lfWidth          = 0;
    lfFont.lfEscapement     = 0;
    lfFont.lfOrientation    = 0;
    lfFont.lfWeight         = FW_NORMAL;
    lfFont.lfItalic         = 0;
    lfFont.lfUnderline      = 0;
    lfFont.lfStrikeOut      = 0;
    lfFont.lfCharSet        = ANSI_CHARSET;
    lfFont.lfOutPrecision   = OUT_DEFAULT_PRECIS;
    lfFont.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
    lfFont.lfQuality        = DEFAULT_QUALITY;
    lfFont.lfPitchAndFamily = DEFAULT_PITCH;
    _fstrcpy (lfFont.lfFaceName, "Courier New");

    if (
        (lpStr)           &&
        (nLen = _fstrlen (lpStr))
       ) {
        rgbOldFColor = 0;
        if (lpExt->rgbFColor)
            rgbOldFColor = SetTextColor (hDC, lpExt->rgbFColor);
        rgbOldBColor = 0;
        if (lpExt->rgbBColor)
            rgbOldBColor = SetBkColor (hDC, lpExt->rgbBColor);

        if (
            (lpExt->bySize) ||
            (lpExt->lpFaceName) ||
            (lpExt->uStatus & BOLD) ||
            (lpExt->uStatus & ITALIC) ||
            (lpExt->uStatus & UNDERLINE)
           ) {
            if (lpExt->bySize)
                lfFont.lfHeight = lpExt->bySize;
            if (lpExt->lpFaceName)
                _fstrcpy (lfFont.lfFaceName, lpExt->lpFaceName);
            if (lpExt->uStatus & BOLD)
                lfFont.lfWeight = FW_BOLD;
            if (lpExt->uStatus & ITALIC)
                lfFont.lfItalic = 1;
            if (lpExt->uStatus & UNDERLINE)
                lfFont.lfUnderline = 1;

            if (hFont = CreateFontIndirect ((const LOGFONT FAR *)&lfFont))
                hOldFont = SelectObject (hDC, hFont);
        }

        // paint whole background
        rTemp = rRect;
        InflateRect ((LPRECT) &rTemp, SMALL_RIM, SMALL_RIM);
        bRet = ExtTextOut ( hDC,
                            rRect.left, rRect.top,
                            ETO_CLIPPED | ETO_OPAQUE,
                            (LPRECT)&rTemp,
                            "", 1,
                            (LPINT)NULL);

        // paint rules
        {
            HPEN hOldPen;

            hOldPen = SelectObject (hDC, hDashedPen);
            MoveTo (hDC, rTemp.left,  rTemp.top);
            LineTo (hDC, rTemp.right, rTemp.top);
            LineTo (hDC, rTemp.right, rTemp.bottom);
            LineTo (hDC, rTemp.left,  rTemp.bottom);
            LineTo (hDC, rTemp.left,  rTemp.top);
            SelectObject (hDC, hOldPen);
        }

        bRet = ExtTextOut ( hDC,
                            rRect.left, rRect.top,
                            ETO_CLIPPED | ETO_OPAQUE,
                            (LPRECT)&rRect,
                            lpStr, nLen,
                            (LPINT)NULL);

        SetTextColor (hDC, rgbOldFColor);
        SetBkColor   (hDC, rgbOldBColor);
        if (hOldFont)
            SelectObject (hDC, hOldFont);
        if (hFont)
            DeleteObject (hFont);
    }
    return (bRet);
}
