//---------------------------------------------------------------------------
// GRIDAPI.H
//---------------------------------------------------------------------------

#define IPROP_GRIGLIA_ROWS              0x0017                
#define IPROP_GRIGLIA_COLS              0x0018                
#define IPROP_GRIGLIA_FIXEDROWS      	0x0019
#define IPROP_GRIGLIA_FIXEDCOLS      	0x001A
#define IPROP_GRIGLIA_ROW            	0x001B
#define IPROP_GRIGLIA_COL            	0x001C
#define IPROP_GRIGLIA_ROWHEIGHT      	0x001D
#define IPROP_GRIGLIA_COLWIDTH       	0x001E
#define IPROP_GRIGLIA_TOPROW         	0x001F
#define IPROP_GRIGLIA_LEFTCOL        	0x0020
#define IPROP_GRIGLIA_CURSORROW      	0x0021
#define IPROP_GRIGLIA_CURSORCOL      	0x0022
#define IPROP_GRIGLIA_TEXT              0x0023                
#define IPROP_GRIGLIA_CLIP              0x0024                
#define IPROP_GRIGLIA_SELSTARTROW       0x0025        
#define IPROP_GRIGLIA_SELENDROW         0x0026        
#define IPROP_GRIGLIA_SELSTARTCOL       0x0027        
#define IPROP_GRIGLIA_SELENDCOL         0x0028        
#define IPROP_GRIGLIA_ENABLECOL         0x0029        
#define IPROP_GRIGLIA_ENABLEROW         0x002A        
#define IPROP_GRIGLIA_ENABLEEDIT        0x002B
#define IPROP_GRIGLIA_ENABLESCROLLBARS  0x002C

#define LEFT_JUST     0
#define CENTER_JUST   1
#define RIGHT_JUST    2

typedef struct tagFind {

	WORD	wCol;
	LPSTR   lpText;

} FINDTEXT;
typedef FINDTEXT FAR * LPFINDTEXT;

#define         PASSWORD        (BYTE)0x127
#define         BOLD            0x0001
#define         ITALIC          0x0002
#define         UNDERLINE       0x0004
#define         DISABLE         0x0008
typedef struct {

    BYTE        byPassword;
    BYTE        bySize;
    COLORREF    rgbFColor;
    COLORREF    rgbBColor;
    UINT        uStatus;
    LPSTR       lpFaceName;

} EXT_INPUT;
typedef EXT_INPUT FAR * LPEXT_INPUT;

// api.c
VOID FAR PASCAL _export
				RepaintGrigliaProperty 	(HWND);
BOOL FAR PASCAL _export
				GetGrigliaProperty 	(HWND, USHORT, LPVOID);
BOOL FAR PASCAL _export
				SetGrigliaProperty 	(HWND, USHORT, LONG);
BOOL FAR PASCAL _export
                                PutText                 (HWND, WORD, WORD, LPSTR);        
LPSTR FAR PASCAL _export
                                GetText                 (HWND, WORD, WORD);
BOOL FAR PASCAL _export
				InsertLines    		(HWND, WORD, WORD);
BOOL FAR PASCAL _export
				DeleteLines    		(HWND, WORD, WORD);
BOOL FAR PASCAL _export
                                FindLine                (HWND, LPFINDTEXT);
void FAR PASCAL _export
                                EraseGrid               (HWND);
void FAR PASCAL _export         
                                SetColSize              (HWND, UINT, UINT);
BOOL FAR PASCAL _export
                                SortLine                (HWND, LPFINDTEXT);
void FAR PASCAL _export
                                InsertCells             (HWND, WORD, WORD, WORD);
void FAR PASCAL _export
                                InsertLineBreak         (HWND, WORD, WORD);
void FAR PASCAL _export
                                DeleteCells             (HWND, WORD, WORD, WORD);
void FAR PASCAL _export
                                DeleteLineBreak         (HWND, WORD, WORD);
void FAR PASCAL _export
                                MoveWordRight           (HWND, WORD, WORD);
void FAR PASCAL _export
                                MoveWordLeft            (HWND, WORD, WORD);
void FAR PASCAL _export
                                ShiftWordRight          (HWND, WORD, WORD);
void FAR PASCAL _export
                                ShiftWordLeft           (HWND, WORD, WORD);

UINT FAR PASCAL _export         GetBlockSize            (HWND, WORD, WORD,      
                                                               WORD, WORD);  
void FAR PASCAL _export         CJust                   (HWND, WORD, WORD,
                                                               WORD, WORD);  
void FAR PASCAL _export         LJust                   (HWND, WORD, WORD,
                                                               WORD, WORD);  
void FAR PASCAL _export         RJust                   (HWND, WORD, WORD,
                                                               WORD, WORD);  
BOOL FAR PASCAL _export         IsBlockEmpty            (HWND, WORD, WORD,
                                                               WORD, WORD);  
BOOL FAR PASCAL _export
                                PutText_Ext             (HWND, WORD, WORD,
                                                         LPEXT_INPUT, LPSTR);
LPSTR FAR PASCAL _export
                                GetText_Ext             (HWND, WORD, WORD,
                                                         LPEXT_INPUT);
