//---------------------------------------------------------------------------
// Griglia.c
//---------------------------------------------------------------------------
// Griglia Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "vbapi.h"
#include "griglia.h"

HANDLE	    hInst;
FARPROC     lpfnNewEdit,    
            lpfnOldEdit;
FARPROC     lpfnNewStatic,
            lpfnOldStatic;
HBITMAP     hTastoSu1,    
            hTastoSu2,            
            hTastoGiu;            
HPEN        hDashedPen,    
            hCursorPen;            
BOOL        bShiftPressed,
            bCtrlPressed,            
            nRepeatKey;            
HCURSOR     hCursorCross,    
            hCursorIBeam,            
            hCursorStndr;
RECT        rButton;

// Local Function Prototyping
static BOOL NEAR        HorBarBuffer            (PGRIGLIA);        
static BOOL NEAR        UpdateHorBarPositions   (PGRIGLIA);                
static BOOL NEAR        VertBarBuffer           (PGRIGLIA);                        
static BOOL NEAR        UpdateVertBarPositions  (PGRIGLIA);                

//---------------------------------------------------------------------------
// GrigliaLibLoad
//---------------------------------------------------------------------------
void GrigliaLibLoad (void) {

        hDashedPen   = CreatePen (PS_SOLID, 1, RGB (0x7f, 0x7f, 0x7f));
        hCursorPen   = CreatePen (PS_SOLID, 3, RGB (0x00, 0x00, 0x00));
	hCursorCross = LoadCursor (hmodDLL, (LPSTR)"cross");
	hCursorIBeam = LoadCursor (NULL, IDC_IBEAM);
	hCursorStndr = LoadCursor (NULL, IDC_ARROW);

}

//---------------------------------------------------------------------------
// GrigliaLibUnload
//---------------------------------------------------------------------------
void GrigliaLibUnload (void) {

    if (hDashedPen)
    	DeleteObject (hDashedPen);
    if (hCursorPen)
	DeleteObject (hCursorPen);
}

//---------------------------------------------------------------------------
// FireChangeEvent
//---------------------------------------------------------------------------
void FireChangeEvent (HCTL  hctl,
                      WORD  wRow,                  
                      WORD  wCol,                      
                      LPSTR lOldpStr) {                  

    CHANGE_PARAMS   cParams;    
    PGRIGLIA        lpGrigliaStruct = GRIGLIADEREF(hctl);    
    LPSTR           lpStr;            

    if (!lOldpStr) {
        if (lpStr = GetCellText (lpGrigliaStruct, wRow, wCol))        
            cParams.hlsPropStr = VBCreateHlstr((LPVOID)lpStr,            
                                               lstrlen ((LPSTR)lpStr));           
    	else
            cParams.hlsPropStr = (HLSTR)NULL;    
    } else    
        cParams.hlsPropStr = VBCreateHlstr((LPVOID)lOldpStr,        
                                           lstrlen ((LPSTR)lOldpStr));    

	cParams.lpY = &wCol;
	cParams.lpX = &wRow;

	if (VBGetMode () == MODE_RUN)
            VBFireEvent (hctl, EVENT_GRIGLIA_CHANGE, &cParams);    

    if (cParams.hlsPropStr)
    	VBDestroyHlstr (cParams.hlsPropStr);

 }

//---------------------------------------------------------------------------
// Griglia Horizontal Position Buffer
//---------------------------------------------------------------------------
static BOOL NEAR HorBarBuffer (PGRIGLIA lpGrigliaStruct) {

    if (lpGrigliaStruct->hHorBars) {

        WORD wSize;    

        wSize = LOWORD (GlobalSize (lpGrigliaStruct->hHorBars)) /
                sizeof (GRIGLIABAR);

        // Verify if block needs to be resized    
        if (lpGrigliaStruct->wRows > wSize) {
            LONG lSize;

            // Block is smaller so update dimensions        
            GlobalUnlock (lpGrigliaStruct->hHorBars);
            lSize = (LONG)lpGrigliaStruct->wRows * sizeof (GRIGLIABAR);
            if (
                (lSize <= 0xffff)                               &&    
                (lpGrigliaStruct->hHorBars =    
                 GlobalReAlloc (lpGrigliaStruct->hHorBars, lSize, GHND))     
               ) {
                lpGrigliaStruct->lpHorBars =
                    (PGRIGLIABAR) GlobalLock (lpGrigliaStruct->hHorBars);                
            } else {
                lpGrigliaStruct->hHorBars   = NULL;            
                lpGrigliaStruct->lpHorBars  = (PGRIGLIABAR) NULL;            
                return (FALSE);
            }
        }

    } else if (lpGrigliaStruct->hHorBars = GlobalAlloc (GHND,
                                                        lpGrigliaStruct->wRows *                                                    
                                                        (LONG) sizeof (GRIGLIABAR))) {                                                    
        lpGrigliaStruct->lpHorBars = (PGRIGLIABAR)        
        GlobalLock (lpGrigliaStruct->hHorBars);                                                             
    } else {
        lpGrigliaStruct->hHorBars   = NULL;        
        lpGrigliaStruct->lpHorBars  = (PGRIGLIABAR) NULL;        
        return (FALSE);
    }

    return (TRUE);    
}

//---------------------------------------------------------------------------
// Griglia Horizontal Position Update
//---------------------------------------------------------------------------
static BOOL NEAR UpdateHorBarPositions (PGRIGLIA lpGrigliaStruct) {

    LONG  lCurrPos;        
    WORD  n;    

    lCurrPos = 0l;    
    for (n = 0; n < lpGrigliaStruct->wRows; ++n) {    

        lCurrPos += (        
                     (lpGrigliaStruct->lpHorBars + n)->wSize +                     
                     lpGrigliaStruct->yChar / INTERCOLUMN_FACTOR                     
                    );                    
        (lpGrigliaStruct->lpHorBars + n)->lPos = lCurrPos;        

    }    
    return (TRUE);    

}

//---------------------------------------------------------------------------
// Griglia Vertical Positions
//---------------------------------------------------------------------------
static BOOL NEAR VertBarBuffer (PGRIGLIA lpGrigliaStruct) {

    if (lpGrigliaStruct->hVertBars) {

        WORD wSize;    

        wSize = LOWORD (GlobalSize (lpGrigliaStruct->hVertBars)) /
                        sizeof (GRIGLIABAR);

        // Verify if block needs to be resized    
        if (lpGrigliaStruct->wCols > wSize) {
            LONG lSize;

            // Block is smaller so update dimensions        
            GlobalUnlock (lpGrigliaStruct->hVertBars);
            lSize = (LONG)lpGrigliaStruct->wCols * sizeof (GRIGLIABAR);
            if (    
                (lSize <= 0xffff)                               &&    
                (lpGrigliaStruct->hVertBars =    
                    GlobalReAlloc (lpGrigliaStruct->hVertBars, lSize, GHND))     
               ) {
                lpGrigliaStruct->lpVertBars =
                    (PGRIGLIABAR) GlobalLock (lpGrigliaStruct->hVertBars);                
            } else {
                lpGrigliaStruct->hVertBars      = NULL;                
                lpGrigliaStruct->lpVertBars  = (PGRIGLIABAR) NULL;            
                return (FALSE);
            }
        }

    } else if (lpGrigliaStruct->hVertBars = GlobalAlloc (GHND,
                                                         lpGrigliaStruct->wCols *                                                    
                                                         (LONG) sizeof (GRIGLIABAR))) {                                                    
        lpGrigliaStruct->lpVertBars = (PGRIGLIABAR)    
            GlobalLock (lpGrigliaStruct->hVertBars);                                                         
    } else {
        lpGrigliaStruct->hVertBars      = NULL;        
        lpGrigliaStruct->lpVertBars  = (PGRIGLIABAR) NULL;            
        return (FALSE);    
    }
    return (TRUE);    
}

//---------------------------------------------------------------------------
// Griglia Vertical Position Update
//---------------------------------------------------------------------------
static BOOL NEAR UpdateVertBarPositions (PGRIGLIA lpGrigliaStruct) {

    LONG  lCurrPos;        
    WORD  n;    

    lCurrPos = 0;    
    for (n = 0; n < lpGrigliaStruct->wCols; ++n) {    

        lCurrPos += (        
                     (lpGrigliaStruct->lpVertBars + n)->wSize +                     
                     lpGrigliaStruct->xChar / INTERCOLUMN_FACTOR                     
                    );                
        (lpGrigliaStruct->lpVertBars + n)->lPos = lCurrPos;        

    }    
    return (TRUE);    

}

//---------------------------------------------------------------------------
// Griglia Paint Border
//---------------------------------------------------------------------------
void GrigliaPaintBorder (PGRIGLIA lpGrigliaStruct) {
                        
    HDC    hDC;        
    static RECT rRect;
    
    if (hDC = GetDC (lpGrigliaStruct->hWndStatic)) {
    
        // normal border
        GetClientRect (lpGrigliaStruct->hWndStatic, (LPRECT)&rRect);
        DrawFocusRect (hDC,  (LPRECT)&rRect);
    
        ReleaseDC(lpGrigliaStruct->hWndStatic, hDC);
    }
}                                                           

//---------------------------------------------------------------------------
// Griglia Cols
//---------------------------------------------------------------------------
BOOL GrigliaCols (PGRIGLIA lpGrigliaStruct,
                  WORD     wVal) {
    WORD n,
         wPrevVal;                    

    if (wVal == lpGrigliaStruct->wCols) {

        // Update ScrollBar Range                        
        Griglia_HScrollRange (lpGrigliaStruct);                        
        return (FALSE);
    }

    wPrevVal              = lpGrigliaStruct->wCols;
    lpGrigliaStruct->wCols = wVal;
    if (
        (wVal > lpGrigliaStruct->wFixedCols)  &&
        (VertBarBuffer (lpGrigliaStruct))                
       ) {
        for (n = wPrevVal; n < lpGrigliaStruct->wCols; ++n) {
            (lpGrigliaStruct->lpVertBars + n)->wSize   = DEFAULT_XSIZE;
            (lpGrigliaStruct->lpVertBars + n)->wStatus = ENABLE_FLAG;
        }
        UpdateVertBarPositions (lpGrigliaStruct);    

        // Update ScrollBar Range    
        Griglia_HScrollRange (lpGrigliaStruct);    
        return (TRUE);    
    } else {
        lpGrigliaStruct->wCols = wPrevVal;    
        return (FALSE);
    }
}                                

//---------------------------------------------------------------------------
// Griglia Rows
//---------------------------------------------------------------------------
BOOL GrigliaRows (PGRIGLIA lpGrigliaStruct,
                  WORD     wVal) {
    WORD n,
         wPrevVal;                    

    if (wVal == lpGrigliaStruct->wRows) {

        // Update ScrollBar Range                        
        Griglia_VScrollRange (lpGrigliaStruct);                        
        return (FALSE);
    }

    wPrevVal              = lpGrigliaStruct->wRows;
    lpGrigliaStruct->wRows = wVal;
    if (
        (wVal > lpGrigliaStruct->wFixedRows)    &&
        (HorBarBuffer (lpGrigliaStruct))                
       ) {
        for (n = wPrevVal; n < lpGrigliaStruct->wRows; ++n) {
            (lpGrigliaStruct->lpHorBars + n)->wSize   = DEFAULT_YSIZE;
            (lpGrigliaStruct->lpHorBars + n)->wStatus = ENABLE_FLAG;
        }
        UpdateHorBarPositions (lpGrigliaStruct);    

        // Update ScrollBar Range    
        Griglia_VScrollRange (lpGrigliaStruct);    
        return (TRUE);    
    } else {
        lpGrigliaStruct->wRows = wPrevVal;    
        return (FALSE);
    }
}                                

//---------------------------------------------------------------------------
// Griglia control function
//---------------------------------------------------------------------------
LONG _export GrigliaCtlProc (HCTL   hctl,                                        
                             HWND   hWnd,
                             USHORT msg,
                             USHORT wp,
                             LONG   lp) {

    LONG        lResult;    
    PGRIGLIA    lpGrigliaStruct = GRIGLIADEREF(hctl);
    HDC                     hDC;    
    TEXTMETRIC  sTextMetrics;    

    // Message pre-processing
    switch( msg ) {

        case WM_CREATE: {
            SHORT n;

            // Initialize Properties
            lpGrigliaStruct->wRows          = 2;
            lpGrigliaStruct->wCols          = 2;
            lpGrigliaStruct->wFixedRows     = 1;
            lpGrigliaStruct->wFixedCols     = 1;
            lpGrigliaStruct->wRow           = 1;
            lpGrigliaStruct->wCol           = 1;
            lpGrigliaStruct->wRowHeight     = (WORD)VBYPixelsToTwips (DEFAULT_YSIZE);
            lpGrigliaStruct->wColWidth      = (WORD)VBXPixelsToTwips (DEFAULT_XSIZE);
            lpGrigliaStruct->wTopRow        = 1;
            lpGrigliaStruct->wLeftCol       = 1;
            lpGrigliaStruct->wCursorRow     = 1;
            lpGrigliaStruct->wCursorCol     = 1;

            // Initialize Horizontal Grid Pos' and Sizes        
            lpGrigliaStruct->hHorBars   = NULL;        
            lpGrigliaStruct->lpHorBars  = (PGRIGLIABAR)NULL;        
            if (HorBarBuffer (lpGrigliaStruct)) {        
                (lpGrigliaStruct->lpHorBars)->wSize       = DEFAULT_YSIZE;            
                (lpGrigliaStruct->lpHorBars)->wStatus     = ENABLE_FLAG;       
                (lpGrigliaStruct->lpHorBars + 1)->wSize   = DEFAULT_YSIZE;            
                (lpGrigliaStruct->lpHorBars + 1)->wStatus = ENABLE_FLAG;        
                UpdateHorBarPositions (lpGrigliaStruct);            
            }        

            // Initialize Vertical Grid Pos' and Sizes        
            lpGrigliaStruct->hVertBars  = NULL;        
            lpGrigliaStruct->lpVertBars = (PGRIGLIABAR)NULL;        
            if (VertBarBuffer (lpGrigliaStruct)) {        
                (lpGrigliaStruct->lpVertBars)->wSize       = DEFAULT_XSIZE;            
                (lpGrigliaStruct->lpVertBars)->wStatus     = ENABLE_FLAG;              
                (lpGrigliaStruct->lpVertBars + 1)->wSize   = DEFAULT_XSIZE;            
                (lpGrigliaStruct->lpVertBars + 1)->wStatus = ENABLE_FLAG;              
                UpdateVertBarPositions (lpGrigliaStruct);            
            }        

            // Initialize Vertical Scroll Bar
            lpGrigliaStruct->nVScrollPos = 0;
            lpGrigliaStruct->nVScrollMax = 0;
            lpGrigliaStruct->nVScrollInc = 3;
            lpGrigliaStruct->nHScrollPos = 0;
            lpGrigliaStruct->nHScrollMax = 0;
            lpGrigliaStruct->nHScrollInc = 3;

            // Initialize Local Key Input Flags            
            bShiftPressed = FALSE;
            bCtrlPressed  = FALSE;

            // Initialize Cluster Arrays
            for (n = 0; n < ROW_CLUSTER; ++n) {
                lpGrigliaStruct->cRowCluster [n].hCluster  = NULL;
                lpGrigliaStruct->cRowCluster [n].lpCluster = (LPSTR)NULL;
            }

            for (n = 0; n < TEXT_CLUSTER; ++n) {
                lpGrigliaStruct->cTextCluster [n].hCluster  = NULL;
                lpGrigliaStruct->cTextCluster [n].lpCluster = (LPSTR)NULL;
            }

            lpGrigliaStruct->hszText      = (HSZ)NULL;
            lpGrigliaStruct->hszClip      = (HSZ)NULL;
            lpGrigliaStruct->wSelStartRow = 1;
            lpGrigliaStruct->wSelEndRow   = 1;
            lpGrigliaStruct->wSelStartCol = 1;
            lpGrigliaStruct->wSelEndCol   = 1;
            lpGrigliaStruct->lStatus      = 0x00000000;
            lpGrigliaStruct->wEnableCol   = ENABLE_FLAG;
            lpGrigliaStruct->wEnableRow   = ENABLE_FLAG;
            lpGrigliaStruct->wEnableEdit  = ENABLE_FLAG;

            SetRectEmpty ((LPRECT)&rButton);
        }        
        break;        

        case VBM_CREATED:{

            RECT rHwnd;
            int  nTopRim,
                 nBottomRim,
                 nRightRim;

            hInst = VBGetHInstance ();

            //  Set Initial Dimensions
            GetClientRect (hWnd, (LPRECT)&rHwnd);
            nTopRim    = 3 * lpGrigliaStruct->yChar / 2;
            nRightRim  = lpGrigliaStruct->yChar;
            nBottomRim = lpGrigliaStruct->yChar;

            // Set Properties            
            lpGrigliaStruct->hWndControl  = hWnd;    
            lpGrigliaStruct->rControl     = rHwnd;    

            lpGrigliaStruct->rEdit.left   = 0;
            lpGrigliaStruct->rEdit.top    = 0;
            lpGrigliaStruct->rEdit.right  = rHwnd.right;
            lpGrigliaStruct->rEdit.bottom = nTopRim;

            lpGrigliaStruct->rStatic.left   = 0;
            lpGrigliaStruct->rStatic.top    = 0;
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               )
                lpGrigliaStruct->rStatic.top = nTopRim;
            lpGrigliaStruct->rStatic.right  = rHwnd.right;
            lpGrigliaStruct->rStatic.bottom = rHwnd.bottom;

            lpGrigliaStruct->rVScrollBar.left   = rHwnd.right - nRightRim;
            lpGrigliaStruct->rVScrollBar.top    = nTopRim;
            lpGrigliaStruct->rVScrollBar.right  = rHwnd.right;
            lpGrigliaStruct->rVScrollBar.bottom = rHwnd.bottom - nBottomRim;

            lpGrigliaStruct->rHScrollBar.left   = 0;
            lpGrigliaStruct->rHScrollBar.top    = rHwnd.bottom - nBottomRim;
            lpGrigliaStruct->rHScrollBar.right  = rHwnd.right - nRightRim;
            lpGrigliaStruct->rHScrollBar.bottom = rHwnd.bottom;

            // Create Windows
            lpGrigliaStruct->hWndEdit = 0;
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               ) {
                lpGrigliaStruct->hWndEdit = CreateWindow ( "Edit",
                                                        NULL,
                                                        WS_CHILD                |
                                                        WS_BORDER               |
                                                        ES_AUTOHSCROLL  |
                                                        WS_VISIBLE,
                                                        lpGrigliaStruct->rEdit.left,
                                                        lpGrigliaStruct->rEdit.top,
                                                        lpGrigliaStruct->rEdit.right -
                                                        lpGrigliaStruct->rEdit.left,
                                                        lpGrigliaStruct->rEdit.bottom -
                                                        lpGrigliaStruct->rEdit.top,
                                                        hWnd,
                                                        1,
                                                        hInst,
                                                        NULL);

                SendMessage (lpGrigliaStruct->hWndEdit,
                            WM_SETFONT,
                            lpGrigliaStruct->hFont,
                            (LONG)TRUE);
            }

            lpGrigliaStruct->hWndStatic = CreateWindow ("Static",
                                                        NULL,
                                                        WS_CHILD                |
                                                        WS_BORDER               |
                                                        WS_VISIBLE,
                                                        lpGrigliaStruct->rStatic.left,
                                                        lpGrigliaStruct->rStatic.top,
                                                        lpGrigliaStruct->rStatic.right -
                                                        lpGrigliaStruct->rStatic.left,
                                                        lpGrigliaStruct->rStatic.bottom -
                                                        lpGrigliaStruct->rStatic.top,
                                                        hWnd,
                                                        2,
                                                        hInst,
                                                        NULL);

            lpGrigliaStruct->hWndHScrollBar = CreateWindow ( "ScrollBar",
                                                            NULL,
                                                            WS_CHILD                        |
                                                            SBS_HORZ                        |
                                                            SBS_BOTTOMALIGN,
                                                            lpGrigliaStruct->rHScrollBar.left,
                                                            lpGrigliaStruct->rHScrollBar.top,
                                                            lpGrigliaStruct->rHScrollBar.right -
                                                            lpGrigliaStruct->rHScrollBar.left,
                                                            lpGrigliaStruct->rHScrollBar.bottom -
                                                            lpGrigliaStruct->rHScrollBar.top,
                                                            hWnd,
                                                            3,
                                                            hInst,
                                                            NULL);

            lpGrigliaStruct->hWndVScrollBar = CreateWindow ( "ScrollBar",
                                                            NULL,
                                                            WS_CHILD                |
                                                            SBS_VERT                |
                                                            SBS_RIGHTALIGN,
                                                            lpGrigliaStruct->rVScrollBar.left,
                                                            lpGrigliaStruct->rVScrollBar.top,
                                                            lpGrigliaStruct->rVScrollBar.right -
                                                            lpGrigliaStruct->rVScrollBar.left,
                                                            lpGrigliaStruct->rVScrollBar.bottom -
                                                            lpGrigliaStruct->rVScrollBar.top,
                                                            hWnd,
                                                            4,
                                                            hInst,
                                                            NULL);

            // Get new Instance Procs            
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               ) 
                lpfnNewEdit   = MakeProcInstance ((FARPROC)EditWndProc,   hmodDLL);
            lpfnNewStatic = MakeProcInstance ((FARPROC)StaticWndProc, hmodDLL);

            // Get old Instance Procs
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               )
                lpfnOldEdit   = (FARPROC)GetWindowLong (lpGrigliaStruct->hWndEdit,
                                                        GWL_WNDPROC);
            lpfnOldStatic = (FARPROC)GetWindowLong (lpGrigliaStruct->hWndStatic,
                                                    GWL_WNDPROC);                                

            // Set new Procs            
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               )
                SetWindowLong (lpGrigliaStruct->hWndEdit,
                                GWL_WNDPROC,
                                (LONG)lpfnNewEdit);
            SetWindowLong (lpGrigliaStruct->hWndStatic,
                           GWL_WNDPROC,       
                           (LONG)lpfnNewStatic);        

            // Update ScrollBar Range
            Griglia_VScrollRange (lpGrigliaStruct);
            Griglia_HScrollRange (lpGrigliaStruct);
            Griglia_VScrollRange (lpGrigliaStruct);
                
        }
        break;

        case WM_SETFONT: {
            HFONT hOldFont;    

            lpGrigliaStruct->hFont = (HFONT) wp;
            if (
            	(hWnd) &&
            	(hDC = GetDC (hWnd))
               ) {

            	// Select font
            	hOldFont = SelectObject (hDC, lpGrigliaStruct->hFont);
                GetTextMetrics (hDC, (LPTEXTMETRIC) &sTextMetrics);        
            	SelectObject (hDC, hOldFont);

            	// Set parameters
                lpGrigliaStruct->xChar = sTextMetrics.tmMaxCharWidth;        
                lpGrigliaStruct->yChar = sTextMetrics.tmHeight + sTextMetrics.tmExternalLeading;                
               
                // Update positions to reflect font change 
                UpdateHorBarPositions (lpGrigliaStruct);            

                ReleaseDC (hWnd, hDC);        
            }    
    	}
        break;    

        case WM_PAINT: {
            static PAINTSTRUCT pPaint;    

            if (hDC = BeginPaint (hWnd, (LPPAINTSTRUCT)&pPaint)) {    
                WORD wTop, wBottom, wLeft, wRight;                
                HRGN hRgn;                
                RECT rHwnd;                

                // Make white background
                GetClientRect (hWnd, (LPRECT)&rHwnd);
                wTop    = 0;
                wLeft   = 0;
                wBottom = rHwnd.bottom;
                wRight  = rHwnd.right;
                if (hRgn = CreateRectRgn (wLeft, wTop, wRight, wBottom)) {
                        FillRgn (hDC, hRgn, GetStockObject (LTGRAY_BRUSH));
                        DeleteObject (hRgn);
                }
                EndPaint (hWnd, (LPPAINTSTRUCT)&pPaint);        
            }    
       	}
       	break;

       	case WM_SIZE: {
            RECT rHwnd;        
            int  nTopRim,    
                 nBottomRim,         
                 nRightRim;    

            nTopRim    = 3 * lpGrigliaStruct->yChar / 2;
            nRightRim  = lpGrigliaStruct->yChar;
            nBottomRim = lpGrigliaStruct->yChar;

            GetClientRect (hWnd, (LPRECT)&rHwnd);

            lpGrigliaStruct->hWndControl  = hWnd;
            lpGrigliaStruct->rControl     = rHwnd;

            lpGrigliaStruct->rEdit.left   = 0;
            lpGrigliaStruct->rEdit.top    = 0;
            lpGrigliaStruct->rEdit.right  = rHwnd.right;
            lpGrigliaStruct->rEdit.bottom = nTopRim;

            lpGrigliaStruct->rStatic.left   = 0;
            lpGrigliaStruct->rStatic.top    = 0;
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               )
                lpGrigliaStruct->rStatic.top = nTopRim;
            lpGrigliaStruct->rStatic.right  = rHwnd.right;
            lpGrigliaStruct->rStatic.bottom = rHwnd.bottom;

            lpGrigliaStruct->rVScrollBar.left   = rHwnd.right - nRightRim;
            lpGrigliaStruct->rVScrollBar.top    = nTopRim;
            lpGrigliaStruct->rVScrollBar.right  = rHwnd.right;
            lpGrigliaStruct->rVScrollBar.bottom = rHwnd.bottom - nBottomRim;

            lpGrigliaStruct->rHScrollBar.left   = 0;
            lpGrigliaStruct->rHScrollBar.top    = rHwnd.bottom - nBottomRim;
            lpGrigliaStruct->rHScrollBar.right  = rHwnd.right - nRightRim;
            lpGrigliaStruct->rHScrollBar.bottom = rHwnd.bottom;
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               )
                SetWindowPos (lpGrigliaStruct->hWndEdit, NULL,
                            lpGrigliaStruct->rEdit.left, lpGrigliaStruct->rEdit.top,
                            lpGrigliaStruct->rEdit.right - lpGrigliaStruct->rEdit.left,
                            lpGrigliaStruct->rEdit.bottom - lpGrigliaStruct->rEdit.top,
                            SWP_NOZORDER);

            SetWindowPos (lpGrigliaStruct->hWndStatic, NULL,
                          lpGrigliaStruct->rStatic.left, lpGrigliaStruct->rStatic.top,
                          lpGrigliaStruct->rStatic.right - lpGrigliaStruct->rStatic.left,
                          lpGrigliaStruct->rStatic.bottom - lpGrigliaStruct->rStatic.top,
                          SWP_NOZORDER);

            if (IsWindowVisible (lpGrigliaStruct->hWndHScrollBar))
                SetWindowPos (lpGrigliaStruct->hWndHScrollBar, NULL,    
                              lpGrigliaStruct->rHScrollBar.left, lpGrigliaStruct->rHScrollBar.top,                          
                              lpGrigliaStruct->rHScrollBar.right - lpGrigliaStruct->rHScrollBar.left,
                              lpGrigliaStruct->rHScrollBar.bottom - lpGrigliaStruct->rHScrollBar.top,
                              SWP_NOZORDER);

            if (IsWindowVisible (lpGrigliaStruct->hWndVScrollBar))
                SetWindowPos (lpGrigliaStruct->hWndVScrollBar, NULL,
                              lpGrigliaStruct->rVScrollBar.left, lpGrigliaStruct->rVScrollBar.top,
                              lpGrigliaStruct->rVScrollBar.right - lpGrigliaStruct->rVScrollBar.left,
                              lpGrigliaStruct->rVScrollBar.bottom - lpGrigliaStruct->rVScrollBar.top,
                              SWP_NOZORDER);

                // Update ScrollBar Range
                Griglia_VScrollRange (lpGrigliaStruct);
                Griglia_HScrollRange (lpGrigliaStruct);
                Griglia_VScrollRange (lpGrigliaStruct);
        }
        break;        

       	case VBM_GETPROPERTY: {
            switch (wp) {
                case IPROP_GRIGLIA_COLWIDTH: {
                    LPWORD lpTemp;

                    lpTemp  = (LPWORD)lp;
                    *lpTemp = lpGrigliaStruct->wColWidth;
                }
                break;

                case IPROP_GRIGLIA_ROWHEIGHT: {
                    LPWORD lpTemp;

                    lpTemp  = (LPWORD)lp;
                    *lpTemp = lpGrigliaStruct->wRowHeight;
                }
                break;
                
                case IPROP_GRIGLIA_ENABLECOL: {
                    LPWORD lpTemp;

                    lpTemp  = (LPWORD)lp;
                    *lpTemp = (lpGrigliaStruct->lpVertBars + 
                               lpGrigliaStruct->wCol)->wStatus;
                }
                break;

                case IPROP_GRIGLIA_ENABLEROW: {
                    LPWORD lpTemp;

                    lpTemp  = (LPWORD)lp;
                    *lpTemp = (lpGrigliaStruct->lpHorBars + 
                               lpGrigliaStruct->wRow)->wStatus;
                }
                break;

                case IPROP_GRIGLIA_TEXT: {
                    HSZ FAR *lpTemp;
                    LPSTR   lpStr;

                    lpTemp = (HSZ FAR *)lp;
                    if (lpStr = GetCellText (lpGrigliaStruct,
                                             lpGrigliaStruct->wRow,
                                             lpGrigliaStruct->wCol))
                        *lpTemp = VBCreateHsz ((_segment)hctl, lpStr);        
                    else    
                        *lpTemp = VBCreateHsz ((_segment)hctl, (LPSTR)"");        
                }    
                break;    

                case IPROP_GRIGLIA_CLIP:
                    if (lpGrigliaStruct->hWndStatic)                    
                        WriteClip (lpGrigliaStruct, lp, hctl);        
                    break;        

                case IPROP_GRIGLIA_AUTHOR: {                
                    HSZ FAR *lpTemp;                    

                    lpTemp = (HSZ FAR *)lp;                    
                    *lpTemp = VBCreateHsz ((_segment)hctl,    
                                           (LPSTR)"G.V.Guardalben");
                }    
                break;                

                case IPROP_GRIGLIA_COMPANY: {
                    HSZ FAR *lpTemp;    

                    lpTemp = (HSZ FAR *)lp;    
                    *lpTemp = VBCreateHsz ((_segment)hctl,    
	                		  (LPSTR)"Hi.T Srl");
                }    
                break;                

                case IPROP_GRIGLIA_ADDRESS: {                
                    HSZ FAR *lpTemp;                    

                    lpTemp = (HSZ FAR *)lp;                    
                    *lpTemp = VBCreateHsz ((_segment)hctl,    
                                           (LPSTR)"Via Don Carlo Steeb, 7 - 37122 VERONA, ITALY");
                }    
                break;                

                case IPROP_GRIGLIA_DONATION: {                
                    HSZ FAR *lpTemp;                    

                    lpTemp = (HSZ FAR *)lp;                    
                    *lpTemp = VBCreateHsz ((_segment)hctl,    
                                            (LPSTR)"Suggested Donation: $15.00 at address specified in property ADDRESS");          
                }    
                break;                

                case IPROP_GRIGLIA_HWND: {
                    LPWORD lpTemp;            

                    lpTemp  = (LPWORD)lp;
                    *lpTemp = lpGrigliaStruct->hWndControl;
                }
                break;
            }
        }
        break;

       	case VBM_SETPROPERTY: {

            WORD wVal;   

            wVal = LOWORD (lp);    
            switch (wp) {

                case IPROP_GRIGLIA_COLS:
                    if (GrigliaCols (lpGrigliaStruct,
                                     wVal))    
                        InvalidateRect (lpGrigliaStruct->hWndStatic, 
                                        NULL, 
                                        TRUE);    
                    break;

                case IPROP_GRIGLIA_ROWS: 
                    if (GrigliaRows (lpGrigliaStruct,
                                     wVal))    
                        InvalidateRect (lpGrigliaStruct->hWndStatic, 
                                        NULL, 
                                        TRUE);    
                break;

                case IPROP_GRIGLIA_FIXEDROWS:                
                    if (wVal == lpGrigliaStruct->wFixedRows)                
                    break;    

                    if (
                        (wVal < lpGrigliaStruct->wRows) &&    
                        (wVal >= 0)    
                       ) {
                        lpGrigliaStruct->wFixedRows = wVal;        
                        lpGrigliaStruct->wCursorRow = wVal;    
                        VBSetControlProperty (hctl, 
                                              IPROP_GRIGLIA_TOPROW,
                                              MAKELONG (wVal, 0));
                        SetEditText (lpGrigliaStruct,                        
                                     lpGrigliaStruct->wCursorRow,                                     
                                     lpGrigliaStruct->wCursorCol);                                     
                        Griglia_VScrollRange (lpGrigliaStruct);
                        InvalidateRect (lpGrigliaStruct->hWndStatic, NULL, TRUE);                                
                    } else
                        return (INVALID_INPUT);                        
                    break;

                case IPROP_GRIGLIA_FIXEDCOLS:                
                    if (wVal == lpGrigliaStruct->wFixedCols)                
                    break;    

                    if (
                        (wVal < lpGrigliaStruct->wCols) &&    
                        (wVal >= 0)    
                       ) {
                    	lpGrigliaStruct->wFixedCols = wVal;
                    	lpGrigliaStruct->wCursorCol = wVal;
                        VBSetControlProperty (hctl, 
                                              IPROP_GRIGLIA_LEFTCOL,
                                              MAKELONG (wVal, 0));
                        SetEditText (lpGrigliaStruct,                        
                                     lpGrigliaStruct->wCursorRow,                                     
                                     lpGrigliaStruct->wCursorCol);                                     
                        Griglia_HScrollRange (lpGrigliaStruct);
                        InvalidateRect (lpGrigliaStruct->hWndStatic, NULL, TRUE);                      
                    } else
                        return (INVALID_INPUT);                        
                    break;

                case IPROP_GRIGLIA_ROW:                
                    if (wVal == lpGrigliaStruct->wRow)                
                    	break;

                    if (
                        (wVal < lpGrigliaStruct->wRows) &&    
                        (wVal >= 0)    
                       ) {
                    	lpGrigliaStruct->wRow       = wVal;
                        lpGrigliaStruct->wRowHeight = 
                            (WORD)VBYPixelsToTwips (                                                  
                                                    (lpGrigliaStruct->lpHorBars +                                                                              
                                                    lpGrigliaStruct->wRow)->wSize                                                                                          
                                                   );                                                                             
                    } else
                        return (INVALID_INPUT);                        
                    break;

                case IPROP_GRIGLIA_COL:                
                    if (wVal == lpGrigliaStruct->wCol)                
                    	break;

                    if (                    
                        (wVal < lpGrigliaStruct->wCols) &&                        
                        (wVal >= 0)                        
                       ) {                   
                    	lpGrigliaStruct->wCol       = wVal;
                        lpGrigliaStruct->wColWidth  = 
                            (WORD)VBXPixelsToTwips (                                                                     
                                                    (lpGrigliaStruct->lpVertBars +                                             
                                                    lpGrigliaStruct->wCol)->wSize                                                                     
                                                   );                                                                    
                    } else
                        return (INVALID_INPUT);                        
                    break;

                case IPROP_GRIGLIA_ROWHEIGHT:                
                    if (VBYTwipsToPixels (wVal) == (SHORT)
                            (lpGrigliaStruct->lpHorBars +                            
                             lpGrigliaStruct->wRow)->wSize)                                                                               
                    	break;

                    if (wVal >= 0) {                    
                        lpGrigliaStruct->wRowHeight = wVal;    
                        (lpGrigliaStruct->lpHorBars +                        
                            lpGrigliaStruct->wRow)->wSize = VBYTwipsToPixels (wVal);                     
                        UpdateHorBarPositions (lpGrigliaStruct);                        
                        Griglia_VScrollRange (lpGrigliaStruct);

                        InvalidateRect (lpGrigliaStruct->hWndStatic, NULL, TRUE);                        
                    } else
                        return (INVALID_INPUT);                        
                    break;

                case IPROP_GRIGLIA_COLWIDTH:                
                    if (VBXTwipsToPixels (wVal) == (SHORT)
                        (lpGrigliaStruct->lpVertBars +                
                        lpGrigliaStruct->wCol)->wSize)                                                                                           
                    	break;

                    if (wVal >= 0) {                    
                    	lpGrigliaStruct->wColWidth  = wVal;
                        (lpGrigliaStruct->lpVertBars +                        
                        lpGrigliaStruct->wCol)->wSize = VBXTwipsToPixels (wVal);                         
                        UpdateVertBarPositions (lpGrigliaStruct);                        
                        Griglia_HScrollRange (lpGrigliaStruct);                        

                        InvalidateRect (lpGrigliaStruct->hWndStatic, NULL, TRUE);                        
                    } else
                        return (INVALID_INPUT);                        
                    break;

                case IPROP_GRIGLIA_TOPROW:                
                        if (wVal == lpGrigliaStruct->wTopRow)                
                    	break;

                        if (wVal >= lpGrigliaStruct->wFixedRows) {
                            lpGrigliaStruct->wTopRow = wVal;
                            Griglia_VScroll (lpGrigliaStruct,        
                                            SB_THUMBTRACK,                         
                                            MAKELONG (wVal -                         
                                                      lpGrigliaStruct->wFixedRows,                                       
                                                      0));                                   
                        }    
                    break;

                case IPROP_GRIGLIA_LEFTCOL:                
                    if (wVal == lpGrigliaStruct->wLeftCol)                
                    	break;

                    if (wVal >= lpGrigliaStruct->wFixedCols) {
                        lpGrigliaStruct->wLeftCol = wVal;
                        Griglia_HScroll (lpGrigliaStruct,        
                                        SB_THUMBTRACK,                         
                                        MAKELONG (wVal -                         
                                                lpGrigliaStruct->wFixedCols,                                   
                                                0));                                       
                        }
                    break;

                case IPROP_GRIGLIA_CURSORROW:                
                    if (wVal == lpGrigliaStruct->wCursorRow) {                
                        lpGrigliaStruct->wRow           = wVal;                
                    	break;
                    }

                    if (
                        (wVal >= lpGrigliaStruct->wFixedRows) &&
                        (wVal < lpGrigliaStruct->wRows)
                       ) {
                        WORD wOldRow, wOldCol;

                        PaintCursor (lpGrigliaStruct);
                        wOldRow = lpGrigliaStruct->wCursorRow;        
                        wOldCol = lpGrigliaStruct->wCursorCol;        
                        lpGrigliaStruct->wCursorRow   = wVal;
                        lpGrigliaStruct->wRow         = wVal;
                        lpGrigliaStruct->wSelStartRow = wVal;
                        lpGrigliaStruct->wSelEndRow   = wVal;
                        SetEditText (lpGrigliaStruct,        
                                    lpGrigliaStruct->wCursorRow,                     
                                    lpGrigliaStruct->wCursorCol);                     
                        PaintCursor (lpGrigliaStruct);
                        FireChangeEvent (hctl, wOldRow, wOldCol, NULL);        
                    }    
                    break;

                case IPROP_GRIGLIA_CURSORCOL:                
                    if (wVal == lpGrigliaStruct->wCursorCol) {                
                        lpGrigliaStruct->wCol           = wVal;                
                    	break;
                    }

                    if (
                        (wVal >= lpGrigliaStruct->wFixedCols) &&
                        (wVal < lpGrigliaStruct->wCols)
                       ) {
                        WORD wOldRow, wOldCol;

                        PaintCursor (lpGrigliaStruct);
                        wOldRow = lpGrigliaStruct->wCursorRow;        
                        wOldCol = lpGrigliaStruct->wCursorCol;        
                        lpGrigliaStruct->wCursorCol   = wVal;
                        lpGrigliaStruct->wCol         = wVal;
                        lpGrigliaStruct->wSelStartCol = wVal;
                        lpGrigliaStruct->wSelEndCol   = wVal;
                        SetEditText (lpGrigliaStruct,        
                                    lpGrigliaStruct->wCursorRow,                     
                                    lpGrigliaStruct->wCursorCol);                     
                        PaintCursor (lpGrigliaStruct);
                        FireChangeEvent (hctl, wOldRow, wOldCol, NULL);        
                    }    
                    break;

                case IPROP_GRIGLIA_ENABLEEDIT:
                    (lpGrigliaStruct->wEnableEdit) = wVal;
                    if (
                        (wVal == ERASE_FLAG)         ||
                        (wVal == ERASE_DISABLE_FLAG)
                       ) {
                        if (lpGrigliaStruct->hWndEdit) 
                            SendMessage (lpGrigliaStruct->hWndEdit, 
                                         WM_CLOSE, NULL, NULL);
                    }    
                    break;

                case IPROP_GRIGLIA_ENABLECOL:
                    (lpGrigliaStruct->lpVertBars + 
                        lpGrigliaStruct->wCol)->wStatus = wVal;
                    break;

                case IPROP_GRIGLIA_ENABLEROW:              
                    (lpGrigliaStruct->lpHorBars + 
                        lpGrigliaStruct->wRow)->wStatus = wVal;
                    break;

                case IPROP_GRIGLIA_TEXT:
                    if (lpGrigliaStruct->hWndStatic) {    
                        if (PutCellText (lpGrigliaStruct,
                                        lpGrigliaStruct->wRow,                 
                                        lpGrigliaStruct->wCol,                 
                                        (LPSTR)lp)) {                 

                            // Fill cell
                            SetCellText (lpGrigliaStruct,
                                         lpGrigliaStruct->wRow,    
                                         lpGrigliaStruct->wCol,    
                                         (LPSTR)lp);    

                            // Set Edit Text
                            if (    
                                (lpGrigliaStruct->wRow ==        
                                lpGrigliaStruct->wCursorRow) &&        
                                (lpGrigliaStruct->wCol ==        
                                lpGrigliaStruct->wCursorCol)         
                               )    
                                SetEditText (lpGrigliaStruct,        
                                             lpGrigliaStruct->wRow,                     
                                             lpGrigliaStruct->wCol);                     

                                if (lpGrigliaStruct->hszText)        
                                    VBDestroyHsz (lpGrigliaStruct->hszText);            
                            lpGrigliaStruct->hszText =
                                    VBCreateHsz ((_segment)hctl,(LPSTR)lp);
                            break;
                        }
                    }
                    break;    

                case IPROP_GRIGLIA_AUTHOR:
                case IPROP_GRIGLIA_COMPANY:
                case IPROP_GRIGLIA_ADDRESS:
                case IPROP_GRIGLIA_DONATION:
                    break;    

                case IPROP_GRIGLIA_CLIP:
                    if (lpGrigliaStruct->hWndStatic) {    
                        //PaintBlock (lpGrigliaStruct);    
                        ReadClip (lpGrigliaStruct, lp, hctl);
                        //PaintBlock (lpGrigliaStruct);    
                        SetEditText (lpGrigliaStruct,        
                                     lpGrigliaStruct->wCursorRow,                     
                                     lpGrigliaStruct->wCursorCol);                     
                    }        
                    break;    

                case IPROP_GRIGLIA_SELSTARTROW:
                    if (wVal == lpGrigliaStruct->wSelStartRow)
                        break;

                    if (
                        (wVal < lpGrigliaStruct->wRows) &&    
                        (wVal >= 0)    
                       ) {
                        PaintBlock (lpGrigliaStruct);
                        lpGrigliaStruct->wSelStartRow = wVal;
                        PaintBlock (lpGrigliaStruct);                    
                    } else
                        return (INVALID_INPUT);                        
                    break;

                case IPROP_GRIGLIA_SELENDROW:            
                    if (wVal == lpGrigliaStruct->wSelEndRow)            
                        break;

                    if (
                        (wVal < lpGrigliaStruct->wRows) &&    
                        (wVal >= 0)    
                       ) {
                        PaintBlock (lpGrigliaStruct);
                        lpGrigliaStruct->wSelEndRow = wVal;
                        PaintBlock (lpGrigliaStruct);                    
                    } else
                        return (INVALID_INPUT);                        
                    break;


                case IPROP_GRIGLIA_SELSTARTCOL:            
                    if (wVal == lpGrigliaStruct->wSelStartCol)            
                        break;

                    if (                
                        (wVal < lpGrigliaStruct->wCols) &&                    
                        (wVal >= 0)                    
                       ) {               
                        PaintBlock (lpGrigliaStruct);                
                        lpGrigliaStruct->wSelStartCol = wVal;
                        PaintBlock (lpGrigliaStruct);                    
                    } else
                        return (INVALID_INPUT);                    
                    break;

                case IPROP_GRIGLIA_SELENDCOL:            
                    if (wVal == lpGrigliaStruct->wSelEndCol)            
                        break;    

                    if (                
                        (wVal < lpGrigliaStruct->wCols) &&                    
                        (wVal >= 0)                    
                       ) {               
                        PaintBlock (lpGrigliaStruct);                
                        lpGrigliaStruct->wSelEndCol = wVal;
                        PaintBlock (lpGrigliaStruct);                
                    } else
                        return (INVALID_INPUT);                    
                break;

            }
        }
        break;

        case WM_VSCROLL:
            Griglia_VScroll (lpGrigliaStruct, wp, lp);    
            break;    
                    
        case WM_HSCROLL:
            Griglia_HScroll (lpGrigliaStruct, wp, lp);    
            break;    

        case WM_MOUSEMOVE: {
            POINT pPoint;    
            RECT  rStatic,    
                  rEdit;        
            static HCURSOR hOld;    

            GetCursorPos ((LPPOINT)&pPoint);
            GetWindowRect (lpGrigliaStruct->hWndStatic, (LPRECT)&rStatic);
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               )
                GetWindowRect (lpGrigliaStruct->hWndEdit, (LPRECT)&rEdit);

            if (wp & MK_LBUTTON) {

                if (        
                    (PtInRect ((LPRECT)&rStatic, pPoint)) &&
                    //(
                    // (hWnd == GetFocus ()) ||
                    // (lpGrigliaStruct->hWndStatic == GetFocus ())
                    //) &&
                    (!IsIconic (GetParent (hWnd)))
                   ) {
                    ScreenToClient (lpGrigliaStruct->hWndStatic,    
                                    (LPPOINT)&pPoint);                            
                    if (!LBlockButtonDown (lpGrigliaStruct, pPoint))            
                        LMouseMoveDown (lpGrigliaStruct, pPoint);                
                }        
            }    
        }
        return (1);    

        case WM_LBUTTONUP: {
            POINT  pPoint;
            
            GetCursorPos ((LPPOINT)&pPoint);    
            ScreenToClient (lpGrigliaStruct->hWndStatic,            
                            (LPPOINT)&pPoint);                                
            LButtonUp (lpGrigliaStruct, pPoint);                    
        }    
        break;    

        case WM_LBUTTONDOWN: {
            POINT  pPoint;
            RECT   rStatic;
            WORD   wOldRow, wOldCol;
            SHORT  nLen;
            HANDLE hOldText;
            LPSTR  lpOldpStr;
            PSTR   pOldStr;
                                    
            // retrieve previous text value
            lpOldpStr = GetCellText (lpGrigliaStruct,
                                     lpGrigliaStruct->wCursorRow,                     
                                     lpGrigliaStruct->wCursorCol);                         

            // get its size
            nLen = 0;
            if (lpOldpStr)
                nLen = lstrlen (lpOldpStr);    

            // try to store it
            if ( hOldText = LocalAlloc ( LHND, nLen + 3)) {
            	pOldStr = (PSTR) LocalLock (hOldText);
                if (lpOldpStr)                
                    lstrcpy (pOldStr, lpOldpStr);    
                else
                    lstrcpy (pOldStr, "");    
            } else {            
                hOldText = NULL;                
                pOldStr  = (PSTR)NULL;                
            }            

            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               ) {
                HANDLE hText;
                PSTR   pStr;

                // Save content of current edit box
                nLen = GetWindowTextLength (lpGrigliaStruct->hWndEdit);
                if ( hText = LocalAlloc ( LHND,
                                          nLen + 3) ) {
                    pStr = (PSTR) LocalLock (hText);
                    GetWindowText (lpGrigliaStruct->hWndEdit,
                                   (LPSTR)pStr, nLen + 1);

                    if (PutCellText (lpGrigliaStruct,
                                    lpGrigliaStruct->wCursorRow,
                                    lpGrigliaStruct->wCursorCol,
                                    (LPSTR)pStr)) {
                        SetCellText (lpGrigliaStruct,
                                    lpGrigliaStruct->wCursorRow,
                                    lpGrigliaStruct->wCursorCol,
                                    pStr);
                    }
                    LocalUnlock (hText);
                    LocalFree (hText);
                }
            }            

            // move to new position
            GetCursorPos ((LPPOINT)&pPoint);    
            GetWindowRect (lpGrigliaStruct->hWndStatic,    
                            (LPRECT)&rStatic);               
            if (PtInRect ((LPRECT)&rStatic, pPoint)) {    
                ScreenToClient (lpGrigliaStruct->hWndStatic,        
                                (LPPOINT)&pPoint);                        
                wOldRow = lpGrigliaStruct->wCursorRow;                
                wOldCol = lpGrigliaStruct->wCursorCol;                
                LButtonDown (lpGrigliaStruct, pPoint);                

                if (pOldStr)                
                    FireChangeEvent (hctl,                    
                                     wOldRow,                                     
                                     wOldCol,
                                     (LPSTR)pOldStr
                                    );                        
                else                
                    FireChangeEvent(hctl,                    
                                    wOldRow,                                        
                                    wOldCol,                                         
                                    (LPSTR)""                             
                                   );                                
                
                if (
                    (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                    (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
                   ) {
                    PostMessage (lpGrigliaStruct->hWndEdit,
                                 WM_ACTIVATE, 1, MAKELONG (0, hWnd));
                    PostMessage (lpGrigliaStruct->hWndEdit,
                                 EM_SETSEL, NULL,
                                 MAKELONG(0, -1));
                    //PostMessage (lpGrigliaStruct->hWndControl,
                    //             WM_SETFOCUS, NULL, (LONG)NULL);
                } else {
                    PostMessage (lpGrigliaStruct->hWndControl,
                                 WM_ACTIVATE, 1, MAKELONG (0, hWnd));
                    if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                        DisplayPosition (lpGrigliaStruct);
                }
                    
                // OFF EDIT MODE    
                lpGrigliaStruct->lStatus &= RES_EDIT_FLAG;    

            }            
            if (hOldText) {    
                LocalUnlock (hOldText);        
            	LocalFree (hOldText);
            }    
        }        
        break;    

        case WM_KEYDOWN:
            KeyDown (hctl, hWnd, wp);
            break;

        case WM_CHAR:
            Wm_Character (hctl, hWnd, wp);
            break;

        case WM_KEYUP:
            KeyUp (hctl, hWnd, wp);
            break;

        case WM_GETFONT:
            return (lpGrigliaStruct->hFont);

        case WM_DESTROY: {        
            int n;            

            // RELEASE HORIZONTAL BAR BUFFER
            if (lpGrigliaStruct->hHorBars) {
                GlobalUnlock (lpGrigliaStruct->hHorBars);        
                GlobalFree   (lpGrigliaStruct->hHorBars);    
                lpGrigliaStruct->hHorBars  = (HANDLE)NULL;    
                lpGrigliaStruct->lpHorBars = (PGRIGLIABAR)NULL;    
            }

            // RELEASE VERTICAL BAR BUFFER
            if (lpGrigliaStruct->hVertBars) {
                GlobalUnlock (lpGrigliaStruct->hVertBars);    
                GlobalFree   (lpGrigliaStruct->hVertBars);    
                lpGrigliaStruct->hVertBars  = (HANDLE)NULL;    
                lpGrigliaStruct->lpVertBars = (PGRIGLIABAR)NULL;    
            }

            // Release Text Blocks
            for (n = 0; n < (int) ROW_CLUSTER; ++n) {
                if (lpGrigliaStruct->cRowCluster [n].hCluster) {    
                    GlobalUnlock (lpGrigliaStruct->cRowCluster [n].hCluster);        
                    GlobalFree   (lpGrigliaStruct->cRowCluster [n].hCluster);        
                    lpGrigliaStruct->cRowCluster [n].hCluster  = (HANDLE)NULL;        
                    lpGrigliaStruct->cRowCluster [n].lpCluster = (LPSTR)NULL;        
                }    
            }

            // Release Text Blocks
            for (n = 0; n < TEXT_CLUSTER; ++n) {
                if (lpGrigliaStruct->cTextCluster [n].hCluster) {    
                    GlobalUnlock (lpGrigliaStruct->cTextCluster [n].hCluster);        
                    GlobalFree   (lpGrigliaStruct->cTextCluster [n].hCluster);        
                    lpGrigliaStruct->cTextCluster [n].hCluster  = (HANDLE)NULL;        
                    lpGrigliaStruct->cTextCluster [n].lpCluster = (LPSTR)NULL;        
                }    
            }
        }        
        break;        
        
        case WM_SETFOCUS:
        case WM_KILLFOCUS: 
            GrigliaPaintBorder (lpGrigliaStruct);
            if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                DisplayPosition (lpGrigliaStruct);
            break;                

    }
    // Default processing:
    lResult = VBDefControlProc (hctl, hWnd, msg, wp, lp);
    return lResult;
}
