//---------------------------------------------------------------------------
// Griglia.h
//---------------------------------------------------------------------------

#define	INVALID_INPUT				380L
#define DEFAULT_XSIZE				50
#define DEFAULT_YSIZE				15
#define INTERCOLUMN_FACTOR			3
#define INVALID_POS				0xffffffff
#define PUSH_V_SIZE				28
#define PUSH_H_SIZE				28
#define PUSH_V_GRID				14
#define PUSH_H_GRID				14
#define	TEXT_CLUSTER				50
#define ROW_CLUSTER				25
#define ROW_CLUSTER_SIZE			0xffff
#define TEXT_CLUSTER_SIZE			0xffff

#define EDIT_FLAG				0x00000001
#define RES_EDIT_FLAG                           0xfffffffe

#define DISABLE_FLAG                            0x0000
#define ENABLE_FLAG                             0x0001 
#define ERASE_FLAG                              0x0002
#define ERASE_DISABLE_FLAG                      0x0003
#define SMALL_RIM                               2

//---------------------------------------------------------------------------
// Extern Variables
//---------------------------------------------------------------------------
extern          HANDLE  hmodDLL;
extern		HANDLE	hInst;
extern          FARPROC lpfnOldEdit;
extern          FARPROC lpfnOldStatic;
extern		HPEN	hDashedPen,
			hCursorPen;
extern          BOOL    bShiftPressed,
			bCtrlPressed,
			nRepeatKey;
extern			HCURSOR hCursorCross,
				hCursorIBeam,
				hCursorStndr;
extern          RECT    rButton;

//---------------------------------------------------------------------------
// Helpful Macros
//---------------------------------------------------------------------------
#define OFFSETIN( struc, field )  ( (USHORT)&( ((struc *)0)->field ) )

//---------------------------------------------------------------------------
// Resource ID's
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs numbers must be consecutive from N to N+5
//---------------------------------------------------------------------------
#define IDBMP_GRIGLIA              7000
#define IDBMP_GRIGLIADOWN          7001
#define IDBMP_GRIGLIAMONO          7003
#define IDBMP_GRIGLIAMONODOWN      7004
#define IDBMP_GRIGLIAEGA           7006
#define IDBMP_GRIGLIAEGADOWN       7007

//---------------------------------------------------------------------------
// LOCAL control data and structs
//---------------------------------------------------------------------------
typedef struct tagList {

    LONG    lPos;                       // Grid Line/Col Position                                        
    WORD    wSize;                      // Grid Line/Col Size                                        
    WORD    wStatus;                    // Grid Line/Col Status

} GRIGLIABAR;
typedef GRIGLIABAR FAR * PGRIGLIABAR;

typedef struct CLUSTER {

    HANDLE  hCluster;                   // Cluster Handle                                        
    LPSTR   lpCluster;                  // Cluster Pointer                                        

} CLUSTER;
typedef CLUSTER FAR * PCLUSTER;

typedef struct {

    HLSTR hlsPropStr;    
    LPINT lpY;    
    LPINT lpX;    
    LPVOID Index;    

} CHANGE_PARAMS;

//---------------------------------------------------------------------------
// GRIGLIA control data and structs
//---------------------------------------------------------------------------
typedef struct {

    // PROPERTIES
    WORD    wRows;                              // Total Number of Rows
    WORD    wCols;                              // Total Number of Cols
    WORD    wFixedRows;                         // Total Number of Fixed Rows
    WORD    wFixedCols;                         // Total Number of Fixed Cols
    WORD    wCol;                               // Selected Column
    WORD    wRow;                               // Selected Row
    WORD    wColWidth;                          // Selected Column Width
    WORD    wRowHeight;                         // Selected Row Width
    WORD    wTopRow;                            // Visible Top Row
    WORD    wLeftCol;                           // Visible Left Col
    WORD    wCursorRow;                         // Cursor Row
    WORD    wCursorCol;                         // Cursor Col
    HSZ     hszText;                            // Text        
    HSZ     hszClip;                            // Clip        
    WORD    wSelStartRow;                       // Selection Start Row                    
    WORD    wSelEndRow;                         // Selection End Row                            
    WORD    wSelStartCol;                       // Selection Start Col
    WORD    wSelEndCol;                         // Selection End Col                            
    WORD    wEnableCol;                         // Enable/Disable Col                           
    WORD    wEnableRow;                         // Enable/Disable Row                           
    WORD    wEnableEdit;                        // Enable/Disable Edit Box                      
    WORD    wEnableScrollBars;                  // Enable/Disable Scroll Bars                   
    HSZ     hszAuthor;                          // Author Name                                            
    HSZ     hszCompany;                         // Company Name                                                
    HSZ     hszAddress;                         // Company Address                                            
    HSZ     hszDonation;                        // Suggested Donation                                    
    HWND    hWndControl;                        // Whole Control Handle                        

    // NOT PROPERTIES
    RECT    rControl;                           // Whole Control Dimensions                        
    RECT    rStatic;                            // Static Box Dimensions                                
    HWND    hWndStatic;                         // Static Box Handle                        
    RECT    rEdit;                              // Edit Box Dimensions
    HWND    hWndEdit;                           // Edit Box Handle
    RECT    rHScrollBar;                        // Vertical ScrollBar Dims
    HWND    hWndHScrollBar;                     // Vertical ScrollBar Handle
    RECT    rVScrollBar;                        // Horizontal ScrollBar Dims
    HWND    hWndVScrollBar;                     // Horizontal ScrollBar Handle
    HFONT   hFont;                              // Control Font
    int     xChar;                              // Char X Dimension
    int     yChar;                              // Char Y Dimension
    HANDLE  hHorBars;                           // Horizontal Bar Pos Handle
    PGRIGLIABAR
            lpHorBars;                          // Horizontal Bar Pos Pointer    
    HANDLE  hVertBars;                          // Vertical Bar Pos Handle    
    PGRIGLIABAR                                 // Vertical Bar Pos Pointer
            lpVertBars;    
    SHORT   nVScrollPos;                        // Current Vert Scroll Position
    SHORT   nVScrollMax;                        // Max Vert Scroll
    SHORT   nVScrollInc;                        // Unit Vert Scroll Increment
    SHORT   nHScrollPos;                        // Current Horz Scroll Position
    SHORT   nHScrollMax;                        // Max Horz Scroll
    SHORT   nHScrollInc;                        // Unit Horz Scroll Increment
    CLUSTER cRowCluster  [ROW_CLUSTER];         // Pointers to Cell Pointer Buffer
    CLUSTER cTextCluster [TEXT_CLUSTER];        // Pointers to Linear Text Buffer
    LONG    lStatus;                            // Status Flag

} GRIGLIA;
typedef GRIGLIA FAR * PGRIGLIA;

#define GRIGLIADEREF(hctl)   ((PGRIGLIA) VBDerefControl (hctl))

#include	"gridapi.h"

//---------------------------------------------------------------------------
// Control Procedure
//---------------------------------------------------------------------------
LONG _export GrigliaCtlProc( HCTL, HWND, USHORT, USHORT, LONG );

// GRIGLIA EXTERNAL PROCEDURES
LONG _export 	EditWndProc			(HWND, unsigned, WORD, LONG);
LONG _export    StaticWndProc                   (HWND, unsigned, WORD, LONG);
LONG _export    ScrollWndProc                   (HWND, unsigned, WORD, LONG);
VOID            FireChangeEvent                 (HCTL, WORD, WORD, LPSTR);
void            GrigliaPaintBorder              (PGRIGLIA);                        
BOOL            GrigliaCols                     (PGRIGLIA, WORD);                        
BOOL            GrigliaRows                     (PGRIGLIA, WORD);                        

// subclass.c
BOOL                    PaintButtonUp           (HDC, UINT, UINT, UINT, UINT);
BOOL                    PaintButtonDown         (HDC, UINT, UINT, UINT, UINT);
BOOL                    PaintTastoSu            (PGRIGLIA, HDC, RECT);
BOOL                    PaintBackground         (PGRIGLIA, HDC, RECT);
BOOL                    PaintVertBars           (PGRIGLIA, HDC, RECT);
BOOL                    PaintHorBars            (PGRIGLIA, HDC, RECT);
BOOL                    PaintCursorLocal        (PGRIGLIA, HDC);
void			GrigliaLibLoad		(void);
void			GrigliaLibUnload	(void);
LONG                    Griglia_VScroll         (PGRIGLIA, WORD, LONG);    
void                    Griglia_VScrollRange    (PGRIGLIA);
LONG                    Griglia_HScroll         (PGRIGLIA, WORD, LONG);    
void                    Griglia_HScrollRange    (PGRIGLIA);
BOOL 			PaintCursor 		(PGRIGLIA);
LONG 		 	Griglia_VertPos 	(WORD, PGRIGLIA);
LONG 			Griglia_HorPos 		(WORD, PGRIGLIA);

// cursor.c
BOOL                    ResetRow                (PGRIGLIA, WORD);
BOOL                    ResetCol                (PGRIGLIA, WORD);
BOOL 			MoveCursorRight		(PGRIGLIA);
BOOL 			MoveCursorLeft 		(PGRIGLIA);
BOOL 			MoveCursorUp		(PGRIGLIA);
BOOL 			MoveCursorDown		(PGRIGLIA);
BOOL 			MoveCursorHome 		(PGRIGLIA, BOOL);
BOOL 			MoveCursorEnd 		(PGRIGLIA, BOOL);
BOOL 			MoveCursorPrior		(PGRIGLIA, BOOL);
BOOL 			MoveCursorNext		(PGRIGLIA, BOOL);
void 			LButtonDown 		(PGRIGLIA, POINT);
void                    LButtonUp               (PGRIGLIA, POINT);
BOOL 			PaintBlockLocal 	(PGRIGLIA, HDC);
BOOL                    PaintBlock              (PGRIGLIA);        
void 			LMouseMoveDown 		(PGRIGLIA, POINT);
BOOL 			LBlockButtonDown 	(PGRIGLIA, POINT);

// text.c
BOOL                    PaintText               (PGRIGLIA, HDC, RECT);        
LPSTR 			GetCellText 		(PGRIGLIA, WORD, WORD);
LPSTR                   GetCellText_Ext         (PGRIGLIA, WORD, WORD,
                                                 LPEXT_INPUT);
BOOL                    SetEditText             (PGRIGLIA, WORD, WORD);        
BOOL 			SetCellText 		(PGRIGLIA, WORD, WORD, LPSTR);
BOOL 			PutCellText 		(PGRIGLIA, WORD, WORD, LPSTR);
BOOL                    PutCellText_Ext         (PGRIGLIA, WORD, WORD,
                                                 LPEXT_INPUT, LPSTR);
BOOL                    WriteClip               (PGRIGLIA, LONG, HCTL);        
BOOL                    ReadClip                (PGRIGLIA, LONG, HCTL);        
BOOL 			InsertLinesText 	(PGRIGLIA, WORD, WORD);
BOOL 			DeleteLinesText 	(PGRIGLIA, WORD, WORD);
BOOL                    FindText                (PGRIGLIA, LPFINDTEXT);        
void                    ClearText               (PGRIGLIA);        
SHORT                   CompareLines            (PGRIGLIA, LPFINDTEXT, UINT, UINT);
void                    SwitchLines             (PGRIGLIA, UINT, UINT);
void                    SortText                (PGRIGLIA, LPFINDTEXT);
void                    InsertCellsText         (PGRIGLIA, WORD, WORD, WORD);

// util.c
BOOL                    CellLRRect              (PGRIGLIA, UINT, LPRECT);
BOOL                    CellTBRect              (PGRIGLIA, UINT, LPRECT);
BOOL                    CellRect                (PGRIGLIA, UINT, UINT, LPRECT);
BOOL                    BlockLRRect             (PGRIGLIA, UINT, UINT, LPRECT);
BOOL                    BlockTBRect             (PGRIGLIA, UINT, UINT, LPRECT);
BOOL                    BlockRect               (PGRIGLIA, UINT, UINT, 
                                                 UINT, UINT, LPRECT);
BOOL                    FindCell                (PGRIGLIA, LPPOINT, POINT);
void                    KeyUp                   (HCTL, HWND, WORD);
void                    KeyDown                 (HCTL, HWND, WORD);
void                    Wm_Character            (HCTL, HWND, WORD);
void                    DisplayPosition         (PGRIGLIA);

// ext.c
void                    RepaintGrid             (PGRIGLIA, BOOL);
void                    InsertCellsText         (PGRIGLIA, WORD, WORD, WORD);
void                    LineBreakText           (PGRIGLIA, WORD, WORD);
void                    DeleteCellsText         (PGRIGLIA, WORD, WORD, WORD);
void                    RemoveLineBreakText     (PGRIGLIA, WORD, WORD);
void                    MoveWordTextRight       (PGRIGLIA, WORD, WORD);
void                    MoveWordTextLeft        (PGRIGLIA, WORD, WORD);
void                    ShiftWordTextRight      (PGRIGLIA, WORD, WORD);
void                    ShiftWordTextLeft       (PGRIGLIA, WORD, WORD);
void                    Just                    (PGRIGLIA, WORD, WORD, WORD, WORD, BYTE);
BOOL                    PaintTextCell_Ext       (HDC, RECT, LPEXT_INPUT, LPSTR);

#ifndef RC_INVOKED

//---------------------------------------------------------------------------
// Property GRIGLIA
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------
#define IPROP_GRIGLIA_NAME           	0x0000
#define IPROP_GRIGLIA_INDEX          	0x0001
#define IPROP_GRIGLIA_PARENT         	0x0002
#define IPROP_GRIGLIA_BACKCOLOR      	0x0003
#define IPROP_GRIGLIA_FORECOLOR      	0x0004
#define IPROP_GRIGLIA_LEFT           	0x0005
#define IPROP_GRIGLIA_TOP            	0x0006
#define IPROP_GRIGLIA_WIDTH          	0x0007

#define IPROP_GRIGLIA_HEIGHT         	0x0008
#define IPROP_GRIGLIA_FONTNAME       	0x0009
#define IPROP_GRIGLIA_FONTSIZE       	0x000A
#define IPROP_GRIGLIA_FONTBOLD       	0x000B
#define IPROP_GRIGLIA_FONTITALIC     	0x000C
#define IPROP_GRIGLIA_FONTSTRIKE     	0x000D
#define IPROP_GRIGLIA_FONTUNDER      	0x000E
#define IPROP_GRIGLIA_TABINDEX       	0x000F

#define IPROP_GRIGLIA_TABSTOP        	0x0010
#define IPROP_GRIGLIA_DRAGMODE       	0x0011
#define IPROP_GRIGLIA_DRAGICON       	0x0012
#define IPROP_GRIGLIA_ENABLED        	0x0013
#define IPROP_GRIGLIA_VISIBLE        	0x0014
#define IPROP_GRIGLIA_TAG            	0x0015
#define IPROP_GRIGLIA_MOUSEPOINTER   	0x0016

// defined in gridapi.h
//#define IPROP_GRIGLIA_ROWS            0x0017                
//#define IPROP_GRIGLIA_COLS            0x0018                
//#define IPROP_GRIGLIA_FIXEDROWS      	0x0019
//#define IPROP_GRIGLIA_FIXEDCOLS      	0x001A
//#define IPROP_GRIGLIA_ROW            	0x001B
//#define IPROP_GRIGLIA_COL            	0x001C
//#define IPROP_GRIGLIA_ROWHEIGHT      	0x001D
//#define IPROP_GRIGLIA_COLWIDTH       	0x001E
//#define IPROP_GRIGLIA_TOPROW         	0x001F
//#define IPROP_GRIGLIA_LEFTCOL        	0x0020
//#define IPROP_GRIGLIA_CURSORROW      	0x0021
//#define IPROP_GRIGLIA_CURSORCOL      	0x0022
//#define IPROP_GRIGLIA_TEXT            0x0023
//#define IPROP_GRIGLIA_CLIP            0x0024
//#define IPROP_GRIGLIA_SELSTARTROW     0x0025        
//#define IPROP_GRIGLIA_SELENDROW       0x0026                
//#define IPROP_GRIGLIA_SELSTARTCOL     0x0027        
//#define IPROP_GRIGLIA_SELENDCOL       0x0028                
//#define IPROP_GRIGLIA_ENABLECOL       0x0029        
//#define IPROP_GRIGLIA_ENABLEROW       0x002A        
//#define IPROP_GRIGLIA_ENABLEEDIT        0x002B
//#define IPROP_GRIGLIA_ENABLESCROLLBARS  0x002C

#define IPROP_GRIGLIA_AUTHOR            0x002D           
#define IPROP_GRIGLIA_COMPANY           0x002E
#define IPROP_GRIGLIA_ADDRESS           0x002F        
#define IPROP_GRIGLIA_DONATION          0x0030        
#define IPROP_GRIGLIA_HWND              0x0031                

#ifdef CTL_DATA

PROPINFO CTL_DATA propRows =
{                                             
   "Rows",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (GRIGLIA, wRows), 0
};

PROPINFO CTL_DATA propCols =
{               
   "Cols",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (GRIGLIA, wCols), 0
};

PROPINFO CTL_DATA propFixedRows =
{
   "FixedRows",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (GRIGLIA, wFixedRows), 0
};

PROPINFO CTL_DATA propFixedCols =
{
   "FixedCols",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (GRIGLIA, wFixedCols), 0
};

PROPINFO CTL_DATA propRow =
{
   "Row",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, wRow), 0
};

PROPINFO CTL_DATA propCol =
{
   "Col",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, wCol), 0
};

PROPINFO CTL_DATA propRowHeight =
{
   "RowHeight",
   DT_SHORT   | PF_fGetMsg | PF_fSetMsg | PF_fSaveData  | PF_fNoShow,
   OFFSETIN (GRIGLIA, wRowHeight), 0
};

PROPINFO CTL_DATA propColWidth =
{
   "ColWidth",
   DT_SHORT   | PF_fGetMsg | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, wColWidth), 0
};

PROPINFO CTL_DATA propTopRow =
{
   "TopRow",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData  | PF_fNoShow,
   OFFSETIN (GRIGLIA, wTopRow), 0
};

PROPINFO CTL_DATA propLeftCol =
{
   "LeftCol",
   DT_SHORT     | PF_fGetData | PF_fSetMsg    | 
   PF_fSaveData | PF_fDefVal  | PF_fNoInitDef |
   PF_fNoShow,
   OFFSETIN (GRIGLIA, wLeftCol), 0
};

PROPINFO CTL_DATA propCursorRow =
{
   "CursorRow",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData  | PF_fNoShow,
   OFFSETIN (GRIGLIA, wCursorRow), 0
};

PROPINFO CTL_DATA propCursorCol =
{
   "CursorCol",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, wCursorCol), 0
};

PROPINFO CTL_DATA propText =
{
   "Text",
   DT_HSZ  | PF_fGetMsg | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, hszText), 0
};

PROPINFO CTL_DATA propClip =
{
   "Clip",
   DT_HSZ  | PF_fGetMsg | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, hszClip), 0
};

PROPINFO CTL_DATA propSelStartRow =
{
   "SelStartRow",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, wSelStartRow), 0
};

PROPINFO CTL_DATA propSelEndRow =
{
   "SelEndRow",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, wSelEndRow), 0
};

PROPINFO CTL_DATA propSelStartCol =
{
   "SelStartCol",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, wSelStartCol), 0
};

PROPINFO CTL_DATA propSelEndCol =
{
   "SelEndCol",
   DT_SHORT   | PF_fGetData | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (GRIGLIA, wSelEndCol), 0
};
                   
PROPINFO CTL_DATA propEnableCol =
{           
    "EnableCol",
    DT_ENUM   | PF_fGetMsg | PF_fSetMsg | PF_fDefVal | PF_fNoShow,
    OFFSETIN (GRIGLIA, wEnableCol), 0, 
    1,
    "0 - Disable\0" "1 - Enable\0" "",
    1
};
                   
PROPINFO CTL_DATA propEnableRow =
{
    "EnableRow",
    DT_ENUM | PF_fGetMsg | PF_fSetMsg | PF_fDefVal | PF_fNoShow,
    OFFSETIN (GRIGLIA, wEnableRow), 0, 
    1,
    "0 - Disable\0" "1 - Enable\0" "",
    1
};
                   
PROPINFO CTL_DATA propEnableEdit =
{
    "EnableEdit",
    DT_ENUM | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN (GRIGLIA, wEnableEdit), 0, 
    1,
    "0 - Disable\0" "1 - Enable\0" 
    "2 - Erase\0" "3 - Erase/Disable\0" "",
    3
};
                   
PROPINFO CTL_DATA propEnableScrollBars =
{
    "ScrollBars",
    DT_ENUM | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData | PF_fDefVal,
    OFFSETIN(GRIGLIA, wEnableScrollBars), 0, 
    4,
    "0 - None\0"     "1 - Horizontal\0" 
    "2 - Vertical\0" "3 - Both\0" 
    "4 - Auto\0"     "",
    4
};

PROPINFO CTL_DATA propAuthor =
{
   "AUTHOR",
   DT_HSZ  | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (GRIGLIA, hszAuthor), 0
};

PROPINFO CTL_DATA propCompany =
{
   "COMPANY",
   DT_HSZ  | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (GRIGLIA, hszCompany), 0
};

PROPINFO CTL_DATA propAddress =
{
   "ADDRESS",
   DT_HSZ  | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (GRIGLIA, hszAddress), 0
};

PROPINFO CTL_DATA propDonation =
{
   "SUGGESTED DONATION",
   DT_HSZ  | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (GRIGLIA, hszDonation), 0
};

PROPINFO CTL_DATA propHwnd =
{
   "hWnd",
   DT_SHORT   | PF_fGetMsg | PF_fSetData | PF_fSaveData | 
   PF_fNoShow | PF_fNoRuntimeW,
   OFFSETIN (GRIGLIA, hWndControl), 0
};

PPROPINFO CTL_DATA propGrigliaList[] = {

    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_FORECOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTSIZE,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_TAG,
    PPROPINFO_STD_MOUSEPOINTER,
    (PPROPINFO)&propRows,
    (PPROPINFO)&propCols,
    (PPROPINFO)&propFixedRows,
    (PPROPINFO)&propFixedCols,
    (PPROPINFO)&propRow,
    (PPROPINFO)&propCol,
    (PPROPINFO)&propRowHeight,
    (PPROPINFO)&propColWidth,
    (PPROPINFO)&propTopRow,
    (PPROPINFO)&propLeftCol,
    (PPROPINFO)&propCursorRow,
    (PPROPINFO)&propCursorCol,
    (PPROPINFO)&propText,
    (PPROPINFO)&propClip,
    (PPROPINFO)&propSelStartRow,
    (PPROPINFO)&propSelEndRow,
    (PPROPINFO)&propSelStartCol,
    (PPROPINFO)&propSelEndCol,
    (PPROPINFO)&propEnableCol,
    (PPROPINFO)&propEnableRow,
    (PPROPINFO)&propEnableEdit,
    (PPROPINFO)&propEnableScrollBars,
    (PPROPINFO)&propAuthor,
    (PPROPINFO)&propCompany,
    (PPROPINFO)&propAddress,
    (PPROPINFO)&propDonation,
    (PPROPINFO)&propHwnd,
    NULL

};

#endif	// CTL_DATA

#ifdef CTL_DATA
//---------------------------------------------------------------------------
// Event griglia
//---------------------------------------------------------------------------
#endif	// CTL_DATA

//---------------------------------------------------------------------------
// Define the consecutive indicies for the events
//---------------------------------------------------------------------------
#define EVENT_GRIGLIA_CHANGE       0
#define EVENT_GRIGLIA_CLICK        1
#define EVENT_GRIGLIA_DRAGDROP     2
#define EVENT_GRIGLIA_DRAGOVER     3
#define EVENT_GRIGLIA_GOTFOCUS     4
#define EVENT_GRIGLIA_KEYDOWN      5
#define EVENT_GRIGLIA_KEYPRESS     6
#define EVENT_GRIGLIA_KEYUP        7
#define EVENT_GRIGLIA_LOSTFOCUS    8

#ifdef CTL_DATA
WORD Parms[] = {ET_I2, ET_I2, ET_SD};

EVENTINFO Event_Change = {

    "Change",
    3,
    6,
    Parms,
    "Row as Integer, Col as Integer, Text As String"

};

PEVENTINFO CTL_DATA eventGrigliaList[] =
{
    &Event_Change,
    PEVENTINFO_STD_CLICK,
    PEVENTINFO_STD_DRAGDROP,
    PEVENTINFO_STD_DRAGOVER,
    PEVENTINFO_STD_GOTFOCUS,
    PEVENTINFO_STD_KEYDOWN,
    PEVENTINFO_STD_KEYPRESS,
    PEVENTINFO_STD_KEYUP,
    PEVENTINFO_STD_LOSTFOCUS,
    NULL
};
#endif	// CTL_DATA

//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------
#ifdef CTL_DATA

MODEL CTL_DATA modelList = {
    VB_VERSION,                         // VB version being used                        
    MODEL_fFocusOk | MODEL_fArrows |
    MODEL_fInitMsg | MODEL_fLoadMsg,    // MODEL flags
    (PCTLPROC)GrigliaCtlProc,           // Control procedure
    CS_VREDRAW | CS_DBLCLKS	|
    CS_HREDRAW,                         // Class style
    WS_CHILD | WS_BORDER |
    WS_CLIPCHILDREN,                    // Default Window style
    sizeof(GRIGLIA),                    // cbCtlExtra for GRIGLIA structure
    IDBMP_GRIGLIA,                      // Palette bitmap ID
    "HiT_Grid",                         // Default control name
    "GrigliaControl",                   // Visual Basic class name
    NULL,                               // Parent class name
    propGrigliaList,                    // Properties Griglia
    eventGrigliaList                    // Events Griglia
};

#endif	// CTL_DATA

#endif  // RC_INVOKED

//---------------------------------------------------------------------------
