//---------------------------------------------------------------------------
// Subclass.c
//---------------------------------------------------------------------------
// Griglia Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "vbapi.h"
#include "griglia.h"

//---------------------------------------------------------------------------
// PaintButtonUp
//---------------------------------------------------------------------------
BOOL PaintButtonUp (HDC  hDC,
                    UINT nLeft,
                    UINT nTop,
                    UINT nRight,
                    UINT nBottom) {
                      
    HRGN hBlackRgn,
         hGrayRgn,
         hWhiteRgn;
                                              
    if (hBlackRgn = CreateRectRgn (nLeft, nTop, nRight, nBottom)) {
        FillRgn  (hDC, hBlackRgn, GetStockObject (GRAY_BRUSH));
        FrameRgn (hDC, hBlackRgn, GetStockObject (BLACK_BRUSH), 1, 1);
        ++nLeft; ++nTop; --nRight; --nBottom;
        if (hGrayRgn = CreateRectRgn (nLeft + 1,   nTop + 1, 
                                      nRight - 2,  nBottom - 2)) {
            FillRgn (hDC, hGrayRgn, GetStockObject (LTGRAY_BRUSH));
            if (hWhiteRgn = CreateRectRgn (nLeft,      nTop,
                                           nRight - 1, nTop + 1)) {
                FillRgn (hDC, hWhiteRgn, GetStockObject (WHITE_BRUSH));
                DeleteObject (hWhiteRgn);    
                if (hWhiteRgn = CreateRectRgn (nLeft,    nTop, 
                                               nLeft + 1, nBottom - 1)) {
                    FillRgn (hDC, hWhiteRgn, GetStockObject (WHITE_BRUSH));
                    DeleteObject (hWhiteRgn);    
                    DeleteObject (hGrayRgn);    
                    DeleteObject (hBlackRgn);    
                    return (TRUE);
                }
            }
            DeleteObject (hGrayRgn);    
        }    
        DeleteObject (hBlackRgn);    
    }
    return (FALSE);
}                      
                 
//---------------------------------------------------------------------------
// PaintButtonDown
//---------------------------------------------------------------------------
BOOL PaintButtonDown (HDC  hDC,
                           UINT nLeft,
                           UINT nTop,
                           UINT nRight,
                           UINT nBottom) {
                      
    HRGN hBlackRgn,
         hGrayRgn,
         hWhiteRgn;
                                              
    if (hBlackRgn = CreateRectRgn (nLeft, nTop, nRight, nBottom)) {
        FillRgn  (hDC, hBlackRgn, GetStockObject (LTGRAY_BRUSH));
        FrameRgn (hDC, hBlackRgn, GetStockObject (BLACK_BRUSH), 1, 1);
        ++nLeft; ++nTop; --nRight; --nBottom;
        if (hGrayRgn = CreateRectRgn (nLeft + 1,   nTop + 1, 
                                      nRight - 2,  nBottom - 2)) {
            FillRgn (hDC, hGrayRgn, GetStockObject (LTGRAY_BRUSH));
            if (hWhiteRgn = CreateRectRgn (nLeft,      nTop,
                                           nRight, nTop + 1)) {
                FillRgn (hDC, hWhiteRgn, GetStockObject (GRAY_BRUSH));
                DeleteObject (hWhiteRgn);    
                if (hWhiteRgn = CreateRectRgn (nLeft,    nTop, 
                                               nLeft + 1, nBottom)) {
                    FillRgn (hDC, hWhiteRgn, GetStockObject (GRAY_BRUSH));
                    DeleteObject (hWhiteRgn);    
                    DeleteObject (hGrayRgn);    
                    DeleteObject (hBlackRgn);    
                    return (TRUE);
                }
            }
            DeleteObject (hGrayRgn);    
        }    
        DeleteObject (hBlackRgn);    
    }
    return (FALSE);
}                                       

//---------------------------------------------------------------------------
// PaintTastoSu
//---------------------------------------------------------------------------
BOOL PaintTastoSu (PGRIGLIA lpGrigliaStruct,
			       HDC	hDC,
                               RECT     rInvalid) {

    HDC    hdcMem;
    WORD   n;
    LONG   lLeft, lTop,
	   lRight, lBottom,
	   lHScroll, lVScroll;

    hdcMem = CreateCompatibleDC (hDC);

    // Top Left Push Button
    PaintButtonUp (hDC, 1, 1, PUSH_H_GRID - 1, PUSH_V_GRID - 1);

    // Top Push Buttons
    lLeft = PUSH_H_GRID;

    // Paint Fixed Cols
    if (lpGrigliaStruct->wFixedCols) for (n = 0;
                                          n < lpGrigliaStruct->wFixedCols;                              
                                          ++n) {                                  

        if ((lHScroll = Griglia_HorPos (n, lpGrigliaStruct)) !=
            INVALID_POS) {     
            lRight = PUSH_H_GRID + lHScroll -
                     lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR);         

            if (lLeft > (LONG)rInvalid.right)
                    break;
            else if (
                     (
                      (lLeft  <= (LONG)rInvalid.left) &&
                      (lRight >= (LONG)rInvalid.left)
                     )                                                                ||
                     (
                      (lLeft >= (LONG)rInvalid.left)  &&
                      (lLeft <= (LONG)rInvalid.right)
                     ) 
                    ) 
                PaintButtonUp (hDC,
                               LOWORD (lLeft) + 1 ,  1,
                               LOWORD (lRight) + 1, PUSH_V_GRID - 1);
            lLeft = lRight + 1;
        }        
    }

    // Paint Other Columns
    for (n = (lpGrigliaStruct->wFixedCols + lpGrigliaStruct->nHScrollPos);
    	 n < lpGrigliaStruct->wCols; ++n) {

        if ((lHScroll = Griglia_HorPos (n, lpGrigliaStruct)) !=
            INVALID_POS) {     
            lRight = PUSH_H_GRID + lHScroll -            
                     lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR);                     

            if (lLeft > (LONG)rInvalid.right)            
                break;                
            else if (            
                     (            
                      (lLeft  <= (LONG)rInvalid.left) &&
                      (lRight >= (LONG)rInvalid.left)
                     )                                                                ||
                     (            
                      (lLeft >= (LONG)rInvalid.left)  &&
                      (lLeft <= (LONG)rInvalid.right)
                     )
                    ) 
                PaintButtonUp (hDC,                
                               LOWORD (lLeft)  + 1,  1,            
                               LOWORD (lRight) + 1, PUSH_V_GRID - 1);            
            lLeft = lRight + 1;            
        }        
    }

    // Left Push Buttons
    lTop     = PUSH_V_GRID;

    // Paint Fixed Row Push Buttons
    if (lpGrigliaStruct->wFixedRows) for (n = 0;    
                                          n < lpGrigliaStruct->wFixedRows;  
                                          ++n) {

        if ((lVScroll = Griglia_VertPos (n, lpGrigliaStruct)) != INVALID_POS) {

            lBottom = PUSH_V_GRID + lVScroll -            
                      lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR);                  

            if (lTop > (LONG)rInvalid.bottom)            
                break;                
            else if (            
                     (            
                      (lTop    <= (LONG)rInvalid.top)                &&
                      (lBottom >= (LONG)rInvalid.top)
                     )                                                               ||
                     (
                      (lTop >= (LONG)rInvalid.top)           &&
                      (lTop <= (LONG)rInvalid.bottom)
                     )
                    ) 
                PaintButtonUp (hDC,            
                               1,               LOWORD (lTop),           
                               PUSH_H_GRID - 1, LOWORD (lBottom));           
                        
            lTop    = lBottom + 1;            
        }        
    }    

    // Paint Other Push Buttons    
    for (n = (lpGrigliaStruct->wFixedRows + lpGrigliaStruct->nVScrollPos);    
         n < lpGrigliaStruct->wRows;         
         ++n) {         

        if ((lVScroll = Griglia_VertPos (n, lpGrigliaStruct)) != INVALID_POS) {

            lBottom = PUSH_V_GRID + lVScroll -
                          lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR);

            if (lTop > (LONG)rInvalid.bottom)
                    break;
            else if (
                    (
                     (lTop    <= (LONG)rInvalid.top)                &&
                     (lBottom >= (LONG)rInvalid.top)
                    )                                                               ||
                    (
                     (lTop >= (LONG)rInvalid.top)           &&
                     (lTop <= (LONG)rInvalid.bottom)
                    )
               ) 
                PaintButtonUp (hDC,
                               1,               LOWORD (lTop),
                               PUSH_H_GRID - 1, LOWORD (lBottom));
            
            lTop    = lBottom + 1;
	}
    }

    DeleteDC (hdcMem);
    return (TRUE);
}

//---------------------------------------------------------------------------
// Paint Griglia Background
//---------------------------------------------------------------------------
BOOL PaintBackground (PGRIGLIA lpGrigliaStruct,
                                  HDC      hDC,
                                  RECT     rInvalid) {

    WORD n;
    LONG lTop,
         lBottom,
         lLeft,
         lRight,
         lVScroll, lHScroll;
    HRGN hRgn;
    static RECT rCell;

    // Make dark gray background
    lTop    = 0;
    lLeft   = 0;
    lBottom = (lpGrigliaStruct->rStatic.bottom - lpGrigliaStruct->rStatic.top);
    lRight  = (lpGrigliaStruct->rStatic.right - lpGrigliaStruct->rStatic.left);
    if (hRgn = CreateRectRgn (LOWORD (lLeft),  LOWORD (lTop),
                              LOWORD (lRight), LOWORD (lBottom))) {
        FillRgn (hDC, hRgn, GetStockObject (GRAY_BRUSH));
        DeleteObject (hRgn);
    }

    lHScroll = Griglia_HorPos  (lpGrigliaStruct->wCols - 1, lpGrigliaStruct);
    lVScroll = Griglia_VertPos (lpGrigliaStruct->wRows - 1, lpGrigliaStruct);

    // Make white background
    lTop    = PUSH_V_GRID;
    lLeft   = PUSH_H_GRID;
    lBottom = min (PUSH_V_GRID + lVScroll -
                   lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR),
                   (LONG)(lpGrigliaStruct->rStatic.bottom -
                          lpGrigliaStruct->rStatic.top)
                  );
    lRight  = min (PUSH_H_GRID + lHScroll -
                   lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR),
                   (LONG)(lpGrigliaStruct->rStatic.right -
                          lpGrigliaStruct->rStatic.left)
                  );
    if (hRgn = CreateRectRgn (LOWORD (lLeft) , LOWORD (lTop),
                              LOWORD (lRight), LOWORD (lBottom))) {

        FillRgn (hDC, hRgn, GetStockObject (WHITE_BRUSH));
        DeleteObject (hRgn);
    }

    // Make fixed cols/rows gray background - top region
    lTop    = PUSH_V_GRID;
    lLeft   = PUSH_H_GRID;
    if (lpGrigliaStruct->wFixedRows) {
        lBottom = min (
                       PUSH_V_GRID +
                       Griglia_VertPos (lpGrigliaStruct->wFixedRows - 1,
                                        lpGrigliaStruct) -
                       lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR),
                       (LONG)(lpGrigliaStruct->rStatic.bottom -
                              lpGrigliaStruct->rStatic.top)
                      );

        lRight  = min (PUSH_H_GRID + lHScroll -
                       lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR),
                       (LONG)(lpGrigliaStruct->rStatic.right -
                       lpGrigliaStruct->rStatic.left)
                      );

        if (hRgn = CreateRectRgn (LOWORD (lLeft) , LOWORD (lTop),
                                  LOWORD (lRight), LOWORD (lBottom))) {
            FillRgn (hDC, hRgn, GetStockObject (LTGRAY_BRUSH));
            DeleteObject (hRgn);
        }
    }

    // Make fixed cols/rows gray background - left region
    lTop    = PUSH_V_GRID;
    lLeft   = PUSH_H_GRID;
    if (lpGrigliaStruct->wFixedCols) {
        lBottom = min (
                       PUSH_V_GRID + lVScroll -
                       lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR),
                       (LONG)(lpGrigliaStruct->rStatic.bottom -
                       lpGrigliaStruct->rStatic.top)
                      );

        lRight  = min (
                        PUSH_H_GRID +
                        (lpGrigliaStruct->lpVertBars +
                        lpGrigliaStruct->wFixedCols - 1)->lPos -
                        lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR),
                        (LONG)(lpGrigliaStruct->rStatic.right -
                        lpGrigliaStruct->rStatic.left)
                       );

        if (hRgn = CreateRectRgn (LOWORD (lLeft),  LOWORD (lTop),
                                  LOWORD (lRight), LOWORD (lBottom))) {
            FillRgn (hDC, hRgn, GetStockObject (LTGRAY_BRUSH));
            DeleteObject (hRgn);
        }
    }

    // Paint disabled columns
    lVScroll = Griglia_VertPos (lpGrigliaStruct->wRows - 1, lpGrigliaStruct);
    lBottom = min (PUSH_V_GRID + lVScroll -
                   lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR),
                   (LONG)(lpGrigliaStruct->rStatic.bottom -
                          lpGrigliaStruct->rStatic.top)
                  );
    for (n = (lpGrigliaStruct->wFixedCols + lpGrigliaStruct->nHScrollPos);
         n < lpGrigliaStruct->wCols;
         ++n) {

        if ((lpGrigliaStruct->lpVertBars + n)->wStatus == DISABLE_FLAG) {

            if (CellLRRect (lpGrigliaStruct, n, (LPRECT)&rCell)) {

                if (rCell.left >= rInvalid.right)
                    break;
                else if (
                         (
                          (rCell.left  <= rInvalid.left)    &&
                          (rCell.right >= rInvalid.left)
                         )                                                                   ||
                         (
                          (rCell.left >= rInvalid.left)     &&
                          (rCell.left <= rInvalid.right)
                         )
                        ) {
                    if (hRgn = CreateRectRgn (rCell.left,
                                              lpGrigliaStruct->rStatic.top,
                                              rCell.right,
                                              LOWORD (lBottom))) {
                        FillRgn (hDC, hRgn, GetStockObject (LTGRAY_BRUSH));
                        DeleteObject (hRgn);
                    }
                }
            }
        }
    }

    // Paint disabled rows
    lHScroll = Griglia_HorPos  (lpGrigliaStruct->wCols - 1, lpGrigliaStruct);
    lRight  = min (PUSH_H_GRID + lHScroll -
                   lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR),
                   (LONG)(lpGrigliaStruct->rStatic.right -
                          lpGrigliaStruct->rStatic.left)
                  );
    for (n = (lpGrigliaStruct->wFixedRows + lpGrigliaStruct->nVScrollPos);
         n < lpGrigliaStruct->wRows;
         ++n) {

        if ((lpGrigliaStruct->lpHorBars + n)->wStatus == DISABLE_FLAG) {

            if (CellTBRect (lpGrigliaStruct, n, (LPRECT)&rCell)) {

                if (rCell.top >= rInvalid.bottom)
                    break;
                else if (
                         (
                          (rCell.top    <= rInvalid.top)    &&
                          (rCell.bottom >= rInvalid.top)
                         )                                                                   ||
                         (
                          (rCell.top >= rInvalid.top)     &&
                          (rCell.top <= rInvalid.bottom)
                         )
                        ) {
                    if (hRgn = CreateRectRgn (lpGrigliaStruct->rStatic.left,
                                              rCell.top,
                                              LOWORD (lRight),
                                              rCell.bottom)) {
                        FillRgn (hDC, hRgn, GetStockObject (LTGRAY_BRUSH));
                        DeleteObject (hRgn);
                    }
                }
            }
        }
    }
    return (TRUE);
}

//---------------------------------------------------------------------------
// Paint Vertical Griglia Bars
//---------------------------------------------------------------------------
BOOL PaintVertBars (PGRIGLIA lpGrigliaStruct,
                                HDC      hDC,                                 
                                RECT     rInvalid) {                        

    WORD   n;
    SHORT  wTop, wBottom, wLeft, wRight;
    LONG   lVScroll;
    static RECT rCell;

    lVScroll = Griglia_VertPos (lpGrigliaStruct->wRows - 1, lpGrigliaStruct);
    wTop     = PUSH_V_GRID - 1;
    wBottom  = LOWORD (min (PUSH_V_GRID + lVScroll -
                            lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR),
                            (LONG)(lpGrigliaStruct->rStatic.bottom -
                            lpGrigliaStruct->rStatic.top)
                      ));

    // Paint Fixed Cols
    if (lpGrigliaStruct->wFixedCols) for (n = 0;
                                          n < lpGrigliaStruct->wFixedCols;                              
                                          ++n) {

        if (CellLRRect (lpGrigliaStruct, n, (LPRECT)&rCell)) {

            wLeft  = rCell.right;
            wRight = wLeft + 1;

            if (wLeft >= rInvalid.right)
                break;
            else if (        
                     (        
                      (wLeft  <= rInvalid.left)    &&
                      (wRight >= rInvalid.left)
                     )                                                                   ||
                     (         
                      (wLeft >= rInvalid.left)     &&
                      (wLeft <= rInvalid.right)
                     )
                    ) {
                HPEN hOldPen;        

                hOldPen = SelectObject (hDC, hDashedPen);                
                MoveTo (hDC, wLeft, wTop);
                LineTo (hDC, wLeft, wBottom);
                SelectObject (hDC, hOldPen);                

            }            
        }        

    }    

    // Paint Other Columns
    for (n = (lpGrigliaStruct->wFixedCols + lpGrigliaStruct->nHScrollPos);
         n < lpGrigliaStruct->wCols;
         ++n) {

        if (CellLRRect (lpGrigliaStruct, n, (LPRECT)&rCell)) {

            wLeft  = rCell.right;
            wRight = wLeft + 1;

            if (wLeft >= rInvalid.right)
                break;
            else if (
                     (
                      (wLeft  <= rInvalid.left)    &&
                      (wRight >= rInvalid.left)
                     )                                                                   ||
                     (
                      (wLeft >= rInvalid.left)     &&
                      (wLeft <= rInvalid.right)
                     )
                    ) {
                HPEN hOldPen;

                hOldPen = SelectObject (hDC, hDashedPen);
                MoveTo (hDC, wLeft, wTop);
                LineTo (hDC, wLeft, wBottom);
                SelectObject (hDC, hOldPen);
            }
        }

    }
    return (TRUE);

}

//---------------------------------------------------------------------------
// Paint Horizontal Griglia Bars
//---------------------------------------------------------------------------
BOOL PaintHorBars (PGRIGLIA lpGrigliaStruct,
                               HDC      hDC,
                               RECT     rInvalid) {

        WORD n;
	LONG lTop, lBottom, lLeft, lRight,
             lHScroll, lVScroll;

    lHScroll = Griglia_HorPos (lpGrigliaStruct->wCols - 1, lpGrigliaStruct);
    lLeft    = PUSH_H_GRID - 1;
    lRight   = min (PUSH_H_GRID + lHScroll -
                    lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR),
                    (LONG)(lpGrigliaStruct->rStatic.right -
                    lpGrigliaStruct->rStatic.left)
                   );

	if (lpGrigliaStruct->wFixedRows) for (n = 0;
										  n < lpGrigliaStruct->wFixedRows;
										  ++n) {

        if ((lVScroll = Griglia_VertPos (n, lpGrigliaStruct)) !=
             INVALID_POS) {

			lTop    = PUSH_V_GRID + lVScroll -
			       	  lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR);
			lBottom = lTop + 1;

			if (lTop > (LONG)rInvalid.bottom)
				break;
			else if (
				(
				 (lTop    <= (LONG)rInvalid.top) 	&&
				 (lBottom >= (LONG)rInvalid.top)
				)								    ||
				(
				 (lTop    >= (LONG)rInvalid.top) 	&&
				 (lTop    <= (LONG)rInvalid.bottom)
				)
			   ) {
		        HPEN hOldPen;

				hOldPen = SelectObject (hDC, hDashedPen);
				MoveTo (hDC, LOWORD (lLeft), LOWORD (lTop));
				LineTo (hDC, LOWORD (lRight), LOWORD (lTop));
				SelectObject (hDC, hOldPen);
			}
    	}
	}

	for (n = (lpGrigliaStruct->wFixedRows + lpGrigliaStruct->nVScrollPos);
		 n < lpGrigliaStruct->wRows;
		 ++n) {

        if ((lVScroll = Griglia_VertPos (n, lpGrigliaStruct)) !=
             INVALID_POS) {

			lTop    = PUSH_V_GRID + lVScroll -
			       	  lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR);
			lBottom = lTop + 1;

			if (lTop > (LONG)rInvalid.bottom)
				break;
			else if (
				(
				 (lTop    <= (LONG)rInvalid.top) 	&&
				 (lBottom >= (LONG)rInvalid.top)
				)								    ||
				(
				 (lTop    >= (LONG)rInvalid.top) 	&&
				 (lTop    <= (LONG)rInvalid.bottom)
				)
			   ) {
		        HPEN hOldPen;

		        hOldPen = SelectObject (hDC, hDashedPen);
				MoveTo (hDC, LOWORD (lLeft), LOWORD (lTop));
				LineTo (hDC, LOWORD (lRight), LOWORD (lTop));
				SelectObject (hDC, hOldPen);
			}
    	}
	}
	return (TRUE);

}

//---------------------------------------------------------------------------
// Paint Selection Griglia Bars
//---------------------------------------------------------------------------
BOOL PaintCursorLocal (PGRIGLIA lpGrigliaStruct,
                       HDC      hDC) {

	LONG  lHScroll, lVScroll;
	RECT  rCursor;
	SHORT hOldRop;
	HPEN  hOldPen;

	SetRectEmpty ((LPRECT)&rCursor);

	// find right position of cursor cell
   	if ((lHScroll =
   		 Griglia_HorPos (lpGrigliaStruct->wCursorCol,
   						 lpGrigliaStruct)) != INVALID_POS) {
		rCursor.right = LOWORD (PUSH_H_GRID + lHScroll -
                                        lpGrigliaStruct->xChar /
                                        (2 * INTERCOLUMN_FACTOR));

		// find left position of cursor cell
   		rCursor.left = PUSH_H_GRID;
   		if (lpGrigliaStruct->wFixedCols)
   			rCursor.left = LOWORD (PUSH_H_GRID +
                                               Griglia_HorPos (lpGrigliaStruct->wFixedCols - 1,
                                                               lpGrigliaStruct));
		if (lpGrigliaStruct->wCursorCol) {
   			if ((lHScroll =
   			     Griglia_HorPos (lpGrigliaStruct->wCursorCol - 1,
   		      	   		   	     lpGrigliaStruct)) != INVALID_POS)
				rCursor.left  = LOWORD (PUSH_H_GRID + lHScroll -
                                                        lpGrigliaStruct->xChar /
                                                         (2 * INTERCOLUMN_FACTOR));
	 	}

		// find bottom position of cursor cell
   		if ((lVScroll =
   		     Griglia_VertPos (lpGrigliaStruct->wCursorRow,
   			 				  lpGrigliaStruct)) != INVALID_POS) {
			rCursor.bottom = LOWORD (PUSH_V_GRID + lVScroll -
			    	  				 lpGrigliaStruct->yChar /
		    	  					 (2 * INTERCOLUMN_FACTOR));

			// find top position of cursor cell
			rCursor.top = PUSH_V_GRID;
   			if (lpGrigliaStruct->wFixedRows)
   				rCursor.top = LOWORD (PUSH_V_GRID +
   									  Griglia_HorPos (lpGrigliaStruct->wFixedRows - 1,
   										      		  lpGrigliaStruct));
			if (lpGrigliaStruct->wCursorRow) {
   				if ((lVScroll =
   					 Griglia_VertPos (lpGrigliaStruct->wCursorRow - 1,
   					 				  lpGrigliaStruct)) != INVALID_POS)
					rCursor.top    = LOWORD (PUSH_V_GRID + lVScroll -
			      				 		 	 lpGrigliaStruct->yChar /
		    	  				 		 	 (2 * INTERCOLUMN_FACTOR));
		    }

			// paint boxes
			if (hOldRop = SetROP2 (hDC, R2_NOTXORPEN)) {
				++rCursor.bottom;
				++rCursor.right;
				if (hOldPen = SelectObject (hDC, hCursorPen)) {
					Rectangle (hDC, rCursor.left,  rCursor.top,
									rCursor.right, rCursor.bottom);
					SelectObject (hDC, hOldPen);
					SetROP2 (hDC, hOldRop);
					return (TRUE);
				}
				SetROP2 (hDC, hOldRop);
			}
		}
	}
	return (FALSE);

}

//---------------------------------------------------------------------------
// Paint Selection Griglia Bars
//---------------------------------------------------------------------------
BOOL PaintCursor (PGRIGLIA lpGrigliaStruct) {

	HDC   hDC;
	BOOL  bRet;

    // Get DC of Static Window
	if (
		(lpGrigliaStruct->hWndStatic) &&
		(hDC = GetDC (lpGrigliaStruct->hWndStatic))
	   ){

		bRet = PaintCursorLocal (lpGrigliaStruct, hDC);
		ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);
		return (bRet);

	}
	return (FALSE);

}

//---------------------------------------------------------------------------
// Griglia Edit Control
//---------------------------------------------------------------------------
LONG _export EditWndProc(HWND 		hWnd,
                         unsigned 	message,
                         WORD 		wp,
                         LONG 		lp) {

    PGRIGLIA            lpGrigliaStruct;
    HCTL                hctl;
    SHORT               nLen;

    hctl            = VBGetHwndControl (GetParent(hWnd));
    lpGrigliaStruct = GRIGLIADEREF( hctl );

    switch (message) {

        // SHOW CARET ON TEXT
        case WM_KILLFOCUS:
            PostMessage (lpGrigliaStruct->hWndControl,                    
                         WM_KILLFOCUS, NULL, (LONG)NULL);                                  

            break;

        case WM_SETFOCUS:
            PostMessage (lpGrigliaStruct->hWndControl,                    
                        WM_SETFOCUS, NULL, (LONG)NULL);                                  

            break;

        case WM_KEYDOWN:
            KeyDown (hctl, hWnd, wp);
            break;

        case WM_KEYUP:
            switch (wp) {

                case VK_END:
                case VK_HOME:
                case VK_NEXT:
                case VK_PRIOR:
                case VK_RIGHT:
                case VK_LEFT:
                case VK_UP:
                case VK_DOWN: {
                    HANDLE hText;            
                    PSTR   pStr;            
                    
                    if (lpGrigliaStruct->lStatus & EDIT_FLAG)                                 // &&
                        break;

                    // change text    
                    nLen = GetWindowTextLength (hWnd);        
                    if ( hText = LocalAlloc ( LHND,
                                              nLen + 3) ) {
                        pStr = (PSTR) LocalLock (hText);
                        GetWindowText (hWnd, (LPSTR)pStr, nLen + 1);                
       
                        if (
                            ((lpGrigliaStruct->lpHorBars + 
                                lpGrigliaStruct->wCursorRow)->wStatus == ENABLE_FLAG)  &&
                            ((lpGrigliaStruct->lpVertBars + 
                                lpGrigliaStruct->wCursorCol)->wStatus == ENABLE_FLAG)  &&
                            (lpGrigliaStruct->wEnableEdit == ENABLE_FLAG)
                           ) {
                            if (PutCellText (lpGrigliaStruct,
                                            lpGrigliaStruct->wCursorRow,                 
                                            lpGrigliaStruct->wCursorCol,                 
                                            (LPSTR)pStr)) {
                                SetCellText (lpGrigliaStruct,                    
                                            lpGrigliaStruct->wCursorRow,                                     
                                            lpGrigliaStruct->wCursorCol,                                 
                                            pStr);
                            }

                        }
                        if (pStr)                        
                            FireChangeEvent (hctl,                            
                                                lpGrigliaStruct->wCursorRow,                                              
                                                lpGrigliaStruct->wCursorCol,                                  
                                                (LPSTR)pStr                                          
                                            );                                 
                        else                        
                            FireChangeEvent (hctl,                            
                                                lpGrigliaStruct->wCursorRow,                                          
                                                lpGrigliaStruct->wCursorCol,                                  
                                                (LPSTR)""                                      
                                            );                                 
                                     
                        LocalUnlock (hText);    
                        LocalFree (hText);

                        KeyUp (hctl, hWnd, wp);

                        // Caret                        
                        if (nLen = GetWindowTextLength (lpGrigliaStruct->hWndEdit))                        
                            PostMessage (lpGrigliaStruct->hWndEdit,                            
                                        EM_SETSEL, NULL, MAKELONG (0, nLen));                                         
                        return ((LONG)1);                        
                    }            
                }        
                break;        

                default: {            
                
                    HANDLE hText;                        
                    PSTR   pStr;                        
                    
                    if (
                        ((lpGrigliaStruct->lpHorBars + lpGrigliaStruct->wCursorRow)->wStatus == ENABLE_FLAG)  &&
                        ((lpGrigliaStruct->lpVertBars + lpGrigliaStruct->wCursorCol)->wStatus == ENABLE_FLAG) &&
                        (lpGrigliaStruct->wEnableEdit == ENABLE_FLAG) &&
                        (isascii (wp)) 
                      ) {                
                
                        if (nLen = GetWindowTextLength (lpGrigliaStruct->hWndEdit)) {
                            if ( hText = LocalAlloc ( LHND,
                                                    nLen + 3) ) {
                                pStr = (PSTR) LocalLock (hText);
                                GetWindowText (hWnd, (LPSTR)pStr, nLen + 1);                    
                                SetCellText (lpGrigliaStruct,                    
                                            lpGrigliaStruct->wCursorRow,                                 
                                            lpGrigliaStruct->wCursorCol,                                    
                                            pStr);                                 
                                bShiftPressed = 0;                    
                                bCtrlPressed  = 0;                    
                                LocalUnlock (hText);
                                LocalFree (hText);
                            }                    
                        } else {
                            SetCellText (lpGrigliaStruct,
                                        lpGrigliaStruct->wCursorRow,
                                        lpGrigliaStruct->wCursorCol,
                                        "");
                            bShiftPressed = 0;
                            bCtrlPressed  = 0;
                            lpGrigliaStruct->lStatus &= RES_EDIT_FLAG;
                        }

                    } else {

                        LPSTR lpStr;

                        if (lpStr = GetCellText (lpGrigliaStruct,
                                                 lpGrigliaStruct->wCursorRow,
                                                 lpGrigliaStruct->wCursorCol))
                            PostMessage (lpGrigliaStruct->hWndEdit,
                                         WM_SETTEXT, NULL,
                                         (LONG)lpStr);
                        else
                            PostMessage (lpGrigliaStruct->hWndEdit,
                                         WM_SETTEXT, NULL,
                                         (LONG)(LPSTR)"");
                        SendMessage (lpGrigliaStruct->hWndEdit,
                                     EM_SETSEL,  NULL,
                                     MAKELONG(0, -1));
                    }
                    KeyUp (hctl, hWnd, wp);
                }                        
                break;                    
            }
            break;    

        case WM_CHAR:
            if (
                ((lpGrigliaStruct->lpHorBars + lpGrigliaStruct->wCursorRow)->wStatus == ENABLE_FLAG) &&
                ((lpGrigliaStruct->lpVertBars + lpGrigliaStruct->wCursorCol)->wStatus == ENABLE_FLAG) &&
                (lpGrigliaStruct->wEnableEdit == ENABLE_FLAG)
               ) switch (wp) {
                
                case VK_ESCAPE: {
                    LPSTR lpStr;

                    if (lpStr = GetCellText (lpGrigliaStruct,
                                             lpGrigliaStruct->wCursorRow,                         
                                             lpGrigliaStruct->wCursorCol)) {                         
                        PostMessage (lpGrigliaStruct->hWndEdit,
                                     WM_SETTEXT, NULL,             
                                     (LONG)lpStr);             
                        SetCellText (lpGrigliaStruct,
                                     lpGrigliaStruct->wCursorRow,             
                                     lpGrigliaStruct->wCursorCol,                 
                                     lpStr);             
                    } else {

                        PostMessage (lpGrigliaStruct->hWndEdit,
                                     WM_SETTEXT, NULL,             
                                     (LONG)(LPSTR)"");             
                        SetCellText (lpGrigliaStruct,
                                     lpGrigliaStruct->wCursorRow,             
                                     lpGrigliaStruct->wCursorCol,             
                                     "");             
                    }

                    PostMessage (lpGrigliaStruct->hWndEdit,            
                                 EM_SETSEL,  NULL,             
                                 MAKELONG(0, -1));             
                    
                    // OFF EDIT MODE
                    lpGrigliaStruct->lStatus &= RES_EDIT_FLAG;

                }
                return ((LONG)1);

                case VK_RETURN: {    
                    
                    HANDLE hOldText;        
                    PSTR   pOldStr;        
                    LPSTR  lpOldpStr;        
                    HANDLE hText;                    
                    PSTR   pStr;                    

                    // retrieve previous text value        
                    lpOldpStr = GetCellText (lpGrigliaStruct,        
                                             lpGrigliaStruct->wCursorRow,                                 
                                             lpGrigliaStruct->wCursorCol);                                 

                    // get its size        
                    nLen = 0;        
                    if (lpOldpStr)        
                        nLen = lstrlen (lpOldpStr);            

                    // try to store it        
                    if ( hOldText = LocalAlloc ( LHND, nLen + 3)) {
                        pOldStr = (PSTR) LocalLock (hOldText);
                        if (lpOldpStr)                
                            lstrcpy (pOldStr, lpOldpStr);
                        else
                            lstrcpy (pOldStr, "");
                    } else {            
                        hOldText = NULL;                
                        pOldStr  = (PSTR)NULL;                
                    }            

                    // change text            
                    nLen = GetWindowTextLength (hWnd);                
                    if ( hText = LocalAlloc ( LHND,
                                              nLen + 3) ) {
                        pStr = (PSTR) LocalLock (hText);
                        GetWindowText (hWnd, (LPSTR)pStr, nLen + 1);                        
                        
                        if (PutCellText (lpGrigliaStruct,        
                                         lpGrigliaStruct->wCursorRow,                         
                                         lpGrigliaStruct->wCursorCol,                         
                                         (LPSTR)pStr)) {                         
                            SetCellText (lpGrigliaStruct,                            
                                         lpGrigliaStruct->wCursorRow,                                         
                                         lpGrigliaStruct->wCursorCol,                                         
                                         pStr);                                     
                            if (pOldStr)                            
                                FireChangeEvent (hctl,                                
                                                 lpGrigliaStruct->wCursorRow,                                                 
                                                 lpGrigliaStruct->wCursorCol,                                             
                                                 (LPSTR)pOldStr                                         
                                                );                                     
                            else                            
                                FireChangeEvent (hctl,                                
                                                 lpGrigliaStruct->wCursorRow,                                                         
                                                 lpGrigliaStruct->wCursorCol,                                             
                                                 (LPSTR)""                                                 
                                                );                                         
                        }                        
                        LocalUnlock (hText);
                        LocalFree (hText);
                        if (hOldText) {
                            LocalUnlock (hOldText);    
                            LocalFree (hOldText);    
                        }
                    }   
                                 
                    // OFF EDIT MODE                                        
                    SendMessage (lpGrigliaStruct->hWndEdit,            
                                 EM_SETSEL,  NULL,             
                                 MAKELONG(0, -1));             
                    lpGrigliaStruct->lStatus &= RES_EDIT_FLAG;                                                    
                    
                    //PostMessage (lpGrigliaStruct->hWndControl,        
                    //             WM_ACTIVATE, 1, MAKELONG (0, hWnd));                     

                }            
                return ((LONG)1);                                    
                
            } else {
                LPSTR lpStr;
                    
                if (lpStr = GetCellText (lpGrigliaStruct,
                                         lpGrigliaStruct->wCursorRow,                         
                                         lpGrigliaStruct->wCursorCol)) 
                    PostMessage (lpGrigliaStruct->hWndEdit,
                                 WM_SETTEXT, NULL,             
                                 (LONG)lpStr);             
                else
                    PostMessage (lpGrigliaStruct->hWndEdit,
                                 WM_SETTEXT, NULL,             
                                 (LONG)(LPSTR)"");             
                SendMessage (lpGrigliaStruct->hWndEdit,                
                             EM_SETSEL,  NULL,
                             MAKELONG(0, -1));                  
            }    
            break;    
    }
    return (CallWindowProc (lpfnOldEdit, hWnd, message, wp, lp));
}

//---------------------------------------------------------------------------
// Griglia Static Control
//---------------------------------------------------------------------------
LONG _export StaticWndProc(HWND 		hWnd,
                           unsigned 	message,
                           WORD 		wp,
                           LONG 		lp) {

    PGRIGLIA            lpGrigliaStruct;
    HCTL                hctl;
	HDC					hDC;

    hctl 	        = VBGetHwndControl (GetParent(hWnd));
    lpGrigliaStruct = GRIGLIADEREF( hctl );

    switch (message) {
        
       	case WM_PAINT: {
            static PAINTSTRUCT pPaint;
            HFONT  hOldFont;

            if (hDC = BeginPaint (hWnd, (LPPAINTSTRUCT)&pPaint)) {
                hOldFont = SelectObject (hDC, lpGrigliaStruct->hFont);

                PaintBackground  (lpGrigliaStruct, hDC, pPaint.rcPaint);
                PaintTastoSu     (lpGrigliaStruct, hDC, pPaint.rcPaint);                        
                PaintText        (lpGrigliaStruct, hDC, pPaint.rcPaint);         
                PaintHorBars     (lpGrigliaStruct, hDC, pPaint.rcPaint);                        
                PaintVertBars    (lpGrigliaStruct, hDC, pPaint.rcPaint);                    
                PaintBlockLocal  (lpGrigliaStruct, hDC);    
                PaintCursorLocal (lpGrigliaStruct, hDC);    
                SetEditText      (lpGrigliaStruct,
                                  lpGrigliaStruct->wCursorRow,                                 
                                  lpGrigliaStruct->wCursorCol);

                if (hOldFont)
                    SelectObject (hDC, hOldFont);
                EndPaint (hWnd, (LPPAINTSTRUCT)&pPaint);          
                if (             
                    (GetFocus() == lpGrigliaStruct->hWndControl) ||
                    (GetFocus() == lpGrigliaStruct->hWndEdit)    ||
                    (GetFocus() == lpGrigliaStruct->hWndStatic)
                   ) 
                GrigliaPaintBorder (lpGrigliaStruct);
            }
        }    
        break;    

    }

    return (CallWindowProc (lpfnOldStatic, hWnd, message, wp, lp));
}

//---------------------------------------------------------------------------
// Griglia_VScrollPos
//---------------------------------------------------------------------------
LONG Griglia_VertPos (WORD      n,       
                      PGRIGLIA  lpGrigliaStruct) {                      

    LONG  lPos;    
    WORD  wFixedRows;    

    if (n >= lpGrigliaStruct->wRows)    
        return (INVALID_POS);        

    lPos        = (lpGrigliaStruct->lpHorBars + n)->lPos;    
    wFixedRows  = lpGrigliaStruct->wFixedRows;    
    if (n >= wFixedRows) {    

        SHORT nVScrollPos;        
        LONG lScroll, lFixed;        

        // Compute Position of Scrolled Rows        
        nVScrollPos = lpGrigliaStruct->nVScrollPos;        
        if (wFixedRows)        
            lScroll = (lpGrigliaStruct->lpHorBars +               
                       nVScrollPos + wFixedRows - 1)->lPos;                  
        else {        
            lScroll    = 0;            
            if ((nVScrollPos - 1) >= 0)            
                lScroll = (lpGrigliaStruct->lpHorBars +                
                           nVScrollPos - 1)->lPos;                              
        }        

        // Compute Position of Fixed Rows        
        lFixed = 0;        
        if (wFixedRows)        
            lFixed = (lpGrigliaStruct->lpHorBars + wFixedRows - 1)->lPos;            

        // Obtain new scrolled position as difference of scrolled - fixed        
        lPos -= (lScroll - lFixed);        

        // Do not accept case when position is below fixed lines
        if (lPos < lFixed)
        lPos = INVALID_POS;        

    }
    return (lPos);    

}

//---------------------------------------------------------------------------
// Griglia_HScrollPos
//---------------------------------------------------------------------------
LONG Griglia_HorPos (WORD n,
                     PGRIGLIA lpGrigliaStruct) {                 

    LONG  lPos;
    WORD  wFixedCols;

    if (n >= lpGrigliaStruct->wCols)
        return (INVALID_POS);    

    lPos = (lpGrigliaStruct->lpVertBars + n)->lPos;

    wFixedCols  = lpGrigliaStruct->wFixedCols;
    if (n >= wFixedCols) {

        SHORT nHScrollPos;
        LONG lScroll, lFixed;

        // Compute Position of Scrolled Cols
        nHScrollPos = lpGrigliaStruct->nHScrollPos;
        if (wFixedCols)
            lScroll = (lpGrigliaStruct->lpVertBars +    
                       nHScrollPos + wFixedCols - 1)->lPos;          
        else {
            lScroll = 0;    
            if ((nHScrollPos - 1) >= 0)    
                lScroll = (lpGrigliaStruct->lpVertBars +        
                           nHScrollPos - 1)->lPos;               
        }

        // Compute Position of Fixed Cols
        lFixed = 0;
        if (wFixedCols)
            lFixed = (lpGrigliaStruct->lpVertBars + wFixedCols - 1)->lPos;    

        // Obtain new scrolled position as difference of scrolled - fixed
        lPos -= (lScroll - lFixed);

        // Do not accept case when position is below fixed cols
        if (lPos < lFixed)
            lPos = INVALID_POS;
    }
    return (lPos);    

}

//---------------------------------------------------------------------------
// Griglia_VSCrollRange
//---------------------------------------------------------------------------
void Griglia_VScrollRange (PGRIGLIA  lpGrigliaStruct) {

    SHORT n, m;
    LONG  lSize,
          lComp;

    for (n = 0; n < (SHORT)lpGrigliaStruct->wRows; ++n) {
        lSize = PUSH_V_GRID + (lpGrigliaStruct->lpHorBars + n)->lPos;

        if (lSize >= (LONG)(lpGrigliaStruct->rStatic.bottom -
            lpGrigliaStruct->rStatic.top)) {

            // Show the scroll bar
            lpGrigliaStruct->rStatic.right = lpGrigliaStruct->rControl.right -
                                             (lpGrigliaStruct->rVScrollBar.right -
                                             lpGrigliaStruct->rVScrollBar.left);
            SetWindowPos (lpGrigliaStruct->hWndStatic, NULL,
                          lpGrigliaStruct->rStatic.left, lpGrigliaStruct->rStatic.top,
                          lpGrigliaStruct->rStatic.right - lpGrigliaStruct->rStatic.left,
                          lpGrigliaStruct->rStatic.bottom - lpGrigliaStruct->rStatic.top,
                          SWP_NOZORDER);
            lpGrigliaStruct->rHScrollBar.right = lpGrigliaStruct->rControl.right -
                                                 (lpGrigliaStruct->rVScrollBar.right -
                                                  lpGrigliaStruct->rVScrollBar.left);
            SetWindowPos (lpGrigliaStruct->hWndHScrollBar, NULL,
                          lpGrigliaStruct->rHScrollBar.left, lpGrigliaStruct->rHScrollBar.top,
                          lpGrigliaStruct->rHScrollBar.right - lpGrigliaStruct->rHScrollBar.left,
                          lpGrigliaStruct->rHScrollBar.bottom - lpGrigliaStruct->rHScrollBar.top,
                          SWP_NOZORDER);
            ShowScrollBar (lpGrigliaStruct->hWndVScrollBar,
                           SB_CTL, TRUE);

            // Get number of lines of last page
            lComp = (LONG)(lpGrigliaStruct->rStatic.bottom -
                           lpGrigliaStruct->rStatic.top - PUSH_V_GRID);
            if (lpGrigliaStruct->wFixedRows)
                lComp -= (lpGrigliaStruct->lpHorBars +
                          lpGrigliaStruct->wFixedRows - 1)->lPos;
                for (m = (SHORT)lpGrigliaStruct->wRows - 1; m >= 0; --m) {
                    lSize = (lpGrigliaStruct->lpHorBars +
                            lpGrigliaStruct->wRows - 1)->lPos -
                            (lpGrigliaStruct->lpHorBars + m)->lPos;
                    if (lSize > lComp) {
                        lpGrigliaStruct->nVScrollMax = m + 2 -
                                                       lpGrigliaStruct->wFixedRows;
                        break;
                    } else if (lSize == lComp) {
                        lpGrigliaStruct->nVScrollMax = m + 1 -
                                                       lpGrigliaStruct->wFixedRows;
                        break;
                    }
                }
                lpGrigliaStruct->nVScrollPos = 0;
                lpGrigliaStruct->nVScrollInc = max (1, 5);
                SetScrollRange (lpGrigliaStruct->hWndVScrollBar,
                                                SB_CTL,
                                                0, lpGrigliaStruct->nVScrollMax,
                                                TRUE);
                SetScrollPos   (lpGrigliaStruct->hWndVScrollBar,
                                                SB_CTL,
                                                lpGrigliaStruct->nVScrollPos, TRUE);
                return;
        }
    }

    // Hide the scroll bar
    lpGrigliaStruct->nVScrollPos = 0;
    lpGrigliaStruct->nVScrollMax = 0;
    lpGrigliaStruct->wTopRow     = lpGrigliaStruct->wFixedRows;
    ShowScrollBar (lpGrigliaStruct->hWndVScrollBar,
                    SB_CTL, FALSE);
    lpGrigliaStruct->rStatic.right     = lpGrigliaStruct->rControl.right;
    SetWindowPos (lpGrigliaStruct->hWndStatic, NULL,
                  lpGrigliaStruct->rStatic.left, lpGrigliaStruct->rStatic.top,
                  lpGrigliaStruct->rStatic.right - lpGrigliaStruct->rStatic.left,
                  lpGrigliaStruct->rStatic.bottom - lpGrigliaStruct->rStatic.top,
                  SWP_NOZORDER);
    lpGrigliaStruct->rHScrollBar.right = lpGrigliaStruct->rControl.right;
    SetWindowPos (lpGrigliaStruct->hWndHScrollBar, NULL,
                  lpGrigliaStruct->rHScrollBar.left, lpGrigliaStruct->rHScrollBar.top,
                  lpGrigliaStruct->rHScrollBar.right - lpGrigliaStruct->rHScrollBar.left,
                  lpGrigliaStruct->rHScrollBar.bottom - lpGrigliaStruct->rHScrollBar.top,
                  SWP_NOZORDER);

}

//---------------------------------------------------------------------------
// Griglia_HSCrollRange
//---------------------------------------------------------------------------
void Griglia_HScrollRange (PGRIGLIA  lpGrigliaStruct) {
    SHORT  n, m;
    LONG lSize,
         lComp;

    for (n = 0; n < (SHORT)lpGrigliaStruct->wCols; ++n) {
        lSize = PUSH_H_GRID + (lpGrigliaStruct->lpVertBars + n)->lPos;

        if (lSize >= (LONG)(lpGrigliaStruct->rStatic.right -
                            lpGrigliaStruct->rStatic.left)) {

            // Show the scroll bar
            lpGrigliaStruct->rStatic.bottom = lpGrigliaStruct->rControl.bottom -
                                               (lpGrigliaStruct->rHScrollBar.bottom -
                                                lpGrigliaStruct->rHScrollBar.top);
            SetWindowPos (lpGrigliaStruct->hWndStatic, NULL,
                          lpGrigliaStruct->rStatic.left, lpGrigliaStruct->rStatic.top,
                          lpGrigliaStruct->rStatic.right - lpGrigliaStruct->rStatic.left,
                          lpGrigliaStruct->rStatic.bottom - lpGrigliaStruct->rStatic.top,
                          SWP_NOZORDER);
            lpGrigliaStruct->rVScrollBar.bottom = lpGrigliaStruct->rControl.bottom -
                                                    (lpGrigliaStruct->rHScrollBar.bottom -
                                                    lpGrigliaStruct->rHScrollBar.top);
            SetWindowPos (lpGrigliaStruct->hWndVScrollBar, NULL,
                        lpGrigliaStruct->rVScrollBar.left, lpGrigliaStruct->rVScrollBar.top,
                        lpGrigliaStruct->rVScrollBar.right - lpGrigliaStruct->rVScrollBar.left,
                        lpGrigliaStruct->rVScrollBar.bottom - lpGrigliaStruct->rVScrollBar.top,
                        SWP_NOZORDER);
            ShowScrollBar (lpGrigliaStruct->hWndHScrollBar,
                            SB_CTL, TRUE);

            // COMPUTE SCROLLABLESIZE WITHOUT FIXED COLS
            lComp = (LONG)(lpGrigliaStruct->rStatic.right -
                           lpGrigliaStruct->rStatic.left  - PUSH_H_GRID);
            // REMOVE FIXED COLS SIZE
            if (lpGrigliaStruct->wFixedCols)
                lComp -= (lpGrigliaStruct->lpVertBars +
                          lpGrigliaStruct->wFixedCols - 1)->lPos;

            for (m = (SHORT)lpGrigliaStruct->wCols - 2; m >= 0; --m) {

                lSize = (lpGrigliaStruct->lpVertBars +
                         lpGrigliaStruct->wCols - 1)->lPos -
                         (lpGrigliaStruct->lpVertBars + m)->lPos;
                if (lSize > lComp) {
                    lpGrigliaStruct->nHScrollMax = m + 2 -
                                                   lpGrigliaStruct->wFixedCols;
                    break;
                } else if (lSize == lComp) {
                    lpGrigliaStruct->nHScrollMax = m + 1 -
                                                   lpGrigliaStruct->wFixedCols;
                    break;
                }
            }
            lpGrigliaStruct->nHScrollPos = 0;
            lpGrigliaStruct->nHScrollInc = max (1, 5);
            SetScrollRange (lpGrigliaStruct->hWndHScrollBar,
                            SB_CTL,
                            0, lpGrigliaStruct->nHScrollMax,
                            TRUE);
            SetScrollPos   (lpGrigliaStruct->hWndHScrollBar,
                            SB_CTL,
                            lpGrigliaStruct->nHScrollPos, TRUE);
            return;
        }
    }

    // Hide the scroll bar
    lpGrigliaStruct->nHScrollPos = 0;
    lpGrigliaStruct->nHScrollMax = 0;
    lpGrigliaStruct->wLeftCol    = lpGrigliaStruct->wFixedCols;
    ShowScrollBar (lpGrigliaStruct->hWndHScrollBar,
                    SB_CTL, FALSE);
    lpGrigliaStruct->rStatic.bottom     = lpGrigliaStruct->rControl.bottom;
    SetWindowPos (lpGrigliaStruct->hWndStatic, NULL,
                lpGrigliaStruct->rStatic.left, lpGrigliaStruct->rStatic.top,
                lpGrigliaStruct->rStatic.right - lpGrigliaStruct->rStatic.left,
                lpGrigliaStruct->rStatic.bottom - lpGrigliaStruct->rStatic.top,
                SWP_NOZORDER);
    lpGrigliaStruct->rVScrollBar.bottom = lpGrigliaStruct->rControl.bottom;
    SetWindowPos (lpGrigliaStruct->hWndVScrollBar, NULL,
                lpGrigliaStruct->rVScrollBar.left, lpGrigliaStruct->rVScrollBar.top,
                lpGrigliaStruct->rVScrollBar.right - lpGrigliaStruct->rVScrollBar.left,
                lpGrigliaStruct->rVScrollBar.bottom - lpGrigliaStruct->rVScrollBar.top,
                SWP_NOZORDER);

}

//---------------------------------------------------------------------------
// Griglia VSCroll
//---------------------------------------------------------------------------
LONG Griglia_VScroll (PGRIGLIA  lpGrigliaStruct,
                      WORD      wp,
                      LONG      lp) {

    int nVscrollInc;

    switch (wp) {
        case SB_TOP:
            nVscrollInc = -lpGrigliaStruct->nVScrollPos;
            break;

        case SB_BOTTOM:
            nVscrollInc = lpGrigliaStruct->nVScrollMax -
                          lpGrigliaStruct->nVScrollPos;
            break;

        case SB_LINEUP:
            nVscrollInc = -1;
            break;

        case SB_LINEDOWN:
            nVscrollInc = 1;
            break;

        case SB_PAGEDOWN:
            nVscrollInc = max (1, lpGrigliaStruct->nVScrollInc) -
                          lpGrigliaStruct->nVScrollPos %
                          lpGrigliaStruct->nVScrollInc;
            break;

        case SB_PAGEUP:
            nVscrollInc = lpGrigliaStruct->nVScrollPos %
                          lpGrigliaStruct->nVScrollInc == 0 ?
                          -lpGrigliaStruct->nVScrollInc :
                          -lpGrigliaStruct->nVScrollPos %
                          lpGrigliaStruct->nVScrollInc;
            break;

        case SB_THUMBTRACK:
            nVscrollInc = (SHORT)LOWORD (lp) - lpGrigliaStruct->nVScrollPos;
            break;

        default:
            nVscrollInc = 0;
    }

    if  (
         (lpGrigliaStruct->nVScrollMax > 0)                                     &&
         (nVscrollInc = max (-lpGrigliaStruct->nVScrollPos,
                             min (nVscrollInc,
                                  lpGrigliaStruct->nVScrollMax -
                                  lpGrigliaStruct->nVScrollPos)))
        ) {
        LONG  lOldPos, lNewPos;
        RECT  rStaticScroll;
        WORD  wFixedRows;

        // Get Scroll Increment in pixels
        GetClientRect (lpGrigliaStruct->hWndStatic, (LPRECT)&rStaticScroll);
        if (!(wFixedRows = lpGrigliaStruct->wFixedRows)) {

            lOldPos = 0;
            if ((lpGrigliaStruct->nVScrollPos - 1) >= 0)
                lOldPos = (lpGrigliaStruct->lpHorBars +
                           lpGrigliaStruct->nVScrollPos - 1)->lPos;

            lNewPos = 0;
            if ((lpGrigliaStruct->nVScrollPos + nVscrollInc - 1) >= 0)
                lNewPos = (lpGrigliaStruct->lpHorBars +
                       lpGrigliaStruct->nVScrollPos +
                       nVscrollInc - 1)->lPos;
            rStaticScroll.top =     PUSH_V_GRID;
        } else {
            lOldPos = (lpGrigliaStruct->lpHorBars +
                       wFixedRows - 1 +
                       lpGrigliaStruct->nVScrollPos)->lPos;
            lNewPos = (lpGrigliaStruct->lpHorBars +
                       wFixedRows - 1 +
                       lpGrigliaStruct->nVScrollPos +
                       nVscrollInc)->lPos;
            rStaticScroll.top =    
                        PUSH_V_GRID +                
                        LOWORD((lpGrigliaStruct->lpHorBars +                
                               wFixedRows - 1)->lPos);                
        }

        // Remove Cursor
        PaintCursor (lpGrigliaStruct);

        lpGrigliaStruct->nVScrollPos += nVscrollInc;    
        if (rStaticScroll.top < rStaticScroll.bottom) {
    
            if (
                (GetFocus () == lpGrigliaStruct->hWndControl) ||
                (GetFocus () == lpGrigliaStruct->hWndEdit)    ||
                (GetFocus () == lpGrigliaStruct->hWndStatic)
               )
                GrigliaPaintBorder (lpGrigliaStruct);

            ScrollWindow  (lpGrigliaStruct->hWndStatic,        
                            0, LOWORD (lOldPos - lNewPos),                        
                            (LPRECT)&rStaticScroll, (LPRECT)&rStaticScroll);                

            // Repaint Cursor        
            PaintCursor (lpGrigliaStruct);    
            SetScrollPos (lpGrigliaStruct->hWndVScrollBar, SB_CTL,        
                          lpGrigliaStruct->nVScrollPos, TRUE);                            
            UpdateWindow (lpGrigliaStruct->hWndStatic);        
            lpGrigliaStruct->wTopRow = lpGrigliaStruct->nVScrollPos +        
                                       lpGrigliaStruct->wFixedRows;                               
    
        
        }    
        return ((LONG)TRUE);

    }
    return ((LONG)FALSE);

}

//---------------------------------------------------------------------------
// Griglia HSCroll
//---------------------------------------------------------------------------
LONG Griglia_HScroll (PGRIGLIA  lpGrigliaStruct,
                      WORD      wp,                      
                      LONG      lp) {                      

    int nHscrollInc;    

    switch (wp) {
        case SB_TOP:
            nHscrollInc = -lpGrigliaStruct->nHScrollPos;
            break;

        case SB_BOTTOM:
            nHscrollInc = lpGrigliaStruct->nHScrollMax -
                                  lpGrigliaStruct->nHScrollPos;
            break;

        case SB_LINEUP:
            nHscrollInc = -1;
            break;

        case SB_LINEDOWN:
            nHscrollInc = 1;
            break;

        case SB_PAGEDOWN:
            nHscrollInc = max (1, lpGrigliaStruct->nHScrollInc) -
                                          lpGrigliaStruct->nHScrollPos %
                                          lpGrigliaStruct->nHScrollInc;
            break;

        case SB_PAGEUP:
            nHscrollInc = lpGrigliaStruct->nHScrollPos %
                                  lpGrigliaStruct->nHScrollInc == 0 ?
                                          -lpGrigliaStruct->nHScrollInc :
                                          -lpGrigliaStruct->nHScrollPos %
                                          lpGrigliaStruct->nHScrollInc;
            break;

        case SB_THUMBTRACK:
            nHscrollInc = (SHORT)LOWORD (lp) - lpGrigliaStruct->nHScrollPos;
            break;

        default:
            nHscrollInc = 0;
    }

    if (    
        (lpGrigliaStruct->nHScrollMax > 0) &&    
        (nHscrollInc = max (-lpGrigliaStruct->nHScrollPos,    
                            min (nHscrollInc,   
                            lpGrigliaStruct->nHScrollMax -    
                            lpGrigliaStruct->nHScrollPos)))    
       ) {
        LONG  lOldPos, lNewPos;
        RECT  rStaticScroll;
        WORD  wFixedCols;

        // Get Scroll Increment in pixels
        GetClientRect (lpGrigliaStruct->hWndStatic, (LPRECT)&rStaticScroll);
        if (!(wFixedCols = lpGrigliaStruct->wFixedCols)) {

            lOldPos = 0;
            if ((lpGrigliaStruct->nHScrollPos - 1) >= 0)
            lOldPos = (lpGrigliaStruct->lpVertBars +
                               lpGrigliaStruct->nHScrollPos - 1)->lPos;

            lNewPos = 0;
            if ((lpGrigliaStruct->nHScrollPos + nHscrollInc - 1) >= 0)
            lNewPos = (lpGrigliaStruct->lpVertBars +
                               lpGrigliaStruct->nHScrollPos +
                               nHscrollInc - 1)->lPos;
            rStaticScroll.left = PUSH_H_GRID;
        } else {
            lOldPos = (lpGrigliaStruct->lpVertBars +
                                wFixedCols - 1 +
                                lpGrigliaStruct->nHScrollPos)->lPos;
            lNewPos = (lpGrigliaStruct->lpVertBars +
                                wFixedCols - 1 +
                                lpGrigliaStruct->nHScrollPos +
                                nHscrollInc)->lPos;
            rStaticScroll.left =    
                                PUSH_H_GRID +        
                                LOWORD((lpGrigliaStruct->lpVertBars +        
                                        wFixedCols - 1)->lPos);        
        }

        // Remove Cursor
        PaintCursor (lpGrigliaStruct);

        lpGrigliaStruct->nHScrollPos += nHscrollInc;        
        if (rStaticScroll.left < rStaticScroll.right) {
    
            if (
                (GetFocus () == lpGrigliaStruct->hWndControl) ||
                (GetFocus () == lpGrigliaStruct->hWndEdit)    ||
                (GetFocus () == lpGrigliaStruct->hWndStatic)
               )
                GrigliaPaintBorder (lpGrigliaStruct);
            
            ScrollWindow  (lpGrigliaStruct->hWndStatic,            
                            LOWORD (lOldPos - lNewPos), 0,                            
                            (LPRECT)&rStaticScroll, (LPRECT)&rStaticScroll);                    

            // Repaint Cursor            
            PaintCursor (lpGrigliaStruct);    
            SetScrollPos (lpGrigliaStruct->hWndHScrollBar, SB_CTL,            
                          lpGrigliaStruct->nHScrollPos, TRUE);                                
            UpdateWindow (lpGrigliaStruct->hWndStatic);            
            lpGrigliaStruct->wLeftCol = lpGrigliaStruct->nHScrollPos +            
                                        lpGrigliaStruct->wFixedCols;                                        

        }        
        return ((LONG)TRUE);    

    }    
    return ((LONG)FALSE);

}
