//---------------------------------------------------------------------------
// Text.c
//---------------------------------------------------------------------------
// Griglia Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include "vbapi.h"
#include "griglia.h"

#define  GRIGIO_CHIARO RGB (0xc0, 0xc0, 0xc0)
#define  CR                "\r"
#define  LF                "\n"
#define  TB                "\t"

static BOOL NEAR     PaintTextLine   (PGRIGLIA, HDC, RECT, RECT,
                                      DWORD, WORD);                                      
static BOOL NEAR     PaintTextCell   (HDC, RECT, LPEXT_INPUT, LPSTR, DWORD);
static LPSTR NEAR    AppendText      (PGRIGLIA, LPSTR);
static LPSTR NEAR    AppendText_Ext  (PGRIGLIA, LPEXT_INPUT, LPSTR);

//---------------------------------------------------------------------------
// PaintText
//---------------------------------------------------------------------------
BOOL PaintText (PGRIGLIA lpGrigliaStruct,
                HDC      hDC,                
                RECT     rInvalid) {                

    RECT  rText;        
    WORD  n;

    rText.left  = 0;
    rText.right = 0;

    // Paint Fixed Row Text
    if (lpGrigliaStruct->wFixedRows) 
        for (n = 0;    
             n < lpGrigliaStruct->wFixedRows;
             ++n) {

        if (CellTBRect (lpGrigliaStruct, n, (LPRECT)&rText)) {    

            if (rText.top >= (LONG)rInvalid.bottom)            
                break;                
            else if (            
                     (            
                      (rText.top    <= (LONG)rInvalid.top)                &&             
                      (rText.bottom >= (LONG)rInvalid.top)         
                     )                                                               ||            
                     (            
                      (rText.top >= (LONG)rInvalid.top)           &&             
                      (rText.top <= (LONG)rInvalid.bottom)             
                     )            
                    ) {       
                rText.top    += SMALL_RIM;
                if (rText.bottom < rInvalid.bottom)
                    rText.bottom -= SMALL_RIM;
                PaintTextLine (lpGrigliaStruct, hDC,                
                               rInvalid, rText,                           
                               GRIGIO_CHIARO, n);                           
            }    
        }        
    }    

    // Paint Other Line Text
    for (n = (lpGrigliaStruct->wFixedRows + lpGrigliaStruct->nVScrollPos);
         n < lpGrigliaStruct->wRows;     
        ++n) {     

        if (CellTBRect (lpGrigliaStruct, n, (LPRECT)&rText)) {    

            if (rText.top >= (LONG)rInvalid.bottom)            
                break;                
            else if (            
                     (            
                      (rText.top    <= (LONG)rInvalid.top)                &&             
                      (rText.bottom >= (LONG)rInvalid.top)         
                     )                                                               ||            
                     (            
                      (rText.top >= (LONG)rInvalid.top)           &&             
                      (rText.top <= (LONG)rInvalid.bottom)             
                     )            
                    ) {       
                rText.top    += SMALL_RIM;
                if (rText.bottom < rInvalid.bottom)
                    rText.bottom -= SMALL_RIM;
                if ((lpGrigliaStruct->lpHorBars + n)->wStatus == DISABLE_FLAG)
                    PaintTextLine (lpGrigliaStruct, hDC, rInvalid,        
                                   rText, GRIGIO_CHIARO, n);                   
                else            
                    PaintTextLine (lpGrigliaStruct, hDC, rInvalid,        
                                   rText, (DWORD)NULL, n);                   
            }
        }    
    }
    return (TRUE);
}

//---------------------------------------------------------------------------
// PaintTextLine
//---------------------------------------------------------------------------
static BOOL NEAR PaintTextLine (PGRIGLIA lpGrigliaStruct,
                                HDC      hDC,         
                                RECT     rInvalid,
                                RECT     rText,
                                DWORD    dwBkColor,
                                WORD     wRow) {
                                    
    WORD      n;
    LPSTR     lpText;
    static    EXT_INPUT eInput;

    // Paint Fixed Col Text
    if (lpGrigliaStruct->wFixedCols) 
        for (n = 0;
             n < lpGrigliaStruct->wFixedCols;                                                                  
             ++n) {                                                                  

        if (CellLRRect (lpGrigliaStruct, n, (LPRECT)&rText)) {    

            if (rText.left >= (LONG)rInvalid.right)
                break;    
            else if (
                     (
                      (rText.left  <= (LONG)rInvalid.left) &&
                      (rText.right >= (LONG)rInvalid.left)
                     )                                                                ||
                    (
                     (rText.left >= (LONG)rInvalid.left)  &&
                     (rText.left <= (LONG)rInvalid.right)
                    )
                ) {   
                rText.left  += SMALL_RIM;
                if (rText.right < rInvalid.right)
                    rText.right -= SMALL_RIM;

                _fmemset ((LPSTR)&eInput, 0, sizeof (EXT_INPUT));
                if (lpText = GetCellText_Ext (lpGrigliaStruct, wRow, n, &eInput))
                    PaintTextCell (hDC, rText, &eInput,
                                   lpText, GRIGIO_CHIARO);                   
                else
                    PaintTextCell (hDC, rText, &eInput,
                                   "", GRIGIO_CHIARO);                   
            }    
        }        
    }

    // Paint Other Column Text
    for (n = (lpGrigliaStruct->wFixedCols + lpGrigliaStruct->nHScrollPos);
         n < lpGrigliaStruct->wCols; 
         ++n) {

        if (CellLRRect (lpGrigliaStruct, n, (LPRECT)&rText)) {    

            if (rText.left >= (LONG)rInvalid.right)
                break;    
            else if (
                     (
                      (rText.left  <= (LONG)rInvalid.left) &&
                      (rText.right >= (LONG)rInvalid.left)
                     )                                                                ||
                    (
                     (rText.left >= (LONG)rInvalid.left)  &&
                     (rText.left <= (LONG)rInvalid.right)
                    )
                ) {

                rText.left  += SMALL_RIM;
                if (rText.right < rInvalid.right)
                    rText.right -= SMALL_RIM;

                _fmemset ((LPSTR)&eInput, 0, sizeof (EXT_INPUT));
                if (lpText = GetCellText_Ext (lpGrigliaStruct, wRow, n, &eInput)) {
                    if ((lpGrigliaStruct->lpVertBars + n)->wStatus == DISABLE_FLAG)
                        PaintTextCell (hDC, rText, &eInput,
                                       lpText, GRIGIO_CHIARO);                        
                    else {
                        if (dwBkColor)         
                            PaintTextCell (hDC, rText, &eInput,
                                           lpText, dwBkColor);                        
                        else         
                            PaintTextCell (hDC, rText, &eInput,
                                           lpText, GetBkColor (hDC));                        
                    }
                } else {
                    if ((lpGrigliaStruct->lpVertBars + n)->wStatus == DISABLE_FLAG)
                        PaintTextCell (hDC, rText, &eInput,
                                       "", GRIGIO_CHIARO);                        
                    else {
                        if (dwBkColor)         
                            PaintTextCell (hDC, rText, &eInput,
                                           "", dwBkColor);                        
                        else         
                            PaintTextCell (hDC, rText, &eInput,
                                           "", GetBkColor (hDC));                        
                    }
                }    
            }    
        }        
    }

    return (TRUE);    
}

//---------------------------------------------------------------------------
// PaintTextCell
//---------------------------------------------------------------------------
static BOOL NEAR PaintTextCell (HDC         hDC,
                                RECT        rRect,
                                LPEXT_INPUT lpExt,
                                LPSTR       lpStr,
                                DWORD       dwBkColor) {

    BOOL  bRet;
    DWORD dwOldBkColor;
    UINT  nLen;

    dwOldBkColor = SetBkColor (hDC, dwBkColor);
    if (
        (lpStr)           &&
        (nLen = _fstrlen (lpStr))
       ) {

        if (*(LPSTR)lpExt == (BYTE) PASSWORD)
            bRet = PaintTextCell_Ext (hDC,
                                      rRect,
                                      lpExt,
                                      lpStr);
        else if (_fstrncmp (lpStr, "+_!`", 4) == 0) {
            HRGN hRgn;                
    
            rRect.top    += SMALL_RIM;
            rRect.bottom -= SMALL_RIM;
            rRect.left   += SMALL_RIM;
            rRect.right  -= SMALL_RIM;

            if (hRgn = CreateRectRgn (rRect.left, rRect.top,
                                      rRect.right, rRect.bottom)) {
                FillRgn (hDC, hRgn, GetStockObject (DKGRAY_BRUSH));
                DeleteObject (hRgn);
            }
           
        } else
            bRet = ExtTextOut ( hDC,
                                rRect.left, rRect.top,
                                ETO_CLIPPED | ETO_OPAQUE,
                                (LPRECT)&rRect,
                                lpStr, nLen,
                                (LPINT)NULL);
    } else {

        if (*(LPSTR)lpExt == (BYTE) PASSWORD)
            bRet = PaintTextCell_Ext (hDC,
                                      rRect,
                                      lpExt,
                                      " ");
        else
            bRet = ExtTextOut (hDC,
                                rRect.left, rRect.top,
                                ETO_CLIPPED | ETO_OPAQUE,
                                (LPRECT)&rRect,
                                " ", 1,
                                (LPINT)NULL);
    }

    SetBkColor (hDC, dwOldBkColor);
    return (bRet);

}

//---------------------------------------------------------------------------
// SetCellText
//---------------------------------------------------------------------------
BOOL SetCellText (PGRIGLIA lpGrigliaStruct,
                  WORD     wRow,
                  WORD     wCol,
                  LPSTR    lpStr) {

    RECT rText;
    HDC  hDC;
    BOOL bRet;
    static EXT_INPUT eInput;

    _fmemset ((LPSTR)&eInput, 0, sizeof (EXT_INPUT));
    GetCellText_Ext (lpGrigliaStruct, wRow, wCol, &eInput);

    if (
        (
         (wRow >= lpGrigliaStruct->wFixedRows) &&
         (wRow < lpGrigliaStruct->wTopRow)
        ) ||
        (
         (wCol >= lpGrigliaStruct->wFixedCols) &&
         (wCol < lpGrigliaStruct->wLeftCol)
        )
       )
       return (TRUE);

    if (CellRect (lpGrigliaStruct, wCol, wRow, (LPRECT)&rText)) {        

        rText.top    += SMALL_RIM;
        rText.bottom -= SMALL_RIM;
        rText.left   += SMALL_RIM;
        rText.right  -= SMALL_RIM;

        // Get DC of Static Window
        if (
            (lpGrigliaStruct->hWndStatic) &&
            (hDC = GetDC (lpGrigliaStruct->hWndStatic))
           ) {

            HFONT  hOldFont;

            hOldFont = SelectObject (hDC, lpGrigliaStruct->hFont);

            // Store Value
            if (
                (wRow < lpGrigliaStruct->wFixedRows) ||
                (wCol < lpGrigliaStruct->wFixedCols) ||
                ((lpGrigliaStruct->lpHorBars + wRow)->wStatus == DISABLE_FLAG) ||
                ((lpGrigliaStruct->lpVertBars + wCol)->wStatus == DISABLE_FLAG)
               )
                bRet = PaintTextCell (hDC, rText, &eInput,
                                      lpStr, GRIGIO_CHIARO);
            else {
                if (
                    (wRow <= lpGrigliaStruct->wSelEndRow) &&
                    (wRow >= lpGrigliaStruct->wSelStartRow) &&
                    (wCol <= lpGrigliaStruct->wSelEndCol) &&
                    (wCol >= lpGrigliaStruct->wSelStartCol) &&
                    (
                     (wRow != lpGrigliaStruct->wCursorRow) ||
                     (wCol != lpGrigliaStruct->wCursorCol)
                    )
                   )
                    InvertRect (hDC, &rText);
                else if (
                         (wRow == lpGrigliaStruct->wCursorRow) &&
                         (wCol == lpGrigliaStruct->wCursorCol)
                        )
                    PaintCursorLocal (lpGrigliaStruct, hDC);

                bRet = PaintTextCell (hDC, rText, &eInput,
                                      lpStr, GetBkColor (hDC));
                if (
                    (wRow <= lpGrigliaStruct->wSelEndRow) &&
                    (wRow >= lpGrigliaStruct->wSelStartRow) &&
                    (wCol <= lpGrigliaStruct->wSelEndCol) &&
                    (wCol >= lpGrigliaStruct->wSelStartCol) &&
                    (
                     (wRow != lpGrigliaStruct->wCursorRow) ||
                     (wCol != lpGrigliaStruct->wCursorCol)
                    )
                   )
                    InvertRect (hDC, &rText);
                else if (
                         (wRow == lpGrigliaStruct->wCursorRow) &&
                         (wCol == lpGrigliaStruct->wCursorCol)
                        )
                    PaintCursorLocal (lpGrigliaStruct, hDC);
            }

            SelectObject (hDC, hOldFont);
            ReleaseDC (lpGrigliaStruct->hWndStatic, hDC);
            return (bRet);
        }
        
    }
    return (FALSE);
}

//---------------------------------------------------------------------------
// SetEditText
//---------------------------------------------------------------------------
BOOL SetEditText (PGRIGLIA lpGrigliaStruct,
                  WORD     wRow,
                  WORD     wCol) {

    int   nLen;
    LPSTR lpStr;

    if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
        return (TRUE);

    if (lpStr = GetCellText (lpGrigliaStruct, wRow, wCol)) {

        if (nLen = GetWindowTextLength (lpGrigliaStruct->hWndEdit)) {
            HANDLE hText;
            PSTR   pStr;

            if ( hText = LocalAlloc ( LHND,
                                      nLen + 3) ) {
                pStr = (PSTR) LocalLock (hText);
                GetWindowText (lpGrigliaStruct->hWndEdit,
                               (LPSTR)pStr, nLen + 1);

                if (lstrcmp (lpStr, (LPSTR)pStr))
                    SetWindowText (lpGrigliaStruct->hWndEdit, lpStr);

                LocalUnlock (hText);
                LocalFree   (hText);
                return (TRUE);
            }
        } else {
            if (lstrlen (lpStr))
                SetWindowText (lpGrigliaStruct->hWndEdit, lpStr);
            else
                SetWindowText (lpGrigliaStruct->hWndEdit, "");
            return (TRUE);
        }
    } else  {
    	SetWindowText (lpGrigliaStruct->hWndEdit, "");
    	return (TRUE);
    }
}

//---------------------------------------------------------------------------
// GetCellText
//---------------------------------------------------------------------------
LPSTR GetCellText (PGRIGLIA lpGrigliaStruct,
                   WORD     wRow,
                   WORD     wCol) {

	WORD wClusRows,
		 wClusNum,
		 wClusPos;

	// Determine Row Cluster and Cluster Position
	wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
				lpGrigliaStruct->wCols));
	wClusNum  = wRow / wClusRows;
	wClusPos  = wCol +
				(wRow -	wClusNum * wClusRows) * lpGrigliaStruct->wCols;

	if (
		(wClusNum < ROW_CLUSTER) 							&&
		(lpGrigliaStruct->cRowCluster [wClusNum].hCluster)
	   ) {
		LPSTR lpStr;

		lpStr = (LPSTR)*((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster +
                                                     wClusPos);
		return (lpStr);

	}
	return ((LPSTR)NULL);
}

//---------------------------------------------------------------------------
// GetCellText_Ext
//---------------------------------------------------------------------------
LPSTR GetCellText_Ext (PGRIGLIA     lpGrigliaStruct,
                       WORD         wRow,
                       WORD         wCol,
                       LPEXT_INPUT  lpExt) {

	WORD wClusRows,
		 wClusNum,
		 wClusPos;

	// Determine Row Cluster and Cluster Position
	wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
				lpGrigliaStruct->wCols));
	wClusNum  = wRow / wClusRows;
	wClusPos  = wCol +
				(wRow -	wClusNum * wClusRows) * lpGrigliaStruct->wCols;

	if (
		(wClusNum < ROW_CLUSTER) 							&&
		(lpGrigliaStruct->cRowCluster [wClusNum].hCluster)
	   ) {
		LPSTR lpStr;

		lpStr = (LPSTR)*((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster +
                                                     wClusPos);

                // return extension
                if (lpExt)
                    _fmemset (lpExt, 0, sizeof (EXT_INPUT));
                if (
                    (lpStr) &&
                    (*(lpStr + _fstrlen (lpStr) + 1) == PASSWORD)
                   )
                    _fmemcpy (lpExt,
                              lpStr + _fstrlen (lpStr) + 1,
                              sizeof (EXT_INPUT));
		return (lpStr);

	}
	return ((LPSTR)NULL);
}

//---------------------------------------------------------------------------
// PutCellText
//---------------------------------------------------------------------------
BOOL PutCellText (PGRIGLIA lpGrigliaStruct,
                  WORD     wRow,                  
                  WORD     wCol,
                  LPSTR    lpText) {

    WORD  wClusRows,
          wClusNum,      
          wClusPos;

    // Determine Row Cluster and Cluster Position
    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
                lpGrigliaStruct->wCols));
    wClusNum  = wRow / wClusRows;
    wClusPos  = wCol +
                (wRow - wClusNum * wClusRows) * lpGrigliaStruct->wCols;

    // If Necesary Allocate Row Cluster
    if (
        (wClusNum < ROW_CLUSTER)                                &&                        
        (!lpGrigliaStruct->cRowCluster [wClusNum].hCluster)
       ) {
        if (lpGrigliaStruct->cRowCluster [wClusNum].hCluster = GlobalAlloc (GHND,    
                                                                            ROW_CLUSTER_SIZE))                                   
        lpGrigliaStruct->cRowCluster [wClusNum].lpCluster =            
            (LPSTR)GlobalLock (lpGrigliaStruct->cRowCluster                                
                                [wClusNum].hCluster);                                               
    }    

    if (    
        (wClusNum < ROW_CLUSTER)                                                        &&        
        (lpGrigliaStruct->cRowCluster [wClusNum].hCluster)        
       ) {       

        LPSTR  lpStoredText;        

        lpStoredText = (LPSTR)*((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster + wClusPos);        

        if (        
            (lpStoredText)                                  &&
            (_fstrlen (lpText) == _fstrlen (lpStoredText))
           )       
            _fstrcpy (lpStoredText, lpText);
        else {
            // see if there is an extension
            if (
                (lpStoredText) &&
                (*(lpStoredText + _fstrlen (lpStoredText) + 1) == PASSWORD)
               ) {

                static EXT_INPUT eInput;

                _fmemset ((LPSTR)&eInput, 0, sizeof (EXT_INPUT));
                GetCellText_Ext (lpGrigliaStruct, wRow, wCol, &eInput);
                if (lpStoredText = AppendText_Ext (lpGrigliaStruct,
                                                   (LPEXT_INPUT)&eInput, lpText)) {
                    LPSTR lpStr;

                    lpStr               = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster +
                                                          wClusPos);
                    *(LPINT)lpStr       = FP_OFF (lpStoredText);
                    *(LPINT)(lpStr + 2) = FP_SEG (lpStoredText);
                }

            } else if (lpStoredText = AppendText (lpGrigliaStruct, lpText)) {
                LPSTR lpStr;                

                lpStr               = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster +                
                                                        wClusPos);       
                *(LPINT)lpStr       = FP_OFF (lpStoredText);                
                *(LPINT)(lpStr + 2) = FP_SEG (lpStoredText);                
            }            
        }        
        return (TRUE);        
    }    
    return (FALSE);    
}

//---------------------------------------------------------------------------
// PutCellText_Ext
//---------------------------------------------------------------------------
BOOL PutCellText_Ext (PGRIGLIA    lpGrigliaStruct,
                      WORD        wRow,
                      WORD        wCol,
                      LPEXT_INPUT lpExt,
                      LPSTR       lpText) {

    WORD  wClusRows,
          wClusNum,      
          wClusPos;

    // Determine Row Cluster and Cluster Position
    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
                lpGrigliaStruct->wCols));
    wClusNum  = wRow / wClusRows;
    wClusPos  = wCol +
                (wRow - wClusNum * wClusRows) * lpGrigliaStruct->wCols;

    // If Necesary Allocate Row Cluster
    if (
        (wClusNum < ROW_CLUSTER)                                &&                        
        (!lpGrigliaStruct->cRowCluster [wClusNum].hCluster)
       ) {
        if (lpGrigliaStruct->cRowCluster [wClusNum].hCluster = GlobalAlloc (GHND,    
                                                                            ROW_CLUSTER_SIZE))                                   
        lpGrigliaStruct->cRowCluster [wClusNum].lpCluster =            
            (LPSTR)GlobalLock (lpGrigliaStruct->cRowCluster                                
                                [wClusNum].hCluster);                                               
    }    

    if (    
        (wClusNum < ROW_CLUSTER)                                                        &&        
        (lpGrigliaStruct->cRowCluster [wClusNum].hCluster)        
       ) {       

        LPSTR  lpStoredText;        

        lpStoredText = (LPSTR)*((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster + wClusPos);        

        if (        
            (lpStoredText)                                              &&
            (*(lpStoredText + _fstrlen (lpStoredText) + 1) == PASSWORD) &&
            (_fstrlen (lpText) == _fstrlen (lpStoredText))
           ) {
            _fstrcpy (lpStoredText, lpText);
            _fmemcpy (lpStoredText + _fstrlen (lpText) + 1,
                      lpExt, sizeof (EXT_INPUT));

        } else {
            if (lpStoredText = AppendText_Ext (lpGrigliaStruct, lpExt, lpText)) {
                LPSTR lpStr;

                lpStr               = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster +
                                                        wClusPos);
                *(LPINT)lpStr       = FP_OFF (lpStoredText);
                *(LPINT)(lpStr + 2) = FP_SEG (lpStoredText);
            }
        }
        return (TRUE);        
    }    
    return (FALSE);    
}

//---------------------------------------------------------------------------
// AppendText
//---------------------------------------------------------------------------
static LPSTR NEAR AppendText (PGRIGLIA 	lpGrigliaStruct,
                              LPSTR     lpText) {                          

    SHORT n;
    WORD  wLen, wTemp;
    LONG  lClusSize;

    wLen = (WORD)_fstrlen (lpText) + 1;
    for (n = 0; n < TEXT_CLUSTER; ++n) {

        // Text Cluster Exists ?
        if (lpGrigliaStruct->cTextCluster [n].hCluster) {

            LPSTR lpTemp;

            lpTemp = lpGrigliaStruct->cTextCluster [n].lpCluster;

            lClusSize = (LONG)(*(LPWORD)lpTemp + 1);

            if ((lClusSize + wLen + 10) < (LONG)TEXT_CLUSTER_SIZE) {

                // Update Length
                wTemp           = wLen + LOWORD(lClusSize);
                *(LPWORD)lpTemp = wTemp;

                // Append String
                _fstrncpy (lpTemp + LOWORD(lClusSize) + 3, lpText, wLen - 1);
                *(lpTemp + LOWORD (lClusSize) + wLen + 2) = 0;
                *(lpTemp + LOWORD (lClusSize) + wLen + 3) = 0;
                return (lpGrigliaStruct->cTextCluster [n].lpCluster +
                                LOWORD(lClusSize) + 3);
            } else {    
                n = n;        
            }    
        } else if (lpGrigliaStruct->cTextCluster [n].hCluster =
                    GlobalAlloc (GHND, (DWORD)TEXT_CLUSTER_SIZE)) {       

                LPSTR lpTemp;

                lpGrigliaStruct->cTextCluster [n].lpCluster =
                                (LPSTR)GlobalLock (lpGrigliaStruct->cTextCluster [n].
                                                                   hCluster);
                lpTemp = lpGrigliaStruct->cTextCluster [n].lpCluster;

                // Initialize First Two Bytes to Length
                *(LPWORD)lpTemp = wLen;

                // Append String
                _fstrncpy (lpTemp + 2, lpText, wLen - 1);
                *(lpTemp + wLen + 1) = 0;
                *(lpTemp + wLen + 2) = 0;
                return (lpTemp + 2);

        }
    }
    return ((LPSTR)NULL);
}

//---------------------------------------------------------------------------
// AppendText_Ext
//---------------------------------------------------------------------------
static LPSTR NEAR AppendText_Ext (PGRIGLIA    lpGrigliaStruct,
                                  LPEXT_INPUT lpExt,
                                  LPSTR       lpText) {

    SHORT n;
    WORD  wLen, wTemp;
    LONG  lClusSize;

    wLen = (WORD)_fstrlen (lpText) + sizeof (EXT_INPUT);
    for (n = 0; n < TEXT_CLUSTER; ++n) {

        // Text Cluster Exists ?
        if (lpGrigliaStruct->cTextCluster [n].hCluster) {

            LPSTR lpTemp;

            lpTemp = lpGrigliaStruct->cTextCluster [n].lpCluster;

            lClusSize = (LONG)(*(LPWORD)lpTemp + 1);

            if ((lClusSize + wLen + 10) < (LONG)TEXT_CLUSTER_SIZE) {

                // Update Length
                wTemp           = wLen + LOWORD(lClusSize);
                *(LPWORD)lpTemp = wTemp;

                // Append String
                _fstrncpy (lpTemp + LOWORD(lClusSize) + 3,
                           lpText, _fstrlen (lpText));
                *(lpTemp + LOWORD (lClusSize) + _fstrlen (lpText) + 3) = 0;
                _fmemcpy  (lpTemp + LOWORD(lClusSize) + _fstrlen (lpText) + 3 + 1,
                           lpExt, sizeof (EXT_INPUT));
                return (lpGrigliaStruct->cTextCluster [n].lpCluster +
                        LOWORD(lClusSize) + 3);
            } else {    
                n = n;        
            }    
        } else if (lpGrigliaStruct->cTextCluster [n].hCluster =
                    GlobalAlloc (GHND, (DWORD)TEXT_CLUSTER_SIZE)) {       

                LPSTR lpTemp;

                lpGrigliaStruct->cTextCluster [n].lpCluster =
                                (LPSTR)GlobalLock (lpGrigliaStruct->cTextCluster [n].
                                                                   hCluster);
                lpTemp = lpGrigliaStruct->cTextCluster [n].lpCluster;

                // Initialize First Two Bytes to Length
                *(LPWORD)lpTemp = wLen;

                // Append String
                _fstrncpy (lpTemp + 2,
                           lpText, _fstrlen (lpText));
                *(lpTemp + _fstrlen (lpText) + 2) = 0;
                _fmemcpy  (lpTemp + 2 + _fstrlen (lpText) + 1,
                           lpExt, sizeof (EXT_INPUT));
                return (lpTemp + 2);

        }
    }
    return ((LPSTR)NULL);
}

//---------------------------------------------------------------------------
// WriteClip
//---------------------------------------------------------------------------
BOOL WriteClip (PGRIGLIA lpGrigliaStruct,
		 	    LONG     lp,
			    HCTL	 hctl) {

	HANDLE hText;
	LPSTR  lpText, lpStr;
	SHORT  n, m;
	HSZ FAR *lpTemp;

	if (hText = GlobalAlloc (GHND, (DWORD)0xffff)) {
		LPSTR lpText;

		lpText  = (LPSTR)GlobalLock (hText);
		*lpText = 0;

		for (n =  (SHORT)lpGrigliaStruct->wSelStartRow;
		 	 n <= (SHORT)lpGrigliaStruct->wSelEndRow;
		 	 ++n) {

			if (n > (SHORT)lpGrigliaStruct->wSelStartRow) {
				lstrcat (lpText, CR);
				lstrcat (lpText, LF);
			}

			for (m =  (SHORT)lpGrigliaStruct->wSelStartCol;
				 m <= (SHORT)lpGrigliaStruct->wSelEndCol;
				 ++m) {

				if (m > (SHORT)lpGrigliaStruct->wSelStartCol)
					lstrcat (lpText, TB);
				if (lpStr = GetCellText (lpGrigliaStruct, n ,m))
					lstrcat (lpText, lpStr);
			}
		}
		if (lstrlen (lpText)) {
			lpTemp  = (HSZ FAR *)lp;
	        *lpTemp = VBCreateHsz ((_segment)hctl, lpText);
		} else {
			lpTemp  = (HSZ FAR *)lp;
	        *lpTemp = VBCreateHsz ((_segment)hctl, (LPSTR)"");
		}

		GlobalUnlock (hText);
		GlobalFree   (hText);
		return (TRUE);

	}

	lpTemp  = (HSZ FAR *)lp;
	*lpTemp = VBCreateHsz ((_segment)hctl, lpText);
	return (FALSE);
}

//---------------------------------------------------------------------------
// ReadClip
//---------------------------------------------------------------------------
BOOL ReadClip (PGRIGLIA lpGrigliaStruct,
			   LONG     lp,
			   HCTL	 	hctl) {

	LPSTR  lpText = (LPSTR)lp;
	LPSTR  lpTab, lpCr, lpLf;
	SHORT  n, m, nOffset = 0, nSize, nLen;

	nLen = lstrlen (lpText);
	for (n =  (SHORT)lpGrigliaStruct->wSelStartRow;
		 n <= (SHORT)lpGrigliaStruct->wSelEndRow;
		 ++n) {

		for (m =  (SHORT)lpGrigliaStruct->wSelStartCol;
			 m <= (SHORT)lpGrigliaStruct->wSelEndCol;
			 ++m) {

			lpTab = _fstrchr (lpText + nOffset, '\t');
			lpCr  = _fstrchr (lpText + nOffset, '\r');
			lpLf  = _fstrchr (lpText + nOffset, '\n');

            if (
                (!lpTab) && (!lpCr) && (!lpLf)
               ) {
               	if (nLen - nOffset) {
					if (PutCellText (lpGrigliaStruct, n, m,
									 lpText + nOffset))
						SetCellText (lpGrigliaStruct, n, m,
									 lpText + nOffset);
					nOffset = nLen;
               	} else {
					if (PutCellText (lpGrigliaStruct, n, m,
									 (LPSTR) ""))
						SetCellText (lpGrigliaStruct, n, m,
									 (LPSTR) "");
			   	}

			} else if (!lpTab) {

				// no more tab found
				if ((lpLf) || (lpCr)) {
					if (lpLf && lpCr)
						nSize   = min ((lpLf - lpText - nOffset),
									   (lpCr - lpText - nOffset));
					else if (lpLf)
						nSize   = (lpLf - lpText - nOffset);
					else
						nSize   = (lpCr - lpText - nOffset);

					// cut string at appropriate size
					*(lpText + nOffset + nSize) = 0;

					if (nSize) {
						if (PutCellText (lpGrigliaStruct, n, m,
										 lpText + nOffset))
							SetCellText (lpGrigliaStruct, n, m,
										 lpText + nOffset);
               		} else {
						if (PutCellText (lpGrigliaStruct, n, m,
									 	(LPSTR) ""))
							SetCellText (lpGrigliaStruct, n, m,
									 	(LPSTR) "");
			   		}

					if (lpLf && lpCr)
						nOffset = max ((lpLf - lpText + 1),
									   (lpCr - lpText + 1));
					else if (lpLf)
						nOffset = (lpLf - lpText + 1);
					else
						nOffset = (lpCr - lpText + 1);
					break;

				} else {
				    if (nLen - nOffset) {
						if (PutCellText (lpGrigliaStruct, n, m,
										 lpText + nOffset))
							SetCellText (lpGrigliaStruct, n, m,
										 lpText + nOffset);
               		} else {
						if (PutCellText (lpGrigliaStruct, n, m,
									 	(LPSTR) ""))
							SetCellText (lpGrigliaStruct, n, m,
									 	(LPSTR) "");
			   		}

					if (lpGrigliaStruct->hszClip)
						VBDestroyHsz (lpGrigliaStruct->hszClip);
					if (lpGrigliaStruct->hszClip =
						VBCreateHsz ((_segment)hctl,(LPSTR)lp))
						return (TRUE);
					return (FALSE);

				}

			} else if (
					   (lpLf && ((lpLf - lpText) < (lpTab - lpText))) ||
					   (lpCr && ((lpCr - lpText) < (lpTab - lpText)))
					  ) {
				// found Lf before Tab
				if (lpLf && lpCr)
					nSize   = min ((lpLf - lpText - nOffset),
								   (lpCr - lpText - nOffset));
				else if (lpLf)
					nSize   = (lpLf - lpText - nOffset);
				else
					nSize   = (lpCr - lpText - nOffset);

				// cut string at appropriate size
				*(lpText + nOffset + nSize) = 0;

				if (nSize) {
					if (PutCellText (lpGrigliaStruct, n, m,
									 lpText + nOffset))
						SetCellText (lpGrigliaStruct, n, m,
									 lpText + nOffset);
               	} else {
					if (PutCellText (lpGrigliaStruct, n, m,
								 	(LPSTR) ""))
						SetCellText (lpGrigliaStruct, n, m,
								 	(LPSTR) "");
			   	}

				if (lpLf && lpCr)
					nOffset = max ((lpLf - lpText + 1),
								   (lpCr - lpText)+ 1);
				else if (lpLf)
					nOffset = (lpLf - lpText + 1);
				else
					nOffset = (lpCr - lpText + 1);

				break;

			} else {

				// cut string at tab
				*lpTab  = 0;

				// insert text into appropriate cell
				if (lpTab - lpText - nOffset) {
					if (PutCellText (lpGrigliaStruct, n, m,
									 lpText + nOffset))
						SetCellText (lpGrigliaStruct, n, m,
									 lpText + nOffset);
               	} else {
					if (PutCellText (lpGrigliaStruct, n, m,
								 	(LPSTR) ""))
						SetCellText (lpGrigliaStruct, n, m,
								 	(LPSTR) "");
			   	}

				// recompute nOffset
				nOffset = (lpTab - lpText + 1);
			}

		}
		if (m > (SHORT)lpGrigliaStruct->wSelEndCol) {
			lpCr  = _fstrchr (lpText + nOffset, '\r');
			lpLf  = _fstrchr (lpText + nOffset, '\n');
			if (lpLf && lpCr)
				nOffset = max ((lpLf - lpText),
							   (lpCr - lpText));
			else if (lpLf)
				nOffset = (lpLf - lpText);
			else if (lpCr)
				nOffset = (lpCr - lpText);
		}
	}
	if (lpGrigliaStruct->hszClip)
		VBDestroyHsz (lpGrigliaStruct->hszClip);
	if (lpGrigliaStruct->hszClip = VBCreateHsz ((_segment)hctl,(LPSTR)lp))
		return (TRUE);
	return (FALSE);
}

//---------------------------------------------------------------------------
// InsertLinesText
//---------------------------------------------------------------------------
BOOL InsertLinesText (PGRIGLIA 	lpGrigliaStruct,
                      WORD      wRow,                          
                      WORD      wInsertRows) {      

    WORD  wClusRows,
          wClusNum, wClusNumFrom, wClusNumTo,  
          wClusPos, wClusPosFrom, wClusPosTo,  
          n;  
    LPSTR lpPtr,lpPtrFrom, lpPtrTo;

    // Determine Row Cluster and Cluster Position
    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
                lpGrigliaStruct->wCols));            

    for (n = lpGrigliaStruct->wRows - wInsertRows - 1; n >= wRow; --n) {

        // positions to copy from    
        wClusNumFrom = n / wClusRows;    
        wClusPosFrom = (n -     wClusNumFrom * wClusRows)  *    
                       lpGrigliaStruct->wCols;                
        lpPtrFrom    = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNumFrom].lpCluster + wClusPosFrom);

        // positions to copy to    
        wClusNumTo = (n + wInsertRows) / wClusRows;    
        wClusPosTo = ((n + wInsertRows) - wClusNumTo * wClusRows) *    
                     lpGrigliaStruct->wCols;             
        lpPtrTo    = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNumTo].lpCluster + wClusPosTo);

        _fmemcpy (lpPtrTo,
                  lpPtrFrom,        
                  (sizeof (LPSTR) * lpGrigliaStruct->wCols));  

    }    

    for (n = wRow; n < wRow + wInsertRows; ++n) {

        // positions to copy from    
        wClusNum = n / wClusRows;    
        wClusPos = (n - wClusNum * wClusRows) *    
                   lpGrigliaStruct->wCols;                        
        lpPtr    = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster + wClusPos);
        _fmemset (lpPtr,
                      0,
                      (sizeof (LPSTR) * lpGrigliaStruct->wCols));

    }
    return (TRUE);
}

//---------------------------------------------------------------------------
// DeleteLinesText
//---------------------------------------------------------------------------
BOOL DeleteLinesText (PGRIGLIA 	lpGrigliaStruct,
                      WORD      wRow,
                      WORD      wDeleteRows) {

    WORD  wClusRows,
          wClusNum, wClusNumFrom, wClusNumTo,      
          wClusPos, wClusPosFrom, wClusPosTo,
          n;
    LPSTR lpPtr,lpPtrFrom, lpPtrTo;

    // Determine Row Cluster and Cluster Position
    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
                                     lpGrigliaStruct->wCols));

    for (n = wRow; n < lpGrigliaStruct->wRows - wDeleteRows; ++n) {

        // positions to copy from        
        wClusNumTo = n / wClusRows;    
        wClusPosTo = (n - wClusNumTo * wClusRows)  *    
                          lpGrigliaStruct->wCols;            
        lpPtrTo    = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNumTo].lpCluster + wClusPosTo);

        // positions to copy to    
        wClusNumFrom = (n + wDeleteRows) / wClusRows;    
        wClusPosFrom = ((n + wDeleteRows) - wClusNumFrom * wClusRows) *    
                                            lpGrigliaStruct->wCols;   
        lpPtrFrom    = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNumFrom].lpCluster + wClusPosFrom);

        _fmemcpy (lpPtrTo,
                  lpPtrFrom,    
                  (sizeof (LPSTR) * lpGrigliaStruct->wCols));  

    }

    for (n = lpGrigliaStruct->wRows - wDeleteRows;
             n < lpGrigliaStruct->wRows; ++n) {

        // positions to copy from    
        wClusNum = n / wClusRows;    
        wClusPos = (n - wClusNum * wClusRows) *    
                        lpGrigliaStruct->wCols;                    
        lpPtr    = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster [wClusNum].lpCluster + wClusPos);
        _fmemset (lpPtr,
                  0,
                  (sizeof (LPSTR) * lpGrigliaStruct->wCols));

    }    
    return (TRUE);
}

//---------------------------------------------------------------------------
// FindText
//---------------------------------------------------------------------------
BOOL FindText (PGRIGLIA 	lpGrigliaStruct,
               LPFINDTEXT 	lpFind) {

    WORD	wClusRows,
		wClusNum,
		wClusPos,
		n;
    LPSTR	lpStr;
    LPFINDTEXT	lpLoop;
    BOOL  bFound;

    if (!lpFind)
	return (FALSE);

    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
		lpGrigliaStruct->wCols));

    for (n = 0; n < lpGrigliaStruct->wRows; ++n) {

	bFound = TRUE;
	lpLoop = lpFind;

	// loop over all search blocks
	while (
		(bFound)		 &&
		(lpLoop->wCol != 0xffff) &&
		(lpLoop->lpText)
	      ) {

	    wClusNum  = n / wClusRows;
	    wClusPos  = lpLoop->wCol +
			(n - wClusNum * wClusRows) *
			lpGrigliaStruct->wCols;
	    lpStr = (LPSTR)*((LPLONG)
		    lpGrigliaStruct->cRowCluster [wClusNum].lpCluster +
		    wClusPos);

	    if (
		(!lpStr)  ||
		(_fstrcmp (lpStr, lpLoop->lpText))
	       )
		bFound = FALSE;

	    // fetch next search column
	    ++lpLoop;
	}

	if (bFound)
                return (n);
    }
    return (0xffff);
}

//---------------------------------------------------------------------------
// ClearText
//---------------------------------------------------------------------------
void ClearText (PGRIGLIA lpGrigliaStruct) {
        
    UINT n;
    
    // Release Text Blocks
    for (n = 0; n < (int) ROW_CLUSTER; ++n) {
        if (lpGrigliaStruct->cRowCluster [n].hCluster) {    
            GlobalUnlock (lpGrigliaStruct->cRowCluster [n].hCluster);        
            GlobalFree   (lpGrigliaStruct->cRowCluster [n].hCluster);        
            lpGrigliaStruct->cRowCluster [n].hCluster  = (HANDLE)NULL;        
            lpGrigliaStruct->cRowCluster [n].lpCluster = (LPSTR)NULL;        
        }    
    }

    // Release Text Blocks
    for (n = 0; n < TEXT_CLUSTER; ++n) {
        if (lpGrigliaStruct->cTextCluster [n].hCluster) {    
            GlobalUnlock (lpGrigliaStruct->cTextCluster [n].hCluster);        
            GlobalFree   (lpGrigliaStruct->cTextCluster [n].hCluster);        
            lpGrigliaStruct->cTextCluster [n].hCluster  = (HANDLE)NULL;        
            lpGrigliaStruct->cTextCluster [n].lpCluster = (LPSTR)NULL;        
        }    
    }
}

//---------------------------------------------------------------------------
// CompareLines
//---------------------------------------------------------------------------
SHORT CompareLines (PGRIGLIA         lpGrigliaStruct,
                    LPFINDTEXT       lpFind,
                    UINT             nRow1,
                    UINT             nRow2) {
                 
    UINT  wClusRows, 
          wClusNum,
          wClusPos;
    LPFINDTEXT lpLoop;
    LPSTR      lpStr1, lpStr2;
    BOOL  bFound;
    
    if ( !lpFind)
	return (FALSE);

    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
		lpGrigliaStruct->wCols));

    bFound = TRUE;
    lpLoop = lpFind;

    // loop over all search blocks
    while (
            (bFound)                 &&
            (lpLoop->wCol != 0xffff) 
          ) {

        wClusNum  = nRow1 / wClusRows;
        wClusPos  = lpLoop->wCol +
                    (nRow1 - wClusNum * wClusRows) *
                    lpGrigliaStruct->wCols;
        lpStr1    = (LPSTR)*((LPLONG)
                    lpGrigliaStruct->cRowCluster [wClusNum].lpCluster +
                    wClusPos);
        wClusNum  = nRow2 / wClusRows;
        wClusPos  = lpLoop->wCol +
                    (nRow2 - wClusNum * wClusRows) *
                    lpGrigliaStruct->wCols;
        lpStr2    = (LPSTR)*((LPLONG)
                    lpGrigliaStruct->cRowCluster [wClusNum].lpCluster +
                    wClusPos);

        if (
            (!lpStr1)  ||
            (!lpStr2)  
           ) 
            bFound = FALSE;
        else    
            bFound = (_fstrcmp (lpStr1, lpStr2) == 0);

        // fetch next search column
        ++lpLoop;
    }       
    if (    
        (!lpStr1)  ||    
        (!lpStr2)      
       )    
        return (0);
    else
        return (_fstrcmp (lpStr1, lpStr2));
}

//---------------------------------------------------------------------------
// SwitchLines
//---------------------------------------------------------------------------
void SwitchLines (PGRIGLIA         lpGrigliaStruct,
                  UINT             nRow1,
                  UINT             nRow2) {
                    
    UINT  wClusRows, 
          wClusNum1,
          wClusNum2,
          wClusPos1,
          wClusPos2;
    LPSTR lpStr1, 
          lpStr2,
          lpTemp;      
    HANDLE hTemp;      
    
    // line 1
    wClusRows = (ROW_CLUSTER_SIZE / (sizeof (LPSTR) *
		lpGrigliaStruct->wCols));
    wClusNum1 = nRow1 / wClusRows;        
    wClusPos1 = (nRow1 -  wClusNum1 * wClusRows)  *        
                 lpGrigliaStruct->wCols;                   
    lpStr1    = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster 
                        [wClusNum1].lpCluster + wClusPos1);    

    // line2
    wClusNum2 = nRow2 / wClusRows;        
    wClusPos2 = (nRow2 - wClusNum2 * wClusRows) *        
                 lpGrigliaStruct->wCols;                  
    lpStr2    = (LPSTR)((LPLONG)lpGrigliaStruct->cRowCluster 
                        [wClusNum2].lpCluster + wClusPos2);    

    if (hTemp = GlobalAlloc (GHND,        
                             sizeof (LPSTR) * lpGrigliaStruct->wCols)) {
        lpTemp = (LPSTR)GlobalLock (hTemp);
        
        _fmemcpy (lpTemp,
                  lpStr1,
                  (sizeof (LPSTR) * lpGrigliaStruct->wCols));  
        _fmemcpy (lpStr1,
                  lpStr2,
                  (sizeof (LPSTR) * lpGrigliaStruct->wCols));  
        _fmemcpy (lpStr2,
                  lpTemp,
                  (sizeof (LPSTR) * lpGrigliaStruct->wCols));  
        
        GlobalUnlock (hTemp);                
        GlobalFree   (hTemp);    
    }           
}

//---------------------------------------------------------------------------
// SortText
//---------------------------------------------------------------------------
void SortText (PGRIGLIA         lpGrigliaStruct,
               LPFINDTEXT 	lpFind) {

    SHORT nLines, nGap, i, j;            

    nLines = lpGrigliaStruct->wRows - 1 - lpGrigliaStruct->wFixedRows;

    for (nGap = nLines / 2; nGap > 0; nGap /= 2) {
        for (i = nGap; i < nLines; i++) {
            for (j = i - nGap;
                 j >= 0 &&
                 (CompareLines (lpGrigliaStruct, 
                                lpFind, 
                                j + lpGrigliaStruct->wFixedRows, 
                                j + lpGrigliaStruct->wFixedRows + nGap) > 0);
                 j -= nGap) 
                SwitchLines (lpGrigliaStruct,
                             j + lpGrigliaStruct->wFixedRows, 
                             j + lpGrigliaStruct->wFixedRows + nGap);
        }
    }
}
