//---------------------------------------------------------------------------
// Util.c
//---------------------------------------------------------------------------
// Griglia Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>
#include <string.h>
#include <ctype.h>
#include "vbapi.h"
#include "griglia.h"

//--------------------------------------------------------------------------
// CellLRRect
//---------------------------------------------------------------------------
BOOL CellLRRect (PGRIGLIA lpGrigliaStruct,
                 UINT     nCol,
                 LPRECT   lpRect) {

            LONG  lScroll, lTemp;    
    static  RECT  rStatic;

    // Get Client Rect
    GetClientRect (lpGrigliaStruct->hWndStatic,	(LPRECT)&rStatic);

    // find right position of cursor cell    
    lScroll = Griglia_HorPos (nCol, lpGrigliaStruct);
    if (lScroll != INVALID_POS) {
        
        lTemp = PUSH_H_GRID + lScroll -        
                lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR);
        if (lTemp > MAKELONG (rStatic.right, 0))
            lpRect->right = rStatic.right;
        else if (lTemp < MAKELONG (rStatic.left, 0))
            lpRect->right = rStatic.left;
        else    
            lpRect->right = LOWORD (lTemp);

        // find left position of cursor cell        
        if (nCol) {            
            
            lScroll = Griglia_HorPos (nCol - 1,            
                                      lpGrigliaStruct);                                    
            if (lScroll != INVALID_POS) {
                lTemp = PUSH_H_GRID + lScroll -                
                        lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR);
                if (lTemp > MAKELONG (rStatic.right, 0))
                    lpRect->left = rStatic.right;
                else if (lTemp < MAKELONG (rStatic.left, 0))
                    lpRect->left = rStatic.left;
                else    
                    lpRect->left = LOWORD (lTemp);
                return (TRUE);
            }
            
        } else {
    
            lpRect->left = PUSH_H_GRID;        
            return (TRUE);
        }                        
    
    }
    return (FALSE);            
}                

//--------------------------------------------------------------------------
// CellTBRect
//---------------------------------------------------------------------------
BOOL CellTBRect (PGRIGLIA lpGrigliaStruct,
                 UINT     nRow,
                 LPRECT   lpRect) {
                
           LONG  lScroll, lTemp;    
    static RECT  rStatic;

    // Get Client Rect
    GetClientRect (lpGrigliaStruct->hWndStatic,	(LPRECT)&rStatic);

    // find bottom position of cursor cell        
    lScroll = Griglia_VertPos (nRow,
                                lpGrigliaStruct);
    if (lScroll != INVALID_POS) {
        
        lTemp = PUSH_V_GRID + lScroll -
                lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR);
        if (lTemp > MAKELONG (rStatic.bottom, 0))
            lpRect->bottom = rStatic.bottom;
        else if (lTemp < MAKELONG (rStatic.top, 0))
            lpRect->bottom = rStatic.top;
        else
            lpRect->bottom = LOWORD (lTemp);
    
        // find top position of cursor cell
        if (nRow > 0) {
            lScroll = Griglia_VertPos (nRow - 1,
                                       lpGrigliaStruct);
            if (lScroll != INVALID_POS) {
                lTemp  = PUSH_V_GRID + lScroll -
                         lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR);
                if (lTemp > MAKELONG (rStatic.bottom, 0))
                    lpRect->top = rStatic.bottom;
                else if (lTemp < MAKELONG (rStatic.top, 0))
                    lpRect->top = rStatic.top;
                else
                    lpRect->top = LOWORD (lTemp);
                return (TRUE);
            }
        
        } else {
    
            lpRect->top = PUSH_V_GRID;
            return (TRUE);    
        }
    }
    return (FALSE);    
}

//--------------------------------------------------------------------------
// CellRect
//---------------------------------------------------------------------------
BOOL CellRect (PGRIGLIA lpGrigliaStruct,
               UINT     nCol,
               UINT     nRow,
               LPRECT   lpRect) {
 
    SetRectEmpty (lpRect);
    
    if (CellLRRect (lpGrigliaStruct,
                    nCol,
                    lpRect))    
        return (CellTBRect (lpGrigliaStruct,
                            nRow,
                            lpRect));
    return (FALSE);                        

}
//--------------------------------------------------------------------------
// BlockLRRect
//---------------------------------------------------------------------------
BOOL BlockLRRect (PGRIGLIA lpGrigliaStruct,
                  UINT     nStartCol,
                  UINT     nEndCol,
                  LPRECT   lpRect) {

           LONG  lScroll, lTemp;    
    static RECT  rStatic;

    // Get Client Rect
    GetClientRect (lpGrigliaStruct->hWndStatic,	(LPRECT)&rStatic);

    // find right position of cursor cell    
    lScroll = Griglia_HorPos (nEndCol, lpGrigliaStruct);
    if (lScroll != INVALID_POS) {
        
        lTemp = PUSH_H_GRID + lScroll -        
                lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR);
        if (lTemp > MAKELONG (rStatic.right, 0))
            lpRect->right = rStatic.right;
        else if (lTemp < MAKELONG (rStatic.left, 0))
            lpRect->right = rStatic.left;
        else    
            lpRect->right = LOWORD (lTemp);

        // find left position of cursor cell        
        if (nStartCol > 0) {
            
            lScroll = Griglia_HorPos (nStartCol - 1,            
                                    lpGrigliaStruct);                                    
            if (lScroll != INVALID_POS) {
                lTemp = PUSH_H_GRID + lScroll -                
                        lpGrigliaStruct->xChar / (2 * INTERCOLUMN_FACTOR);
                if (lTemp > MAKELONG (rStatic.right, 0))
                    lpRect->left = rStatic.right;
                else if (lTemp < MAKELONG (rStatic.left, 0))
                    lpRect->left = rStatic.left;
                else    
                    lpRect->left = LOWORD (lTemp);
                return (TRUE);
            }    
        
        } else {
    
            lpRect->left = PUSH_H_GRID;        
            return (TRUE);
    
        }
        
    }
    return (FALSE);            
}                

//--------------------------------------------------------------------------
// BlockTBRect
//---------------------------------------------------------------------------
BOOL BlockTBRect (PGRIGLIA lpGrigliaStruct,
                  UINT     nStartRow,
                  UINT     nEndRow,
                  LPRECT   lpRect) {
                
           LONG  lScroll, lTemp;    
    static RECT  rStatic;

    // Get Client Rect
    GetClientRect (lpGrigliaStruct->hWndStatic,	(LPRECT)&rStatic);

    // find bottom position of cursor cell        
    lScroll = Griglia_VertPos (nEndRow,
                               lpGrigliaStruct);
    if (lScroll != INVALID_POS) {
    
        lTemp = PUSH_V_GRID + lScroll -
                lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR);
        if (lTemp > MAKELONG (rStatic.bottom, 0))
            lpRect->bottom = rStatic.bottom;
        else if (lTemp < MAKELONG (rStatic.top, 0))
            lpRect->bottom = rStatic.top;    
        else
            lpRect->bottom = LOWORD (lTemp);
    
        // find top position of cursor cell
        if (nStartRow > 0) {
            
            lScroll = Griglia_VertPos (nStartRow - 1,
                                       lpGrigliaStruct);
            if (lScroll != INVALID_POS) {
                lTemp  = PUSH_V_GRID + lScroll -
                        lpGrigliaStruct->yChar / (2 * INTERCOLUMN_FACTOR);
                if (lTemp > MAKELONG (rStatic.bottom, 0))
                    lpRect->top = rStatic.bottom;
                else if (lTemp < MAKELONG (rStatic.top, 0))
                    lpRect->top = rStatic.top;
                else
                    lpRect->top = LOWORD (lTemp);
                return (TRUE);
            }   
        
        } else {
    
            lpRect->top = PUSH_V_GRID;
            return (TRUE);    
        
    
        }
    }
    return (FALSE);    
}

//--------------------------------------------------------------------------
// BlockRect
//---------------------------------------------------------------------------
BOOL BlockRect (PGRIGLIA lpGrigliaStruct,
                UINT     nStartCol,
                UINT     nEndCol,
                UINT     nStartRow,
                UINT     nEndRow,
                LPRECT   lpRect) {
    
    UINT nTemp;
    
    SetRectEmpty (lpRect);
    
    if (nStartCol > nEndCol) {
        nTemp     = nStartCol;
        nEndCol   = nStartCol;                           
        nStartCol = nTemp;
    }    
    if (nStartRow > nEndRow) {
        nTemp     = nStartRow;
        nEndRow   = nStartRow;                           
        nStartRow = nTemp;
    }    
    
    if (BlockLRRect (lpGrigliaStruct,
                     nStartCol,
                     nEndCol,
                     lpRect))    
        return (BlockTBRect (lpGrigliaStruct,
                             nStartRow,
                             nEndRow,
                             lpRect));
    return (FALSE);                        

}

//---------------------------------------------------------------------------
// FindCell
//---------------------------------------------------------------------------
BOOL FindCell (PGRIGLIA lpGrigliaStruct,
               LPPOINT  lpOut,    
               POINT    pPoint) {                         
                                
           UINT n, m;            
    static RECT rRect;
    
    // Scan Other Columns
    for (n = (lpGrigliaStruct->wFixedCols + lpGrigliaStruct->nHScrollPos);
         n < lpGrigliaStruct->wCols; 
         ++n) {
        
        if (
            (CellLRRect (lpGrigliaStruct, n, (LPRECT)&rRect)) &&
            (rRect.left   <= pPoint.x)                        &&                                  
            (rRect.right  >= pPoint.x) 
           ) {
            for (m = (lpGrigliaStruct->wFixedRows + lpGrigliaStruct->nVScrollPos);                                
                 m < lpGrigliaStruct->wRows; 
                 ++m) {                           
            
                if (
                    (CellTBRect (lpGrigliaStruct, m, (LPRECT)&rRect)) &&
                    (rRect.top    <= pPoint.y)                        &&   
                    (rRect.bottom >= pPoint.y)                          
                   ) {
                    lpOut->x = n;
                    lpOut->y = m;
                    return (TRUE);                            
                }
            }    
        }    
    }
    return (FALSE);
}

//---------------------------------------------------------------------------
// KeyUp
//---------------------------------------------------------------------------
void KeyUp (HCTL   hctl,
            HWND   hWnd,
            WORD   wp) {

    WORD        wOldRow, wOldCol;
    PGRIGLIA    lpGrigliaStruct = GRIGLIADEREF(hctl);

    wOldRow = lpGrigliaStruct->wCursorRow;
    wOldCol = lpGrigliaStruct->wCursorCol;

    switch (wp) {

        case VK_PRIOR:
            if (MoveCursorPrior (lpGrigliaStruct, bCtrlPressed)) {
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

                if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                    DisplayPosition (lpGrigliaStruct);
            }
            break;

        case VK_NEXT:
            if (MoveCursorNext (lpGrigliaStruct, bCtrlPressed)) {
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

                if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                    DisplayPosition (lpGrigliaStruct);
            }
            break;

        case VK_HOME:
            if (MoveCursorHome (lpGrigliaStruct, bCtrlPressed)) {
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

                if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                    DisplayPosition (lpGrigliaStruct);
            }
            break;

        case VK_END:
            if (MoveCursorEnd (lpGrigliaStruct, bCtrlPressed)) {
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

                if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                    DisplayPosition (lpGrigliaStruct);
            }
            break;

        case VK_LEFT:
            if (MoveCursorLeft (lpGrigliaStruct)) {
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

                if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                    DisplayPosition (lpGrigliaStruct);
            }
            break;

        case VK_RIGHT:
            if (MoveCursorRight (lpGrigliaStruct)) {
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

                if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                    DisplayPosition (lpGrigliaStruct);
            }
            break;

        case VK_UP:
            if (MoveCursorUp (lpGrigliaStruct)) {
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

                if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                    DisplayPosition (lpGrigliaStruct);
            }
            break;

        case VK_DOWN:
            if (MoveCursorDown (lpGrigliaStruct)) {
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

                if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                    DisplayPosition (lpGrigliaStruct);
            }
            break;

        case VK_SHIFT:
            bShiftPressed = FALSE;
            break;

        case VK_CONTROL:
            bCtrlPressed = FALSE;
            break;

        case VK_F2:
            if (
                (lpGrigliaStruct->wEnableEdit != ERASE_FLAG)         &&
                (lpGrigliaStruct->wEnableEdit != ERASE_DISABLE_FLAG)
               ) {
                int nLen;

                nLen = GetWindowTextLength (lpGrigliaStruct->hWndEdit);
                SendMessage (lpGrigliaStruct->hWndEdit,
                            EM_SETSEL,     NULL,
                            MAKELONG (nLen, nLen));

                PostMessage (lpGrigliaStruct->hWndEdit,
                            WM_ACTIVATE, 1, MAKELONG (0, hWnd));

                // INTO EDIT MODE
                lpGrigliaStruct->lStatus |= EDIT_FLAG;
            }
            break;

    }
    nRepeatKey = 0;
    return;
}

//---------------------------------------------------------------------------
// KeyDown
//---------------------------------------------------------------------------
void KeyDown (HCTL   hctl,
              HWND   hWnd,
              WORD   wp) {

    WORD wOldRow, wOldCol, wOldRepeatKey;
    PGRIGLIA    lpGrigliaStruct = GRIGLIADEREF(hctl);

    wOldRow    = lpGrigliaStruct->wCursorRow;
    wOldCol    = lpGrigliaStruct->wCursorCol;
    wOldRepeatKey = nRepeatKey;

    if (lpGrigliaStruct->lStatus & EDIT_FLAG)
        return;

    switch (wp) {
        case VK_SHIFT:
                bShiftPressed = TRUE;
                break;

        case VK_CONTROL:
                bCtrlPressed = TRUE;
                break;

        case VK_PRIOR:
            ++nRepeatKey;
            for (; nRepeatKey > 1; --nRepeatKey)
                MoveCursorPrior (lpGrigliaStruct, bCtrlPressed);
            if (wOldRepeatKey)
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

            if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                DisplayPosition (lpGrigliaStruct);
            break;

        case VK_NEXT:
            ++nRepeatKey;
            for (; nRepeatKey > 1; --nRepeatKey)
                MoveCursorNext (lpGrigliaStruct, bCtrlPressed);
            if (wOldRepeatKey)
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

            if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                DisplayPosition (lpGrigliaStruct);
            break;

        case VK_LEFT:
            ++nRepeatKey;
            for (; nRepeatKey > 1; --nRepeatKey)
                MoveCursorLeft (lpGrigliaStruct);
            if (wOldRepeatKey)
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

            if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                DisplayPosition (lpGrigliaStruct);
            break;

        case VK_RIGHT:
            ++nRepeatKey;
            for (; nRepeatKey > 1; --nRepeatKey)
                MoveCursorRight (lpGrigliaStruct);
            if (wOldRepeatKey)
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

            if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                DisplayPosition (lpGrigliaStruct);
            break;

        case VK_UP:
            ++nRepeatKey;
            for (; nRepeatKey > 1; --nRepeatKey)
                MoveCursorUp (lpGrigliaStruct);
            if (wOldRepeatKey)
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

            if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                DisplayPosition (lpGrigliaStruct);
            break;

        case VK_DOWN:
            ++nRepeatKey;
            for (; nRepeatKey > 1; --nRepeatKey)
                MoveCursorDown (lpGrigliaStruct);
            if (wOldRepeatKey)
                FireChangeEvent (hctl, wOldRow, wOldCol, NULL);

            if (lpGrigliaStruct->wEnableEdit == ERASE_FLAG)
                DisplayPosition (lpGrigliaStruct);
            break;
    }
    return;
}

//---------------------------------------------------------------------------
// Wm_Character
//---------------------------------------------------------------------------
void Wm_Character (HCTL   hctl,
                   HWND   hWnd,
                   WORD   wp) {

    PGRIGLIA    lpGrigliaStruct = GRIGLIADEREF(hctl);
    switch (wp) {

        case VK_ESCAPE:
            if (
                ((lpGrigliaStruct->lpHorBars + lpGrigliaStruct->wCursorRow)->wStatus == ENABLE_FLAG) &&
                ((lpGrigliaStruct->lpVertBars + lpGrigliaStruct->wCursorCol)->wStatus == ENABLE_FLAG) &&
                (lpGrigliaStruct->wEnableEdit == ENABLE_FLAG)
               ) {
                
                LPSTR lpStr;

                if (lpStr = GetCellText (lpGrigliaStruct,
                                         lpGrigliaStruct->wCursorRow,
                                         lpGrigliaStruct->wCursorCol)) {
                    PostMessage (lpGrigliaStruct->hWndEdit,
                                 WM_SETTEXT, NULL,
                                 (LONG)lpStr);
                    SetCellText (lpGrigliaStruct,
                                 lpGrigliaStruct->wCursorRow,
                                 lpGrigliaStruct->wCursorCol,
                                 lpStr);
                } else {

                    PostMessage (lpGrigliaStruct->hWndEdit,
                                 WM_SETTEXT, NULL,
                                 (LONG)(LPSTR)"");
                    SetCellText (lpGrigliaStruct,
                                 lpGrigliaStruct->wCursorRow,
                                 lpGrigliaStruct->wCursorCol,
                                 "");
                }

                PostMessage (lpGrigliaStruct->hWndEdit,
                            WM_ACTIVATE, 1, MAKELONG (0, hWnd));
                PostMessage (lpGrigliaStruct->hWndEdit,
                             EM_SETSEL,  NULL,
                             MAKELONG(0, -1));

                // OFF EDIT MODE
                lpGrigliaStruct->lStatus &= RES_EDIT_FLAG;
            }
            break;

        case VK_RETURN:
                    
            if (
                ((lpGrigliaStruct->lpHorBars + lpGrigliaStruct->wCursorRow)->wStatus == ENABLE_FLAG) &&
                ((lpGrigliaStruct->lpVertBars + lpGrigliaStruct->wCursorCol)->wStatus == ENABLE_FLAG) &&
                (lpGrigliaStruct->wEnableEdit == ENABLE_FLAG)
               ) {
                
                HANDLE hOldText;
                PSTR   pOldStr;
                LPSTR  lpOldpStr;
                HANDLE hText;
                PSTR   pStr;
                SHORT  nLen;

                // retrieve previous text value
                lpOldpStr = GetCellText (lpGrigliaStruct,
                                         lpGrigliaStruct->wCursorRow,
                                         lpGrigliaStruct->wCursorCol);

                // get its size
                nLen = 0;
                if (lpOldpStr)
                    nLen = lstrlen (lpOldpStr);

                // try to store it
                if ( hOldText = LocalAlloc ( LHND, nLen + 3)) {
                    pOldStr = (PSTR) LocalLock (hOldText);
                    if (lpOldpStr)
                        lstrcpy (pOldStr, lpOldpStr);
                    else
                        lstrcpy (pOldStr, "");
                } else {
                    hOldText = NULL;
                    pOldStr  = (PSTR)NULL;
                }

                // change text
                nLen = GetWindowTextLength (lpGrigliaStruct->hWndEdit);
                if ( hText = LocalAlloc ( LHND,
                                          nLen + 3) ) {
                    pStr = (PSTR) LocalLock (hText);
                    GetWindowText (lpGrigliaStruct->hWndEdit, (LPSTR)pStr, nLen + 1);

                    if (PutCellText (lpGrigliaStruct,
                                     lpGrigliaStruct->wCursorRow,
                                     lpGrigliaStruct->wCursorCol,
                                     (LPSTR)pStr)) {
                        SetCellText (lpGrigliaStruct,
                                     lpGrigliaStruct->wCursorRow,
                                     lpGrigliaStruct->wCursorCol,
                                     pStr);
                        if (pOldStr)
                            FireChangeEvent (hctl,
                                             lpGrigliaStruct->wCursorRow,
                                             lpGrigliaStruct->wCursorCol,
                                             (LPSTR)pOldStr
                                            );
                        else
                            FireChangeEvent (hctl,
                                             lpGrigliaStruct->wCursorRow,
                                             lpGrigliaStruct->wCursorCol,
                                             (LPSTR)""
                                            );
                    }
                    LocalUnlock (hText);
                    LocalFree (hText);
                    if (hOldText) {
                        LocalUnlock (hOldText);
                        LocalFree (hOldText);
                    }
                }

                // OFF EDIT MODE
                PostMessage (lpGrigliaStruct->hWndEdit,
                            WM_ACTIVATE, 1, MAKELONG (0, hWnd));
                SendMessage (lpGrigliaStruct->hWndEdit,
                             EM_SETSEL,  NULL,
                             MAKELONG(0, -1));
                lpGrigliaStruct->lStatus &= RES_EDIT_FLAG;

            }
            break;

        default:
            if (lpGrigliaStruct->wEnableEdit == ERASE_DISABLE_FLAG)
                break;
            else if (lpGrigliaStruct->wEnableEdit != ERASE_FLAG) {
                static szStr [2];

                PostMessage (lpGrigliaStruct->hWndEdit,
                            WM_ACTIVATE, 1, MAKELONG (0, hWnd));
                szStr [0] = wp;
                szStr [1] = 0;
                PostMessage (lpGrigliaStruct->hWndEdit,
                            WM_SETTEXT, NULL, (LONG)(LPSTR)&szStr[0]);
                PostMessage (lpGrigliaStruct->hWndEdit,
                            EM_SETSEL, NULL, MAKELONG (1, 1));
            } else if (
                       ((lpGrigliaStruct->lpHorBars +
                         lpGrigliaStruct->wCursorRow)->wStatus == ENABLE_FLAG)  &&
                       ((lpGrigliaStruct->lpVertBars +
                         lpGrigliaStruct->wCursorCol)->wStatus == ENABLE_FLAG)
                      ) {
                LPSTR  lpStr;
                PSTR   pStr;
                HANDLE hText;
                UINT   nLen;
                // retrieve previous text value
                lpStr = GetCellText (lpGrigliaStruct,
                                     lpGrigliaStruct->wCursorRow,
                                     lpGrigliaStruct->wCursorCol);

                // get its size
                nLen = 0;
                if (lpStr)
                    nLen = _fstrlen (lpStr);

                // try to store it
                if ( hText = LocalAlloc ( LHND, nLen + 3)) {
                    pStr = (PSTR) LocalLock (hText);
                    if (
                        (lpStr) &&
                        (nLen)
                       )
                        _fstrcpy (pStr, lpStr);
                    else
                        _fstrcpy (pStr, "");

                    if (wp == VK_BACK) {
                        if (nLen)
                            *(pStr + nLen - 1) = 0;
                    } else if (isprint (wp)) {
                        // add new char
                        *(pStr + nLen)     = LOBYTE (wp);
                        *(pStr + nLen + 1) = 0;
                    }
                    if (PutCellText (lpGrigliaStruct,
                                     lpGrigliaStruct->wCursorRow,
                                     lpGrigliaStruct->wCursorCol,
                                     (LPSTR)pStr)) {
                        DestroyCaret ();
                        SetCellText (lpGrigliaStruct,
                                     lpGrigliaStruct->wCursorRow,
                                     lpGrigliaStruct->wCursorCol,
                                     pStr);
                        DisplayPosition (lpGrigliaStruct);
                    }
                    LocalUnlock (hText);
                    LocalFree (hText);
                }
            }
            break;
    }
}

//---------------------------------------------------------------------------
// DisplayPosition
//---------------------------------------------------------------------------
void DisplayPosition (PGRIGLIA lpGrigliaStruct) {

           LPSTR lpStr;
           HDC   hDC;
           SHORT nXLen, nYLen;
    static RECT  rCell;

    if (hDC = GetDC (lpGrigliaStruct->hWndStatic)) {

        lpStr = GetCellText (lpGrigliaStruct,
                             lpGrigliaStruct->wCursorRow,
                             lpGrigliaStruct->wCursorCol);
        if (
            (lpStr) &&
            (_fstrlen (lpStr))
           ) {
            nXLen = LOWORD (GetTextExtent (hDC, lpStr, _fstrlen (lpStr)));
            nYLen = max (HIWORD (GetTextExtent (hDC, lpStr,
                                                _fstrlen (lpStr))) - 4,
                         4);
        } else {
            nXLen = 3;
            nYLen = max (HIWORD (GetTextExtent (hDC, "A", 1)) - 4, 4);
        }
        ReleaseDC(lpGrigliaStruct->hWndStatic, hDC);

        CreateCaret (lpGrigliaStruct->hWndStatic,
                     0, 1, nYLen);
        if (
            (CellRect (lpGrigliaStruct,
                      lpGrigliaStruct->wCursorCol,
                      lpGrigliaStruct->wCursorRow,
                      (LPRECT)&rCell))                                  &&
            ((lpGrigliaStruct->lpHorBars +
                lpGrigliaStruct->wCursorRow)->wStatus == ENABLE_FLAG)   &&
            ((lpGrigliaStruct->lpVertBars +
                lpGrigliaStruct->wCursorCol)->wStatus == ENABLE_FLAG)   &&
            (rCell.left + nXLen <= rCell.right)
           ) {
            SetCaretPos (rCell.left + nXLen, rCell.top + 4);
            ShowCaret   (NULL);
        }
    }
}
