VERSION 2.00
Begin Form frmMenuDemo 
   Caption         =   "MenuDemo Custom Control Example"
   ClientHeight    =   2835
   ClientLeft      =   1335
   ClientTop       =   1890
   ClientWidth     =   5535
   Height          =   3525
   Left            =   1275
   LinkTopic       =   "Form1"
   ScaleHeight     =   2835
   ScaleWidth      =   5535
   Top             =   1260
   Width           =   5655
   Begin jbMenuDemo MenuInfo1 
      Left            =   240
      Top             =   120
   End
   Begin Frame Frame1 
      Caption         =   "Menu - Edit : Align"
      Height          =   1335
      Left            =   3120
      TabIndex        =   3
      Top             =   240
      Width           =   2175
      Begin CheckBox chkEnabled 
         Caption         =   "Enabled"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   840
         Value           =   1  'Checked
         Width           =   1455
      End
      Begin CheckBox chkVisible 
         Caption         =   "Visible"
         Height          =   255
         Left            =   240
         TabIndex        =   4
         Top             =   480
         Value           =   1  'Checked
         Width           =   1695
      End
   End
   Begin Label lblStatusBar 
      BorderStyle     =   1  'Fixed Single
      Caption         =   " Status Bar"
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   2400
      Width           =   4935
   End
   Begin Label lblMenuindexVal 
      Caption         =   "1"
      Height          =   255
      Left            =   1560
      TabIndex        =   1
      Top             =   2040
      Width           =   495
   End
   Begin Label lblMenuindex 
      Caption         =   "MenuIndex ="
      Height          =   255
      Left            =   360
      TabIndex        =   0
      Top             =   2040
      Width           =   1215
   End
   Begin Menu mnuFile 
      Caption         =   "File"
      Begin Menu mnuFileOpen 
         Caption         =   "Open"
      End
      Begin Menu mnuFileClose 
         Caption         =   "Close"
      End
      Begin Menu mnuD1 
         Caption         =   "-"
      End
      Begin Menu mnuFileExit 
         Caption         =   "Exit"
      End
   End
   Begin Menu mnuEdit 
      Caption         =   "Edit"
      Begin Menu mnuEditCopy 
         Caption         =   "Copy"
      End
      Begin Menu mnuEditAlign 
         Caption         =   "Align"
         Begin Menu mnuEditAlignTop 
            Caption         =   "Top"
         End
         Begin Menu mnuEditAlignBottom 
            Caption         =   "Bottom"
         End
      End
      Begin Menu mnuEditLast 
         Caption         =   "Last"
      End
   End
End
Option Explicit

Dim MenuMsgs() As String  ' String array to store menu messages
Dim OldStatus As String   ' String to save the old status message

Sub chkEnabled_Click ()

    ' Change the [Edit : Align] Enabled property
    mnuEditAlign.Enabled = chkEnabled.Value

End Sub

Sub chkVisible_Click ()

    ' Change the [Edit : Align] Visible property
    mnuEditAlign.Visible = chkVisible.Value


    ' Reset indexing to the MenuMsgs messages
    reset_status_array

    ' Display new status bar message
    If (chkVisible.Value) Then
        lblStatusBar.Caption = " Menu item [Edit : Align] is visible"
    Else
        lblStatusBar.Caption = " Menu item [Edit : Align] is NOT visible"
    End If

End Sub

Sub Form_Load ()

    ' Reset indexing for the MenuMsgs messages
    reset_status_array
    
    ' Hide the menu index number labels
    lblMenuindex.Visible = False
    lblMenuindexVal.Visible = False

End Sub

Sub MenuInfo1_Close ()
    
    ' Restore the old status bar message
    lblStatusBar.Caption = OldStatus
    
    ' Hide the menu index number labels
    lblMenuindex.Visible = False
    lblMenuindexVal.Visible = False

End Sub

Sub MenuInfo1_Open ()
    
    ' Save the old status bar message
     OldStatus = lblStatusBar.Caption

    ' Display the menu index number labels
    lblMenuindex.Visible = True
    lblMenuindexVal.Visible = True
    
End Sub

Sub MenuInfo1_Select (MenuIndex As Integer)

    ' Display the menu index number
    lblMenuindexVal.Caption = MenuIndex
    
    ' Display the message for this menu index
    lblStatusBar.Caption = MenuMsgs(MenuIndex)

End Sub

'
' Must be called when thr form is loaded, and after
'  a menu item's Visible property changes state.
'
Sub reset_status_array ()
    
    Dim i As Integer
    ReDim MenuMsgs(10) As String

    i = 0
    MenuMsgs(i) = "": i = i + 1                   ' Control Menu Selected
    MenuMsgs(i) = " File stuff": i = i + 1        ' File
    MenuMsgs(i) = " Open a File": i = i + 1       ' File : Open
    MenuMsgs(i) = " Close a file": i = i + 1      ' File : Close
    MenuMsgs(i) = " Exit the program": i = i + 1  ' File : Exit
    MenuMsgs(i) = " Edit stuff": i = i + 1        ' Edit
    MenuMsgs(i) = " Copy something": i = i + 1    ' Edit : Copy
    If (mnuEditAlign.Visible) Then                ' Check if [Edit : Align] is Visible
        MenuMsgs(i) = " Align objects": i = i + 1                ' Edit : Align
        MenuMsgs(i) = " Align the tops of objects": i = i + 1    ' Edit : Align : Top
        MenuMsgs(i) = " Align the bottoms of objects": i = i + 1 ' Edit : Align : Bottom
    End If
    MenuMsgs(i) = " Last menu item": i = i + 1    ' Edit : Last
                                                   
End Sub

