//---------------------------------------------------------------------------
// MhSample.c
//---------------------------------------------------------------------------
/* 
---------------------------------------------------------------------------
	 Function : MicroHelp, Inc. Sample Custom Control
---------------------------------------------------------------------------
	 Properties :
			Standard Properties (see VB documentation)
	 CtlName         Enabled         Height          Index
	 Left            Parent          Tag             Top
	 Width           BackColor

			Non-Standard Properties
---------------------------------------------------------------------------
	 Events :
			Standard Events (see VB documentation)
			None
			Non-Standard Events
'----------------------------------------------------------------------------
	 Methods :
============================================================================*/

#define NOCOMM
#include <windows.h>     //Standard windows.h
#include <vbapi2.h>      //VB API
#include "mhSample.h"    //VB2+ Control Model
#include "mhSampl1.h"    //VB1  Control Model

//Definition of structure used when calling VBFireEvent - 
//Note:  This structure varies based on the type and number
//       of paramaters passed to each event.

typedef struct tagPARAMS // event procedure parameter profiles
{
	 WORD FAR   *lpwp2;  // Integer Parameter #2
	 WORD FAR   *lpwp1;  // Integer Parameter #1
	 LPVOID      Index;  // reserve space for index parameter to array ctl
}
PARAMS;

PARAMS params;

HANDLE hmodDLL = (HANDLE) NULL;

//---------------------------------------------------------------------------
// MhSample Control Message Processing function
// VB Calls this procedure with each message intended for this control
// This is very similar to the "normal" windows message procedure except
// that it adds the HCTL (handle to control) as a parameter.
//---------------------------------------------------------------------------

LONG _export MhSampleCtlProc
(
	 HCTL        hctl,
	 HWND        hwnd,
	 USHORT      msg,
	 USHORT      wp,
	 LONG        lp
)
{
	 LONG        lResult;
	 PMHSAMPLE pMhSample = MHSAMPLEDEREF(hctl);  //Dereference the PDS so we have
																							 //a pointer to our PDS
	 // Message pre-processing
	 switch( msg )
	 {
			 
			//This is the best message to set default property values
			//This is because this message gets generated before a load 
			//from the formfile happens.  On the initial creation of a
			//control the default values set in the NCCREATE message
			//will not be overwritten by a formfile load (because there
			//is not a FormFile load on newly created controls.)
				
			case WM_NCCREATE:
			
			pMhSample = MHSAMPLEDEREF(hctl);       //Dereference the PDS so we have
																						 //a pointer
			//Set default values
			pMhSample->DefaultProperty = 10;       //Sets .DefaultProperty to 10 on
																						 //initial creation of control
			break;

/* This is a sample of how to fire an event in vb.  This also shows the
	 use of the params structure.  Here we are using a User-Defined
	 message.  User-defined messages can come in handy when firing an event
	 because you can use SendMessage/PostMessage from anywhere in the DLL to
	 fire your event (or do other processing and fire your event).   
	 
			#define MH_USERMESSAGE = WM_USER + 1
			
			case MH_USERMESSAGE:
			{
						
				pMhSample = MHSAMPLEDEREF(hctl);

				hwndglobal = (HWND) wp;
				wpglobal = (WORD) lp;

				paramsglobal.lpwp1=&hwndglobal;
				paramsglobal.lpwp2=&wpglobal;
						
				VBFireEvent(hctl, EVENT_SAMPLE_SAMPLECLOSED, &paramsglobal);
						
				pMhSample->DialogHwnd = (HWND) NULL;
					 
			}
			return 0;
*/ 
	 
	 case WM_PAINT:
	 {
			PAINTSTRUCT ps;
			
			//If wp is != NULL when coming into the WM_PAINT then use the wp 
			// as a hDC and do all you paint work on that hDC.  
			// This happens when a PrintForm command takes place.  On any
			// paint message we are calling our Common User function to
			// paint the control
			
			if (wp)
				MhSamplePaintControl(hctl, hwnd, (HDC) wp);
			else
			{
				BeginPaint(hwnd, &ps);
				MhSamplePaintControl(hctl, hwnd, ps.hdc);
				EndPaint(hwnd, &ps);
			}
		}  
			break;

	 //Standard Font properties required that we respond to the 2 Windows
	 //message for SetFont and GetFont.  Here we store the value of the
	 //font in our PDS and return it when needed.  
	 
	 case WM_SETFONT:
			 pMhSample = MHSAMPLEDEREF(hctl);                  //A pointer to our control data
			 pMhSample->hfont = (HFONT) wp;
			 return 0;

	 case WM_GETFONT:
			 pMhSample = MHSAMPLEDEREF(hctl);                  //A pointer to our control data
			 return pMhSample->hfont;

	 case WM_DESTROY:
			pMhSample = MHSAMPLEDEREF(hctl);
			//free any resources you may have created for this instance
			//Free any memory, hpics, bmps, cursors, etc.
			
			break;

	 case WM_RBUTTONDOWN:
			if (VBGetMode()==MODE_DESIGN)
			{
				//VBGetMode is a VB Api function that tells the control if VB
				//is MODE_DESIGN, MODE_RUN, or MODE_BREAK.

				//Note:  This gives us design time R-button down.  MicroHelp
				//uses the right button at design time to do sizing of inner
				//areas and also to bring up Help on the control.  This control
				//only beeps when the right button is pressed at design time.
				MessageBeep(0);
				break;
			}

	 case VBM_GETPROPERTY:
			switch ( wp )
			{
				
				// wp is set to the property index and lp is where we
				// will store the value of the requested property.
				// Fill in lp (and cast to correct type) the property
				// information requested

				//case IPROP_SAMPLE_HDC:
				//   *(SHORT FAR*) lp = pMhSample->hdc;
				//return 0;

			}
			break;

	 case VBM_CHECKPROPERTY:
	 {   
			switch ( wp )
			{
				
				// This message is used to check a property that VB may be 
				// setting automatically.  Return 0 to set property to value
				// otherwise return vb error code.
				// wp = property index and lp = data they are trying to set
				// the property to.

				//case IPROP_SAMPLE_MAXFILESIZE:
				//   if ((SHORT) lp > 32767 || (SHORT) lp < 0)
				//      return ERR_BADPROPERTY;
				//return 0;
			}
		}
		break;

	 case VBM_SETPROPERTY:
			switch ( wp )
			{
				
				// Note:  The wp has the property index and
				// the lp has the value they are setting.
				// Cast the lp into your storage area or PDS
				// If it is a property array - lp will be a
				// LPDATASTRUCT
				
				//case IPROP_SAMPLE_ACTION:
				//    pMhSample = MHSAMPLEDEREF(hctl);
				//    pMhSample->Action = (SHORT) lp;
				//    break;
			}
			break;

	 case VBM_CREATED:
		//This message is fired after all properties have been loaded from the
		//form file and the control is getting ready to be drawn on the screen.
		//If you return 0 here then the control will not display itself at 
		//run-time.  We don't wan't it to display so we are returning 0 ONLY if
		//the mode is NOT= MODE_DESIGN.  This is similar to the TIMER control
		//that only shows at design time.  Remove the 2 lines below to have the
		//control show up at run-time.

		if (VBGetMode() != MODE_DESIGN)
			return 0L;
		break;

	 }

	 // Default processing:
	 // VB will process message or pass it on to Windows default processing
	 // This is a very important item!  All standard properties and events
	 // are fired based on default processing getting called.  If you "return"
	 // from any of the above messages then default proc DOES NOT get called.
	 
	 
	 lResult = VBDefControlProc( hctl, hwnd, msg, wp, lp );

	 //After default processing you might want to process the message again
	 //to do something different.  Also you might have a need for VB to do
	 //the default processing and then you to do your own processing.
	 //This sample app doesn't use post processing so it is commented out.

	 // Message post-processing:

	 //switch( msg )
	 //{
	 //}

	 //LResult is the result value from the message process.  This is usually
	 //set by default processing but it may also be returned from any message
	 //that you process.  For messages such as VBM_SETPROPERTY, if you return
	 //a value that is in the VB error code range then VB will bring up the
	 //appropriate Run-time error message box (or user defined error if out of
	 //range
	 
	 return lResult;
}

VOID NEAR MhSamplePaintControl(HCTL hctl, HWND hwnd, HDC hdc)
{
				RECT rect;
				HBRUSH hbr;
				HBRUSH hbrOld = (HBRUSH) NULL;
				HFONT hfontOld = (HFONT) NULL;
				PMHSAMPLE pMhSample = MHSAMPLEDEREF(hctl);
				
				//Note: To Get the standard back color property we send a message
				//to the parent requesting the CTLCOLOR of our child control.  This
				//returns us a brush of that color.  This brush is owned by the parent
				//so don't DeleteObject it!

				hbr = (HBRUSH)SendMessage(GetParent(hwnd), WM_CTLCOLOR, hdc, MAKELONG(hwnd, 0));
				
				if (VBGetMode() == MODE_DESIGN)
				{
					pMhSample = MHSAMPLEDEREF(hctl);
					
					if (pMhSample->hfont)
						hfontOld = SelectObject(hdc, pMhSample->hfont);

					hbrOld = SelectObject(hdc, hbr);

					GetClientRect(hwnd, &rect);
					Rectangle(hwnd, rect.left, rect.top,rect.right,rect.bottom);
					DrawText(hdc, "MhSample Control", -1, &rect, DT_CENTER | DT_WORDBREAK | DT_VCENTER);
					
					if (hfontOld)
						SelectObject(hdc, hfontOld);

					if (hbrOld)
						SelectObject(hdc, hbrOld);

				}
}
//---------------------------------------------------------------------------
// End of local procedures
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Register custom control.
//  This routine is called by VB when the custom control DLL is
//  loaded for use.
//---------------------------------------------------------------------------



BOOL FAR PASCAL _export VBINITCC
(
	USHORT usVersion,
	BOOL    fRuntime
)
{
	// avoid warnings on unused (but required) formal parameters

	usVersion = usVersion;

// If we want to make this a run-time only VBX then we don't allow
// it to be registered at design-time.  If we return FALSE VB won't
// allow the control at design-time.

#ifdef RUN_TIME
	 if (!fRuntime)
			return FALSE;
#endif //RUN_TIME

	// This is where we decide to either register the Version 1 control
	// or the Version 2 control.  Note:  Version 1 controls are compatible
	// with VB 1.0, 2.0 and Visual C++ version 1.0.  Version 2 controls are
	// only compatible with VB 2.0 and later.

	if (usVersion < VB_VERSION)
		return VBRegisterModel(hmodDLL, &modelMhSample_vb1);
	else
		return VBRegisterModel(hmodDLL, &modelMhSample);

	return TRUE;
}

//---------------------------------------------------------------------------
// UnRegister custom control.
//    This routine is called by VB when the custom control DLL is being
//    unloaded.
//---------------------------------------------------------------------------
VOID FAR PASCAL _export VBTERMCC
(
	 VOID
)
{
	 return;
}


//---------------------------------------------------------------------------
// Provide custom control model information to host environment.
// This host enviroment may be VB, VC or other third party products
//---------------------------------------------------------------------------
LPMODELINFO FAR PASCAL _export VBGetModelInfo
(
	 USHORT usVersion
)
{
	 if (usVersion < VB_VERSION)
		return &modelinfoMhSample_vb1;
	 else
		return &modelinfoMhSample;
}


//---------------------------------------------------------------------------
// Initialize library.
//  This routine is called when the first client loads the DLL.
//---------------------------------------------------------------------------

int FAR PASCAL LibMain
(
	HANDLE  hModule,
	WORD    wDataSeg,
	WORD    cbHeapSize,
	LPSTR   lpszCmdLine
)
{
	// avoid warnings on unused (but required) formal parameters

	wDataSeg = wDataSeg;
	cbHeapSize = cbHeapSize;
	lpszCmdLine = lpszCmdLine;

	//This is where we set the Global hmodDLL variable.  This is the instance
	//handle to our DLL (.VBX)

	hmodDLL = hModule;

	return 1;
}

#if (_MSC_VER < 610)

// C7 and QCWIN provide default a WEP

int FAR PASCAL WEP(int bSystemExit);

// For Windows 3.0 it is recommended that the WEP function reside in a
// FIXED code segment and be exported as RESIDENTNAME.  This is
// accomplished using the alloc_text pragma below and the related EXPORTS
// and SEGMENTS directives in the .DEF file.
//
// Read the comments section documenting the WEP function in the Windows
// 3.1 SDK "Programmers Reference, Volume 2: Functions" before placing
// any additional code in the WEP routine for a Windows 3.0 DLL.
//
#pragma alloc_text(WEP_TEXT,WEP)

//---------------------------------------------------------------------------
// WEP
//  Performs cleanup tasks when the DLL is unloaded.  WEP() is
//  called automatically by Windows when the DLL is unloaded (no
//  remaining tasks still have the DLL loaded).  It is strongly
//  recommended that a DLL have a WEP() function, even if it does
//  nothing but returns success (1), as in this example.
//---------------------------------------------------------------------------
int FAR PASCAL WEP
(
	int bSystemExit
)
{
	// avoid warnings on unused (but required) formal parameters

	bSystemExit = bSystemExit;

	return 1;
}

#endif


//---------------------------------------------------------------------------
