//---------------------------------------------------------------------------
// MhSample.h
//
//  The header file contains initialization information that VB uses to know
//  all about your custom control.  This includes properties, events, default
//  values, etc.  You can also define any global variables, macros, etc.
//---------------------------------------------------------------------------

// Bitmap ID's - Define ID's for use in the resource file and .C file
//               VB Uses the bitmap id's to load the toolbox bitmaps.
//               Note the 0, 1, 3, and 6 have significant meanings.  
//               VB Uses the base number + x (1, 3, or 6) to get the 
//               bitmaps for the correct type of display that VB 
//               is running on.

	 #define IDBMP_SAMPLEU             8000    // VGA Button Up bitmap
	 #define IDBMP_SAMPLED             8001    // VGA Button Down bitmap
	 #define IDBMP_SAMPLEMU            8003    // Monochrome Bitmap
	 #define IDBMP_SAMPLEEU            8006    // EGA Bitmap

//If the resource compile is invoked do not do any of this other stuff.
//Only the bitmaps id's are used in the .RC file.

#ifndef RC_INVOKED

//---------------------------------------------------------------------------
// MhSample Programmer Defined Structure (Instance Specific Data)
//---------------------------------------------------------------------------
typedef struct tagMHSAMPLE
{
	//Programmer defined data
	SHORT junk;
	SHORT Flags;
	HFONT hfont;
	SHORT DefaultProperty;
} MHSAMPLE;

//Create Pointer Type
typedef MHSAMPLE FAR * PMHSAMPLE;

//Dereference Macro - Dereferences the handle returned by VB into a pointer
//to the instance specific programmer defined structure

#define MHSAMPLEDEREF( hctl )   CONTROLDEREF( MHSAMPLE, hctl )

// Error Message Code Constants
#define EBER_NONE 0
#define ERR_OUTOFMEMORY 1
#define ERR_BADPROPERTY 380


//---------------------------------------------------------------------------
// Prototype of the Control message handling Procedure
//---------------------------------------------------------------------------
LONG _export MhSampleCtlProc( HCTL, HWND, USHORT, USHORT, LONG );


//--------------------------------------------------------------------------
//User Defined function prototypes
//--------------------------------------------------------------------------
VOID NEAR MhSamplePaintControl(HCTL, HWND, HDC);

//---------------------------------------------------------------------------
// Programmer defined Property Structures and information
//---------------------------------------------------------------------------

//Sample list used in enumerated properties
CHAR szSampleAction[]= "0 - None\0"\
					 "1 - Do Something\0"\
					 "2 - Do Something Else\0"\
					 "3 - Another Thing\0"\
					 "4 - And Another\0"\
					 "5 - One More\0"\
					 "6 - Last Thing\0"\
					 "\0";

PROPINFO propinfoSampleAction =
{
	 "Action",                  // Property Name
	 DT_ENUM | PF_fGetMsg | 
	 PF_fSetMsg | PF_fNoShow,   // Flags
	 0,                         // Offset into PDS (PF_fGetData/SetData)
	 0,                         // Bit packing Mask for DT_BOOL, SHORT, & ENUM
	 0,                         // Default Value for this property (PF_fDefVal)
	 szSampleAction,             // String Array for valid values (DT_ENUM)
	 6                          // Highest Value allowed for DT_ENUM, 0=Don't Validate
}; 

/*   Sample Properties (1 of each type)

PROPINFO propinfoSampleHelpCommand =
{
	 "HelpCommand",
	 DT_SHORT | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fDefVal,
	 OFFSETIN(MHSAMPLE, HelpCommand), 0, 0

};

PROPINFO propinfoSampleHelpContext =
{
	 "HelpContext",
	 DT_LONG | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fDefVal,
	 OFFSETIN(MHSAMPLE, HelpContext), 0, 0

};

PROPINFO propinfoSampleHelpFile =
{
	 "HelpFile",
	 DT_HSZ | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fDefVal,
	 OFFSETIN(MHSAMPLE, hszHelpFile), 0, 0

};

PROPINFO propinfoSamplePicture =
{
	 "Picture",
	 DT_PICTURE | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fDefVal,
	 OFFSETIN(MHSAMPLE, hpicPicture), 0, 0

};

PROPINFO propinfoSamplePicture =
{
	 "Picture",
	 DT_PICTURE | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fDefVal,
	 OFFSETIN(MHSAMPLE, hpicPicture), 0, 0

};

PROPINFO propinfoSampleColor =
{
	 "Color",
	 DT_COLOR | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fDefVal,
	 OFFSETIN(MHSAMPLE, Color), 0, 0

};

		
		========================  Property Flags =================================
		
		DT_BOOL       = (1 bit packed or BOOL) Bool property (True/False)
		DT_COLOR      = (LONG) VB Color value
		DT_ENUM       = (Bitpacked or SHORT) Value 0 - 255 max
		DT_HLSTR      = (HLSTR) Basic String handle (2.0+)
		DT_HSZ        = (HSZ) Handle for a Null Terminated Basic String
		DT_LONG       = (LONG) Long Integer
		DT_PICTURE    = (HPIC) Handle to a VB Picture
		DT_REAL       = (FLOAT) Floating point number
		DT_SHORT      = (SHORT) Short Integer
		DT_XPOS       = (LONG) X Coordinate in TWIPS
		DT_XSIZE      = (LONG) X Size in TWIPS
		DT_YPOS       = (LONG) Y Coordinate in TWIPS
		DT_YSIZE      = (LONG) Y Size in TWIPS
		
		PF_fDefVal    = if prop = Default Value then don't load/save from Formfile
										Use default value field of property structure.
		PF_fEditable  = Allows direct editing in the settings box
		PF_fGetData   = VB Gets Property value by directly accessing PDS
		PF_fGetHszMsg = When value is to be displayed in property window VB will
										send a VBM_GETPROPERTYHSZ message to the control.
		PF_fGetMsg    = VB sends a VBM_GETPROPERTY message to control to get the
										value of a property
		PF_fNoMultiSelect = Keeps a control from being allowed to be selected as
												a group when user is using the "multiple" selection
												in VB 2.0 +
		PF_fNoInitDef = Prevents VB from setting the property to the default value
										during loading of the control.
		PF_fNoRuntimeR = Indicates that a property is ReadOnly at run-time (2.0+)
		PF_fNoRuntimeW = Indicates that a property is WriteOnly at run-time
		PF_fNoShow     = Don't show property in property window at design-time
		PF_fPreHwnd    = Causes the property to be loaded before the window (HWND)
										 is created.
		PF_fPropArray  = Specifies that the property is an Array (must use PF_NoShow
										 as arrays are not allowed at design time)
		PF_fSaveData   = VB will save/load property from Form File
		PF_fSaveMsg    = Causes VB to send a VBM_SAVEPROPERTY message so we can save
										 to the Form File
		PF_fSetCheck   = VB will send a VBM_CHECKPROPERTY message to control when
										 user sets property at design or run-time.
		PF_fSetData    = VB sets data directly in PDS
		PF_fUpdateOnEdit = VB updates display as each character is typed during edit


*/


//---------------------------------------------------------------------------
// Custom Programmer defined Event procedure parameters and prototypes
//---------------------------------------------------------------------------

//Parameters for an event passing 2 integers

// Parm Types:
// ET_I2 = 16 bit Integer, ET_I4 = 32 bit Integer
// ET_R4 = 4 byte Real   , ET_R8 = 8 byte Real
// ET_CY = Currency      , ET_FS = Fixed length String
// ET_HLSTR = HLSTR

WORD ParmsI2xI2[] = { ET_I2, ET_I2 };

EVENTINFO eventinfoSampleClosed =
	 {
			"SampleClosed",         // VB Custom Event Name
			2,                     // Number of arguments - not including Index
			4,                     // Number of WORDS represented by arg list
			ParmsI2xI2,            // Pointer to byte array describing parameters
			"Hwnd as Integer, WhichDialog as Integer"  // Event Text Parameter names
	 };

/*   Sample Event with no parameters
	 EVENTINFO eventinfoFilenameChange =
	 {
			"FilenameChange",
			0,
			0,
			NULL,
			NULL
	 };
*/
//---------------------------------------------------------------------------
// Event list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the events
// We refer to events by number - always add new events to bottom of list
//---------------------------------------------------------------------------
#define EVENT_SAMPLE_SAMPLECLOSED    0x0000

//---------------------------------------------------------------------------
// Property list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
// We refer to properties by number - always add new props to bottom of list
// We define these macros to make the code much easier to read
//---------------------------------------------------------------------------

#define IPROP_SAMPLE_CTLNAME         0x0000
#define IPROP_SAMPLE_INDEX           0x0001
#define IPROP_SAMPLE_PARENT          0x0002
#define IPROP_SAMPLE_LEFT            0x0003
#define IPROP_SAMPLE_TOP             0x0004
#define IPROP_SAMPLE_WIDTH           0x0005
#define IPROP_SAMPLE_HEIGHT          0x0006
#define IPROP_SAMPLE_TAG             0x0007
#define IPROP_SAMPLE_HWND            0x0008
#define IPROP_SAMPLE_ACTION          0x0009
#define IPROP_SAMPLE_BACKCOLOR       0x000A
#define IPROP_SAMPLE_FONTNAME        0x000B


// Property List - VB uses this to know what properties your control will 
//                 have.  Add new properties to end of list.  Make sure you
//                 add a property index # above to match each property.

PPROPINFO proplistSample[] =
{
	 PPROPINFO_STD_CTLNAME,
	 PPROPINFO_STD_INDEX,
	 PPROPINFO_STD_PARENT,
	 PPROPINFO_STD_LEFT,
	 PPROPINFO_STD_TOP,
	 PPROPINFO_STD_WIDTH,
	 PPROPINFO_STD_HEIGHT,
	 PPROPINFO_STD_TAG,
	 PPROPINFO_STD_HWND,
	 &propinfoSampleAction,
	 PPROPINFO_STD_BACKCOLOR,
	 PPROPINFO_STD_FONTNAME,
	NULL  
};

// Event List - VB uses this to know what events your control will 
//              have.  Add new Events to end of list.  Make sure you
//              add an event index # above to match each property.

PEVENTINFO eventlistSample[] =
{
	 &eventinfoSampleClosed,
	 NULL
};  

//Model information - This model is registered with a call to 
//                    VBRegisterControl.  The model contains
//                    all information that VB needs to create 
//                    instances of the control onto a form.

MODEL modelMhSample =
{
	 VB_VERSION,                          // VB version being used
	 MODEL_fLoadMsg | MODEL_fDesInteract, // MODEL flags
	 (PCTLPROC)MhSampleCtlProc,            // Control procedure
	 CS_DBLCLKS | CS_HREDRAW | 
				CS_VREDRAW,                     // Class style
	 WS_CHILD,                            // default Window style
	 sizeof(MHSAMPLE),                     // size of Programmer Defined Struct MHSAMPLE 
	 IDBMP_SAMPLEU,                        // First Palette bitmap ID#
	 "MhSample",                           // VB Default Control name
	 "MhSample",                           // Visual Basic class name (IF...TYPEOF)
	 NULL,                                // Parent class name (for subclassing)
	 proplistSample,                       // Properties list
	 eventlistSample,                      // Events list
	 IPROP_SAMPLE_ACTION,                  // Default Property in property viewer
	 EVENT_SAMPLE_SAMPLECLOSED              // Default Event shown in code window
};

// Items below are used to point to the controls model.  The standard
// way of accessing the model information (if necessary) of a custom control
// is to call the function VBGetModelInfo which is exported by each custom
// control (VB 2.0+).  Once you have a pointer to the modelinfo you can 
// extract information about properties, events, etc.

LPMODEL modellistMhSample[] =
{
	 &modelMhSample,           
	 NULL
};

MODELINFO modelinfoMhSample =
{
	 VB_VERSION,             // VB version being used
	 modellistMhSample        // MODEL list
};

#endif  // RC_INVOKED
