/***************************MULTI.DLL*************************************
*									 *
*    Author: Jeff Simms	 72200,3173	 Date: June 25, 1992		 *
*									 *
*    Idea for DLL came from the MultiPik demo - author Costas Kitsos	 *
*									 *
*    Compiled under MS C7 Compact Model	   .def and .h files at end	 *
**************************************************************************/

#include <windows.h>
#include "multisel.h"

int s[1];
char text[250];
FARPROC lpfnOldListProc;
HWND hListWnd;
HWND lbhwnd;

int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSegment,
				   WORD wHeapSize, LPSTR lpszCmdLine )
{
    if ( wHeapSize != 0 )
	UnlockData( 0 );
    return 1;
}

int FAR PASCAL WEP (int bSystemExit)
{
    return (1);
}

  int __export FAR PASCAL MultiListBox(HWND lbhWnd, HWND lbParent, DWORD MulSel)

{


  HANDLE hInst;
  POINT Lpoint;
  RECT LBRect;
  int X,Y,nWidth,nHeight;

  if (!MulSel)
    MulSel = 0x54A108CA;

  hInst = GetWindowWord(lbParent, GWW_HINSTANCE);

  lbhwnd = lbhWnd;

  GetWindowRect(lbhwnd,&LBRect);
  Lpoint.x = LBRect.left;
  Lpoint.y = LBRect.top;
  ScreenToClient(lbParent,&Lpoint);
  X = Lpoint.x;
  Y = Lpoint.y;

   nWidth = (LBRect.right - LBRect.left);
   nHeight = (LBRect.bottom - LBRect.top);

   hListWnd = CreateWindow ("listbox", NULL, MulSel,
		 X, Y, nWidth, nHeight, lbParent, 257, hInst, NULL);

   lpfnOldListProc = (FARPROC) SetWindowLong(hListWnd,GWL_WNDPROC,(DWORD)(FARPROC)SubListFunc);

	 return hListWnd ;

 }

 LONG __export FAR PASCAL SubListFunc(HWND hWnd,WORD Message,WORD wParam,LONG lParam)

 {

   if (Message == WM_LBUTTONDBLCLK)
   {
	SendMessage(hListWnd,LB_GETSELITEMS,1,(LONG) (LPSTR) s);
	SendMessage(hListWnd,LB_GETTEXT, s[0],(LONG) (LPSTR) text);
	SendMessage(lbhwnd,Message,wParam,lParam);
	SendMessage(lbhwnd,LB_ADDSTRING,0, (LONG) (LPSTR) text);
    }

  return CallWindowProc(lpfnOldListProc,hWnd,Message,wParam,lParam);

 }


  void __export FAR PASCAL MultiGetSel(HWND lbhandle)

 {
   int i,nCount,lpItems[1000];
     nCount = (WORD)SendMessage(hListWnd,LB_GETSELITEMS,1000, (LONG) lpItems);

    for (i = 0; i < nCount; i++)
	{
	SendMessage(hListWnd,LB_GETTEXT, lpItems[i], (LONG) (LPSTR) text);
	SendMessage(lbhandle,LB_ADDSTRING,0, (LONG) (LPSTR) text);
	}
 }

  void __export FAR PASCAL MultiAdd(LPSTR lpString)
 {
	SendMessage(hListWnd,LB_ADDSTRING,0, (LONG) lpString);
 }

  void __export FAR PASCAL MultiReset(WORD wNata)
 {
	SendMessage(hListWnd,LB_RESETCONTENT,0,0);
 }

  void __export FAR PASCAL MultiDelete(WORD nIndex)
 {
	SendMessage(hListWnd,LB_DELETESTRING, nIndex, 0);
 }

  int __export FAR PASCAL MultiCount()
 {
    int nCount;
    nCount = (WORD)SendMessage(hListWnd,LB_GETCOUNT, 0, 0);
    return nCount;
 }

  void __export FAR PASCAL MultiText(WORD nIndex)
 {
      SendMessage(hListWnd,LB_GETTEXT, nIndex, (LONG) (LPSTR) text);
      SendMessage(lbhwnd,LB_ADDSTRING,0, (LONG) (LPSTR) text);
 }

  void __export FAR PASCAL MultiSetTop(WORD nIndex)
 {
	SendMessage(hListWnd,LB_SETTOPINDEX, nIndex, 0);
 }

  void __export FAR PASCAL MultiSetSel(WORD nSet, WORD nIndex)
 {
       SendMessage(hListWnd,LB_SETSEL, nSet, nIndex);
 }

  int __export FAR PASCAL MultiFind(WORD nIndex,LPSTR lpString)
 {
	int nMatch;
	nMatch = (WORD)SendMessage(hListWnd,LB_FINDSTRING, nIndex, (LONG) (LPSTR) lpString);
	return	nMatch ;
 }

/*	       MULTI.DEF

LIBRARY	       MULTI
DESCRIPTION    'MULTIPLE SELECTION LISTBOX DLL'
EXETYPE        WINDOWS
CODE	       PRELOAD MOVEABLE DISCARDABLE
DATA	       PRELOAD MOVEABLE SINGLE
HEAPSIZE       1024
EXPORTS        WEP
	       MultiListBox
	       SubListFunc
	       MultiGetSel
	       MultiAdd
	       MultiReset
	       MultiDelete
	       MultiCount
	       MultiText
	       MultiSetTop
	       MultiSetSel
	       MultiFind
*/

/*	       MULTISEL.H

int __export FAR PASCAL MultiListBox(HWND,HWND,DWORD);
LONG __export FAR PASCAL SubListFunc(HWND,WORD,WORD,LONG);
void __export FAR PASCAL MultiGetSel(HWND);
void __export FAR PASCAL MultiAdd(LPSTR);
void __export FAR PASCAL MultiReset(WORD);
void __export FAR PASCAL MultiDelete(WORD);
int __export FAR PASCAL MultiCount();
void __export FAR PASCAL MultiText(WORD);
void __export FAR PASCAL MultiSetTop(WORD);
void __export FAR PASCAL MultiSetSel(WORD,WORD);
int __export FAR PASCAL MultiFind(WORD,LPSTR);

*/
