Option Explicit
DefInt A-Z

'Unusual Properties
  'fPT.AutoRedraw=True
  'fPT.ScaleMode=Pixel
  'pPal.AutoRedraw=True
  'pPal.ScaleMode=Pixel

Global Const TotalPens = 256

Type BoxType
  X1    As Integer
  Y1    As Integer
  X2    As Integer
  Y2    As Integer
End Type

Type PenType
  Red           As Integer
  Green         As Integer
  Blue          As Integer
  pRGB          As Long
End Type

Global hPen As Integer
Global hBrush As Integer

Global Pen() As PenType
Global Box() As BoxType
Global Rect() As RectType
Global Ani As LogPalette256Lng
Global SysPal(0 To 19) As Long

Global Const bClear = 0
Global Const bRandom = 1
Global Const bReds = 2
Global Const bGreens = 3
Global Const bBlues = 4
Global Const bCyans = 5
Global Const bMagentas = 6
Global Const bYellows = 7
Global Const bGrays = 8
Global Const bClipboard = 9
Global Const bExit = 10
Global Const bAbout = 11

Global Const mRGB = 0
Global Const mNDX = 1
Global Const mDTH = 2

Sub BoxCreateStructure (Pict As Control)
  
  'set up variables
    Dim Counter, bx, by, bw, bh, i, j
    ReDim Box(0 To TotalPens - 1) As BoxType

  'calculate standard box dimensions
    bx = Pict.ScaleWidth
    by = Pict.ScaleHeight
    bw = bx / 16
    bh = by / 16
    Pict.Width = bw * 16 + 2
    Pict.Height = bh * 16 + 2
  
  'calc coords for each box
    For i = 0 To 15
      For j = 0 To 15
	Box(Counter).Y1 = i * bh
	Box(Counter).Y2 = Box(Counter).Y1 + bh
	Box(Counter).X1 = j * bw
	Box(Counter).X2 = Box(Counter).X1 + bw
	Counter = Counter + 1
      Next j
    Next i

End Sub

Sub BoxOutlines (Pict As Control)

  'draw boxes
    Dim i, RetVal, fRect As RectType

    fRect.Top = 0
    fRect.Left = 0
    fRect.Right = Pict.Width
    fRect.Bottom = Pict.Height
    hBrush = CreateSolidBrush(&HFFFFFF)
    RetVal = FillRect(Pict.hDC, fRect, hBrush)
    RetVal = DeleteObject(hBrush)
    
    For i = 0 To TotalPens - 1
      Pict.Line (Box(i).X1, Box(i).Y1)-(Box(i).X2, Box(i).Y2), , B
    Next i

End Sub

Sub BoxRefresh (Pict As Control, Method As Integer)
  
  'set up some vars
    Dim i, RetVal, oldPen, oldBrush
  
  'create new brushes and pens, select new and save old
    hPen = CreatePen(PS_SOLID, 1, RGB(0, 0, 0))
    hBrush = CreateSolidBrush(&H2000000 Or RGB(255, 255, 255))
    oldPen = SelectObject(Pict.hDC, hPen)
    oldBrush = SelectObject(Pict.hDC, hBrush)

  'draw boxes
    For i = 0 To TotalPens - 1
      RetVal = SelectObject(Pict.hDC, oldBrush)
      RetVal = DeleteObject(hBrush)
      If Method = mRGB Then
	hBrush = CreateSolidBrush(&H2000000 Or Pen(i).pRGB)
      ElseIf Method = mNDX Then
	hBrush = CreateSolidBrush(&H1000000 Or i)
      Else 'Method = mDTH
	hBrush = CreateSolidBrush(Pen(i).pRGB)
      End If
      RetVal = SelectObject(Pict.hDC, hBrush)
      RetVal = Rectangle(Pict.hDC, Box(i).X1, Box(i).Y1, Box(i).X2, Box(i).Y2)
    Next i

  'reselect old pens and brushes, delete new ones
    RetVal = SelectObject(Pict.hDC, oldPen)
    RetVal = SelectObject(Pict.hDC, oldBrush)
    RetVal = DeleteObject(hPen)
    RetVal = DeleteObject(hBrush)
    
End Sub

Sub BreakUpRGB (ByVal RGBin As Long, RGBout As PenType)

  RGBout.pRGB = RGBin
  RGBout.Red = RGBin Mod 256
  RGBin = RGBin \ 256
  RGBout.Green = RGBin Mod 256
  RGBin = RGBin \ 256
  RGBout.Blue = RGBin Mod 256

End Sub

Sub Howdy ()

  Dim Cr As String, m As String
  Cr = Chr$(13) + Chr$(10)
  m = "Howdy!" + Cr + Cr
  m = m + "This is a quick cut at a demo of the code " + Cr
  m = m + "that appeared in Inside Visual Basic, by" + Cr
  m = m + "the Cobb Group, Nov/Dec 1993." + Cr + Cr
  m = m + "Please let me know if I can make any of" + Cr
  m = m + "this more clear.  It's mostly routines cut" + Cr
  m = m + "from other apps.  I *even* understand a" + Cr
  m = m + "lot of it! <g>" + Cr + Cr
  m = m + "Later...   Karl      [CIS ID:72302,3707]"
  MsgBox m
  
End Sub

Sub PalDefPrimary (Which, WhiteFade)

  'set up some vars
    Dim i, t, NewBack&
    t = TotalPens - 1  '(255)

  'make some colors
    PaletteClear
    For i = t To 0 Step -1
      Select Case Which
	Case bReds
	  If WhiteFade Then
	    Pen(t - i).Red = t
	    Pen(t - i).Green = t - i
	    Pen(t - i).Blue = t - i
	  Else
	    Pen(t - i).Red = i
	  End If
	Case bGreens
	  If WhiteFade Then
	    Pen(t - i).Red = t - i
	    Pen(t - i).Green = t
	    Pen(t - i).Blue = t - i
	  Else
	    Pen(t - i).Green = i
	  End If
	Case bBlues
	  If WhiteFade Then
	    Pen(t - i).Red = t - i
	    Pen(t - i).Green = t - i
	    Pen(t - i).Blue = t
	  Else
	    Pen(t - i).Blue = i
	  End If
	Case bCyans
	  If WhiteFade Then
	    Pen(t - i).Red = t - i
	    Pen(t - i).Green = t
	    Pen(t - i).Blue = t
	  Else
	    Pen(t - i).Green = i
	    Pen(t - i).Blue = i
	  End If
	Case bMagentas
	  If WhiteFade Then
	    Pen(t - i).Red = t
	    Pen(t - i).Green = t - i
	    Pen(t - i).Blue = t
	  Else
	    Pen(t - i).Red = i
	    Pen(t - i).Blue = i
	  End If
	Case bYellows
	  If WhiteFade Then
	    Pen(t - i).Red = t
	    Pen(t - i).Green = t
	    Pen(t - i).Blue = t - i
	  Else
	    Pen(t - i).Red = i
	    Pen(t - i).Green = i
	  End If
	Case bGrays
	  If WhiteFade Then
	    Pen(t - i).Red = t - i
	    Pen(t - i).Green = t - i
	    Pen(t - i).Blue = t - i
	  Else
	    Pen(t - i).Red = i
	    Pen(t - i).Green = i
	    Pen(t - i).Blue = i
	  End If
      End Select
      Pen(t - i).pRGB = RGB(Pen(t - i).Red, Pen(t - i).Green, Pen(t - i).Blue)
    Next i

End Sub

Sub PalDefRandom ()

  'set up some vars
    Dim i, t
    t = TotalPens - 1

  'reseed random number generator
    Randomize Timer

  'make some colors
    PaletteClear
    For i = 0 To t
      Pen(i).Red = Rnd * t
      Pen(i).Green = Rnd * t
      Pen(i).Blue = Rnd * t
      Pen(i).pRGB = RGB(Pen(i).Red, Pen(i).Green, Pen(i).Blue)
    Next i

End Sub

Sub PaletteClear ()
  
  ReDim Pen(0 To TotalPens - 1 + 20) As PenType

End Sub

Sub PaletteInterpret (Pict As Control)

  'set up some local vars
    Dim i, RetVal&, iRetVal, hPal
    ReDim pRGB(0 To TotalPens - 1) As Long

  'get a handle to the control's palette
    hPal = SendMessageByNum(Pict.hWnd, VBM_GETPALETTE, 0, 0)

  'use GetPaletteEntries to determine colors
    iRetVal = GetPaletteEntries(hPal, 0, TotalPens, pRGB(0))
    For i = 0 To iRetVal - 1
      BreakUpRGB pRGB(i), Pen(i)
    Next i
      
End Sub

Sub PaletteUpdate (Frm As Form, Pict As Control)

  'set up some vars
    Dim Pal As LogPalette256Lng
    Dim i, hPal, RetVal
    
  'set main vars
    Pal.Version = &H300
    Pal.NumEntries = TotalPens + 20
  
  'Loop through pen definitions
    For i = 0 To TotalPens - 1
      Pal.PalEntry(i) = Pen(i).pRGB
    Next i
    For i = TotalPens To TotalPens + 19
      BreakUpRGB SysPal(i - TotalPens), Pen(i)
      Pal.PalEntry(i) = Pen(i).pRGB
    Next i
    
  'set palette in clipboard, then paste into control
    hPal = CreatePal256Lng(Pal)
    If OpenClipboard(Pict.Parent.hWnd) Then
      RetVal = SetClipboardData(CF_PALETTE, hPal)
      RetVal = CloseClipboard()
      Frm.Picture = Clipboard.GetData(CF_PALETTE)
      Pict.Picture = Clipboard.GetData(CF_PALETTE)
    End If
    
End Sub

Function PaletteUpdateClip (Frm As Form, Pict As Control)

  If Clipboard.GetFormat(CF_PALETTE) Then
    Frm.Picture = Clipboard.GetData(CF_PALETTE)
    Pict.Picture = Clipboard.GetData(CF_PALETTE)
    PaletteUpdateClip = True
  Else
    MsgBox "No palette is on the clipboard!"
    PaletteUpdateClip = False
  End If
  
End Function

Sub PalSystemSave (Frm As Form)
  
  'local vars
    Dim i, RetVal

  'use GetSystemPaletteEntries to determine colors
    RetVal = GetSystemPaletteEntries(Frm.hDC, 0, 20, SysPal(0))

End Sub

Sub PenSelect (Pict As Control, X As Integer, Y As Integer, Method)

  'set up some vars
    Dim cBox, cDM, cDW, i, cap$, RetVal&, tPen As PenType
  
  'save values to restore after drawing
    cDM = Pict.DrawMode
    cDW = Pict.DrawWidth

  'set new values
    Pict.DrawMode = INVERT
    Pict.DrawWidth = 2
  
  'erase last box if been here before
    cap$ = Pict.Parent.Caption
    If cap$ <> App.Title Then
      cBox = Val(Mid$(cap$, 4))
      Pict.Line (Box(cBox).X1, Box(cBox).Y1)-(Box(cBox).X2, Box(cBox).Y2), , B
    End If

  'find box clicked on
    For i = 0 To TotalPens - 1
      If X >= Box(i).X1 And X <= Box(i).X2 Then
	If Y >= Box(i).Y1 And Y <= Box(i).Y2 Then
	  cBox = i
	  Exit For
	End If
      End If
    Next i
    Pict.Line (Box(cBox).X1, Box(cBox).Y1)-(Box(cBox).X2, Box(cBox).Y2), , B

  'reset caption on form
    cap$ = "Pen " + Format$(cBox) + Space$(8)
    If Method = mDTH Then
      cap$ = cap$ + "Red=" + Format$(Pen(cBox).Red) + Space$(4)
      cap$ = cap$ + "Green=" + Format$(Pen(cBox).Green) + Space$(4)
      cap$ = cap$ + "Blue=" + Format$(Pen(cBox).Blue)
    Else
      RetVal& = GetPixel(Pict.hDC, X, Y)
      BreakUpRGB RetVal&, tPen
      cap$ = cap$ + "Red=" + Format$(tPen.Red) + Space$(4)
      cap$ = cap$ + "Green=" + Format$(tPen.Green) + Space$(4)
      cap$ = cap$ + "Blue=" + Format$(tPen.Blue)
    End If
    Pict.Parent.Caption = cap$

  'restore old values
    Pict.DrawMode = cDM
    Pict.DrawWidth = cDW
  
End Sub

Sub RectCreateStructure (Frm As Form)

  'set up variables
    Dim rx, ry, rw, rh, i
    ReDim Rect(0 To 63) As RectType

  'calculate standard box/curtain dimensions
    rx = Frm.ScaleWidth
    ry = Frm.ScaleHeight
    rw = rx
    rh = ry / 64
  
  'calc coords for each box
    For i = 0 To 63
      Rect(i).Left = 0
      Rect(i).Right = rx
      Rect(i).Top = i * rh
      Rect(i).Bottom = Rect(i).Top + rh
    Next i
    
End Sub

Sub RectRefresh (Frm As Form, Method)

  'set up some vars
    Dim i, RetVal, fRect As RectType
  
  'fill form with color 0
    If Method = mRGB Then
      hBrush = CreateSolidBrush(&H2000000 Or Pen(0).pRGB)
    ElseIf Method = mNDX Then
      hBrush = CreateSolidBrush(&H1000000 Or 0)
    Else 'Method = mDTH
      hBrush = CreateSolidBrush(Pen(0).pRGB)
    End If
    fRect.Top = 0
    fRect.Left = 0
    fRect.Right = Frm.Width
    fRect.Bottom = Frm.Height
    RetVal = FillRect(Frm.hDC, fRect, hBrush)
    RetVal = DeleteObject(hBrush)
    
  'draw boxes
    For i = 64 To 1 Step -1
      If Method = mRGB Then
	hBrush = CreateSolidBrush(&H2000000 Or Pen(i * 4 - 1).pRGB)
      ElseIf Method = mNDX Then
	hBrush = CreateSolidBrush(&H1000000 Or i * 4 - 1)
      Else 'Method = mDTH
	hBrush = CreateSolidBrush(Pen(i * 4 - 1).pRGB)
      End If
      RetVal = FillRect(Frm.hDC, Rect(64 - i), hBrush)
      RetVal = DeleteObject(hBrush)
    Next i
    
End Sub

Sub UserButtonClick (Index As Integer, Frm As Form, Pict As Control, dMethod, WhiteFade)

  Static Busy

  If Not Busy Then
    Busy = True
      Frm.MousePointer = 11
      Frm.Caption = App.Title
      Select Case Index
	Case bClear
	  Pict.Cls
	  BoxOutlines Pict
  
	Case bRandom
	  PalDefRandom
	  PaletteUpdate Frm, Pict
	  RectRefresh Frm, dMethod
	  BoxRefresh Pict, dMethod
  
	Case bReds To bGrays
	  PalDefPrimary Index, WhiteFade
	  PaletteUpdate Frm, Pict
	  RectRefresh Frm, dMethod
	  BoxRefresh Pict, dMethod
	
	Case bClipboard
	  If PaletteUpdateClip(Frm, Pict) Then
	    RectRefresh Frm, mNDX
	    BoxRefresh Pict, mNDX
	    PaletteInterpret Pict
	  End If
	
	Case bExit
	  End

	Case bAbout
	  Howdy
      End Select
      Frm.MousePointer = 0
    Busy = False
    
  Else
    Beep
  End If

End Sub

