
'---------------------------------------------------------------------------
'   Sets the ClipSiblings style bit so that windows can overlap without
'   interfering with each other.
'--------------------------------------------------------------------------
'
Sub SetClipSiblingBit (ByVal hWndParent As Integer)

    Dim hWndChild As Integer
    Dim Style As Long

    '-- Get the first child window.
    hWndChild = GetWindow(hWndParent, GW_CHILD)

    '-- Set the CLIPSIBLING bit for each child window.
    '   Loop terminates when GetWindowNext runs out of
    '   child windows and returns NULL.

    Do
        Style = GetWindowLong(hWndChild, GWL_STYLE) '-- Get current style.
        Style = Style Or WS_CLIPSIBLINGS            '-- Set the bit.
        Style = SetWindowLong(hWndChild, GWL_STYLE, Style) '-- Set new style.

        '-- Process any child windows of this window.
        If GetWindow(hWndChild, GW_CHILD) <> 0 Then
            Call SetClipSiblingBit(hWndChild)       '-- recursive call.
        End If

        '-- Get the next top level child window.
        hWndChild = GetNextWindow(hWndChild, GW_HWNDNEXT)

    Loop Until hWndChild = 0

End Sub

'--------------------------------------------------------------------------
'   This is the KEY routine of this demo. It sets new style bits that
'   can give a VB Picture Control a new look and new capabilities.
'   You can add a caption, system menu, minimize button and a sizing
'   border.
'
'   NewStyle consists of one or more of the following constants. You use
'   OR to combine constants. WS_CAPTION, WS_THICKFRAME, WS_MINIMIZEBOX
'   and WS_SYSMENU.
'
'   Example, WS_CAPTION Or WS_THICKFRAME gives a Picture control a Caption
'   and a sizing border.
'
'   NOTE: If you omit the WS_CAPTION style, the Caption argument should
'   be an empty string, i.e. "".
'
'   See the Form_Load Event for examples of calling this routine.
'--------------------------------------------------------------------------
'
Sub EnhancePicCtl (Ctl As Control, Caption As String, NewStyle As Long)

    Dim Style As Long
    Dim hSysMenu As Integer

    '-- Get the current window style.
    Style = GetWindowLong(ControlHwnd(Ctl), GWL_STYLE)
    
    '-- For some reason, Win3 always adds a Maximize button, so we get rid of it.
    Style = Style - WS_MAXIMIZEBOX
    
    '-- Use OR to combine the existing style and the new style options.
    Style = Style Or NewStyle

    '-- Set our new style.
    Style = SetWindowLong(ControlHwnd(Ctl), GWL_STYLE, Style)

    '-- Print the Caption if there is one.
    If Caption <> "" Then
        Call SetWindowText(ControlHwnd(Ctl), Caption)
    End If

    '-- Thanks to Costas Kitsos for explaining how to
    '-- remove the Close option and Separator from the
    '-- System Menu. We don't want to close a VB control
    '-- because we can't get it back.

    If (NewStyle And WS_SYSMENU) <> 0 Then
        hSysMenu = GetSystemMenu(ControlHwnd(Ctl), 0)
        LoseScClose = RemoveMenu(hSysMenu, SC_CLOSE, MF_BYCOMMAND)
        LoseSeparator = RemoveMenu(hSysMenu, 5, MF_BYPOSITION)
        Call DrawMenuBar(ControlHwnd(Ctl))
    End If
    
    '-- This forces VB to display the control with its new style.
    '-- There must be a better way.<g>
    Ctl.Left = Ctl.Left - Ctl.Left + Ctl.Left
        

End Sub

'--------------------------------------------------------------------------
'   Demonstrates using SendMessage to restore an iconized picture.
'-------------------------------------------------------------------------
'
Sub RestorePic (Ctl As Control)

    r& = SendMessage(ControlHwnd(Ctl), WM_SYSCOMMAND, SC_RESTORE, 0)

End Sub

'--------------------------------------------------------------------------
'   Demonstrates how to iconize a control using SendMessage.
'--------------------------------------------------------------------------
'
Sub MinimizePic (Ctl As Control)

    r& = SendMessage(ControlHwnd(Ctl), WM_SYSCOMMAND, SC_MINIMIZE, 0)

End Sub

'--------------------------------------------------------------------------
'   Makes the child window the top window of the parent. Thus, it appears
'   on top of all the other child windows.
'--------------------------------------------------------------------------
'
Sub MoveToTop (ByVal ChildCtl As Integer, ByVal ParentCtl As Integer)
    
    Dim TopWindow As Integer

    TopWindow = GetTopWindow(ParentCtl)

    If TopWindow = ChildCtl Then Exit Sub

    TopWindow = GetNextWindow(TopWindow, GW_HWNDPREV)
    Call SetWindowPos(ChildCtl, TopWindow, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_SHOWWINDOW)

End Sub

